/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ChatMessageInfoSpec;
import it.auties.whatsapp.model.info.WebNotificationsInfo;
import java.util.ArrayList;

public class WebNotificationsInfoSpec {
    public static byte[] encode(WebNotificationsInfo protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeUInt64(2, Long.valueOf(protoInputObject.timestampSeconds()));
        outputStream.writeUInt32(3, Integer.valueOf(protoInputObject.unreadChats()));
        outputStream.writeUInt32(4, Integer.valueOf(protoInputObject.notifyMessageCount()));
        if (protoInputObject.notifyMessages() != null) {
            for (ChatMessageInfo notifyMessagesEntry : protoInputObject.notifyMessages()) {
                outputStream.writeBytes(5, ChatMessageInfoSpec.encode(notifyMessagesEntry));
            }
        }
        return outputStream.toByteArray();
    }

    public static WebNotificationsInfo decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        long timestampSeconds = 0L;
        int unreadChats = 0;
        int notifyMessageCount = 0;
        ArrayList<ChatMessageInfo> notifyMessages = new ArrayList<ChatMessageInfo>();
        block6: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 2: {
                    timestampSeconds = inputStream.readInt64();
                    continue block6;
                }
                case 3: {
                    unreadChats = inputStream.readInt32();
                    continue block6;
                }
                case 4: {
                    notifyMessageCount = inputStream.readInt32();
                    continue block6;
                }
                case 5: {
                    notifyMessages.add(ChatMessageInfoSpec.decode(inputStream.readBytes()));
                    continue block6;
                }
            }
            inputStream.skipBytes();
        }
        return new WebNotificationsInfo(timestampSeconds, unreadChats, notifyMessageCount, notifyMessages);
    }
}

