/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufMessageName;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.util.Bytes;
import java.util.HexFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

@ProtobufMessageName(value="MessageKey")
public final class ChatMessageKey
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private Jid chatJid;
    @ProtobufProperty(index=2, type=ProtobufType.BOOL)
    private final boolean fromMe;
    @ProtobufProperty(index=3, type=ProtobufType.STRING)
    private final String id;
    @ProtobufProperty(index=4, type=ProtobufType.STRING)
    private Jid senderJid;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ChatMessageKey(Jid chatJid, boolean fromMe, String id, Jid senderJid) {
        this.chatJid = chatJid;
        this.fromMe = fromMe;
        this.id = Objects.requireNonNullElseGet(id, ChatMessageKey::randomId);
        this.senderJid = senderJid;
    }

    public ChatMessageKey(Jid chatJid, boolean fromMe) {
        this(chatJid, fromMe, null);
    }

    public ChatMessageKey(Jid chatJid, boolean fromMe, Jid senderJid) {
        this(chatJid, fromMe, ChatMessageKey.randomId(), senderJid);
    }

    public static String randomId() {
        return HexFormat.of().formatHex(Bytes.random(8)).toUpperCase(Locale.ROOT);
    }

    public Jid chatJid() {
        return this.chatJid;
    }

    public ChatMessageKey setChatJid(Jid chatJid) {
        this.chatJid = chatJid;
        return this;
    }

    public boolean fromMe() {
        return this.fromMe;
    }

    public String id() {
        return this.id;
    }

    public Optional<Jid> senderJid() {
        return Optional.ofNullable(this.senderJid);
    }

    public ChatMessageKey setSenderJid(Jid senderJid) {
        this.senderJid = senderJid;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ChatMessageKey)) return false;
        ChatMessageKey other = (ChatMessageKey)obj;
        if (!Objects.equals(this.id(), other.id())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.chatJid, this.fromMe, this.id, this.senderJid);
    }
}

