/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.extension.OptionalExtension;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.message.standard.AudioMessage;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class AudioMessageSpec {
    public static byte[] encode(AudioMessage protoInputObject) {
        byte[] waveform0;
        Optional<byte[]> waveform;
        byte[] streamingSidecar0;
        Optional<byte[]> streamingSidecar;
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        Long mediaKeyTimestampSeconds0;
        OptionalLong mediaKeyTimestampSeconds;
        String mediaDirectPath0;
        Optional<String> mediaDirectPath;
        byte[] mediaEncryptedSha2560;
        Optional<byte[]> mediaEncryptedSha256;
        byte[] mediaKey0;
        Integer duration0;
        OptionalInt duration;
        Long mediaSize0;
        OptionalLong mediaSize;
        byte[] mediaSha2560;
        Optional<byte[]> mediaSha256;
        String mimetype0;
        Optional<String> mimetype;
        String mediaUrl0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Optional<String> mediaUrl = protoInputObject.mediaUrl();
        if (mediaUrl != null && (mediaUrl0 = (String)mediaUrl.orElse(null)) != null) {
            outputStream.writeString(1, mediaUrl0);
        }
        if ((mimetype = protoInputObject.mimetype()) != null && (mimetype0 = (String)mimetype.orElse(null)) != null) {
            outputStream.writeString(2, mimetype0);
        }
        if ((mediaSha256 = protoInputObject.mediaSha256()) != null && (mediaSha2560 = (byte[])mediaSha256.orElse(null)) != null) {
            outputStream.writeBytes(3, mediaSha2560);
        }
        if ((mediaSize = protoInputObject.mediaSize()) != null && (mediaSize0 = OptionalExtension.toNullableLong((OptionalLong)mediaSize)) != null) {
            outputStream.writeUInt64(4, mediaSize0);
        }
        if ((duration = protoInputObject.duration()) != null && (duration0 = OptionalExtension.toNullableInt((OptionalInt)duration)) != null) {
            outputStream.writeUInt32(5, duration0);
        }
        outputStream.writeBool(6, Boolean.valueOf(protoInputObject.voiceMessage()));
        Optional<byte[]> mediaKey = protoInputObject.mediaKey();
        if (mediaKey != null && (mediaKey0 = (byte[])mediaKey.orElse(null)) != null) {
            outputStream.writeBytes(7, mediaKey0);
        }
        if ((mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256()) != null && (mediaEncryptedSha2560 = (byte[])mediaEncryptedSha256.orElse(null)) != null) {
            outputStream.writeBytes(8, mediaEncryptedSha2560);
        }
        if ((mediaDirectPath = protoInputObject.mediaDirectPath()) != null && (mediaDirectPath0 = (String)mediaDirectPath.orElse(null)) != null) {
            outputStream.writeString(9, mediaDirectPath0);
        }
        if ((mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds()) != null && (mediaKeyTimestampSeconds0 = OptionalExtension.toNullableLong((OptionalLong)mediaKeyTimestampSeconds)) != null) {
            outputStream.writeInt64(10, mediaKeyTimestampSeconds0);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)contextInfo.orElse(null)) != null) {
            outputStream.writeBytes(17, ContextInfoSpec.encode(contextInfo0));
        }
        if ((streamingSidecar = protoInputObject.streamingSidecar()) != null && (streamingSidecar0 = (byte[])streamingSidecar.orElse(null)) != null) {
            outputStream.writeBytes(18, streamingSidecar0);
        }
        if ((waveform = protoInputObject.waveform()) != null && (waveform0 = (byte[])waveform.orElse(null)) != null) {
            outputStream.writeBytes(19, waveform0);
        }
        outputStream.writeFixed32(20, protoInputObject.backgroundArgb());
        return outputStream.toByteArray();
    }

    public static AudioMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        String mediaUrl = null;
        String mimetype = null;
        byte[] mediaSha256 = null;
        Long mediaSize = null;
        Integer duration = null;
        boolean voiceMessage = false;
        byte[] mediaKey = null;
        byte[] mediaEncryptedSha256 = null;
        String mediaDirectPath = null;
        Long mediaKeyTimestampSeconds = null;
        ContextInfo contextInfo = null;
        byte[] streamingSidecar = null;
        byte[] waveform = null;
        Integer backgroundArgb = null;
        block16: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    mediaUrl = inputStream.readString();
                    continue block16;
                }
                case 2: {
                    mimetype = inputStream.readString();
                    continue block16;
                }
                case 3: {
                    mediaSha256 = inputStream.readBytes();
                    continue block16;
                }
                case 4: {
                    mediaSize = inputStream.readInt64();
                    continue block16;
                }
                case 5: {
                    duration = inputStream.readInt32();
                    continue block16;
                }
                case 6: {
                    voiceMessage = inputStream.readBool();
                    continue block16;
                }
                case 7: {
                    mediaKey = inputStream.readBytes();
                    continue block16;
                }
                case 8: {
                    mediaEncryptedSha256 = inputStream.readBytes();
                    continue block16;
                }
                case 9: {
                    mediaDirectPath = inputStream.readString();
                    continue block16;
                }
                case 10: {
                    mediaKeyTimestampSeconds = inputStream.readInt64();
                    continue block16;
                }
                case 17: {
                    contextInfo = ContextInfoSpec.decode(inputStream.readBytes());
                    continue block16;
                }
                case 18: {
                    streamingSidecar = inputStream.readBytes();
                    continue block16;
                }
                case 19: {
                    waveform = inputStream.readBytes();
                    continue block16;
                }
                case 20: {
                    backgroundArgb = inputStream.readFixed32();
                    continue block16;
                }
            }
            inputStream.skipBytes();
        }
        return new AudioMessage(mediaUrl, mimetype, mediaSha256, mediaSize, duration, voiceMessage, mediaKey, mediaEncryptedSha256, mediaDirectPath, mediaKeyTimestampSeconds, contextInfo, streamingSidecar, waveform, backgroundArgb);
    }
}

