/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.message.standard.LiveLocationMessage;
import java.util.Optional;

public class LiveLocationMessageSpec {
    public static byte[] encode(LiveLocationMessage protoInputObject) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        byte[] thumbnail0;
        String caption0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeDouble(1, Double.valueOf(protoInputObject.latitude()));
        outputStream.writeDouble(2, Double.valueOf(protoInputObject.longitude()));
        outputStream.writeUInt32(3, Integer.valueOf(protoInputObject.accuracy()));
        outputStream.writeFloat(4, Float.valueOf(protoInputObject.speed()));
        outputStream.writeUInt32(5, Integer.valueOf(protoInputObject.magneticNorthOffset()));
        Optional<String> caption = protoInputObject.caption();
        if (caption != null && (caption0 = (String)caption.orElse(null)) != null) {
            outputStream.writeString(6, caption0);
        }
        outputStream.writeUInt64(7, Long.valueOf(protoInputObject.sequenceNumber()));
        outputStream.writeUInt32(8, Integer.valueOf(protoInputObject.timeOffset()));
        Optional<byte[]> thumbnail = protoInputObject.thumbnail();
        if (thumbnail != null && (thumbnail0 = (byte[])thumbnail.orElse(null)) != null) {
            outputStream.writeBytes(16, thumbnail0);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)contextInfo.orElse(null)) != null) {
            outputStream.writeBytes(17, ContextInfoSpec.encode(contextInfo0));
        }
        return outputStream.toByteArray();
    }

    public static LiveLocationMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        double latitude = 0.0;
        double longitude = 0.0;
        int accuracy = 0;
        float speed = 0.0f;
        int magneticNorthOffset = 0;
        String caption = null;
        long sequenceNumber = 0L;
        int timeOffset = 0;
        byte[] thumbnail = null;
        ContextInfo contextInfo = null;
        block12: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    latitude = inputStream.readDouble();
                    continue block12;
                }
                case 2: {
                    longitude = inputStream.readDouble();
                    continue block12;
                }
                case 3: {
                    accuracy = inputStream.readInt32();
                    continue block12;
                }
                case 4: {
                    speed = inputStream.readFloat();
                    continue block12;
                }
                case 5: {
                    magneticNorthOffset = inputStream.readInt32();
                    continue block12;
                }
                case 6: {
                    caption = inputStream.readString();
                    continue block12;
                }
                case 7: {
                    sequenceNumber = inputStream.readInt64();
                    continue block12;
                }
                case 8: {
                    timeOffset = inputStream.readInt32();
                    continue block12;
                }
                case 16: {
                    thumbnail = inputStream.readBytes();
                    continue block12;
                }
                case 17: {
                    contextInfo = ContextInfoSpec.decode(inputStream.readBytes());
                    continue block12;
                }
            }
            inputStream.skipBytes();
        }
        return new LiveLocationMessage(latitude, longitude, accuracy, speed, magneticNorthOffset, caption, sequenceNumber, timeOffset, thumbnail, contextInfo);
    }
}

