/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.setting;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.chat.ChatWallpaper;
import it.auties.whatsapp.model.chat.ChatWallpaperSpec;
import it.auties.whatsapp.model.media.MediaVisibility;
import it.auties.whatsapp.model.media.MediaVisibilitySpec;
import it.auties.whatsapp.model.setting.AutoDownloadSettings;
import it.auties.whatsapp.model.setting.AutoDownloadSettingsSpec;
import it.auties.whatsapp.model.setting.AvatarUserSettings;
import it.auties.whatsapp.model.setting.AvatarUserSettingsSpec;
import it.auties.whatsapp.model.setting.GlobalSettings;
import java.util.Optional;

public class GlobalSettingsSpec {
    public static byte[] encode(GlobalSettings protoInputObject) {
        Optional<AutoDownloadSettings> autoDownloadRoaming;
        AutoDownloadSettings autoDownloadRoaming0;
        Optional<AutoDownloadSettings> autoDownloadCellular;
        AutoDownloadSettings autoDownloadCellular0;
        Optional<AutoDownloadSettings> autoDownloadWiFi;
        AutoDownloadSettings autoDownloadWiFi0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Optional<ChatWallpaper> lightThemeWallpaper = protoInputObject.lightThemeWallpaper();
        ChatWallpaper lightThemeWallpaper0 = lightThemeWallpaper.orElse(null);
        if (lightThemeWallpaper0 != null) {
            outputStream.writeBytes(1, ChatWallpaperSpec.encode(lightThemeWallpaper0));
        }
        outputStream.writeInt32(2, MediaVisibilitySpec.encode(protoInputObject.mediaVisibility()));
        Optional<ChatWallpaper> darkThemeWallpaper = protoInputObject.darkThemeWallpaper();
        ChatWallpaper darkThemeWallpaper0 = darkThemeWallpaper.orElse(null);
        if (darkThemeWallpaper0 != null) {
            outputStream.writeBytes(3, ChatWallpaperSpec.encode(darkThemeWallpaper0));
        }
        if ((autoDownloadWiFi0 = (AutoDownloadSettings)(autoDownloadWiFi = protoInputObject.autoDownloadWiFi()).orElse(null)) != null) {
            outputStream.writeBytes(4, AutoDownloadSettingsSpec.encode(autoDownloadWiFi0));
        }
        if ((autoDownloadCellular0 = (AutoDownloadSettings)(autoDownloadCellular = protoInputObject.autoDownloadCellular()).orElse(null)) != null) {
            outputStream.writeBytes(5, AutoDownloadSettingsSpec.encode(autoDownloadCellular0));
        }
        if ((autoDownloadRoaming0 = (AutoDownloadSettings)(autoDownloadRoaming = protoInputObject.autoDownloadRoaming()).orElse(null)) != null) {
            outputStream.writeBytes(6, AutoDownloadSettingsSpec.encode(autoDownloadRoaming0));
        }
        outputStream.writeBool(7, Boolean.valueOf(protoInputObject.showIndividualNotificationsPreview()));
        outputStream.writeBool(8, Boolean.valueOf(protoInputObject.showGroupNotificationsPreview()));
        outputStream.writeInt32(9, Integer.valueOf(protoInputObject.disappearingModeDuration()));
        outputStream.writeInt64(10, Long.valueOf(protoInputObject.disappearingModeTimestampSeconds()));
        outputStream.writeBytes(11, AvatarUserSettingsSpec.encode(protoInputObject.avatarUserSettings()));
        return outputStream.toByteArray();
    }

    public static GlobalSettings decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        Optional<ChatWallpaper> lightThemeWallpaper = Optional.empty();
        MediaVisibility mediaVisibility = null;
        Optional<ChatWallpaper> darkThemeWallpaper = Optional.empty();
        Optional<AutoDownloadSettings> autoDownloadWiFi = Optional.empty();
        Optional<AutoDownloadSettings> autoDownloadCellular = Optional.empty();
        Optional<AutoDownloadSettings> autoDownloadRoaming = Optional.empty();
        boolean showIndividualNotificationsPreview = false;
        boolean showGroupNotificationsPreview = false;
        int disappearingModeDuration = 0;
        long disappearingModeTimestampSeconds = 0L;
        AvatarUserSettings avatarUserSettings = null;
        block13: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    lightThemeWallpaper = Optional.ofNullable(ChatWallpaperSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
                case 2: {
                    mediaVisibility = MediaVisibilitySpec.decode(inputStream.readInt32()).orElse(null);
                    continue block13;
                }
                case 3: {
                    darkThemeWallpaper = Optional.ofNullable(ChatWallpaperSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
                case 4: {
                    autoDownloadWiFi = Optional.ofNullable(AutoDownloadSettingsSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
                case 5: {
                    autoDownloadCellular = Optional.ofNullable(AutoDownloadSettingsSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
                case 6: {
                    autoDownloadRoaming = Optional.ofNullable(AutoDownloadSettingsSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
                case 7: {
                    showIndividualNotificationsPreview = inputStream.readBool();
                    continue block13;
                }
                case 8: {
                    showGroupNotificationsPreview = inputStream.readBool();
                    continue block13;
                }
                case 9: {
                    disappearingModeDuration = inputStream.readInt32();
                    continue block13;
                }
                case 10: {
                    disappearingModeTimestampSeconds = inputStream.readInt64();
                    continue block13;
                }
                case 11: {
                    avatarUserSettings = AvatarUserSettingsSpec.decode(inputStream.readBytes());
                    continue block13;
                }
            }
            inputStream.skipBytes();
        }
        return new GlobalSettings(lightThemeWallpaper, mediaVisibility, darkThemeWallpaper, autoDownloadWiFi, autoDownloadCellular, autoDownloadRoaming, showIndividualNotificationsPreview, showGroupNotificationsPreview, disappearingModeDuration, disappearingModeTimestampSeconds, avatarUserSettings);
    }
}

