/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.registration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.crypto.MD5;
import it.auties.whatsapp.crypto.PBKDF2;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateBuilder;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetails;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetailsBuilder;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetailsSpec;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.util.Bytes;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.ProxyAuthenticator;
import it.auties.whatsapp.util.Specification;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.dongliu.apk.parser.ByteArrayApkFile;
import net.dongliu.apk.parser.bean.ApkSigner;
import net.dongliu.apk.parser.bean.CertificateMeta;

public final class WhatsappMetadata {
    private static volatile Version webVersion;
    private static volatile Version personalIosVersion;
    private static volatile Version businessIosVersion;
    private static volatile WhatsappApk personalApk;
    private static volatile WhatsappApk businessApk;
    private static final Path androidCache;

    public static CompletableFuture<Version> getVersion(UserAgent.PlatformType platform) {
        return switch (platform) {
            case UserAgent.PlatformType.WEB, UserAgent.PlatformType.WINDOWS, UserAgent.PlatformType.MACOS -> WhatsappMetadata.getWebVersion();
            case UserAgent.PlatformType.ANDROID, UserAgent.PlatformType.ANDROID_BUSINESS -> WhatsappMetadata.getAndroidData(platform.isBusiness()).thenApply(WhatsappApk::version);
            case UserAgent.PlatformType.IOS -> WhatsappMetadata.getIosVersion(false);
            case UserAgent.PlatformType.IOS_BUSINESS -> WhatsappMetadata.getIosVersion(true);
            default -> throw new IllegalStateException("Unsupported mobile os: " + String.valueOf((Object)platform));
        };
    }

    private static CompletableFuture<Version> getIosVersion(boolean business) {
        if (business && businessIosVersion != null) {
            return CompletableFuture.completedFuture(businessIosVersion);
        }
        if (!business && personalIosVersion != null) {
            return CompletableFuture.completedFuture(personalIosVersion);
        }
        return Medias.downloadAsync(URI.create(business ? "https://itunes.apple.com/lookup?bundleId=net.whatsapp.WhatsAppSMB" : "https://itunes.apple.com/lookup?bundleId=net.whatsapp.WhatsApp"), "Mozilla/5.0 (iPhone; CPU iPhone OS 17_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.3.1 Mobile/15E148 Safari/604.1", new Map.Entry[0]).thenApplyAsync(response -> {
            Version result = Json.readValue(response, IosVersionResponse.class).version().filter(version -> String.valueOf(version.tertiary()).length() != 1 || String.valueOf(version.quaternary()).length() != 1).orElse(business ? Specification.Whatsapp.MOBILE_DEFAULT_BUSINESS_IOS_VERSION : Specification.Whatsapp.MOBILE_DEFAULT_PERSONAL_IOS_VERSION);
            if (business) {
                businessIosVersion = result;
            } else {
                personalIosVersion = result;
            }
            return result;
        });
    }

    private static CompletableFuture<Version> getWebVersion() {
        if (webVersion != null) {
            return CompletableFuture.completedFuture(webVersion);
        }
        HttpClient client = HttpClient.newHttpClient();
        try {
            HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create("https://web.whatsapp.com/check-update?version=2.2245.9&platform=web")).build();
            CompletionStage completionStage = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(response -> {
                WebVersionResponse webVersionResponse = Json.readValue((String)response.body(), WebVersionResponse.class);
                webVersion = Version.of(webVersionResponse.currentVersion());
                return webVersion;
            });
            if (client != null) {
                client.close();
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throw new RuntimeException("Cannot fetch latest web version", throwable3);
            }
        }
    }

    public static CompletableFuture<String> getToken(long phoneNumber, UserAgent.PlatformType platform, Version appVersion) {
        return switch (platform) {
            case UserAgent.PlatformType.ANDROID, UserAgent.PlatformType.ANDROID_BUSINESS -> WhatsappMetadata.getAndroidData(platform.isBusiness()).thenApplyAsync(whatsappData -> WhatsappMetadata.getAndroidToken(String.valueOf(phoneNumber), whatsappData));
            case UserAgent.PlatformType.IOS, UserAgent.PlatformType.IOS_BUSINESS -> WhatsappMetadata.getIosToken(phoneNumber, appVersion, platform.isBusiness());
            default -> throw new IllegalStateException("Unsupported mobile os: " + String.valueOf((Object)platform));
        };
    }

    private static CompletableFuture<String> getIosToken(long phoneNumber, Version version, boolean business) {
        String staticToken = business ? "USUDuDYDeQhY4RF2fCSp5m3F6kJ1M2J8wS7bbNA2" : "0a1mLfGUIBVrMKF1RdvLI5lkRBvof6vn0fD2QRSM";
        String token = staticToken + HexFormat.of().formatHex(version.toHash()) + phoneNumber;
        return CompletableFuture.completedFuture(HexFormat.of().formatHex(MD5.calculate(token)));
    }

    private static String getAndroidToken(String phoneNumber, WhatsappApk whatsappData) {
        try {
            Mac mac = Mac.getInstance("HMACSHA1");
            byte[] secretKeyBytes = whatsappData.secretKey();
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyBytes, 0, secretKeyBytes.length, "PBKDF2");
            mac.init(secretKey);
            whatsappData.certificates().forEach(mac::update);
            mac.update(whatsappData.md5Hash());
            mac.update(phoneNumber.getBytes(StandardCharsets.UTF_8));
            return URLEncoder.encode(Base64.getEncoder().encodeToString(mac.doFinal()), StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException throwable) {
            throw new RuntimeException("Cannot compute mobile token", throwable);
        }
    }

    private static CompletableFuture<WhatsappApk> getAndroidData(boolean business) {
        if (!business && personalApk != null) {
            return CompletableFuture.completedFuture(personalApk);
        }
        if (business && businessApk != null) {
            return CompletableFuture.completedFuture(businessApk);
        }
        return WhatsappMetadata.getCachedAndroidApk(business).map(CompletableFuture::completedFuture).orElseGet(() -> WhatsappMetadata.downloadAndroidData(business));
    }

    private static Optional<WhatsappApk> getCachedAndroidApk(boolean business) {
        try {
            Path localCache = WhatsappMetadata.getAndroidLocalCache(business);
            if (Files.notExists(localCache, new LinkOption[0])) {
                return Optional.empty();
            }
            Instant now = Instant.now();
            FileTime fileTime = Files.getLastModifiedTime(localCache, new LinkOption[0]);
            if (fileTime.toInstant().until(now, ChronoUnit.DAYS) > 7L) {
                return Optional.empty();
            }
            return Optional.of(Json.readValue(Files.readString(localCache), WhatsappApk.class));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    private static Path getAndroidLocalCache(boolean business) {
        return androidCache.resolve(business ? "whatsapp_business.json" : "whatsapp.json");
    }

    private static CompletableFuture<WhatsappApk> downloadAndroidData(boolean business) {
        return Medias.downloadAsync(business ? Specification.Whatsapp.MOBILE_BUSINESS_ANDROID_URL : Specification.Whatsapp.MOBILE_ANDROID_URL, (String)null, new Map.Entry[0]).thenApplyAsync(apk -> {
            try (ByteArrayApkFile apkFile = new ByteArrayApkFile(apk);){
                Version version = Version.of(apkFile.getApkMeta().getVersionName());
                byte[] md5Hash = MD5.calculate(apkFile.getFileData("classes.dex"));
                byte[] secretKey = WhatsappMetadata.getSecretKey(apkFile.getApkMeta().getPackageName(), WhatsappMetadata.getAboutLogo(apkFile));
                List<byte[]> certificates = WhatsappMetadata.getCertificates(apkFile);
                if (business) {
                    WhatsappApk result = new WhatsappApk(version, md5Hash, secretKey, certificates, true);
                    WhatsappMetadata.cacheWhatsappData(result);
                    WhatsappApk whatsappApk = businessApk = result;
                    return whatsappApk;
                }
                WhatsappApk result = new WhatsappApk(version, md5Hash, secretKey, certificates, false);
                WhatsappMetadata.cacheWhatsappData(result);
                WhatsappApk whatsappApk = personalApk = result;
                return whatsappApk;
            }
            catch (IOException | GeneralSecurityException exception) {
                throw new RuntimeException("Cannot extract certificates from APK", exception);
            }
        });
    }

    private static void cacheWhatsappData(WhatsappApk apk) {
        CompletableFuture.runAsync(() -> {
            try {
                String json = Json.writeValueAsString(apk, true);
                Path file = WhatsappMetadata.getAndroidLocalCache(apk.business());
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.writeString(file, (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        });
    }

    private static byte[] getAboutLogo(ByteArrayApkFile apkFile) throws IOException {
        byte[] resource = apkFile.getFileData("res/drawable-hdpi/about_logo.png");
        if (resource != null) {
            return resource;
        }
        byte[] resourceV4 = apkFile.getFileData("res/drawable-hdpi-v4/about_logo.png");
        if (resourceV4 != null) {
            return resourceV4;
        }
        byte[] xxResourceV4 = apkFile.getFileData("res/drawable-xxhdpi-v4/about_logo.png");
        if (xxResourceV4 != null) {
            return xxResourceV4;
        }
        throw new NoSuchElementException("Missing about_logo.png from apk");
    }

    private static List<byte[]> getCertificates(ByteArrayApkFile apkFile) throws IOException, CertificateException {
        return apkFile.getApkSingers().stream().map(ApkSigner::getCertificateMetas).flatMap(Collection::stream).map(CertificateMeta::getData).toList();
    }

    private static byte[] getSecretKey(String packageName, byte[] resource) throws IOException, GeneralSecurityException {
        byte[] password = Bytes.concat(packageName.getBytes(StandardCharsets.UTF_8), resource);
        return PBKDF2.hmacSha1With8Bit(password, Specification.Whatsapp.MOBILE_ANDROID_SALT, 128, 512);
    }

    public static String generateBusinessCertificate(Keys keys) {
        BusinessVerifiedNameDetails details = new BusinessVerifiedNameDetailsBuilder().name("").issuer("smb:wa").serial(Math.abs(new SecureRandom().nextLong())).build();
        byte[] encodedDetails = BusinessVerifiedNameDetailsSpec.encode(details);
        BusinessVerifiedNameCertificate certificate = new BusinessVerifiedNameCertificateBuilder().encodedDetails(encodedDetails).signature(Curve25519.sign((byte[])keys.identityKeyPair().privateKey(), (byte[])encodedDetails, (boolean)true)).build();
        return Base64.getUrlEncoder().encodeToString(BusinessVerifiedNameCertificateSpec.encode(certificate));
    }

    public static CompletableFuture<String> generateGpiaToken(UUID advertisingId, byte[] deviceIdentifier, boolean business) {
        return WhatsappMetadata.getAndroidData(business).thenApplyAsync(androidData -> {
            byte[] uuidBytes = WhatsappMetadata.uuidToBytes(advertisingId);
            byte[] combinedBytes = Bytes.concat(deviceIdentifier, androidData.certificates().getFirst(), androidData.secretKey(), uuidBytes);
            byte[] randomBytes = Bytes.random(Math.max(0, 430 - combinedBytes.length));
            combinedBytes = Bytes.concat(combinedBytes, randomBytes);
            byte[] hashedBytes = Sha256.calculate(combinedBytes);
            byte[] truncatedBytes = new byte[430];
            System.arraycopy(hashedBytes, 0, truncatedBytes, 0, Math.min(hashedBytes.length, 430));
            byte[] thirdHeaderRandom = Bytes.random(430 - hashedBytes.length);
            System.arraycopy(thirdHeaderRandom, 0, truncatedBytes, hashedBytes.length, thirdHeaderRandom.length);
            return Base64.getEncoder().encodeToString(truncatedBytes);
        });
    }

    private static byte[] uuidToBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    static {
        ProxyAuthenticator.allowAll();
        androidCache = Path.of(System.getProperty("user.home") + "/.cobalt/token/android", new String[0]);
    }

    private record WhatsappApk(Version version, byte[] md5Hash, byte[] secretKey, List<byte[]> certificates, boolean business) {
    }

    private record WebVersionResponse(@JsonProperty(value="isBroken") boolean broken, @JsonProperty(value="isBelowSoft") boolean outdatedSoft, @JsonProperty(value="isBelowHard") boolean outdatedHard, @JsonProperty(value="hardUpdateTime") long outdatedUpdateTime, @JsonProperty(value="beta") String beta, @JsonProperty(value="currentVersion") String currentVersion) {
    }

    private static final class IosVersionResponse {
        private static final IosVersionResponse EMPTY = new IosVersionResponse(null);
        private final Version version;

        IosVersionResponse(Version version) {
            this.version = version;
        }

        @JsonCreator
        public static IosVersionResponse of(Map<String, Object> json) {
            List results = (List)json.get("results");
            if (results.isEmpty()) {
                return EMPTY;
            }
            String result = (String)((Map)results.getFirst()).get("version");
            if (result == null) {
                return EMPTY;
            }
            return new IosVersionResponse(Version.of("2." + result));
        }

        public Optional<Version> version() {
            return Optional.of(this.version);
        }
    }
}

