/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.crypto.AesCbc;
import it.auties.whatsapp.crypto.Hmac;
import it.auties.whatsapp.crypto.LTHash;
import it.auties.whatsapp.exception.HmacValidationException;
import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.model.action.ArchiveChatAction;
import it.auties.whatsapp.model.action.ClearChatAction;
import it.auties.whatsapp.model.action.ContactAction;
import it.auties.whatsapp.model.action.DeleteChatAction;
import it.auties.whatsapp.model.action.DeleteMessageForMeAction;
import it.auties.whatsapp.model.action.MarkChatAsReadAction;
import it.auties.whatsapp.model.action.MuteAction;
import it.auties.whatsapp.model.action.PinAction;
import it.auties.whatsapp.model.action.StarAction;
import it.auties.whatsapp.model.action.TimeFormatAction;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatMute;
import it.auties.whatsapp.model.companion.CompanionHashState;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.MessageIndexInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.mobile.CountryLocale;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.node.Attributes;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.setting.LocaleSettings;
import it.auties.whatsapp.model.setting.PushNameSettings;
import it.auties.whatsapp.model.setting.Setting;
import it.auties.whatsapp.model.setting.UnarchiveChatsSettings;
import it.auties.whatsapp.model.sync.ActionDataSync;
import it.auties.whatsapp.model.sync.ActionDataSyncBuilder;
import it.auties.whatsapp.model.sync.ActionDataSyncSpec;
import it.auties.whatsapp.model.sync.ActionMessageRangeSync;
import it.auties.whatsapp.model.sync.ActionValueSync;
import it.auties.whatsapp.model.sync.AppStateSyncKey;
import it.auties.whatsapp.model.sync.AppStateSyncKeyData;
import it.auties.whatsapp.model.sync.ExternalBlobReferenceSpec;
import it.auties.whatsapp.model.sync.IndexSync;
import it.auties.whatsapp.model.sync.KeyId;
import it.auties.whatsapp.model.sync.MutationKeys;
import it.auties.whatsapp.model.sync.MutationSync;
import it.auties.whatsapp.model.sync.MutationSyncBuilder;
import it.auties.whatsapp.model.sync.MutationsSync;
import it.auties.whatsapp.model.sync.MutationsSyncSpec;
import it.auties.whatsapp.model.sync.PatchRequest;
import it.auties.whatsapp.model.sync.PatchSync;
import it.auties.whatsapp.model.sync.PatchSyncBuilder;
import it.auties.whatsapp.model.sync.PatchSyncSpec;
import it.auties.whatsapp.model.sync.PatchType;
import it.auties.whatsapp.model.sync.RecordSync;
import it.auties.whatsapp.model.sync.RecordSyncBuilder;
import it.auties.whatsapp.model.sync.SnapshotSync;
import it.auties.whatsapp.model.sync.SnapshotSyncSpec;
import it.auties.whatsapp.model.sync.SyncActionMessage;
import it.auties.whatsapp.model.sync.Syncable;
import it.auties.whatsapp.model.sync.ValueSync;
import it.auties.whatsapp.model.sync.VersionSync;
import it.auties.whatsapp.socket.SocketHandler;
import it.auties.whatsapp.util.Bytes;
import it.auties.whatsapp.util.Exceptions;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.Validate;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class AppStateHandler {
    private static final int TIMEOUT = 120;
    private static final int PULL_ATTEMPTS = 3;
    private final SocketHandler socketHandler;
    private final ConcurrentMap<PatchType, Integer> attempts;
    private final Semaphore pullSemaphore;
    private final Semaphore pushSemaphore;

    protected AppStateHandler(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
        this.attempts = new ConcurrentHashMap<PatchType, Integer>();
        this.pullSemaphore = new Semaphore(1, true);
        this.pushSemaphore = new Semaphore(1, true);
    }

    protected CompletableFuture<Void> push(Jid jid, List<PatchRequest> patches) {
        ClientType clientType = this.socketHandler.store().clientType();
        CompletableFuture<Object> pullOperation = switch (clientType) {
            default -> throw new MatchException(null, null);
            case ClientType.MOBILE -> CompletableFuture.completedFuture(null);
            case ClientType.WEB -> this.pull(jid, this.getPatchesTypes(patches));
        };
        return ((CompletableFuture)pullOperation.thenComposeAsync(ignored -> this.sendPush(jid, patches, clientType != ClientType.MOBILE))).orTimeout(120L, TimeUnit.SECONDS).exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.PUSH_APP_STATE, (Throwable)throwable));
    }

    private Set<PatchType> getPatchesTypes(List<PatchRequest> patches) {
        return patches.stream().map(PatchRequest::type).collect(Collectors.toUnmodifiableSet());
    }

    private CompletableFuture<Void> sendPush(Jid jid, List<PatchRequest> patches, boolean readPatches) {
        try {
            this.pushSemaphore.acquire();
            List<PushRequest> requests = patches.stream().map(entry -> this.createPushRequest(jid, (PatchRequest)entry)).toList();
            boolean mobile = this.socketHandler.store().clientType() == ClientType.MOBILE;
            List<Node> body = requests.stream().map(request -> this.createPushRequestNode((PushRequest)request, mobile)).toList();
            LinkedHashMap<String, Object> syncAttributes = Attributes.of(new Map.Entry[0]).put("data_namespace", (Object)3, mobile).toMap();
            Node sync = Node.of("sync", syncAttributes, body);
            return ((CompletableFuture)this.socketHandler.sendQuery("set", "w:sync:app:state", sync).whenCompleteAsync((result, error) -> {
                this.pushSemaphore.release();
                if (error != null) {
                    Exceptions.rethrow(error);
                }
            })).thenRunAsync(() -> this.onPush(jid, requests, readPatches));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    private PushRequest createPushRequest(Jid jid, PatchRequest request) {
        CompanionHashState oldState = this.socketHandler.keys().findHashStateByName(jid, request.type()).orElseGet(() -> new CompanionHashState(request.type()));
        CompanionHashState newState = oldState.copy();
        AppStateSyncKey key = this.socketHandler.keys().getLatestAppKey(jid);
        MutationKeys mutationKeys = MutationKeys.of(key.keyData().keyData());
        KeyId syncId = new KeyId(key.keyId().keyId());
        List<MutationResult> mutations = request.entries().stream().map(patch -> this.createMutationSync((PatchRequest.PatchEntry)patch, mutationKeys, key, syncId)).toList();
        LTHash newStateGenerator = new LTHash(newState);
        mutations.forEach(mutation -> newStateGenerator.mix(mutation.indexMac(), mutation.valueMac(), mutation.operation()));
        LTHash.Result result = newStateGenerator.finish();
        newState.setHash(result.hash());
        newState.setIndexValueMap(result.indexValueMap());
        newState.setVersion(newState.version() + 1L);
        byte[] snapshotMac = this.generateSnapshotMac(newState.hash(), newState.version(), request.type(), mutationKeys.snapshotMacKey());
        byte[][] concatValueMac = (byte[][])mutations.stream().map(MutationResult::valueMac).toArray(x$0 -> new byte[x$0][]);
        byte[] patchMac = this.generatePatchMac(snapshotMac, concatValueMac, newState.version(), request.type(), mutationKeys.patchMacKey());
        List<MutationSync> syncs = mutations.stream().map(MutationResult::sync).toList();
        PatchSync sync = new PatchSyncBuilder().patchMac(patchMac).snapshotMac(snapshotMac).keyId(syncId).mutations(syncs).build();
        return new PushRequest(request.type(), oldState, newState, sync);
    }

    private MutationResult createMutationSync(PatchRequest.PatchEntry patch, MutationKeys mutationKeys, AppStateSyncKey key, KeyId syncId) {
        byte[] index = patch.index().getBytes(StandardCharsets.UTF_8);
        int actionVersion = patch.sync().action().orElseThrow(() -> new NoSuchElementException("Missing action")).actionVersion();
        ActionDataSync actionData = new ActionDataSyncBuilder().index(index).value(patch.sync()).padding(new byte[0]).version(actionVersion).build();
        byte[] encoded = ActionDataSyncSpec.encode(actionData);
        byte[] encrypted = AesCbc.encryptAndPrefix(encoded, mutationKeys.encKey());
        byte[] valueMac = this.generateMac(patch.operation(), encrypted, key.keyId().keyId(), mutationKeys.macKey());
        byte[] indexMac = Hmac.calculateSha256(index, mutationKeys.indexKey());
        RecordSync record = new RecordSyncBuilder().index(new IndexSync(indexMac)).value(new ValueSync(Bytes.concat(encrypted, valueMac))).keyId(syncId).build();
        MutationSync sync = new MutationSyncBuilder().operation(patch.operation()).record(record).build();
        return new MutationResult(sync, indexMac, valueMac, patch.operation());
    }

    private Node createPushRequestNode(PushRequest request, boolean mobile) {
        long version = request.oldState().version();
        LinkedHashMap<String, Object> collectionAttributes = Attributes.of(new Map.Entry[0]).put("name", (Object)request.type()).put("version", (Object)version, !mobile).put("return_snapshot", (Object)false, !mobile).put("order", (Object)(request.type() != PatchType.CRITICAL_UNBLOCK_LOW ? "1" : "0"), mobile).toMap();
        return Node.of("collection", collectionAttributes, (Object)Node.of("patch", PatchSyncSpec.encode(request.sync())));
    }

    private void onPush(Jid jid, List<PushRequest> requests, boolean readPatches) {
        requests.forEach(request -> {
            this.socketHandler.keys().putState(jid, request.newState());
            if (!readPatches) {
                return;
            }
            PatchSync patch = new PatchSyncBuilder().version(new VersionSync(request.newState().version())).keyId(request.sync().keyId()).deviceIndex(request.sync().deviceIndex()).patchMac(request.sync().patchMac()).exitCode(request.sync().exitCode()).externalMutations(request.sync().externalMutations()).mutations(request.sync().mutations()).snapshotMac(request.sync().snapshotMac()).build();
            SyncRecord results = this.decodePatches(jid, request.type(), List.of(patch), request.oldState());
            results.records().forEach(this::processActions);
        });
    }

    protected void pull(PatchType ... patchTypes) {
        if (patchTypes == null || patchTypes.length == 0) {
            return;
        }
        Optional<Jid> jid = this.socketHandler.store().jid();
        if (jid.isEmpty()) {
            return;
        }
        ((CompletableFuture)this.pull(jid.get(), Set.of(patchTypes)).thenAcceptAsync(success -> this.onPull(false, (boolean)success))).exceptionallyAsync(exception -> this.onPullError(false, (Throwable)exception));
    }

    protected CompletableFuture<Void> pullInitial() {
        if (this.socketHandler.keys().initialAppSync()) {
            return CompletableFuture.completedFuture(null);
        }
        Optional<Jid> jid = this.socketHandler.store().jid();
        if (jid.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.pull(jid.get(), Set.of(PatchType.values())).thenAcceptAsync(success -> this.onPull(true, (boolean)success))).exceptionallyAsync(exception -> this.onPullError(true, (Throwable)exception));
    }

    private void onPull(boolean initial, boolean success) {
        if (!this.socketHandler.keys().initialAppSync()) {
            this.socketHandler.keys().setInitialAppSync(initial && success || this.isSyncComplete());
        }
        this.attempts.clear();
    }

    private boolean isSyncComplete() {
        return Arrays.stream(PatchType.values()).allMatch(this::isSyncComplete);
    }

    private boolean isSyncComplete(PatchType entry) {
        Optional<Jid> jid = this.socketHandler.store().jid();
        return jid.isPresent() && this.socketHandler.keys().findHashStateByName(jid.get(), entry).filter(type -> type.version() > 0L).isPresent();
    }

    private Void onPullError(boolean initial, Throwable exception) {
        this.attempts.clear();
        if (initial) {
            return (Void)this.socketHandler.handleFailure(ErrorHandler.Location.INITIAL_APP_STATE_SYNC, exception);
        }
        return (Void)this.socketHandler.handleFailure(ErrorHandler.Location.PULL_APP_STATE, exception);
    }

    private CompletableFuture<Boolean> pull(Jid jid, Set<PatchType> patchTypes) {
        try {
            this.pullSemaphore.acquire();
            HashMap<PatchType, CompanionHashState> tempStates = new HashMap<PatchType, CompanionHashState>();
            List<Node> nodes = this.getPullNodes(jid, patchTypes, tempStates);
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.socketHandler.sendQuery("set", "w:sync:app:state", Node.of("sync", nodes)).thenApplyAsync(this::parseSyncRequest)).thenApplyAsync(records -> this.decodeSyncs(jid, (Map<PatchType, CompanionHashState>)tempStates, (List<SnapshotSyncRecord>)records))).thenComposeAsync(remaining -> this.handlePullResult(jid, (Set<PatchType>)remaining))).orTimeout(120L, TimeUnit.SECONDS).whenCompleteAsync((result, error) -> {
                this.pullSemaphore.release();
                if (error != null) {
                    Exceptions.rethrow(error);
                }
            });
        }
        catch (Throwable throwable) {
            this.pullSemaphore.release();
            return CompletableFuture.failedFuture(throwable);
        }
    }

    private CompletableFuture<Boolean> handlePullResult(Jid jid, Set<PatchType> remaining) {
        return remaining.isEmpty() ? CompletableFuture.completedFuture(true) : this.pull(jid, remaining);
    }

    private List<Node> getPullNodes(Jid jid, Set<PatchType> patchTypes, Map<PatchType, CompanionHashState> tempStates) {
        return patchTypes.stream().map(name -> this.createStateWithVersion(jid, (PatchType)((Object)name))).peek(state -> tempStates.put(state.type(), (CompanionHashState)state)).map(CompanionHashState::toNode).toList();
    }

    private CompanionHashState createStateWithVersion(Jid jid, PatchType name) {
        return this.socketHandler.keys().findHashStateByName(jid, name).orElseGet(() -> new CompanionHashState(name));
    }

    private Set<PatchType> decodeSyncs(Jid jid, Map<PatchType, CompanionHashState> tempStates, List<SnapshotSyncRecord> records) {
        return records.stream().map(record -> {
            PatchChunk chunk = this.decodeSync(jid, (SnapshotSyncRecord)record, tempStates);
            chunk.records().forEach(this::processActions);
            return chunk;
        }).filter(PatchChunk::hasMore).map(PatchChunk::patchType).collect(Collectors.toUnmodifiableSet());
    }

    private PatchChunk decodeSync(Jid jid, SnapshotSyncRecord record, Map<PatchType, CompanionHashState> tempStates) {
        try {
            ArrayList<ActionDataSync> results = new ArrayList<ActionDataSync>();
            if (record.hasSnapshot()) {
                Optional<SyncRecord> snapshot = this.decodeSnapshot(jid, record.patchType(), record.snapshot());
                snapshot.ifPresent(decodedSnapshot -> {
                    results.addAll(decodedSnapshot.records());
                    tempStates.put(record.patchType(), decodedSnapshot.state());
                    this.socketHandler.keys().putState(jid, decodedSnapshot.state());
                });
            }
            if (record.hasPatches()) {
                SyncRecord decodedPatches = this.decodePatches(jid, record.patchType(), record.patches(), tempStates.get((Object)record.patchType()));
                results.addAll(decodedPatches.records());
                this.socketHandler.keys().putState(jid, decodedPatches.state());
            }
            return new PatchChunk(record.patchType(), results, record.hasMore());
        }
        catch (Throwable throwable) {
            CompanionHashState hashState = new CompanionHashState(record.patchType());
            this.socketHandler.keys().putState(jid, hashState);
            this.attempts.put(record.patchType(), this.attempts.getOrDefault((Object)record.patchType(), 0) + 1);
            if ((Integer)this.attempts.get((Object)record.patchType()) >= 3) {
                throw new RuntimeException("Cannot parse patch(%s tries)".formatted(3), throwable);
            }
            return this.decodeSync(jid, record, tempStates);
        }
    }

    private List<SnapshotSyncRecord> parseSyncRequest(Node node) {
        return Stream.ofNullable(node).map(sync -> sync.findNodes("sync")).flatMap(Collection::stream).map(sync -> sync.findNodes("collection")).flatMap(Collection::stream).map(this::parseSync).flatMap(Optional::stream).toList();
    }

    private Optional<SnapshotSyncRecord> parseSync(Node sync) {
        PatchType name = PatchType.of(sync.attributes().getString("name"));
        String type = sync.attributes().getString("type");
        if (Objects.equals(type, "error")) {
            return Optional.empty();
        }
        boolean more = sync.attributes().getBoolean("has_more_patches");
        SnapshotSync snapshotSync = sync.findNode("snapshot").flatMap(this::decodeSnapshot).orElse(null);
        int versionCode = sync.attributes().getInt("version");
        List<PatchSync> patches = sync.findNode("patches").orElse(sync).findNodes("patch").stream().map(patch -> this.decodePatch((Node)patch, versionCode)).flatMap(Optional::stream).toList();
        return Optional.of(new SnapshotSyncRecord(name, snapshotSync, patches, more));
    }

    private Optional<SnapshotSync> decodeSnapshot(Node snapshot) {
        return snapshot == null ? Optional.empty() : snapshot.contentAsBytes().map(ExternalBlobReferenceSpec::decode).map(Medias::downloadAsync).flatMap(CompletableFuture::join).map(SnapshotSyncSpec::decode);
    }

    private Optional<PatchSync> decodePatch(Node patch, long versionCode) {
        if (!patch.hasContent()) {
            return Optional.empty();
        }
        PatchSync patchSync = PatchSyncSpec.decode(patch.contentAsBytes().orElseThrow());
        if (!patchSync.hasVersion()) {
            VersionSync version = new VersionSync(versionCode + 1L);
            patchSync.setVersion(version);
        }
        return Optional.of(patchSync);
    }

    private void processActions(ActionDataSync mutation) {
        ActionValueSync value = mutation.value();
        if (value == null) {
            return;
        }
        value.action().ifPresent(action -> this.onAction(mutation, (Action)action));
        value.setting().ifPresent(this::onSetting);
        mutation.value().primaryFeature().ifPresent(this.socketHandler::onFeatures);
    }

    private void onSetting(Setting setting) {
        Setting setting2 = setting;
        Objects.requireNonNull(setting2);
        Setting setting3 = setting2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocaleSettings.class, PushNameSettings.class, UnarchiveChatsSettings.class}, (Object)setting3, n)) {
            case 0: {
                LocaleSettings localeSettings = (LocaleSettings)setting3;
                Optional<CountryLocale> oldLocale = this.socketHandler.store().locale();
                this.socketHandler.updateLocale(CountryLocale.of(localeSettings.locale()), oldLocale.orElse(null));
                break;
            }
            case 1: {
                PushNameSettings pushNameSettings = (PushNameSettings)setting3;
                String oldName = this.socketHandler.store().name();
                this.socketHandler.updateUserName(pushNameSettings.name(), oldName);
                break;
            }
            case 2: {
                UnarchiveChatsSettings unarchiveChatsSettings = (UnarchiveChatsSettings)setting3;
                boolean settingValue = unarchiveChatsSettings.unarchiveChats();
                this.socketHandler.store().setUnarchiveChats(settingValue);
                break;
            }
        }
        this.socketHandler.onSetting(setting);
    }

    private void onAction(ActionDataSync mutation, Action action) {
        MessageIndexInfo messageIndex = mutation.messageIndex();
        Optional targetContact = messageIndex.chatJid().flatMap(this.socketHandler.store()::findContactByJid);
        Optional targetChat = messageIndex.chatJid().flatMap(this.socketHandler.store()::findChatByJid);
        Optional targetNewsletter = messageIndex.chatJid().flatMap(this.socketHandler.store()::findNewsletterByJid);
        Optional targetChatMessage = targetChat.flatMap(chat -> {
            String messageId = mutation.messageIndex().messageId().orElse(null);
            return this.socketHandler.store().findMessageById((Chat)chat, messageId);
        });
        Optional targetNewsletterMessage = targetNewsletter.flatMap(newsletter -> {
            String messageId = mutation.messageIndex().messageId().orElse(null);
            return this.socketHandler.store().findMessageById((Newsletter)newsletter, messageId);
        });
        Action action2 = action;
        Objects.requireNonNull(action2);
        Action action3 = action2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClearChatAction.class, ContactAction.class, DeleteMessageForMeAction.class, MarkChatAsReadAction.class, MuteAction.class, PinAction.class, StarAction.class, ArchiveChatAction.class, TimeFormatAction.class, DeleteChatAction.class}, (Object)action3, n)) {
            case 0: {
                ClearChatAction clearChatAction = (ClearChatAction)action3;
                Chat chat2 = targetChat.orElse(null);
                this.clearMessages(chat2, clearChatAction);
                break;
            }
            case 1: {
                ContactAction contactAction = (ContactAction)action3;
                Contact contact = targetContact.orElseGet(() -> this.createContact(messageIndex));
                Chat chat3 = targetChat.orElseGet(() -> this.createChat(messageIndex));
                this.updateName(contact, chat3, contactAction);
                break;
            }
            case 2: {
                DeleteMessageForMeAction ignored = (DeleteMessageForMeAction)action3;
                targetChatMessage.ifPresent(message -> {
                    targetChat.ifPresent(chat -> chat.removeMessage((ChatMessageInfo)message));
                    this.socketHandler.onMessageDeleted((MessageInfo)message, false);
                });
                targetNewsletterMessage.ifPresent(message -> {
                    targetNewsletter.ifPresent(newsletter -> newsletter.removeMessage((NewsletterMessageInfo)message));
                    this.socketHandler.onMessageDeleted((MessageInfo)message, false);
                });
                break;
            }
            case 3: {
                MarkChatAsReadAction markAction = (MarkChatAsReadAction)action3;
                targetChat.ifPresent(chat -> {
                    int read = markAction.read() ? 0 : -1;
                    chat.setUnreadMessagesCount(read);
                });
                break;
            }
            case 4: {
                MuteAction muteAction = (MuteAction)action3;
                targetChat.ifPresent(chat -> {
                    long timestamp = muteAction.muteEndTimestampSeconds().orElse(0L);
                    chat.setMute(ChatMute.muted(timestamp));
                });
                break;
            }
            case 5: {
                PinAction pinAction = (PinAction)action3;
                targetChat.ifPresent(chat -> {
                    int timestamp = pinAction.pinned() ? (int)mutation.value().timestamp() : 0;
                    chat.setPinnedTimestampSeconds(timestamp);
                });
                break;
            }
            case 6: {
                StarAction starAction = (StarAction)action3;
                targetChatMessage.ifPresent(message -> {
                    boolean starred = starAction.starred();
                    message.setStarred(starred);
                });
                break;
            }
            case 7: {
                ArchiveChatAction archiveChatAction = (ArchiveChatAction)action3;
                targetChat.ifPresent(chat -> {
                    boolean archived = archiveChatAction.archived();
                    chat.setArchived(archived);
                });
                break;
            }
            case 8: {
                TimeFormatAction timeFormatAction = (TimeFormatAction)action3;
                boolean format = timeFormatAction.twentyFourHourFormatEnabled();
                this.socketHandler.store().setTwentyFourHourFormat(format);
                break;
            }
            case 9: {
                DeleteChatAction ignored = (DeleteChatAction)action3;
                targetChat.ifPresent(Chat::removeMessages);
                break;
            }
        }
        this.socketHandler.onAction(action, messageIndex);
    }

    private Chat createChat(MessageIndexInfo messageIndex) {
        Jid chat = messageIndex.chatJid().orElseThrow();
        return this.socketHandler.store().addNewChat(chat);
    }

    private Contact createContact(MessageIndexInfo messageIndex) {
        Jid chatJid = messageIndex.chatJid().orElseThrow();
        Contact contact = this.socketHandler.store().addContact(chatJid);
        this.socketHandler.onNewContact(contact);
        return contact;
    }

    private void clearMessages(Chat targetChat, ClearChatAction clearChatAction) {
        if (targetChat == null) {
            return;
        }
        if (clearChatAction.messageRange().isEmpty()) {
            targetChat.removeMessages();
            return;
        }
        clearChatAction.messageRange().stream().map(ActionMessageRangeSync::messages).flatMap(Collection::stream).map(SyncActionMessage::key).filter(Objects::nonNull).forEach(key -> targetChat.removeMessage(entry -> Objects.equals(entry.id(), key.id())));
    }

    private void updateName(Contact contact, Chat chat, ContactAction contactAction) {
        contactAction.fullName().ifPresent(contact::setFullName);
        contactAction.firstName().ifPresent(contact::setShortName);
        contactAction.name().ifPresent(chat::setName);
    }

    private SyncRecord decodePatches(Jid jid, PatchType name, List<PatchSync> patches, CompanionHashState state) {
        CompanionHashState newState = state.copy();
        List<ActionDataSync> results = patches.stream().map(patch -> this.decodePatch(jid, name, newState, (PatchSync)patch)).map(MutationsRecord::records).flatMap(Collection::stream).toList();
        return new SyncRecord(newState, results);
    }

    private MutationsRecord decodePatch(Jid jid, PatchType patchType, CompanionHashState newState, PatchSync patch) {
        if (patch.hasExternalMutations()) {
            Medias.downloadAsync(patch.externalMutations()).join().ifPresent(blob -> this.handleExternalMutation(patch, (byte[])blob));
        }
        newState.setVersion(patch.encodedVersion());
        Optional<byte[]> syncMac = this.calculatePatchMac(jid, patch, patchType);
        Validate.isTrue(!this.socketHandler.store().checkPatchMacs() || syncMac.isEmpty() || Arrays.equals(syncMac.get(), patch.patchMac()), "sync_mac", HmacValidationException.class, new Object[0]);
        MutationsRecord mutations = this.decodeMutations(jid, patch.mutations(), newState);
        newState.setHash(mutations.result().hash());
        newState.setIndexValueMap(mutations.result().indexValueMap());
        Optional<byte[]> snapshotMac = this.calculateSnapshotMac(jid, patchType, newState, patch);
        Validate.isTrue(!this.socketHandler.store().checkPatchMacs() || snapshotMac.isEmpty() || Arrays.equals(snapshotMac.get(), patch.snapshotMac()), "patch_mac", HmacValidationException.class, new Object[0]);
        return mutations;
    }

    private void handleExternalMutation(PatchSync patch, byte[] blob) {
        MutationsSync mutationsSync = MutationsSyncSpec.decode(blob);
        patch.mutations().addAll(mutationsSync.mutations());
    }

    private Optional<byte[]> calculateSnapshotMac(Jid jid, PatchType name, CompanionHashState newState, PatchSync patch) {
        return this.getMutationKeys(jid, patch.keyId()).map(mutationKeys -> this.generateSnapshotMac(newState.hash(), newState.version(), name, mutationKeys.snapshotMacKey()));
    }

    private Optional<byte[]> calculatePatchMac(Jid jid, PatchSync patch, PatchType patchType) {
        return this.getMutationKeys(jid, patch.keyId()).map(mutationKeys -> this.generatePatchMac(patch.snapshotMac(), this.getSyncMutationMac(patch), patch.encodedVersion(), patchType, mutationKeys.patchMacKey()));
    }

    private byte[][] getSyncMutationMac(PatchSync patch) {
        return (byte[][])patch.mutations().stream().map(mutation -> mutation.record().value().blob()).map(entry -> Arrays.copyOfRange(entry, ((byte[])entry).length - 32, ((byte[])entry).length)).toArray(x$0 -> new byte[x$0][]);
    }

    private Optional<SyncRecord> decodeSnapshot(Jid jid, PatchType name, SnapshotSync snapshot) {
        Optional<MutationKeys> mutationKeys = this.getMutationKeys(jid, snapshot.keyId());
        if (mutationKeys.isEmpty()) {
            return Optional.empty();
        }
        CompanionHashState newState = new CompanionHashState(name, snapshot.version().version());
        MutationsRecord mutations = this.decodeMutations(jid, snapshot.records(), newState);
        newState.setHash(mutations.result().hash());
        newState.setIndexValueMap(mutations.result().indexValueMap());
        Validate.isTrue(!this.socketHandler.store().checkPatchMacs() || Arrays.equals(snapshot.mac(), this.generateSnapshotMac(newState.hash(), newState.version(), name, mutationKeys.get().snapshotMacKey())), "decode_snapshot", HmacValidationException.class, new Object[0]);
        return Optional.of(new SyncRecord(newState, mutations.records()));
    }

    private Optional<MutationKeys> getMutationKeys(Jid jid, KeyId snapshot) {
        return this.socketHandler.keys().findAppKeyById(jid, snapshot.id()).map(AppStateSyncKey::keyData).map(AppStateSyncKeyData::keyData).map(MutationKeys::of);
    }

    private MutationsRecord decodeMutations(Jid jid, List<? extends Syncable> syncs, CompanionHashState state) {
        LTHash generator = new LTHash(state);
        List<ActionDataSync> mutations = syncs.stream().map(mutation -> this.decodeMutation(jid, mutation.operation(), mutation.record(), generator)).flatMap(Optional::stream).collect(Collectors.toList());
        return new MutationsRecord(generator.finish(), mutations);
    }

    private Optional<ActionDataSync> decodeMutation(Jid jid, RecordSync.Operation operation, RecordSync sync, LTHash generator) {
        Optional<MutationKeys> mutationKeys = this.getMutationKeys(jid, sync.keyId());
        if (mutationKeys.isEmpty()) {
            return Optional.empty();
        }
        byte[] blob = sync.value().blob();
        byte[] encryptedBlob = Arrays.copyOfRange(blob, 0, blob.length - 32);
        byte[] encryptedMac = Arrays.copyOfRange(blob, blob.length - 32, blob.length);
        Validate.isTrue(!this.socketHandler.store().checkPatchMacs() || Arrays.equals(encryptedMac, this.generateMac(operation, encryptedBlob, sync.keyId().id(), mutationKeys.get().macKey())), "decode_mutation", HmacValidationException.class, new Object[0]);
        byte[] result = AesCbc.decrypt(encryptedBlob, mutationKeys.get().encKey());
        ActionDataSync actionSync = ActionDataSyncSpec.decode(result);
        Validate.isTrue(!this.socketHandler.store().checkPatchMacs() || Arrays.equals(sync.index().blob(), Hmac.calculateSha256(actionSync.index(), mutationKeys.get().indexKey())), "decode_mutation", HmacValidationException.class, new Object[0]);
        generator.mix(sync.index().blob(), encryptedMac, operation);
        return Optional.of(actionSync);
    }

    private byte[] generateMac(RecordSync.Operation operation, byte[] data, byte[] keyId, byte[] key) {
        byte[] keyData = Bytes.concat(operation.content(), keyId);
        byte[] last = new byte[8];
        last[last.length - 1] = (byte)keyData.length;
        byte[] total = Bytes.concat(keyData, data, last);
        byte[] sha512 = Hmac.calculateSha512(total, key);
        return Arrays.copyOfRange(sha512, 0, 32);
    }

    private byte[] generateSnapshotMac(byte[] ltHash, long version, PatchType patchType, byte[] key) {
        byte[] total = Bytes.concat(ltHash, Bytes.longToBytes(version), patchType.toString().getBytes(StandardCharsets.UTF_8));
        return Hmac.calculateSha256(total, key);
    }

    private byte[] generatePatchMac(byte[] snapshotMac, byte[][] valueMac, long version, PatchType patchType, byte[] key) {
        byte[] total = Bytes.concat(snapshotMac, Bytes.concat(valueMac), Bytes.longToBytes(version), patchType.toString().getBytes(StandardCharsets.UTF_8));
        return Hmac.calculateSha256(total, key);
    }

    protected void dispose() {
        this.attempts.clear();
    }

    private record PushRequest(PatchType type, CompanionHashState oldState, CompanionHashState newState, PatchSync sync) {
    }

    private record MutationResult(MutationSync sync, byte[] indexMac, byte[] valueMac, RecordSync.Operation operation) {
    }

    private record SnapshotSyncRecord(PatchType patchType, SnapshotSync snapshot, List<PatchSync> patches, boolean hasMore) {
        public boolean hasSnapshot() {
            return this.snapshot != null;
        }

        public boolean hasPatches() {
            return this.patches != null && !this.patches.isEmpty();
        }
    }

    private record SyncRecord(CompanionHashState state, List<ActionDataSync> records) {
    }

    private record PatchChunk(PatchType patchType, List<ActionDataSync> records, boolean hasMore) {
    }

    private record MutationsRecord(LTHash.Result result, List<ActionDataSync> records) {
    }
}

