/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import it.auties.whatsapp.model.message.model.Message;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageContainerSpec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class Bytes {
    private static final String CROCKFORD_CHARACTERS = "123456789ABCDEFGHJKLMNPQRSTVWXYZ";

    public static byte random() {
        return (byte)ThreadLocalRandom.current().nextInt();
    }

    public static byte[] random(int length) {
        byte[] bytes = new byte[length];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }

    public static byte[] reversedConcat(byte[][] entries) {
        int arrayLength = 0;
        for (byte[] entry : entries) {
            if (entry == null) continue;
            arrayLength += entry.length;
        }
        byte[] result = new byte[arrayLength];
        int offset = 0;
        for (int i = entries.length - 1; i >= 0; --i) {
            byte[] array = entries[i];
            if (array == null) continue;
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static byte[] concat(byte[] ... entries) {
        return Arrays.stream(entries).filter(Objects::nonNull).reduce(Bytes::concat).orElseGet(() -> new byte[0]);
    }

    public static byte[] concat(byte first, byte[] second) {
        if (second == null) {
            return new byte[]{first};
        }
        byte[] result = new byte[1 + second.length];
        result[0] = first;
        System.arraycopy(second, 0, result, 1, second.length);
        return result;
    }

    public static byte[] concat(byte[] first, byte[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static byte versionToBytes(int version) {
        return (byte)(version << 4 | 3);
    }

    public static int bytesToVersion(byte version) {
        return Byte.toUnsignedInt(version) >> 4;
    }

    public static byte[] compress(byte[] uncompressed) {
        Deflater deflater = new Deflater();
        deflater.setInput(uncompressed);
        deflater.finish();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            result.write(buffer, 0, count);
        }
        deflater.end();
        return result.toByteArray();
    }

    public static byte[] decompress(byte[] compressed) {
        return Bytes.decompress(compressed, 0, compressed.length);
    }

    public static byte[] decompress(byte[] compressed, int offset, int length) {
        try {
            Inflater decompressor = new Inflater();
            decompressor.setInput(compressed, offset, length);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buffer);
                result.write(buffer, 0, count);
            }
            decompressor.end();
            return result.toByteArray();
        }
        catch (DataFormatException exception) {
            throw new IllegalArgumentException("Malformed data", exception);
        }
    }

    public static byte[] messageToBytes(Message message) {
        return Bytes.messageToBytes(MessageContainer.of(message));
    }

    public static byte[] messageToBytes(MessageContainer container) {
        if (container.isEmpty()) {
            return null;
        }
        int padRandomByte = 1 + (0xF & Bytes.random());
        byte[] padding = new byte[padRandomByte];
        Arrays.fill(padding, (byte)padRandomByte);
        return Bytes.concat(MessageContainerSpec.encode(container), padding);
    }

    public static MessageContainer bytesToMessage(byte[] bytes) {
        byte[] message = Arrays.copyOfRange(bytes, 0, bytes.length - bytes[bytes.length - 1]);
        return MessageContainerSpec.decode(message);
    }

    public static byte[] longToBytes(long number) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(number);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }
        dataOutputStream.close();
        return byArray;
    }

    public static byte[] intToBytes(int input, int length) {
        byte[] result = new byte[length];
        for (int i = length - 1; i >= 0; --i) {
            result[i] = (byte)(0xFF & input);
            input >>>= 8;
        }
        return result;
    }

    public static int bytesToInt(byte[] bytes, int length) {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result = 256 * result + Byte.toUnsignedInt(bytes[i]);
        }
        return result;
    }

    public static String bytesToCrockford(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int value = 0;
        int bitCount = 0;
        StringBuilder crockford = new StringBuilder();
        for (int i = 0; i < buffer.limit(); ++i) {
            value = value << 8 | buffer.get(i) & 0xFF;
            bitCount += 8;
            while (bitCount >= 5) {
                crockford.append(CROCKFORD_CHARACTERS.charAt(value >>> bitCount - 5 & 0x1F));
                bitCount -= 5;
            }
        }
        if (bitCount > 0) {
            crockford.append(CROCKFORD_CHARACTERS.charAt(value << 5 - bitCount & 0x1F));
        }
        return crockford.toString();
    }

    public static byte[] intToVarInt(int value) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.write((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        out.write((byte)(value & 0x7F));
        return out.toByteArray();
    }
}

