/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.exception.HmacValidationException;
import it.auties.whatsapp.util.Exceptions;
import java.nio.file.Path;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;

public interface ErrorHandler {
    public Result handleError(Whatsapp var1, Location var2, Throwable var3);

    public static ErrorHandler toTerminal() {
        return ErrorHandler.defaultErrorHandler((api, error) -> error.printStackTrace());
    }

    public static ErrorHandler toFile() {
        return ErrorHandler.defaultErrorHandler((api, error) -> Exceptions.save(error));
    }

    public static ErrorHandler toFile(Path directory) {
        return ErrorHandler.defaultErrorHandler((api, error) -> Exceptions.save(directory, error));
    }

    public static ErrorHandler defaultErrorHandler(BiConsumer<Whatsapp, Throwable> printer) {
        return (whatsapp, location, throwable) -> {
            System.Logger logger = System.getLogger("ErrorHandler");
            if (location == Location.RECONNECT) {
                logger.log(System.Logger.Level.WARNING, "Cannot reconnect: retrying on next timeout");
                return Result.DISCARD;
            }
            if (throwable instanceof CompletionException && throwable.getCause() instanceof TimeoutException) {
                logger.log(System.Logger.Level.WARNING, "Detected possible network anomaly: reconnecting");
                return Result.RECONNECT;
            }
            logger.log(System.Logger.Level.ERROR, "Socket failure at %s".formatted(new Object[]{location}));
            if (printer != null) {
                printer.accept(whatsapp, throwable);
            }
            if (location == Location.CRYPTOGRAPHY && whatsapp.store().clientType() == ClientType.MOBILE) {
                logger.log(System.Logger.Level.WARNING, "Reconnecting");
                return Result.RECONNECT;
            }
            if (location == Location.INITIAL_APP_STATE_SYNC || location == Location.CRYPTOGRAPHY || location == Location.MESSAGE && throwable instanceof HmacValidationException) {
                logger.log(System.Logger.Level.WARNING, "Restore");
                return Result.RESTORE;
            }
            logger.log(System.Logger.Level.WARNING, "Ignored failure");
            return Result.DISCARD;
        };
    }

    public static enum Location {
        UNKNOWN,
        LOGIN,
        CRYPTOGRAPHY,
        MEDIA_CONNECTION,
        STREAM,
        PULL_APP_STATE,
        PUSH_APP_STATE,
        INITIAL_APP_STATE_SYNC,
        MESSAGE,
        HISTORY_SYNC,
        RECONNECT;

    }

    public static enum Result {
        DISCARD,
        RESTORE,
        DISCONNECT,
        RECONNECT,
        LOG_OUT;

    }
}

