/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import it.auties.protobuf.annotation.ProtobufConverter;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.TextPreviewSetting;
import it.auties.whatsapp.api.WebHistoryLength;
import it.auties.whatsapp.controller.Controller;
import it.auties.whatsapp.controller.StoreBuilder;
import it.auties.whatsapp.listener.Listener;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.call.Call;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatBuilder;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.companion.CompanionDevice;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.MessageStatusInfo;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.media.MediaConnection;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.mobile.CountryLocale;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.newsletter.NewsletterName;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.privacy.PrivacySettingType;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.registration.WhatsappMetadata;
import it.auties.whatsapp.socket.SocketRequest;
import it.auties.whatsapp.util.Bytes;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.ProtobufFutureMixin;
import it.auties.whatsapp.util.ProtobufUriMixin;
import it.auties.whatsapp.util.ProxyAuthenticator;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HexFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Store
extends Controller<Store>
implements ProtobufMessage {
    @ProtobufProperty(index=5, type=ProtobufType.STRING, mixin=ProtobufUriMixin.class)
    URI proxy;
    @ProtobufProperty(index=6, type=ProtobufType.OBJECT, overrideType=Version.class, mixin=ProtobufFutureMixin.class)
    CompletableFuture<Version> version;
    @ProtobufProperty(index=7, type=ProtobufType.BOOL)
    boolean online;
    @ProtobufProperty(index=8, type=ProtobufType.OBJECT)
    CountryLocale locale;
    @ProtobufProperty(index=9, type=ProtobufType.STRING)
    String name;
    @ProtobufProperty(index=40, type=ProtobufType.STRING)
    String verifiedName;
    @ProtobufProperty(index=10, type=ProtobufType.STRING)
    String businessAddress;
    @ProtobufProperty(index=11, type=ProtobufType.DOUBLE)
    Double businessLongitude;
    @ProtobufProperty(index=12, type=ProtobufType.DOUBLE)
    Double businessLatitude;
    @ProtobufProperty(index=13, type=ProtobufType.STRING)
    String businessDescription;
    @ProtobufProperty(index=14, type=ProtobufType.STRING)
    String businessWebsite;
    @ProtobufProperty(index=15, type=ProtobufType.STRING)
    String businessEmail;
    @ProtobufProperty(index=16, type=ProtobufType.OBJECT)
    BusinessCategory businessCategory;
    @ProtobufProperty(index=17, type=ProtobufType.STRING)
    String deviceHash;
    @ProtobufProperty(index=18, type=ProtobufType.MAP, keyType=ProtobufType.STRING, valueType=ProtobufType.INT32)
    LinkedHashMap<Jid, Integer> linkedDevicesKeys;
    @ProtobufProperty(index=19, type=ProtobufType.STRING, mixin=ProtobufUriMixin.class)
    URI profilePicture;
    @ProtobufProperty(index=20, type=ProtobufType.STRING)
    String about;
    @ProtobufProperty(index=21, type=ProtobufType.STRING)
    Jid jid;
    @ProtobufProperty(index=22, type=ProtobufType.STRING)
    Jid lid;
    @ProtobufProperty(index=23, type=ProtobufType.MAP, keyType=ProtobufType.STRING, valueType=ProtobufType.STRING)
    final ConcurrentHashMap<String, String> properties;
    @JsonIgnore
    final ConcurrentHashMap<Jid, Chat> chats;
    @ProtobufProperty(index=24, type=ProtobufType.MAP, keyType=ProtobufType.STRING, valueType=ProtobufType.OBJECT)
    final ConcurrentHashMap<Jid, Contact> contacts;
    @ProtobufProperty(index=25, type=ProtobufType.OBJECT)
    final ConcurrentHashMap.KeySetView<ChatMessageInfo, Boolean> status;
    @JsonIgnore
    final ConcurrentHashMap<Jid, Newsletter> newsletters;
    @ProtobufProperty(index=26, type=ProtobufType.MAP, keyType=ProtobufType.STRING, valueType=ProtobufType.OBJECT)
    final ConcurrentHashMap<String, PrivacySettingEntry> privacySettings;
    @ProtobufProperty(index=27, type=ProtobufType.MAP, keyType=ProtobufType.STRING, valueType=ProtobufType.OBJECT)
    final ConcurrentHashMap<String, Call> calls;
    @ProtobufProperty(index=28, type=ProtobufType.BOOL)
    boolean unarchiveChats;
    @ProtobufProperty(index=29, type=ProtobufType.BOOL)
    boolean twentyFourHourFormat;
    @JsonIgnore
    final ConcurrentHashMap<String, SocketRequest> requests;
    @JsonIgnore
    final ConcurrentHashMap<String, CompletableFuture<ChatMessageInfo>> replyHandlers;
    @JsonIgnore
    final ConcurrentHashMap.KeySetView<Listener, Boolean> listeners;
    @JsonIgnore
    final String tag;
    @ProtobufProperty(index=30, type=ProtobufType.UINT64)
    final Long initializationTimeStamp;
    @JsonIgnore
    MediaConnection mediaConnection;
    @JsonIgnore
    final CountDownLatch mediaConnectionLatch;
    @ProtobufProperty(index=31, type=ProtobufType.OBJECT)
    ChatEphemeralTimer newChatsEphemeralTimer;
    @ProtobufProperty(index=32, type=ProtobufType.OBJECT)
    TextPreviewSetting textPreviewSetting;
    @ProtobufProperty(index=33, type=ProtobufType.OBJECT)
    WebHistoryLength historyLength;
    @ProtobufProperty(index=34, type=ProtobufType.BOOL)
    boolean autodetectListeners;
    @ProtobufProperty(index=36, type=ProtobufType.BOOL)
    boolean automaticPresenceUpdates;
    @ProtobufProperty(index=41, type=ProtobufType.BOOL)
    boolean automaticMessageReceipts;
    @ProtobufProperty(index=37, type=ProtobufType.OBJECT)
    UserAgent.ReleaseChannel releaseChannel;
    @ProtobufProperty(index=38, type=ProtobufType.OBJECT)
    CompanionDevice device;
    @ProtobufProperty(index=39, type=ProtobufType.BOOL)
    boolean checkPatchMacs;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Store(UUID uuid, PhoneNumber phoneNumber, ClientType clientType, Collection<String> alias, URI proxy, CompletableFuture<Version> version, boolean online, CountryLocale locale, String name, String verifiedName, String businessAddress, Double businessLongitude, Double businessLatitude, String businessDescription, String businessWebsite, String businessEmail, BusinessCategory businessCategory, String deviceHash, LinkedHashMap<Jid, Integer> linkedDevicesKeys, URI profilePicture, String about, Jid jid, Jid lid, ConcurrentHashMap<String, String> properties, ConcurrentHashMap<Jid, Contact> contacts, ConcurrentHashMap.KeySetView<ChatMessageInfo, Boolean> status, ConcurrentHashMap<String, PrivacySettingEntry> privacySettings, ConcurrentHashMap<String, Call> calls, boolean unarchiveChats, boolean twentyFourHourFormat, Long initializationTimeStamp, ChatEphemeralTimer newChatsEphemeralTimer, TextPreviewSetting textPreviewSetting, WebHistoryLength historyLength, boolean autodetectListeners, boolean automaticPresenceUpdates, boolean automaticMessageReceipts, UserAgent.ReleaseChannel releaseChannel, CompanionDevice device, boolean checkPatchMacs) {
        super(uuid, phoneNumber, null, clientType, alias);
        if (proxy != null) {
            ProxyAuthenticator.globalAuthenticator().register(proxy);
        }
        this.proxy = proxy;
        this.version = version;
        this.online = online;
        this.locale = locale;
        this.name = Objects.requireNonNullElse(name, "Cobalt");
        this.verifiedName = verifiedName;
        this.businessAddress = businessAddress;
        this.businessLongitude = businessLongitude;
        this.businessLatitude = businessLatitude;
        this.businessDescription = businessDescription;
        this.businessWebsite = businessWebsite;
        this.businessEmail = businessEmail;
        this.businessCategory = businessCategory;
        this.deviceHash = deviceHash;
        this.linkedDevicesKeys = Objects.requireNonNullElseGet(linkedDevicesKeys, LinkedHashMap::new);
        this.profilePicture = profilePicture;
        this.about = about;
        this.jid = jid;
        this.lid = lid;
        this.properties = Objects.requireNonNullElseGet(properties, ConcurrentHashMap::new);
        this.chats = new ConcurrentHashMap();
        this.contacts = Objects.requireNonNullElseGet(contacts, ConcurrentHashMap::new);
        this.status = Objects.requireNonNullElseGet(status, ConcurrentHashMap::newKeySet);
        this.newsletters = new ConcurrentHashMap();
        this.privacySettings = Objects.requireNonNullElseGet(privacySettings, ConcurrentHashMap::new);
        this.calls = Objects.requireNonNullElseGet(calls, ConcurrentHashMap::new);
        this.unarchiveChats = unarchiveChats;
        this.twentyFourHourFormat = twentyFourHourFormat;
        this.requests = new ConcurrentHashMap();
        this.replyHandlers = new ConcurrentHashMap();
        this.listeners = ConcurrentHashMap.newKeySet();
        this.tag = HexFormat.of().formatHex(Bytes.random(1));
        this.initializationTimeStamp = Objects.requireNonNullElseGet(initializationTimeStamp, Clock::nowSeconds);
        this.mediaConnectionLatch = new CountDownLatch(1);
        this.newChatsEphemeralTimer = Objects.requireNonNullElse(newChatsEphemeralTimer, ChatEphemeralTimer.OFF);
        this.textPreviewSetting = Objects.requireNonNullElse(textPreviewSetting, TextPreviewSetting.ENABLED_WITH_INFERENCE);
        this.historyLength = Objects.requireNonNullElseGet(historyLength, WebHistoryLength::standard);
        this.autodetectListeners = autodetectListeners;
        this.automaticPresenceUpdates = automaticPresenceUpdates;
        this.automaticMessageReceipts = automaticMessageReceipts;
        this.releaseChannel = Objects.requireNonNullElse(releaseChannel, UserAgent.ReleaseChannel.RELEASE);
        this.device = device;
        this.checkPatchMacs = checkPatchMacs;
    }

    public static Store newStore(UUID uuid, Long phoneNumber, Collection<String> alias, ClientType clientType) {
        return new StoreBuilder().uuid(uuid).initializationTimeStamp(Clock.nowSeconds()).phoneNumber(phoneNumber != null ? PhoneNumber.of(phoneNumber) : null).device(clientType == ClientType.MOBILE ? CompanionDevice.ios(false) : CompanionDevice.web()).clientType(clientType).alias(alias).name("Cobalt").jid(phoneNumber != null ? Jid.of(phoneNumber) : null).autodetectListeners(true).automaticPresenceUpdates(true).automaticMessageReceipts(clientType == ClientType.MOBILE).build();
    }

    public Optional<Contact> findContactByJid(JidProvider jid) {
        JidProvider jidProvider = jid;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Contact.class}, (Object)jidProvider, n)) {
            case 0 -> {
                Contact contact = (Contact)jidProvider;
                yield Optional.of(contact);
            }
            case -1 -> Optional.empty();
            default -> Optional.ofNullable(this.contacts.get(jid.toJid()));
        };
    }

    public Optional<Contact> findContactByName(String name) {
        return this.findContactsStream(name).findAny();
    }

    private Stream<Contact> findContactsStream(String name) {
        return name == null ? Stream.empty() : this.contacts().parallelStream().filter(contact -> {
            if (contact.fullName().filter(name::equals).isPresent()) return true;
            if (contact.chosenName().filter(name::equals).isPresent()) return true;
            if (!contact.shortName().filter(name::equals).isPresent()) return false;
            return true;
        });
    }

    public Collection<Contact> contacts() {
        return Collections.unmodifiableCollection(this.contacts.values());
    }

    public Set<Contact> findContactsByName(String name) {
        return this.findContactsStream(name).collect(Collectors.toUnmodifiableSet());
    }

    public Optional<ChatMessageInfo> findMessageByKey(ChatMessageKey key) {
        return Optional.ofNullable(key).map(ChatMessageKey::chatJid).flatMap(this::findChatByJid).flatMap(chat -> this.findMessageById((Chat)chat, key.id()));
    }

    public Optional<? extends MessageStatusInfo<?>> findMessageById(JidProvider provider, String id) {
        if (provider == null || id == null) {
            return Optional.empty();
        }
        JidProvider jidProvider = provider;
        Objects.requireNonNull(jidProvider);
        JidProvider jidProvider2 = jidProvider;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Chat.class, Newsletter.class, Contact.class, Jid.class}, (Object)jidProvider2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Chat chat = (Chat)jidProvider2;
                yield this.findMessageById(chat, id);
            }
            case 1 -> {
                Newsletter newsletter = (Newsletter)jidProvider2;
                yield this.findMessageById(newsletter, id);
            }
            case 2 -> {
                Contact contact = (Contact)jidProvider2;
                yield this.findChatByJid(contact.jid()).flatMap(chat -> this.findMessageById((Chat)chat, id));
            }
            case 3 -> {
                Jid contactJid = (Jid)jidProvider2;
                switch (contactJid.type()) {
                    case NEWSLETTER: {
                        yield this.findNewsletterByJid(contactJid).flatMap(newsletter -> this.findMessageById((Newsletter)newsletter, id));
                    }
                    case STATUS: {
                        yield this.status.stream().filter(entry -> Objects.equals(entry.chatJid(), provider.toJid()) && Objects.equals(entry.id(), id)).findFirst();
                    }
                }
                yield this.findChatByJid(contactJid).flatMap(chat -> this.findMessageById((Chat)chat, id));
            }
        };
    }

    public Optional<NewsletterMessageInfo> findMessageById(Newsletter newsletter, String id) {
        return newsletter.messages().parallelStream().filter(entry -> Objects.equals(id, entry.id()) || Objects.equals(id, String.valueOf(entry.serverId()))).findFirst();
    }

    public Optional<ChatMessageInfo> findMessageById(Chat chat, String id) {
        return chat.messages().parallelStream().map(HistorySyncMessage::messageInfo).filter(message -> Objects.equals(message.key().id(), id)).findAny();
    }

    public Optional<Chat> findChatByJid(JidProvider jid) {
        if (jid == null) {
            return Optional.empty();
        }
        if (jid instanceof Chat) {
            Chat chat = (Chat)jid;
            return Optional.of(chat);
        }
        return Optional.ofNullable(this.chats.get(jid.toJid()));
    }

    public Optional<Newsletter> findNewsletterByJid(JidProvider jid) {
        if (jid == null) {
            return Optional.empty();
        }
        if (jid instanceof Newsletter) {
            Newsletter newsletter = (Newsletter)jid;
            return Optional.of(newsletter);
        }
        return Optional.ofNullable(this.newsletters.get(jid.toJid()));
    }

    public Optional<Chat> findChatByName(String name) {
        return this.findChatsByNameStream(name).findAny();
    }

    public Optional<Newsletter> findNewsletterByName(String name) {
        return this.findNewslettersByNameStream(name).findAny();
    }

    private Stream<Chat> findChatsByNameStream(String name) {
        return name == null ? Stream.empty() : this.chats.values().parallelStream().filter(chat -> chat.name().equalsIgnoreCase(name));
    }

    private Stream<Newsletter> findNewslettersByNameStream(String name) {
        return name == null ? Stream.empty() : this.newsletters.values().parallelStream().filter(newsletter -> name.equalsIgnoreCase(newsletter.metadata().name().map(NewsletterName::text).orElse(null)));
    }

    public Optional<Chat> findChatBy(Function<Chat, Boolean> function) {
        return this.chats.values().parallelStream().filter(function::apply).findFirst();
    }

    public Optional<Newsletter> findNewsletterBy(Function<Newsletter, Boolean> function) {
        return this.newsletters.values().parallelStream().filter(function::apply).findFirst();
    }

    public Set<Chat> findChatsByName(String name) {
        return this.findChatsByNameStream(name).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Newsletter> findNewslettersByName(String name) {
        return this.findNewslettersByNameStream(name).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Chat> findChatsBy(Function<Chat, Boolean> function) {
        return this.chats.values().stream().filter(function::apply).collect(Collectors.toUnmodifiableSet());
    }

    public Collection<ChatMessageInfo> status() {
        return Collections.unmodifiableCollection(this.status);
    }

    public Collection<Newsletter> newsletters() {
        return Collections.unmodifiableCollection(this.newsletters.values());
    }

    public Collection<ChatMessageInfo> findStatusBySender(JidProvider jid) {
        return this.status.stream().filter(entry -> Objects.equals(entry.chatJid(), jid)).toList();
    }

    public boolean resolvePendingRequest(Node response, boolean exceptionally) {
        return this.findPendingRequest(response.id()).map(request -> this.deleteAndComplete((SocketRequest)request, response, exceptionally)).isPresent();
    }

    public Optional<SocketRequest> findPendingRequest(String id) {
        return id == null ? Optional.empty() : Optional.ofNullable(this.requests.get(id));
    }

    private SocketRequest deleteAndComplete(SocketRequest request, Node response, boolean exceptionally) {
        if (request.complete(response, exceptionally)) {
            this.requests.remove(request.id());
        }
        return request;
    }

    public void resolveAllPendingRequests() {
        this.requests.values().forEach(request -> request.complete(null, false));
    }

    public Collection<SocketRequest> pendingRequests() {
        return Collections.unmodifiableCollection(this.requests.values());
    }

    public boolean resolvePendingReply(ChatMessageInfo response) {
        return response.message().contentWithContext().flatMap(ContextualMessage::contextInfo).flatMap(ContextInfo::quotedMessageId).map(id -> {
            CompletableFuture<ChatMessageInfo> future = this.replyHandlers.remove(id);
            if (future == null) {
                return false;
            }
            future.complete(response);
            return true;
        }).orElse(false);
    }

    public Chat addNewChat(Jid chatJid) {
        Chat chat = new ChatBuilder().jid(chatJid).build();
        this.addChat(chat);
        return chat;
    }

    public Optional<Chat> addChat(Chat chat) {
        Chat oldChat;
        if (chat.hasName() && chat.jid().hasServer(JidServer.WHATSAPP)) {
            Contact contact = this.findContactByJid(chat.jid()).orElseGet(() -> this.addContact(new Contact(chat.jid())));
            contact.setFullName(chat.name());
        }
        if ((oldChat = this.chats.get(chat.jid())) != null) {
            if (oldChat.hasName() && !chat.hasName()) {
                chat.setName(oldChat.name());
            }
            this.joinMessages(chat, oldChat);
        }
        return this.addChatDirect(chat);
    }

    private void joinMessages(Chat chat, Chat oldChat) {
        Long newChatTimestamp = chat.newestMessage().map(message -> message.timestampSeconds().orElse(0L)).orElse(0L);
        Long oldChatTimestamp = oldChat.newestMessage().map(message -> message.timestampSeconds().orElse(0L)).orElse(0L);
        if (newChatTimestamp <= oldChatTimestamp) {
            chat.addMessages(oldChat.messages());
            return;
        }
        chat.addOldMessages(chat.messages());
    }

    public Optional<Chat> addChatDirect(Chat chat) {
        return Optional.ofNullable(this.chats.put(chat.jid(), chat));
    }

    public Contact addContact(Jid jid) {
        return this.addContact(new Contact(jid));
    }

    public Contact addContact(Contact contact) {
        this.contacts.put(contact.jid(), contact);
        return contact;
    }

    public Optional<Newsletter> addNewsletter(Newsletter newsletter) {
        return Optional.ofNullable(this.newsletters.put(newsletter.jid(), newsletter));
    }

    public Optional<Chat> removeChat(JidProvider chatJid) {
        return Optional.ofNullable(this.chats.remove(chatJid.toJid()));
    }

    public Optional<Newsletter> removeNewsletter(JidProvider newsletterJid) {
        return Optional.ofNullable(this.newsletters.remove(newsletterJid.toJid()));
    }

    public Optional<Contact> removeContact(JidProvider contactJid) {
        return Optional.ofNullable(this.contacts.remove(contactJid.toJid()));
    }

    public List<Chat> pinnedChats() {
        return this.chats.values().parallelStream().filter(Chat::isPinned).sorted(Comparator.comparingLong(Chat::pinnedTimestampSeconds).reversed()).toList();
    }

    public List<ChatMessageInfo> starredMessages() {
        return this.chats().parallelStream().map(Chat::starredMessages).flatMap(Collection::stream).toList();
    }

    public List<Chat> chats() {
        return this.chats.values().stream().sorted(Comparator.comparingLong(Chat::timestampSeconds).reversed()).toList();
    }

    public Map<String, String> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void addProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    public MediaConnection mediaConnection() {
        return this.mediaConnection(Duration.ofMinutes(1L));
    }

    public MediaConnection mediaConnection(Duration timeout) {
        try {
            boolean result = this.mediaConnectionLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (!result) {
                throw new RuntimeException("Cannot get media connection");
            }
            return this.mediaConnection;
        }
        catch (InterruptedException exception) {
            throw new RuntimeException("Cannot lock on media connection", exception);
        }
    }

    public Store setMediaConnection(MediaConnection mediaConnection) {
        this.mediaConnection = mediaConnection;
        this.mediaConnectionLatch.countDown();
        return this;
    }

    public boolean hasMediaConnection() {
        return this.mediaConnection != null;
    }

    public Collection<Contact> blockedContacts() {
        return this.contacts().stream().filter(Contact::blocked).toList();
    }

    public Store addStatus(ChatMessageInfo info) {
        this.status.add(info);
        return this;
    }

    public CompletableFuture<Node> addRequest(SocketRequest request) {
        if (request.id() == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.requests.put(request.id(), request);
        return request.future();
    }

    public CompletableFuture<ChatMessageInfo> addPendingReply(String messageId) {
        CompletableFuture<ChatMessageInfo> result = new CompletableFuture<ChatMessageInfo>();
        this.replyHandlers.put(messageId, result);
        return result;
    }

    public Optional<URI> profilePicture() {
        return Optional.ofNullable(this.profilePicture);
    }

    public Collection<PrivacySettingEntry> privacySettings() {
        return this.privacySettings.values();
    }

    public PrivacySettingEntry findPrivacySetting(PrivacySettingType type) {
        return this.privacySettings.get(type.name());
    }

    public PrivacySettingEntry addPrivacySetting(PrivacySettingType type, PrivacySettingEntry entry) {
        return this.privacySettings.put(type.name(), entry);
    }

    public Map<Jid, Integer> linkedDevicesKeys() {
        return Collections.unmodifiableMap(this.linkedDevicesKeys);
    }

    public Collection<Jid> linkedDevices() {
        return Collections.unmodifiableCollection(this.linkedDevicesKeys.keySet());
    }

    public Optional<Integer> addLinkedDevice(Jid companion, int keyId) {
        return Optional.ofNullable(this.linkedDevicesKeys.put(companion, keyId));
    }

    public Optional<Integer> removeLinkedCompanion(Jid companion) {
        return Optional.ofNullable((Integer)this.linkedDevicesKeys.remove(companion));
    }

    public void removeLinkedCompanions() {
        this.linkedDevicesKeys.clear();
    }

    public Collection<Listener> listeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public Store addListener(Listener listener) {
        this.listeners.add(listener);
        return this;
    }

    public Store addListeners(Collection<Listener> listeners) {
        this.listeners.addAll(listeners);
        return this;
    }

    public Store removeListener(Listener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public Store removeListeners() {
        this.listeners.clear();
        return this;
    }

    public Store setProxy(URI proxy) {
        if (proxy != null && proxy.getUserInfo() != null) {
            ProxyAuthenticator.globalAuthenticator().register(proxy);
        } else if (proxy == null && this.proxy != null) {
            ProxyAuthenticator.globalAuthenticator().unregister(this.proxy);
        }
        this.proxy = proxy;
        return this;
    }

    public Optional<URI> proxy() {
        return Optional.ofNullable(this.proxy);
    }

    public Optional<String> businessAddress() {
        return Optional.ofNullable(this.businessAddress);
    }

    public Optional<Double> businessLongitude() {
        return Optional.ofNullable(this.businessLongitude);
    }

    public Optional<Double> businessLatitude() {
        return Optional.ofNullable(this.businessLatitude);
    }

    public Optional<String> businessDescription() {
        return Optional.ofNullable(this.businessDescription);
    }

    public Optional<String> businessWebsite() {
        return Optional.ofNullable(this.businessWebsite);
    }

    public Optional<String> businessEmail() {
        return Optional.ofNullable(this.businessEmail);
    }

    public Optional<BusinessCategory> businessCategory() {
        return Optional.ofNullable(this.businessCategory);
    }

    @Override
    public void dispose() {
        this.serialize(false);
        this.serializer.linkMetadata(this);
        this.mediaConnectionLatch.countDown();
    }

    @Override
    public void serialize(boolean async) {
        this.serializer.serializeStore(this, async);
    }

    public Optional<Call> addCall(Call call) {
        return Optional.ofNullable(this.calls.put(call.id(), call));
    }

    public Optional<Call> findCallById(String callId) {
        return callId == null ? Optional.empty() : Optional.ofNullable(this.calls.get(callId));
    }

    public Collection<Call> calls() {
        return Collections.unmodifiableCollection(this.calls.values());
    }

    public String tag() {
        return this.tag;
    }

    @JsonGetter(value="version")
    public Version version() {
        if (this.version == null) {
            this.version = WhatsappMetadata.getVersion(this.device.platform());
        }
        return this.version.join();
    }

    public boolean online() {
        return this.online;
    }

    public Optional<CountryLocale> locale() {
        return Optional.ofNullable(this.locale);
    }

    public String name() {
        return this.name;
    }

    public Optional<String> deviceHash() {
        return Optional.ofNullable(this.deviceHash);
    }

    public Optional<String> about() {
        return Optional.ofNullable(this.about);
    }

    public Optional<Jid> jid() {
        return Optional.ofNullable(this.jid);
    }

    public Optional<Jid> lid() {
        return Optional.ofNullable(this.lid);
    }

    public boolean unarchiveChats() {
        return this.unarchiveChats;
    }

    public boolean twentyFourHourFormat() {
        return this.twentyFourHourFormat;
    }

    public long initializationTimeStamp() {
        return this.initializationTimeStamp;
    }

    public ChatEphemeralTimer newChatsEphemeralTimer() {
        return this.newChatsEphemeralTimer;
    }

    public TextPreviewSetting textPreviewSetting() {
        return this.textPreviewSetting;
    }

    public WebHistoryLength historyLength() {
        return this.historyLength;
    }

    public boolean autodetectListeners() {
        return this.autodetectListeners;
    }

    public boolean automaticPresenceUpdates() {
        return this.automaticPresenceUpdates;
    }

    public UserAgent.ReleaseChannel releaseChannel() {
        return this.releaseChannel;
    }

    public CompanionDevice device() {
        return this.device;
    }

    public boolean checkPatchMacs() {
        return this.checkPatchMacs;
    }

    public boolean automaticMessageReceipts() {
        return this.automaticPresenceUpdates;
    }

    public Store setOnline(boolean online) {
        this.online = online;
        return this;
    }

    public Store setLocale(CountryLocale locale) {
        this.locale = locale;
        return this;
    }

    public Store setName(String name) {
        this.name = name;
        return this;
    }

    public Store setBusinessAddress(String businessAddress) {
        this.businessAddress = businessAddress;
        return this;
    }

    public Store setBusinessLongitude(Double businessLongitude) {
        this.businessLongitude = businessLongitude;
        return this;
    }

    public Store setBusinessLatitude(Double businessLatitude) {
        this.businessLatitude = businessLatitude;
        return this;
    }

    public Store setBusinessDescription(String businessDescription) {
        this.businessDescription = businessDescription;
        return this;
    }

    public Store setBusinessWebsite(String businessWebsite) {
        this.businessWebsite = businessWebsite;
        return this;
    }

    public Store setBusinessEmail(String businessEmail) {
        this.businessEmail = businessEmail;
        return this;
    }

    public Store setBusinessCategory(BusinessCategory businessCategory) {
        this.businessCategory = businessCategory;
        return this;
    }

    public Store setDeviceHash(String deviceHash) {
        this.deviceHash = deviceHash;
        return this;
    }

    public Store setLinkedDevicesKeys(LinkedHashMap<Jid, Integer> linkedDevicesKeys) {
        this.linkedDevicesKeys = linkedDevicesKeys;
        return this;
    }

    public Store setProfilePicture(URI profilePicture) {
        this.profilePicture = profilePicture;
        return this;
    }

    public Store setAbout(String about) {
        this.about = about;
        return this;
    }

    public Store setJid(Jid jid) {
        this.jid = jid;
        return this;
    }

    public Store setLid(Jid lid) {
        this.lid = lid;
        return this;
    }

    public Store setUnarchiveChats(boolean unarchiveChats) {
        this.unarchiveChats = unarchiveChats;
        return this;
    }

    public Store setTwentyFourHourFormat(boolean twentyFourHourFormat) {
        this.twentyFourHourFormat = twentyFourHourFormat;
        return this;
    }

    public Store setNewChatsEphemeralTimer(ChatEphemeralTimer newChatsEphemeralTimer) {
        this.newChatsEphemeralTimer = newChatsEphemeralTimer;
        return this;
    }

    public Store setTextPreviewSetting(TextPreviewSetting textPreviewSetting) {
        this.textPreviewSetting = textPreviewSetting;
        return this;
    }

    public Store setHistoryLength(WebHistoryLength historyLength) {
        this.historyLength = historyLength;
        return this;
    }

    public Store setAutodetectListeners(boolean autodetectListeners) {
        this.autodetectListeners = autodetectListeners;
        return this;
    }

    public Store setAutomaticPresenceUpdates(boolean automaticPresenceUpdates) {
        this.automaticPresenceUpdates = automaticPresenceUpdates;
        return this;
    }

    public Store setReleaseChannel(UserAgent.ReleaseChannel releaseChannel) {
        this.releaseChannel = releaseChannel;
        return this;
    }

    public Store setDevice(CompanionDevice device) {
        if (Objects.equals(this.device(), device)) {
            return this;
        }
        Objects.requireNonNull(device, "The device cannot be null");
        this.device = device;
        this.version = device.appVersion().map(CompletableFuture::completedFuture).orElseGet(() -> WhatsappMetadata.getVersion(device.platform()));
        return this;
    }

    public Store setCheckPatchMacs(boolean checkPatchMacs) {
        this.checkPatchMacs = checkPatchMacs;
        return this;
    }

    public Optional<String> verifiedName() {
        return Optional.ofNullable(this.verifiedName);
    }

    public Store setVerifiedName(String verifiedName) {
        this.verifiedName = verifiedName;
        return this;
    }

    public Store setAutomaticMessageReceipts(boolean automaticMessageReceipts) {
        this.automaticMessageReceipts = automaticMessageReceipts;
        return this;
    }

    private static class AsyncVersion {
        private Version value;
        private CompletableFuture<Version> future;

        @JsonCreator
        private AsyncVersion(Version initialValue) {
            this.value = Objects.requireNonNull(initialValue, "Missing value");
        }

        public AsyncVersion(Version initialValue, Supplier<CompletableFuture<Version>> defaultValue) {
            this.value = initialValue;
            if (initialValue == null) {
                this.future = defaultValue.get();
            }
        }

        @ProtobufConverter
        @JsonValue
        public Version value() {
            if (this.future != null) {
                this.value = this.future.join();
                this.future = null;
            }
            return this.value;
        }

        public void setValue(Version value) {
            if (this.future != null && !this.future.isDone()) {
                this.future.cancel(true);
            }
            this.future = null;
            this.value = value;
        }
    }
}

