/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.button.base;

import it.auties.whatsapp.model.button.base.Button;
import it.auties.whatsapp.model.button.base.ButtonBody;
import it.auties.whatsapp.model.button.base.ButtonText;
import it.auties.whatsapp.model.info.NativeFlowInfo;
import java.util.Optional;

public class ButtonBuilder {
    private String id = null;
    private Optional<ButtonText> bodyText = Optional.empty();
    private Optional<NativeFlowInfo> bodyNativeFlow = Optional.empty();
    private ButtonBody.Type bodyType = null;

    public ButtonBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ButtonBuilder bodyText(Optional<ButtonText> bodyText) {
        this.bodyText = bodyText;
        return this;
    }

    public ButtonBuilder bodyText(ButtonText bodyText) {
        this.bodyText = Optional.ofNullable(bodyText);
        return this;
    }

    public ButtonBuilder bodyNativeFlow(Optional<NativeFlowInfo> bodyNativeFlow) {
        this.bodyNativeFlow = bodyNativeFlow;
        return this;
    }

    public ButtonBuilder bodyNativeFlow(NativeFlowInfo bodyNativeFlow) {
        this.bodyNativeFlow = Optional.ofNullable(bodyNativeFlow);
        return this;
    }

    public ButtonBuilder bodyType(ButtonBody.Type bodyType) {
        this.bodyType = bodyType;
        return this;
    }

    public Button build() {
        return new Button(this.id, this.bodyText, this.bodyNativeFlow, this.bodyType);
    }
}

