/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.chat;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufMessageName;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufEnum;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.chat.ChatDisappear;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.ChatMute;
import it.auties.whatsapp.model.chat.ChatWallpaper;
import it.auties.whatsapp.model.chat.GroupParticipant;
import it.auties.whatsapp.model.chat.GroupPastParticipant;
import it.auties.whatsapp.model.chat.GroupRole;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.jid.JidType;
import it.auties.whatsapp.model.media.MediaVisibility;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.ConcurrentLinkedHashedDequeue;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

@ProtobufMessageName(value="Conversation")
public final class Chat
implements ProtobufMessage,
JidProvider {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    final Jid jid;
    @ProtobufProperty(index=2, type=ProtobufType.OBJECT)
    final ConcurrentLinkedHashedDequeue<HistorySyncMessage> historySyncMessages;
    @ProtobufProperty(index=3, type=ProtobufType.STRING)
    final Jid newJid;
    @ProtobufProperty(index=4, type=ProtobufType.STRING)
    final Jid oldJid;
    @ProtobufProperty(index=6, type=ProtobufType.UINT32)
    int unreadMessagesCount;
    @ProtobufProperty(index=7, type=ProtobufType.BOOL)
    boolean readOnly;
    @ProtobufProperty(index=8, type=ProtobufType.BOOL)
    boolean endOfHistoryTransfer;
    @ProtobufProperty(index=9, type=ProtobufType.UINT32)
    ChatEphemeralTimer ephemeralMessageDuration;
    @ProtobufProperty(index=10, type=ProtobufType.INT64)
    long ephemeralMessagesToggleTimeSeconds;
    @ProtobufProperty(index=11, type=ProtobufType.OBJECT)
    EndOfHistoryTransferType endOfHistoryTransferType;
    @ProtobufProperty(index=12, type=ProtobufType.UINT64)
    long timestampSeconds;
    @ProtobufProperty(index=13, type=ProtobufType.STRING)
    String name;
    @ProtobufProperty(index=15, type=ProtobufType.BOOL)
    boolean notSpam;
    @ProtobufProperty(index=16, type=ProtobufType.BOOL)
    boolean archived;
    @ProtobufProperty(index=17, type=ProtobufType.OBJECT)
    ChatDisappear disappearInitiator;
    @ProtobufProperty(index=19, type=ProtobufType.BOOL)
    boolean markedAsUnread;
    @ProtobufProperty(index=20, type=ProtobufType.OBJECT)
    final List<GroupParticipant> participants;
    @ProtobufProperty(index=21, type=ProtobufType.BYTES)
    byte[] token;
    @ProtobufProperty(index=22, type=ProtobufType.UINT64)
    long tokenTimestampSeconds;
    @ProtobufProperty(index=23, type=ProtobufType.BYTES)
    byte[] identityKey;
    @ProtobufProperty(index=24, type=ProtobufType.UINT32)
    int pinnedTimestampSeconds;
    @ProtobufProperty(index=25, type=ProtobufType.UINT64)
    ChatMute mute;
    @ProtobufProperty(index=26, type=ProtobufType.OBJECT)
    ChatWallpaper wallpaper;
    @ProtobufProperty(index=27, type=ProtobufType.OBJECT)
    MediaVisibility mediaVisibility;
    @ProtobufProperty(index=28, type=ProtobufType.UINT64)
    long tokenSenderTimestampSeconds;
    @ProtobufProperty(index=29, type=ProtobufType.BOOL)
    boolean suspended;
    @ProtobufProperty(index=30, type=ProtobufType.BOOL)
    boolean terminated;
    @ProtobufProperty(index=31, type=ProtobufType.UINT64)
    long foundationTimestampSeconds;
    @ProtobufProperty(index=32, type=ProtobufType.STRING)
    Jid founder;
    @ProtobufProperty(index=33, type=ProtobufType.STRING)
    String description;
    @ProtobufProperty(index=34, type=ProtobufType.BOOL)
    boolean support;
    @ProtobufProperty(index=35, type=ProtobufType.BOOL)
    boolean parentGroup;
    @ProtobufProperty(index=36, type=ProtobufType.BOOL)
    boolean defaultSubGroup;
    @ProtobufProperty(index=37, type=ProtobufType.STRING)
    final Jid parentGroupJid;
    @ProtobufProperty(index=38, type=ProtobufType.STRING)
    String displayName;
    @ProtobufProperty(index=39, type=ProtobufType.STRING)
    Jid phoneJid;
    @ProtobufProperty(index=40, type=ProtobufType.BOOL)
    boolean shareOwnPhoneNumber;
    @ProtobufProperty(index=41, type=ProtobufType.BOOL)
    boolean pnhDuplicateLidThread;
    @ProtobufProperty(index=42, type=ProtobufType.STRING)
    Jid lidJid;
    @ProtobufProperty(index=999, type=ProtobufType.MAP, keyType=ProtobufType.STRING, valueType=ProtobufType.OBJECT)
    final ConcurrentHashMap<Jid, ContactStatus> presences;
    @ProtobufProperty(index=1000, type=ProtobufType.STRING)
    final Set<Jid> participantsPreKeys;
    @ProtobufProperty(index=1001, type=ProtobufType.OBJECT)
    final Set<GroupPastParticipant> pastParticipants;
    private boolean update;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Chat(Jid jid, ConcurrentLinkedHashedDequeue<HistorySyncMessage> historySyncMessages, Jid newJid, Jid oldJid, int unreadMessagesCount, boolean readOnly, boolean endOfHistoryTransfer, ChatEphemeralTimer ephemeralMessageDuration, long ephemeralMessagesToggleTimeSeconds, EndOfHistoryTransferType endOfHistoryTransferType, long timestampSeconds, String name, boolean notSpam, boolean archived, ChatDisappear disappearInitiator, boolean markedAsUnread, List<GroupParticipant> participants, byte[] token, long tokenTimestampSeconds, byte[] identityKey, int pinnedTimestampSeconds, ChatMute mute, ChatWallpaper wallpaper, MediaVisibility mediaVisibility, long tokenSenderTimestampSeconds, boolean suspended, boolean terminated, long foundationTimestampSeconds, Jid founder, String description, boolean support, boolean parentGroup, boolean defaultSubGroup, Jid parentGroupJid, String displayName, Jid phoneJid, boolean shareOwnPhoneNumber, boolean pnhDuplicateLidThread, Jid lidJid, ConcurrentHashMap<Jid, ContactStatus> presences, Set<Jid> participantsPreKeys, Set<GroupPastParticipant> pastParticipants) {
        this.jid = jid;
        this.historySyncMessages = historySyncMessages;
        this.newJid = newJid;
        this.oldJid = oldJid;
        this.unreadMessagesCount = unreadMessagesCount;
        this.readOnly = readOnly;
        this.endOfHistoryTransfer = endOfHistoryTransfer;
        this.ephemeralMessageDuration = ephemeralMessageDuration;
        this.ephemeralMessagesToggleTimeSeconds = ephemeralMessagesToggleTimeSeconds;
        this.endOfHistoryTransferType = endOfHistoryTransferType;
        this.timestampSeconds = timestampSeconds;
        this.name = name;
        this.notSpam = notSpam;
        this.archived = archived;
        this.disappearInitiator = disappearInitiator;
        this.markedAsUnread = markedAsUnread;
        this.participants = participants;
        this.token = token;
        this.tokenTimestampSeconds = tokenTimestampSeconds;
        this.identityKey = identityKey;
        this.pinnedTimestampSeconds = pinnedTimestampSeconds;
        this.mute = mute;
        this.wallpaper = wallpaper;
        this.mediaVisibility = mediaVisibility;
        this.tokenSenderTimestampSeconds = tokenSenderTimestampSeconds;
        this.suspended = suspended;
        this.terminated = terminated;
        this.foundationTimestampSeconds = foundationTimestampSeconds;
        this.founder = founder;
        this.description = description;
        this.support = support;
        this.parentGroup = parentGroup;
        this.defaultSubGroup = defaultSubGroup;
        this.parentGroupJid = parentGroupJid;
        this.displayName = displayName;
        this.phoneJid = phoneJid;
        this.shareOwnPhoneNumber = shareOwnPhoneNumber;
        this.pnhDuplicateLidThread = pnhDuplicateLidThread;
        this.lidJid = lidJid;
        this.presences = presences;
        this.participantsPreKeys = participantsPreKeys;
        this.pastParticipants = pastParticipants;
    }

    public String name() {
        if (this.name != null) {
            return this.name;
        }
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.jid.user();
    }

    public boolean isGroup() {
        return this.jid.type() == JidType.GROUP;
    }

    public boolean isPinned() {
        return this.pinnedTimestampSeconds != 0;
    }

    public boolean isEphemeral() {
        return this.ephemeralMessageDuration != ChatEphemeralTimer.OFF && this.ephemeralMessagesToggleTimeSeconds != 0L;
    }

    public Collection<ChatMessageInfo> unreadMessages() {
        if (!this.hasUnreadMessages()) {
            return List.of();
        }
        return this.historySyncMessages.stream().limit(this.unreadMessagesCount()).map(HistorySyncMessage::messageInfo).toList();
    }

    public boolean hasUnreadMessages() {
        return this.unreadMessagesCount > 0;
    }

    public Optional<ZonedDateTime> pinnedTimestamp() {
        return Clock.parseSeconds(this.pinnedTimestampSeconds);
    }

    public Optional<ZonedDateTime> timestamp() {
        return Clock.parseSeconds(this.timestampSeconds);
    }

    public Optional<ZonedDateTime> ephemeralMessagesToggleTime() {
        return Clock.parseSeconds(this.ephemeralMessagesToggleTimeSeconds);
    }

    public Optional<ChatMessageInfo> newestMessage() {
        return Optional.ofNullable(this.historySyncMessages.peekLast()).map(HistorySyncMessage::messageInfo);
    }

    public Optional<ChatMessageInfo> oldestMessage() {
        return Optional.ofNullable(this.historySyncMessages.peekFirst()).map(HistorySyncMessage::messageInfo);
    }

    public Optional<ChatMessageInfo> newestStandardMessage() {
        return this.findMessageBy(this::isStandardMessage, true);
    }

    public Optional<ChatMessageInfo> oldestStandardMessage() {
        return this.findMessageBy(this::isStandardMessage, false);
    }

    private boolean isStandardMessage(ChatMessageInfo info) {
        return !info.message().hasCategory(MessageCategory.SERVER) && info.stubType().isEmpty();
    }

    public Optional<ChatMessageInfo> newestMessageFromMe() {
        return this.findMessageBy(this::isMessageFromMe, true);
    }

    public Optional<ChatMessageInfo> oldestMessageFromMe() {
        return this.findMessageBy(this::isMessageFromMe, false);
    }

    private boolean isMessageFromMe(ChatMessageInfo info) {
        return !info.message().hasCategory(MessageCategory.SERVER) && info.stubType().isEmpty() && info.fromMe();
    }

    public Optional<ChatMessageInfo> newestServerMessage() {
        return this.findMessageBy(this::isServerMessage, true);
    }

    public Optional<ChatMessageInfo> oldestServerMessage() {
        return this.findMessageBy(this::isServerMessage, false);
    }

    private boolean isServerMessage(ChatMessageInfo info) {
        return info.message().hasCategory(MessageCategory.SERVER) || info.stubType().isPresent();
    }

    private Optional<ChatMessageInfo> findMessageBy(Function<ChatMessageInfo, Boolean> filter, boolean newest) {
        Iterator<HistorySyncMessage> descendingIterator;
        Iterator<HistorySyncMessage> iterator = descendingIterator = newest ? this.historySyncMessages.descendingIterator() : this.historySyncMessages.iterator();
        while (descendingIterator.hasNext()) {
            ChatMessageInfo info = descendingIterator.next().messageInfo();
            if (!filter.apply(info).booleanValue()) continue;
            return Optional.of(info);
        }
        return Optional.empty();
    }

    public Collection<ChatMessageInfo> starredMessages() {
        return this.historySyncMessages.stream().map(HistorySyncMessage::messageInfo).filter(ChatMessageInfo::starred).toList();
    }

    public Optional<ZonedDateTime> tokenTimestamp() {
        return Clock.parseSeconds(this.tokenTimestampSeconds);
    }

    public Optional<ZonedDateTime> tokenSenderTimestamp() {
        return Clock.parseSeconds(this.tokenSenderTimestampSeconds);
    }

    public Optional<ZonedDateTime> foundationTimestamp() {
        return Clock.parseSeconds(this.foundationTimestampSeconds);
    }

    public void addMessages(Collection<HistorySyncMessage> newMessages) {
        this.historySyncMessages.addAll(newMessages);
        this.update = true;
    }

    public void addOldMessages(Collection<HistorySyncMessage> oldMessages) {
        oldMessages.forEach(this.historySyncMessages::addFirst);
        this.update = true;
    }

    public boolean addNewMessage(ChatMessageInfo info) {
        HistorySyncMessage sync = new HistorySyncMessage(info, this.historySyncMessages.size());
        if (this.historySyncMessages.contains(sync)) {
            return false;
        }
        this.historySyncMessages.add(sync);
        this.update = true;
        this.updateChatTimestamp(info);
        return true;
    }

    public boolean addOldMessage(HistorySyncMessage info) {
        this.historySyncMessages.addFirst(info);
        this.update = true;
        return true;
    }

    public boolean removeMessage(ChatMessageInfo info) {
        boolean result = this.historySyncMessages.removeIf(entry -> Objects.equals(entry.messageInfo().id(), info.id()));
        if (result) {
            this.update = true;
        }
        this.refreshChatTimestamp();
        return result;
    }

    public boolean removeMessage(Predicate<? super ChatMessageInfo> predicate) {
        boolean result = this.historySyncMessages.removeIf(entry -> predicate.test(entry.messageInfo()));
        this.refreshChatTimestamp();
        return result;
    }

    private void refreshChatTimestamp() {
        Optional<ChatMessageInfo> message = this.newestMessage();
        if (message.isEmpty()) {
            return;
        }
        this.updateChatTimestamp(message.get());
    }

    private void updateChatTimestamp(ChatMessageInfo info) {
        if (info.timestampSeconds().isEmpty()) {
            return;
        }
        long newTimestamp = info.timestampSeconds().getAsLong();
        Long oldTimeStamp = this.newestMessage().map(value -> value.timestampSeconds().orElse(0L)).orElse(0L);
        if (oldTimeStamp > newTimestamp) {
            return;
        }
        this.timestampSeconds = newTimestamp;
        this.update = true;
    }

    public void removeMessages() {
        this.historySyncMessages.clear();
        this.update = true;
    }

    public Collection<HistorySyncMessage> messages() {
        return Collections.unmodifiableCollection(this.historySyncMessages);
    }

    public void addParticipants(Collection<GroupParticipant> participants) {
        participants.forEach(this::addParticipant);
        this.update = true;
    }

    public boolean addParticipant(Jid jid, GroupRole role) {
        boolean result = this.addParticipant(new GroupParticipant(jid, role));
        if (result) {
            this.update = true;
        }
        return result;
    }

    public boolean addParticipant(GroupParticipant participant) {
        boolean result = this.participants.add(participant);
        this.update = true;
        return true;
    }

    public boolean removeParticipant(Jid jid) {
        boolean result = this.participants.removeIf(entry -> Objects.equals(entry.jid(), jid));
        if (result) {
            this.update = true;
        }
        return result;
    }

    public Optional<GroupParticipant> findParticipant(Jid jid) {
        return this.participants.stream().filter(entry -> Objects.equals(entry.jid(), jid)).findFirst();
    }

    public boolean addPastParticipant(GroupPastParticipant participant) {
        boolean result = this.pastParticipants.add(participant);
        if (result) {
            this.update = true;
        }
        return result;
    }

    public boolean addPastParticipants(List<GroupPastParticipant> pastParticipants) {
        boolean result = true;
        for (GroupPastParticipant pastParticipant : pastParticipants) {
            result &= this.pastParticipants.add(pastParticipant);
        }
        if (result) {
            this.update = true;
        }
        return result;
    }

    public boolean removePastParticipant(Jid jid) {
        boolean result = this.pastParticipants.removeIf(entry -> Objects.equals(entry.jid(), jid));
        if (result) {
            this.update = true;
        }
        return result;
    }

    public Optional<GroupPastParticipant> findPastParticipant(Jid jid) {
        return this.pastParticipants.stream().filter(entry -> Objects.equals(entry.jid(), jid)).findFirst();
    }

    public Set<Jid> participantsPreKeys() {
        return Collections.unmodifiableSet(this.participantsPreKeys);
    }

    public void addParticipantsPreKeys(Collection<Jid> jids) {
        this.participantsPreKeys.addAll(jids);
        this.update = true;
    }

    public void clearParticipantsPreKeys() {
        this.participantsPreKeys.clear();
        this.update = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof Chat)) return false;
        Chat that = (Chat)other;
        if (!Objects.equals(this.jid(), that.jid())) return false;
        return true;
    }

    @Override
    public Jid toJid() {
        return this.jid();
    }

    public int hashCode() {
        return Objects.hash(this.jid());
    }

    public Jid jid() {
        return this.jid;
    }

    public Collection<HistorySyncMessage> historySyncMessages() {
        return this.historySyncMessages;
    }

    public Optional<Jid> newJid() {
        return Optional.ofNullable(this.newJid);
    }

    public Optional<Jid> oldJid() {
        return Optional.ofNullable(this.oldJid);
    }

    public int unreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public boolean endOfHistoryTransfer() {
        return this.endOfHistoryTransfer;
    }

    public ChatEphemeralTimer ephemeralMessageDuration() {
        return this.ephemeralMessageDuration;
    }

    public long ephemeralMessagesToggleTimeSeconds() {
        return this.ephemeralMessagesToggleTimeSeconds;
    }

    public Optional<EndOfHistoryTransferType> endOfHistoryTransferType() {
        return Optional.ofNullable(this.endOfHistoryTransferType);
    }

    public long timestampSeconds() {
        return this.timestampSeconds;
    }

    public boolean notSpam() {
        return this.notSpam;
    }

    public boolean archived() {
        return this.archived;
    }

    public Optional<ChatDisappear> disappearInitiator() {
        return Optional.ofNullable(this.disappearInitiator);
    }

    public boolean markedAsUnread() {
        return this.markedAsUnread;
    }

    public List<GroupParticipant> participants() {
        return Collections.unmodifiableList(this.participants);
    }

    public Optional<byte[]> token() {
        return Optional.ofNullable(this.token);
    }

    public long tokenTimestampSeconds() {
        return this.tokenTimestampSeconds;
    }

    public Optional<byte[]> identityKey() {
        return Optional.ofNullable(this.identityKey);
    }

    public int pinnedTimestampSeconds() {
        return this.pinnedTimestampSeconds;
    }

    public ChatMute mute() {
        return this.mute;
    }

    public Optional<ChatWallpaper> wallpaper() {
        return Optional.ofNullable(this.wallpaper);
    }

    public MediaVisibility mediaVisibility() {
        return this.mediaVisibility;
    }

    public long tokenSenderTimestampSeconds() {
        return this.tokenSenderTimestampSeconds;
    }

    public boolean suspended() {
        return this.suspended;
    }

    public boolean terminated() {
        return this.terminated;
    }

    public long foundationTimestampSeconds() {
        return this.foundationTimestampSeconds;
    }

    public Optional<Jid> founder() {
        return Optional.ofNullable(this.founder);
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public boolean support() {
        return this.support;
    }

    public boolean parentGroup() {
        return this.parentGroup;
    }

    public boolean defaultSubGroup() {
        return this.defaultSubGroup;
    }

    public Optional<Jid> parentGroupJid() {
        return Optional.ofNullable(this.parentGroupJid);
    }

    public Optional<String> displayName() {
        return Optional.ofNullable(this.displayName);
    }

    public Optional<Jid> phoneJid() {
        return Optional.ofNullable(this.phoneJid);
    }

    public boolean pnhDuplicateLidThread() {
        return this.pnhDuplicateLidThread;
    }

    public Optional<Jid> lidJid() {
        return Optional.ofNullable(this.lidJid);
    }

    public ConcurrentHashMap<Jid, ContactStatus> presences() {
        return this.presences;
    }

    public Set<GroupPastParticipant> pastParticipants() {
        return this.pastParticipants;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean shareOwnPhoneNumber() {
        return this.shareOwnPhoneNumber;
    }

    public Chat setUnreadMessagesCount(int unreadMessagesCount) {
        this.unreadMessagesCount = unreadMessagesCount;
        this.update = true;
        return this;
    }

    public Chat setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.update = true;
        return this;
    }

    public Chat setEndOfHistoryTransfer(boolean endOfHistoryTransfer) {
        this.endOfHistoryTransfer = endOfHistoryTransfer;
        this.update = true;
        return this;
    }

    public Chat setEphemeralMessageDuration(ChatEphemeralTimer ephemeralMessageDuration) {
        this.ephemeralMessageDuration = ephemeralMessageDuration;
        this.update = true;
        return this;
    }

    public Chat setEphemeralMessagesToggleTimeSeconds(long ephemeralMessagesToggleTimeSeconds) {
        this.ephemeralMessagesToggleTimeSeconds = ephemeralMessagesToggleTimeSeconds;
        this.update = true;
        return this;
    }

    public Chat setEndOfHistoryTransferType(EndOfHistoryTransferType endOfHistoryTransferType) {
        this.endOfHistoryTransferType = endOfHistoryTransferType;
        this.update = true;
        return this;
    }

    public Chat setTimestampSeconds(long timestampSeconds) {
        this.timestampSeconds = timestampSeconds;
        this.update = true;
        return this;
    }

    public Chat setName(String name) {
        this.name = name;
        this.update = true;
        return this;
    }

    public Chat setNotSpam(boolean notSpam) {
        this.notSpam = notSpam;
        this.update = true;
        return this;
    }

    public Chat setArchived(boolean archived) {
        this.archived = archived;
        this.update = true;
        return this;
    }

    public Chat setDisappearInitiator(ChatDisappear disappearInitiator) {
        this.disappearInitiator = disappearInitiator;
        this.update = true;
        return this;
    }

    public Chat setMarkedAsUnread(boolean markedAsUnread) {
        this.markedAsUnread = markedAsUnread;
        this.update = true;
        return this;
    }

    public Chat setToken(byte[] token) {
        this.token = token;
        this.update = true;
        return this;
    }

    public Chat setTokenTimestampSeconds(long tokenTimestampSeconds) {
        this.tokenTimestampSeconds = tokenTimestampSeconds;
        this.update = true;
        return this;
    }

    public Chat setIdentityKey(byte[] identityKey) {
        this.identityKey = identityKey;
        this.update = true;
        return this;
    }

    public Chat setPinnedTimestampSeconds(int pinnedTimestampSeconds) {
        this.pinnedTimestampSeconds = pinnedTimestampSeconds;
        this.update = true;
        return this;
    }

    public Chat setMute(ChatMute mute) {
        this.mute = mute;
        this.update = true;
        return this;
    }

    public Chat setWallpaper(ChatWallpaper wallpaper) {
        this.wallpaper = wallpaper;
        this.update = true;
        return this;
    }

    public Chat setMediaVisibility(MediaVisibility mediaVisibility) {
        this.mediaVisibility = mediaVisibility;
        this.update = true;
        return this;
    }

    public Chat setTokenSenderTimestampSeconds(long tokenSenderTimestampSeconds) {
        this.tokenSenderTimestampSeconds = tokenSenderTimestampSeconds;
        this.update = true;
        return this;
    }

    public Chat setSuspended(boolean suspended) {
        this.suspended = suspended;
        this.update = true;
        return this;
    }

    public Chat setTerminated(boolean terminated) {
        this.terminated = terminated;
        this.update = true;
        return this;
    }

    public Chat setFoundationTimestampSeconds(long foundationTimestampSeconds) {
        this.foundationTimestampSeconds = foundationTimestampSeconds;
        this.update = true;
        return this;
    }

    public Chat setFounder(Jid founder) {
        this.founder = founder;
        this.update = true;
        return this;
    }

    public Chat setDescription(String description) {
        this.description = description;
        this.update = true;
        return this;
    }

    public Chat setSupport(boolean support) {
        this.support = support;
        this.update = true;
        return this;
    }

    public Chat setParentGroup(boolean parentGroup) {
        this.parentGroup = parentGroup;
        this.update = true;
        return this;
    }

    public Chat setDefaultSubGroup(boolean defaultSubGroup) {
        this.defaultSubGroup = defaultSubGroup;
        this.update = true;
        return this;
    }

    public Chat setDisplayName(String displayName) {
        this.displayName = displayName;
        this.update = true;
        return this;
    }

    public Chat setPhoneJid(Jid phoneJid) {
        this.phoneJid = phoneJid;
        this.update = true;
        return this;
    }

    public Chat setShareOwnPhoneNumber(boolean shareOwnPhoneNumber) {
        this.shareOwnPhoneNumber = shareOwnPhoneNumber;
        this.update = true;
        return this;
    }

    public Chat setPnhDuplicateLidThread(boolean pnhDuplicateLidThread) {
        this.pnhDuplicateLidThread = pnhDuplicateLidThread;
        this.update = true;
        return this;
    }

    public Chat setLidJid(Jid lidJid) {
        this.lidJid = lidJid;
        this.update = true;
        return this;
    }

    public boolean hasUpdate() {
        return this.update;
    }

    @ProtobufMessageName(value="Conversation.EndOfHistoryTransferType")
    public static enum EndOfHistoryTransferType implements ProtobufEnum
    {
        COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY(0),
        COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY(1);

        final int index;

        private EndOfHistoryTransferType(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }
    }
}

