/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.companion;

import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import java.util.Optional;

public record CompanionDevice(@ProtobufProperty(index=1, type=ProtobufType.STRING) String model, @ProtobufProperty(index=2, type=ProtobufType.STRING) String manufacturer, @ProtobufProperty(index=3, type=ProtobufType.OBJECT) UserAgent.PlatformType platform, @ProtobufProperty(index=4, type=ProtobufType.OBJECT) Optional<Version> appVersion, @ProtobufProperty(index=5, type=ProtobufType.OBJECT) Version osVersion) implements ProtobufMessage
{
    public static CompanionDevice web() {
        return CompanionDevice.web(null);
    }

    public static CompanionDevice web(Version appVersion) {
        return new CompanionDevice("Chrome", "Google", UserAgent.PlatformType.WEB, Optional.ofNullable(appVersion), Version.of("1.0"));
    }

    public static CompanionDevice ios(boolean business) {
        return CompanionDevice.ios(null, business);
    }

    public static CompanionDevice ios(Version appVersion, boolean business) {
        return new CompanionDevice("iPhone_15_Pro_Max", "Apple", business ? UserAgent.PlatformType.IOS_BUSINESS : UserAgent.PlatformType.IOS, Optional.ofNullable(appVersion), Version.of("17.4.1"));
    }

    public String toUserAgent(Version appVersion) {
        return "WhatsApp/%s %s/%s Device/%s".formatted(appVersion, this.platformName(), this.osVersion(), this.deviceName());
    }

    public CompanionDevice toPersonal() {
        if (!this.platform.isBusiness()) {
            return this;
        }
        return new CompanionDevice(this.model, this.manufacturer, this.platform.toPersonal(), this.appVersion, this.osVersion);
    }

    public CompanionDevice toBusiness() {
        if (this.platform.isBusiness()) {
            return this;
        }
        return new CompanionDevice(this.model, this.manufacturer, this.platform.toBusiness(), this.appVersion, this.osVersion);
    }

    private String deviceName() {
        switch (this.platform()) {
            case IOS: 
            case IOS_BUSINESS: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mobile os");
            }
        }
        return this.model;
    }

    private String platformName() {
        return switch (this.platform()) {
            case UserAgent.PlatformType.IOS -> "iOS";
            case UserAgent.PlatformType.IOS_BUSINESS -> "SMB iOS";
            default -> throw new IllegalStateException("Unsupported mobile os");
        };
    }
}

