/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.companion;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.companion.CompanionDevice;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.UserAgentPlatformTypeSpec;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.model.signal.auth.VersionSpec;
import java.util.Optional;

public class CompanionDeviceSpec {
    public static byte[] encode(CompanionDevice protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeString(1, protoInputObject.model());
        outputStream.writeString(2, protoInputObject.manufacturer());
        outputStream.writeInt32(3, UserAgentPlatformTypeSpec.encode(protoInputObject.platform()));
        Optional<Version> appVersion = protoInputObject.appVersion();
        Version appVersion0 = appVersion.orElse(null);
        if (appVersion0 != null) {
            outputStream.writeBytes(4, VersionSpec.encode(appVersion0));
        }
        outputStream.writeBytes(5, VersionSpec.encode(protoInputObject.osVersion()));
        return outputStream.toByteArray();
    }

    public static CompanionDevice decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        String model = null;
        String manufacturer = null;
        UserAgent.PlatformType platform = null;
        Optional<Version> appVersion = Optional.empty();
        Version osVersion = null;
        block7: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    model = inputStream.readString();
                    continue block7;
                }
                case 2: {
                    manufacturer = inputStream.readString();
                    continue block7;
                }
                case 3: {
                    platform = UserAgentPlatformTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block7;
                }
                case 4: {
                    appVersion = Optional.ofNullable(VersionSpec.decode(inputStream.readBytes()));
                    continue block7;
                }
                case 5: {
                    osVersion = VersionSpec.decode(inputStream.readBytes());
                    continue block7;
                }
            }
            inputStream.skipBytes();
        }
        return new CompanionDevice(model, manufacturer, platform, appVersion, osVersion);
    }
}

