/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import it.auties.protobuf.annotation.ProtobufMessageName;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufEnum;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.info.Info;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.payment.PaymentMoney;
import it.auties.whatsapp.util.Clock;
import java.time.ZonedDateTime;
import java.util.Optional;

@ProtobufMessageName(value="PaymentInfo")
public record PaymentInfo(@Deprecated @ProtobufProperty(index=1, type=ProtobufType.OBJECT) Currency currencyDeprecated, @ProtobufProperty(index=2, type=ProtobufType.UINT64) long amount1000, @ProtobufProperty(index=3, type=ProtobufType.STRING) Jid receiverJid, @ProtobufProperty(index=4, type=ProtobufType.OBJECT) Status status, @ProtobufProperty(index=5, type=ProtobufType.UINT64) long transactionTimestampSeconds, @ProtobufProperty(index=6, type=ProtobufType.OBJECT) ChatMessageKey requestMessageKey, @ProtobufProperty(index=7, type=ProtobufType.UINT64) long expiryTimestampSeconds, @ProtobufProperty(index=8, type=ProtobufType.BOOL) boolean futureProofed, @ProtobufProperty(index=9, type=ProtobufType.STRING) String currency, @ProtobufProperty(index=10, type=ProtobufType.OBJECT) TransactionStatus transactionStatus, @ProtobufProperty(index=11, type=ProtobufType.BOOL) boolean useNoviFormat, @ProtobufProperty(index=12, type=ProtobufType.OBJECT) PaymentMoney primaryAmount, @ProtobufProperty(index=13, type=ProtobufType.OBJECT) PaymentMoney exchangeAmount) implements Info,
ProtobufMessage
{
    public Optional<ZonedDateTime> transactionTimestamp() {
        return Clock.parseSeconds(this.transactionTimestampSeconds);
    }

    public Optional<ZonedDateTime> expiryTimestamp() {
        return Clock.parseSeconds(this.expiryTimestampSeconds);
    }

    @ProtobufMessageName(value="PaymentInfo.Currency")
    public static enum Currency implements ProtobufEnum
    {
        UNKNOWN_CURRENCY(0),
        INR(1);

        final int index;

        private Currency(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }
    }

    @ProtobufMessageName(value="PaymentInfo.Status")
    public static enum Status implements ProtobufEnum
    {
        UNKNOWN_STATUS(0),
        PROCESSING(1),
        SENT(2),
        NEED_TO_ACCEPT(3),
        COMPLETE(4),
        COULD_NOT_COMPLETE(5),
        REFUNDED(6),
        EXPIRED(7),
        REJECTED(8),
        CANCELLED(9),
        WAITING_FOR_PAYER(10),
        WAITING(11);

        final int index;

        private Status(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }
    }

    @ProtobufMessageName(value="PaymentInfo.TxnStatus")
    public static enum TransactionStatus implements ProtobufEnum
    {
        UNKNOWN(0),
        PENDING_SETUP(1),
        PENDING_RECEIVER_SETUP(2),
        INIT(3),
        SUCCESS(4),
        COMPLETED(5),
        FAILED(6),
        FAILED_RISK(7),
        FAILED_PROCESSING(8),
        FAILED_RECEIVER_PROCESSING(9),
        FAILED_DA(10),
        FAILED_DA_FINAL(11),
        REFUNDED_TXN(12),
        REFUND_FAILED(13),
        REFUND_FAILED_PROCESSING(14),
        REFUND_FAILED_DA(15),
        EXPIRED_TXN(16),
        AUTH_CANCELED(17),
        AUTH_CANCEL_FAILED_PROCESSING(18),
        AUTH_CANCEL_FAILED(19),
        COLLECT_INIT(20),
        COLLECT_SUCCESS(21),
        COLLECT_FAILED(22),
        COLLECT_FAILED_RISK(23),
        COLLECT_REJECTED(24),
        COLLECT_EXPIRED(25),
        COLLECT_CANCELED(26),
        COLLECT_CANCELLING(27),
        IN_REVIEW(28),
        REVERSAL_SUCCESS(29),
        REVERSAL_PENDING(30),
        REFUND_PENDING(31);

        final int index;

        private TransactionStatus(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }
    }
}

