/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.model.MessageContainer;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public final class QuotedMessageInfo
implements MessageInfo {
    private final String id;
    private final Chat chat;
    private final Contact sender;
    private final MessageContainer message;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public QuotedMessageInfo(String id, Chat chat, Contact sender, MessageContainer message) {
        this.id = id;
        this.chat = chat;
        this.sender = sender;
        this.message = message;
    }

    public static Optional<QuotedMessageInfo> of(ContextInfo contextInfo) {
        if (!contextInfo.hasQuotedMessage()) {
            return Optional.empty();
        }
        String id = contextInfo.quotedMessageId().orElseThrow();
        Chat chat = contextInfo.quotedMessageChat().orElseThrow();
        Contact sender = contextInfo.quotedMessageSender().orElse(null);
        MessageContainer message = contextInfo.quotedMessage().orElseThrow();
        return Optional.of(new QuotedMessageInfo(id, chat, sender, message));
    }

    @Override
    public Jid parentJid() {
        return this.chat.jid();
    }

    @Override
    public Jid senderJid() {
        return Objects.requireNonNullElseGet(this.sender.jid(), this::parentJid);
    }

    public Optional<Contact> sender() {
        return Optional.ofNullable(this.sender);
    }

    @Override
    public String id() {
        return this.id;
    }

    public Optional<Chat> chat() {
        return Optional.of(this.chat);
    }

    @Override
    public MessageContainer message() {
        return this.message;
    }

    @Override
    public OptionalLong timestampSeconds() {
        return OptionalLong.empty();
    }
}

