/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.jid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import it.auties.protobuf.annotation.ProtobufConverter;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.jid.JidType;
import it.auties.whatsapp.model.signal.session.SessionAddress;
import java.util.Objects;

public record Jid(String user, JidServer server, Integer device, Integer agent) implements JidProvider
{
    private final Integer device;
    private final Integer agent;

    public Jid(String user, JidServer server, Integer device, Integer agent) {
        this.user = user != null && user.startsWith("+") ? user.substring(1) : user;
        this.server = server;
        this.device = device;
        this.agent = agent;
    }

    public static Jid ofServer(JidServer server) {
        return Jid.of(null, server);
    }

    @ProtobufConverter
    public static Jid ofProtobuf(String input) {
        return input == null ? null : Jid.of(input);
    }

    public static Jid of(String jid, JidServer server) {
        String complexUser = Jid.withoutServer(jid);
        if (complexUser == null) {
            return new Jid(null, server, null, null);
        }
        if (complexUser.contains(":")) {
            String[] simpleUser = complexUser.split(":", 2);
            String user = simpleUser[0];
            int device = Integer.parseUnsignedInt(simpleUser[1]);
            if (user.contains("_")) {
                String[] simpleUserAgent = user.split("_", 2);
                Integer agent = Jid.tryParseAgent(simpleUserAgent[1]);
                return new Jid(simpleUserAgent[0], server, device, agent);
            }
            return new Jid(user, server, device, null);
        }
        if (!complexUser.contains("_")) {
            return new Jid(complexUser, server, null, null);
        }
        String[] simpleUserAgent = complexUser.split("_", 2);
        Integer agent = Jid.tryParseAgent(simpleUserAgent[1]);
        return new Jid(simpleUserAgent[0], server, null, agent);
    }

    public static String withoutServer(String jid) {
        if (jid == null) {
            return null;
        }
        for (JidServer server : JidServer.values()) {
            jid = jid.replace("@%s".formatted(new Object[]{server}), "");
        }
        return jid;
    }

    private static Integer tryParseAgent(String string) {
        try {
            return Integer.parseUnsignedInt(string);
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    public static Jid ofDevice(String jid, int device) {
        return new Jid(Jid.withoutServer(jid), JidServer.WHATSAPP, device, null);
    }

    @JsonCreator
    public static Jid of(String jid) {
        return Jid.of(jid, JidServer.of(jid));
    }

    public static Jid of(long jid) {
        return Jid.of(String.valueOf(jid), JidServer.WHATSAPP);
    }

    public JidType type() {
        JidType jidType;
        if (this.isCompanion()) {
            jidType = JidType.COMPANION;
        } else {
            block0 : switch (this.server()) {
                default: {
                    throw new MatchException(null, null);
                }
                case WHATSAPP: {
                    if (Objects.equals(this.user(), "16505361212")) {
                        jidType = JidType.OFFICIAL_SURVEY_ACCOUNT;
                        break;
                    }
                    jidType = JidType.USER;
                    break;
                }
                case LID: {
                    jidType = JidType.LID;
                    break;
                }
                case BROADCAST: {
                    if (Objects.equals(this.user(), "status")) {
                        jidType = JidType.STATUS;
                        break;
                    }
                    jidType = JidType.BROADCAST;
                    break;
                }
                case GROUP: {
                    jidType = JidType.GROUP;
                    break;
                }
                case GROUP_CALL: {
                    jidType = JidType.GROUP_CALL;
                    break;
                }
                case NEWSLETTER: {
                    jidType = JidType.NEWSLETTER;
                    break;
                }
                case USER: {
                    switch (this.user()) {
                        case "server": {
                            jidType = JidType.SERVER;
                            break block0;
                        }
                        case "0": {
                            jidType = JidType.ANNOUNCEMENT;
                            break block0;
                        }
                        case "16508638904": {
                            jidType = JidType.IAS;
                            break block0;
                        }
                        case "16505361212": {
                            jidType = JidType.OFFICIAL_BUSINESS_ACCOUNT;
                            break block0;
                        }
                    }
                    jidType = JidType.UNKNOWN;
                }
            }
        }
        return jidType;
    }

    public boolean isCompanion() {
        return this.device() != 0;
    }

    public boolean hasServer(JidServer server) {
        return this.server() == server;
    }

    public boolean isServerJid(JidServer server) {
        return this.user() == null && this.server() == server;
    }

    public Jid withServer(JidServer server) {
        return new Jid(this.user(), server, this.device, this.agent);
    }

    public Jid toSimpleJid() {
        return Jid.of(this.user(), this.server());
    }

    public String toPhoneNumber() {
        return "+%s".formatted(this.user);
    }

    @Override
    @JsonValue
    @ProtobufConverter
    public String toString() {
        String user = Objects.requireNonNullElse(this.user(), "");
        String agent = this.hasAgent() ? "_%s".formatted(this.agent()) : "";
        String device = this.hasDevice() ? ":%s".formatted(this.device()) : "";
        String leading = "%s%s%s".formatted(user, agent, device);
        return leading.isEmpty() ? this.server().toString() : "%s@%s".formatted(new Object[]{leading, this.server()});
    }

    public SessionAddress toSignalAddress() {
        return new SessionAddress(this.user(), this.device());
    }

    @Override
    public Jid toJid() {
        return this;
    }

    public Integer device() {
        return Objects.requireNonNullElse(this.device, 0);
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public Integer agent() {
        return Objects.requireNonNullElse(this.agent, 0);
    }

    public boolean hasAgent() {
        return this.agent != null;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.toString());
    }
}

