/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.media;

import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.util.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public record MediaKeys(byte[] mediaKey, byte[] iv, byte[] cipherKey, byte[] macKey, byte[] ref) {
    private static final int EXPANDED_SIZE = 112;

    public static MediaKeys random(String type) {
        return MediaKeys.of(Bytes.random(32), type);
    }

    public static MediaKeys of(byte[] key, String type) {
        byte[] keyName = type.getBytes(StandardCharsets.UTF_8);
        byte[] expanded = Hkdf.extractAndExpand(key, keyName, 112);
        byte[] iv = Arrays.copyOfRange(expanded, 0, 16);
        byte[] cipherKey = Arrays.copyOfRange(expanded, 16, 48);
        byte[] macKey = Arrays.copyOfRange(expanded, 48, 80);
        byte[] ref = Arrays.copyOfRange(expanded, 80, expanded.length);
        return new MediaKeys(key, iv, cipherKey, macKey, ref);
    }
}

