/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.standard.GroupInviteMessage;
import it.auties.whatsapp.model.message.standard.GroupInviteMessageTypeSpec;
import java.util.Optional;

public class GroupInviteMessageSpec {
    public static byte[] encode(GroupInviteMessage protoInputObject) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        String caption0;
        Optional<String> caption;
        byte[] thumbnail0;
        String group0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Jid group = protoInputObject.group();
        if (group != null && (group0 = group.toString()) != null) {
            outputStream.writeString(1, group0);
        }
        outputStream.writeString(2, protoInputObject.code());
        outputStream.writeUInt64(3, Long.valueOf(protoInputObject.expirationSeconds()));
        outputStream.writeString(4, protoInputObject.groupName());
        Optional<byte[]> thumbnail = protoInputObject.thumbnail();
        if (thumbnail != null && (thumbnail0 = (byte[])thumbnail.orElse(null)) != null) {
            outputStream.writeBytes(5, thumbnail0);
        }
        if ((caption = protoInputObject.caption()) != null && (caption0 = (String)caption.orElse(null)) != null) {
            outputStream.writeString(6, caption0);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)contextInfo.orElse(null)) != null) {
            outputStream.writeBytes(7, ContextInfoSpec.encode(contextInfo0));
        }
        outputStream.writeInt32(8, GroupInviteMessageTypeSpec.encode(protoInputObject.groupType()));
        return outputStream.toByteArray();
    }

    public static GroupInviteMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        Jid group = null;
        String code = null;
        long expirationSeconds = 0L;
        String groupName = null;
        byte[] thumbnail = null;
        String caption = null;
        ContextInfo contextInfo = null;
        GroupInviteMessage.Type groupType = null;
        block10: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    group = Jid.ofProtobuf(inputStream.readString());
                    continue block10;
                }
                case 2: {
                    code = inputStream.readString();
                    continue block10;
                }
                case 3: {
                    expirationSeconds = inputStream.readInt64();
                    continue block10;
                }
                case 4: {
                    groupName = inputStream.readString();
                    continue block10;
                }
                case 5: {
                    thumbnail = inputStream.readBytes();
                    continue block10;
                }
                case 6: {
                    caption = inputStream.readString();
                    continue block10;
                }
                case 7: {
                    contextInfo = ContextInfoSpec.decode(inputStream.readBytes());
                    continue block10;
                }
                case 8: {
                    groupType = GroupInviteMessageTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block10;
                }
            }
            inputStream.skipBytes();
        }
        return new GroupInviteMessage(group, code, expirationSeconds, groupName, thumbnail, caption, contextInfo, groupType);
    }
}

