/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.node;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import it.auties.whatsapp.model.jid.Jid;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.BooleanSupplier;
import java.util.function.Function;

public record Attributes(@JsonValue LinkedHashMap<String, Object> toMap) {
    @SafeVarargs
    public static Attributes of(Map.Entry<String, Object> ... entries) {
        return Attributes.ofNullable(Map.ofEntries(entries));
    }

    @SafeVarargs
    @JsonCreator
    public static Attributes ofNullable(Map.Entry<String, Object> ... entries) {
        return entries == null ? Attributes.of(new Map.Entry[0]) : Attributes.ofNullable(Map.ofEntries(entries));
    }

    public static Attributes ofNullable(Map<String, ?> map) {
        LinkedHashMap modifiableMap = Optional.ofNullable(map).map(LinkedHashMap::new).orElseGet(LinkedHashMap::new);
        return new Attributes(modifiableMap);
    }

    public static Attributes of(Map<String, ?> map) {
        return Attributes.ofNullable(Objects.requireNonNull(map));
    }

    public boolean hasKey(String key) {
        return this.toMap.containsKey(key);
    }

    public boolean hasValue(String key, String value) {
        return Objects.equals(this.toMap.get(key), value);
    }

    @SafeVarargs
    public final <T> Attributes put(String key, T value, Function<T, Boolean> ... conditions) {
        BooleanSupplier[] translated = (BooleanSupplier[])Arrays.stream(conditions).map(condition -> () -> (Boolean)condition.apply(value)).toArray(BooleanSupplier[]::new);
        return this.put(key, value, translated);
    }

    public Attributes put(String key, Object value, BooleanSupplier ... conditions) {
        return this.put(key, value, Arrays.stream(conditions).allMatch(BooleanSupplier::getAsBoolean));
    }

    public Attributes put(String key, Object value, boolean condition) {
        if (condition) {
            this.toMap.put(key, value);
        }
        return this;
    }

    public Attributes put(String key, Object value) {
        this.toMap.put(key, value);
        return this;
    }

    public <T> T get(String key, T defaultValue, Class<T> clazz) {
        return this.get(key, clazz).orElse(defaultValue);
    }

    public <T> Optional<T> get(String key, Class<T> clazz) {
        return Optional.ofNullable(this.toMap.get(key)).map(clazz::cast);
    }

    public int getInt(String key) {
        return this.getOptionalInt(key).orElse(0);
    }

    public OptionalInt getOptionalInt(String key) {
        return this.get(key, Object.class).stream().mapToInt(this::parseInt).findFirst();
    }

    private int parseInt(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
            case 0 -> {
                Number number = (Number)object;
                yield number.intValue();
            }
            case 1 -> {
                String string = (String)object;
                yield Integer.parseInt(string);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(value));
        };
    }

    public long getLong(String key) {
        return this.getOptionalLong(key).orElse(0L);
    }

    public OptionalLong getOptionalLong(String key) {
        return this.get(key, Object.class).stream().mapToLong(this::parseLong).findFirst();
    }

    private long parseLong(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
            case 0 -> {
                Number number = (Number)object;
                yield number.longValue();
            }
            case 1 -> {
                String string = (String)object;
                yield Long.parseLong(string);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(value));
        };
    }

    public String getString(String key) {
        return this.getString(key, "unknown");
    }

    public String getString(String key, String defaultValue) {
        return this.get(key, Object.class).map(Object::toString).orElse(defaultValue);
    }

    public String getNullableString(String key) {
        return this.getString(key, null);
    }

    public Integer getNullableInt(String key) {
        OptionalInt result = this.getOptionalInt(key);
        return result.isPresent() ? Integer.valueOf(result.getAsInt()) : null;
    }

    public Long getNullableLong(String key) {
        OptionalLong result = this.getOptionalLong(key);
        return result.isPresent() ? Long.valueOf(result.getAsLong()) : null;
    }

    public String getRequiredString(String key) {
        return Objects.requireNonNull(this.getString(key, null), "Missing required attribute %s".formatted(key));
    }

    public int getRequiredInt(String key) {
        return this.getOptionalInt(key).orElseThrow(() -> new NullPointerException("Missing required attribute %s".formatted(key)));
    }

    public long getRequiredLong(String key) {
        return this.getOptionalLong(key).orElseThrow(() -> new NullPointerException("Missing required attribute %s".formatted(key)));
    }

    public Optional<String> getOptionalString(String key) {
        return Optional.ofNullable(this.getString(key, null));
    }

    public boolean getBoolean(String key) {
        return this.get(key, Object.class).map(this::parseBool).orElse(false);
    }

    private boolean parseBool(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, String.class}, (Object)object, n)) {
            case 0 -> {
                Boolean bool = (Boolean)object;
                yield bool;
            }
            case 1 -> {
                String string = (String)object;
                yield Boolean.parseBoolean(string);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(value));
        };
    }

    public Optional<Jid> getOptionalJid(String key) {
        return this.get(key, Object.class).map(this::parseJid);
    }

    public Jid getRequiredJid(String key) {
        return this.get(key, Object.class).map(this::parseJid).orElseThrow(() -> new NullPointerException("Missing required attribute %s".formatted(key)));
    }

    private Jid parseJid(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Jid.class, String.class}, (Object)object, n)) {
            case 0 -> {
                Jid jid;
                yield jid = (Jid)object;
            }
            case 1 -> {
                String encodedJid = (String)object;
                yield Jid.of(encodedJid);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(value));
        };
    }

    public Attributes copy() {
        return new Attributes(this.toMap);
    }

    public boolean isEmpty() {
        return this.toMap.isEmpty();
    }

    public Attributes putAll(Map<String, ?> map) {
        return this.putAll(map.entrySet());
    }

    public Attributes putAll(Collection<? extends Map.Entry<String, ?>> entries) {
        for (Map.Entry<String, ?> entry : entries) {
            this.toMap.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @SafeVarargs
    public final Attributes putAll(Map.Entry<String, ?> ... entries) {
        for (Map.Entry<String, ?> entry : entries) {
            this.toMap.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Map.Entry<String, Object>[] toEntries() {
        return (Map.Entry[])this.toMap.entrySet().toArray(Map.Entry[]::new);
    }
}

