/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.setting;

import it.auties.whatsapp.model.chat.ChatWallpaper;
import it.auties.whatsapp.model.media.MediaVisibility;
import it.auties.whatsapp.model.setting.AutoDownloadSettings;
import it.auties.whatsapp.model.setting.AvatarUserSettings;
import it.auties.whatsapp.model.setting.GlobalSettings;
import java.util.Optional;

public class GlobalSettingsBuilder {
    private Optional<ChatWallpaper> lightThemeWallpaper = Optional.empty();
    private MediaVisibility mediaVisibility = null;
    private Optional<ChatWallpaper> darkThemeWallpaper = Optional.empty();
    private Optional<AutoDownloadSettings> autoDownloadWiFi = Optional.empty();
    private Optional<AutoDownloadSettings> autoDownloadCellular = Optional.empty();
    private Optional<AutoDownloadSettings> autoDownloadRoaming = Optional.empty();
    private boolean showIndividualNotificationsPreview = false;
    private boolean showGroupNotificationsPreview = false;
    private int disappearingModeDuration = 0;
    private long disappearingModeTimestampSeconds = 0L;
    private AvatarUserSettings avatarUserSettings = null;

    public GlobalSettingsBuilder lightThemeWallpaper(Optional<ChatWallpaper> lightThemeWallpaper) {
        this.lightThemeWallpaper = lightThemeWallpaper;
        return this;
    }

    public GlobalSettingsBuilder lightThemeWallpaper(ChatWallpaper lightThemeWallpaper) {
        this.lightThemeWallpaper = Optional.ofNullable(lightThemeWallpaper);
        return this;
    }

    public GlobalSettingsBuilder mediaVisibility(MediaVisibility mediaVisibility) {
        this.mediaVisibility = mediaVisibility;
        return this;
    }

    public GlobalSettingsBuilder darkThemeWallpaper(Optional<ChatWallpaper> darkThemeWallpaper) {
        this.darkThemeWallpaper = darkThemeWallpaper;
        return this;
    }

    public GlobalSettingsBuilder darkThemeWallpaper(ChatWallpaper darkThemeWallpaper) {
        this.darkThemeWallpaper = Optional.ofNullable(darkThemeWallpaper);
        return this;
    }

    public GlobalSettingsBuilder autoDownloadWiFi(Optional<AutoDownloadSettings> autoDownloadWiFi) {
        this.autoDownloadWiFi = autoDownloadWiFi;
        return this;
    }

    public GlobalSettingsBuilder autoDownloadWiFi(AutoDownloadSettings autoDownloadWiFi) {
        this.autoDownloadWiFi = Optional.ofNullable(autoDownloadWiFi);
        return this;
    }

    public GlobalSettingsBuilder autoDownloadCellular(Optional<AutoDownloadSettings> autoDownloadCellular) {
        this.autoDownloadCellular = autoDownloadCellular;
        return this;
    }

    public GlobalSettingsBuilder autoDownloadCellular(AutoDownloadSettings autoDownloadCellular) {
        this.autoDownloadCellular = Optional.ofNullable(autoDownloadCellular);
        return this;
    }

    public GlobalSettingsBuilder autoDownloadRoaming(Optional<AutoDownloadSettings> autoDownloadRoaming) {
        this.autoDownloadRoaming = autoDownloadRoaming;
        return this;
    }

    public GlobalSettingsBuilder autoDownloadRoaming(AutoDownloadSettings autoDownloadRoaming) {
        this.autoDownloadRoaming = Optional.ofNullable(autoDownloadRoaming);
        return this;
    }

    public GlobalSettingsBuilder showIndividualNotificationsPreview(boolean showIndividualNotificationsPreview) {
        this.showIndividualNotificationsPreview = showIndividualNotificationsPreview;
        return this;
    }

    public GlobalSettingsBuilder showGroupNotificationsPreview(boolean showGroupNotificationsPreview) {
        this.showGroupNotificationsPreview = showGroupNotificationsPreview;
        return this;
    }

    public GlobalSettingsBuilder disappearingModeDuration(int disappearingModeDuration) {
        this.disappearingModeDuration = disappearingModeDuration;
        return this;
    }

    public GlobalSettingsBuilder disappearingModeTimestampSeconds(long disappearingModeTimestampSeconds) {
        this.disappearingModeTimestampSeconds = disappearingModeTimestampSeconds;
        return this;
    }

    public GlobalSettingsBuilder avatarUserSettings(AvatarUserSettings avatarUserSettings) {
        this.avatarUserSettings = avatarUserSettings;
        return this;
    }

    public GlobalSettings build() {
        return new GlobalSettings(this.lightThemeWallpaper, this.mediaVisibility, this.darkThemeWallpaper, this.autoDownloadWiFi, this.autoDownloadCellular, this.autoDownloadRoaming, this.showIndividualNotificationsPreview, this.showGroupNotificationsPreview, this.disappearingModeDuration, this.disappearingModeTimestampSeconds, this.avatarUserSettings);
    }
}

