/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.sender.SenderChainKey;
import it.auties.whatsapp.model.signal.sender.SenderMessageKey;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class SenderKeyState
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.INT32)
    private final int id;
    @ProtobufProperty(index=2, type=ProtobufType.OBJECT)
    private final SignalKeyPair signingKey;
    @ProtobufProperty(index=3, type=ProtobufType.MAP, keyType=ProtobufType.INT32, valueType=ProtobufType.OBJECT)
    private final ConcurrentHashMap<Integer, SenderMessageKey> messageKeys;
    @ProtobufProperty(index=4, type=ProtobufType.OBJECT)
    private SenderChainKey chainKey;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SenderKeyState(int id, SignalKeyPair signingKey, ConcurrentHashMap<Integer, SenderMessageKey> messageKeys, SenderChainKey chainKey) {
        this.id = id;
        this.signingKey = signingKey;
        this.messageKeys = messageKeys;
        this.chainKey = chainKey;
    }

    public SenderKeyState(int id, SignalKeyPair signingKey, int iteration, byte[] seed) {
        this.id = id;
        this.signingKey = signingKey;
        this.chainKey = new SenderChainKey(iteration, seed);
        this.messageKeys = new ConcurrentHashMap();
    }

    public Map<Integer, SenderMessageKey> messageKeys() {
        return Collections.unmodifiableMap(this.messageKeys);
    }

    public void addSenderMessageKey(SenderMessageKey senderMessageKey) {
        this.messageKeys.put(senderMessageKey.iteration(), senderMessageKey);
    }

    public Optional<SenderMessageKey> findSenderMessageKey(int iteration) {
        return Optional.ofNullable(this.messageKeys.get(iteration));
    }

    public int id() {
        return this.id;
    }

    public SignalKeyPair signingKey() {
        return this.signingKey;
    }

    public SenderChainKey chainKey() {
        return this.chainKey;
    }

    public void setChainKey(SenderChainKey chainKey) {
        this.chainKey = chainKey;
    }

    public int hashCode() {
        return Objects.hashCode(this.id());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof SenderKeyState)) return false;
        SenderKeyState that = (SenderKeyState)other;
        if (!Objects.equals(this.id(), that.id())) return false;
        return true;
    }
}

