/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.registration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.crypto.MD5;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateBuilder;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetails;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetailsBuilder;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetailsSpec;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.ProxyAuthenticator;
import it.auties.whatsapp.util.Specification;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class WhatsappMetadata {
    private static volatile Version webVersion;
    private static volatile Version personalIosVersion;
    private static volatile Version businessIosVersion;

    public static CompletableFuture<Version> getVersion(UserAgent.PlatformType platform) {
        return switch (platform) {
            case UserAgent.PlatformType.WEB, UserAgent.PlatformType.WINDOWS, UserAgent.PlatformType.MACOS -> WhatsappMetadata.getWebVersion();
            case UserAgent.PlatformType.IOS -> WhatsappMetadata.getIosVersion(false);
            case UserAgent.PlatformType.IOS_BUSINESS -> WhatsappMetadata.getIosVersion(true);
            default -> throw new IllegalStateException("Unsupported mobile os: " + String.valueOf((Object)platform));
        };
    }

    private static CompletableFuture<Version> getIosVersion(boolean business) {
        if (business && businessIosVersion != null) {
            return CompletableFuture.completedFuture(businessIosVersion);
        }
        if (!business && personalIosVersion != null) {
            return CompletableFuture.completedFuture(personalIosVersion);
        }
        return Medias.downloadAsync(URI.create(business ? "https://itunes.apple.com/lookup?bundleId=net.whatsapp.WhatsAppSMB" : "https://itunes.apple.com/lookup?bundleId=net.whatsapp.WhatsApp"), "Mozilla/5.0 (iPhone; CPU iPhone OS 17_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.3.1 Mobile/15E148 Safari/604.1", new Map.Entry[0]).thenApplyAsync(response -> {
            Version result = Json.readValue(response, IosVersionResponse.class).version().filter(version -> String.valueOf(version.tertiary()).length() != 1 || String.valueOf(version.quaternary()).length() != 1).orElse(business ? Specification.Whatsapp.MOBILE_DEFAULT_BUSINESS_IOS_VERSION : Specification.Whatsapp.MOBILE_DEFAULT_PERSONAL_IOS_VERSION);
            if (business) {
                businessIosVersion = result;
            } else {
                personalIosVersion = result;
            }
            return result;
        });
    }

    private static CompletableFuture<Version> getWebVersion() {
        if (webVersion != null) {
            return CompletableFuture.completedFuture(webVersion);
        }
        HttpClient client = HttpClient.newHttpClient();
        try {
            HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create("https://web.whatsapp.com/check-update?version=2.2245.9&platform=web")).build();
            CompletionStage completionStage = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(response -> {
                WebVersionResponse webVersionResponse = Json.readValue((String)response.body(), WebVersionResponse.class);
                webVersion = Version.of(webVersionResponse.currentVersion());
                return webVersion;
            });
            if (client != null) {
                client.close();
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throw new RuntimeException("Cannot fetch latest web version", throwable3);
            }
        }
    }

    public static CompletableFuture<String> getToken(long phoneNumber, UserAgent.PlatformType platform, Version appVersion) {
        switch (platform) {
            case IOS: 
            case IOS_BUSINESS: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mobile os: " + String.valueOf((Object)platform));
            }
        }
        return WhatsappMetadata.getIosToken(phoneNumber, appVersion, platform.isBusiness());
    }

    private static CompletableFuture<String> getIosToken(long phoneNumber, Version version, boolean business) {
        String staticToken = business ? "USUDuDYDeQhY4RF2fCSp5m3F6kJ1M2J8wS7bbNA2" : "0a1mLfGUIBVrMKF1RdvLI5lkRBvof6vn0fD2QRSM";
        String token = staticToken + HexFormat.of().formatHex(version.toHash()) + phoneNumber;
        return CompletableFuture.completedFuture(HexFormat.of().formatHex(MD5.calculate(token)));
    }

    public static String generateBusinessCertificate(Keys keys) {
        BusinessVerifiedNameDetails details = new BusinessVerifiedNameDetailsBuilder().name("").issuer("smb:wa").serial(Math.abs(new SecureRandom().nextLong())).build();
        byte[] encodedDetails = BusinessVerifiedNameDetailsSpec.encode(details);
        BusinessVerifiedNameCertificate certificate = new BusinessVerifiedNameCertificateBuilder().encodedDetails(encodedDetails).signature(Curve25519.sign((byte[])keys.identityKeyPair().privateKey(), (byte[])encodedDetails, (boolean)true)).build();
        return Base64.getUrlEncoder().encodeToString(BusinessVerifiedNameCertificateSpec.encode(certificate));
    }

    static {
        ProxyAuthenticator.allowAll();
    }

    private record WebVersionResponse(@JsonProperty(value="isBroken") boolean broken, @JsonProperty(value="isBelowSoft") boolean outdatedSoft, @JsonProperty(value="isBelowHard") boolean outdatedHard, @JsonProperty(value="hardUpdateTime") long outdatedUpdateTime, @JsonProperty(value="beta") String beta, @JsonProperty(value="currentVersion") String currentVersion) {
    }

    private static final class IosVersionResponse {
        private static final IosVersionResponse EMPTY = new IosVersionResponse(null);
        private final Version version;

        IosVersionResponse(Version version) {
            this.version = version;
        }

        @JsonCreator
        public static IosVersionResponse of(Map<String, Object> json) {
            List results = (List)json.get("results");
            if (results.isEmpty()) {
                return EMPTY;
            }
            String result = (String)((Map)results.getFirst()).get("version");
            if (result == null) {
                return EMPTY;
            }
            return new IosVersionResponse(Version.of("2." + result));
        }

        public Optional<Version> version() {
            return Optional.of(this.version);
        }
    }
}

