/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.registration;

import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.api.AsyncVerificationCodeSupplier;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.crypto.AesGcm;
import it.auties.whatsapp.exception.RegistrationException;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.mobile.CountryCode;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.mobile.VerificationCodeError;
import it.auties.whatsapp.model.mobile.VerificationCodeMethod;
import it.auties.whatsapp.model.mobile.VerificationCodeStatus;
import it.auties.whatsapp.model.node.Attributes;
import it.auties.whatsapp.model.response.AbPropsResponse;
import it.auties.whatsapp.model.response.RegistrationResponse;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.registration.WhatsappMetadata;
import it.auties.whatsapp.util.Bytes;
import it.auties.whatsapp.util.Exceptions;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.ProxyAuthenticator;
import it.auties.whatsapp.util.Specification;
import it.auties.whatsapp.util.Validate;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public final class WhatsappRegistration {
    private final HttpClient httpClient;
    private final Store store;
    private final Keys keys;
    private final AsyncVerificationCodeSupplier codeHandler;
    private final VerificationCodeMethod method;

    public WhatsappRegistration(Store store, Keys keys, AsyncVerificationCodeSupplier codeHandler, VerificationCodeMethod method) {
        this.store = store;
        this.keys = keys;
        this.codeHandler = codeHandler;
        this.method = method;
        this.httpClient = this.createClient();
    }

    public CompletableFuture<RegistrationResponse> registerPhoneNumber() {
        return ((CompletableFuture)this.requestVerificationCode(false).thenCompose(ignored -> this.sendVerificationCode())).whenComplete((result, exception) -> {
            this.dispose();
            if (exception != null) {
                Exceptions.rethrow(exception);
            }
        });
    }

    public CompletableFuture<RegistrationResponse> requestVerificationCode() {
        return this.requestVerificationCode(true);
    }

    private CompletableFuture<RegistrationResponse> requestVerificationCode(boolean closeResources) {
        if (this.method == VerificationCodeMethod.NONE) {
            return CompletableFuture.completedFuture(null);
        }
        switch (this.store.device().platform()) {
            case IOS: 
            case IOS_BUSINESS: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mobile os");
            }
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.onboard("1", 2155550000L, null).thenComposeAsync(response -> this.onboard(null, null, response.abHash()))).thenComposeAsync(ignored -> this.exists(null))).thenComposeAsync(result -> this.clientLog(result, Map.entry("current_screen", "verify_sms"), Map.entry("previous_screen", "enter_number"), Map.entry("action_taken", "continue")).thenComposeAsync(response -> this.requestVerificationCode((RegistrationResponse)response, null)))).whenComplete((result, exception) -> this.onRequestVerificationCode(closeResources, (Throwable)exception));
    }

    private void onRequestVerificationCode(boolean closeResources, Throwable exception) {
        if (closeResources) {
            this.dispose();
        }
        if (exception != null) {
            Exceptions.rethrow(exception);
        }
    }

    private CompletableFuture<AbPropsResponse> onboard(String cc, Long in, String abHash) {
        PhoneNumber phoneNumber = this.store.phoneNumber().orElseThrow();
        LinkedHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("cc", Objects.requireNonNullElse(cc, phoneNumber.countryCode().prefix())).put("in", Objects.requireNonNullElse(in, phoneNumber.numberWithoutPrefix())).put("rc", this.store.releaseChannel().index()).put("ab_hash", (Object)abHash, abHash != null).toMap();
        System.out.println("https://v.whatsapp.net/v2/reg_onboard_abprop?" + this.toFormParams(attributes));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://v.whatsapp.net/v2/reg_onboard_abprop?" + this.toFormParams(attributes))).GET().header("User-Agent", this.store.device().toUserAgent(this.store.version())).header("Content-Type", "application/x-www-form-urlencoded").build();
        return this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() != 200) {
                throw new RegistrationException(null, (String)response.body());
            }
            System.out.println((String)response.body());
            return Json.readValue((String)response.body(), AbPropsResponse.class);
        });
    }

    private CompletableFuture<RegistrationResponse> exists(VerificationCodeError lastError) {
        boolean ios = this.store.device().platform().isIOS();
        CompletableFuture<Map<String, Object>> options = this.getRegistrationOptions(this.store, this.keys, false, ios ? Map.entry("recovery_token_error", "-25300") : null);
        return ((CompletableFuture)options.thenComposeAsync(attrs -> this.sendRequest("/exist", (Map<String, Object>)attrs))).thenComposeAsync(result -> {
            if (result.statusCode() != 200) {
                throw new RegistrationException(null, (String)result.body());
            }
            RegistrationResponse response = Json.readValue((String)result.body(), RegistrationResponse.class);
            if (response.errorReason() == VerificationCodeError.INCORRECT) {
                return CompletableFuture.completedFuture(response);
            }
            if (lastError == null) {
                return this.exists(response.errorReason());
            }
            throw new RegistrationException(response, (String)result.body());
        });
    }

    private String convertBufferToUrlHex(byte[] buffer) {
        StringBuilder id = new StringBuilder();
        for (byte x : buffer) {
            id.append(String.format("%%%02x", x));
        }
        return id.toString().toUpperCase(Locale.ROOT);
    }

    @SafeVarargs
    private <T> CompletableFuture<T> clientLog(T data, Map.Entry<String, Object> ... attributes) {
        CompletableFuture<Map<String, Object>> options = this.getRegistrationOptions(this.store, this.keys, false, attributes);
        return ((CompletableFuture)options.thenCompose(attrs -> this.sendRequest("/client_log", (Map<String, Object>)attrs))).thenApply(result -> {
            System.out.println((String)result.body());
            return data;
        });
    }

    private CompletableFuture<RegistrationResponse> requestVerificationCode(RegistrationResponse existsResponse, VerificationCodeError lastError) {
        CompletableFuture<Map<String, Object>> options = this.getRegistrationOptions(this.store, this.keys, true, this.getRequestVerificationCodeParameters(existsResponse));
        return ((CompletableFuture)((CompletableFuture)options.thenComposeAsync(attrs -> this.sendRequest("/code", (Map<String, Object>)attrs))).thenComposeAsync(result -> this.onCodeRequestSent(existsResponse, lastError, (HttpResponse<String>)result))).thenApplyAsync(response -> {
            this.saveRegistrationStatus(this.store, this.keys, false);
            return response;
        });
    }

    private Map.Entry<String, Object>[] getRequestVerificationCodeParameters(RegistrationResponse existsResponse) {
        Map.Entry[] entryArray;
        CountryCode countryCode = this.store.phoneNumber().orElseThrow().countryCode();
        switch (this.store.device().platform()) {
            case UNKNOWN: {
                entryArray = new Map.Entry[]{};
                break;
            }
            case IOS: 
            case IOS_BUSINESS: {
                Map.Entry[] entryArray2 = new Map.Entry[5];
                entryArray2[0] = Map.entry("method", this.method.data());
                entryArray2[1] = Map.entry("sim_mcc", existsResponse.flashType() ? countryCode.mcc() : "000");
                entryArray2[2] = Map.entry("sim_mnc", "000");
                entryArray2[3] = Map.entry("reason", "");
                entryArray = entryArray2;
                entryArray2[4] = Map.entry("cellular_strength", 1);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mobile os");
            }
        }
        return entryArray;
    }

    private CompletionStage<RegistrationResponse> onCodeRequestSent(RegistrationResponse existsResponse, VerificationCodeError lastError, HttpResponse<String> result) {
        if (result.statusCode() != 200) {
            throw new RegistrationException(null, result.body());
        }
        RegistrationResponse response = Json.readValue(result.body(), RegistrationResponse.class);
        if (response.status() == VerificationCodeStatus.SUCCESS) {
            return CompletableFuture.completedFuture(response);
        }
        switch (response.errorReason()) {
            case TOO_RECENT: 
            case TOO_MANY: 
            case TOO_MANY_GUESSES: 
            case TOO_MANY_ALL_METHODS: {
                throw new RegistrationException(response, "Please wait before trying to register this phone number again");
            }
            case NO_ROUTES: {
                throw new RegistrationException(response, "You can only register numbers that are already on Whatsapp, if you need to register any numbers please contact me on Telegram @Auties00");
            }
        }
        VerificationCodeError newErrorReason = response.errorReason();
        Validate.isTrue(newErrorReason != lastError, () -> new RegistrationException(response, (String)result.body()));
        return this.requestVerificationCode(existsResponse, newErrorReason);
    }

    public CompletableFuture<RegistrationResponse> sendVerificationCode() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.codeHandler.get()).thenComposeAsync(code -> this.getRegistrationOptions(this.store, this.keys, true, Map.entry("code", this.normalizeCodeResult((String)code))))).thenComposeAsync(attrs -> this.sendRequest("/register", (Map<String, Object>)attrs))).thenComposeAsync(result -> {
            if (result.statusCode() != 200) {
                throw new RegistrationException(null, (String)result.body());
            }
            RegistrationResponse response = Json.readValue((String)result.body(), RegistrationResponse.class);
            if (response.status() == VerificationCodeStatus.SUCCESS) {
                this.saveRegistrationStatus(this.store, this.keys, true);
                return CompletableFuture.completedFuture(response);
            }
            throw new RegistrationException(response, (String)result.body());
        });
    }

    private void saveRegistrationStatus(Store store, Keys keys, boolean registered) {
        keys.setRegistered(registered);
        if (registered) {
            Jid jid = store.phoneNumber().orElseThrow().toJid();
            store.setJid(jid);
            store.addLinkedDevice(jid, 0);
        }
        keys.serialize(true);
        store.serialize(true);
    }

    private String normalizeCodeResult(String captcha) {
        return captcha.replaceAll("-", "").trim();
    }

    private CompletableFuture<HttpResponse<String>> sendRequest(String path, Map<String, Object> params) {
        HttpRequest request = this.createRequest(path, params);
        return this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(result -> {
            System.out.println(path + ": " + (String)result.body());
            return result;
        });
    }

    private HttpRequest createRequest(String path, Map<String, Object> params) {
        String encodedParams = this.toFormParams(params);
        String userAgent = this.store.device().toUserAgent(this.store.version());
        if (this.store.device().platform().isKaiOs()) {
            return HttpRequest.newBuilder().uri(URI.create("%s%s?%s".formatted("https://v-k.whatsapp.net/v2", path, encodedParams))).GET().header("User-Agent", userAgent).build();
        }
        SignalKeyPair keypair = SignalKeyPair.random();
        byte[] key = Curve25519.sharedKey((byte[])Specification.Whatsapp.REGISTRATION_PUBLIC_KEY, (byte[])keypair.privateKey());
        byte[] buffer = AesGcm.encrypt(new byte[12], encodedParams.getBytes(StandardCharsets.UTF_8), key);
        String cipheredParameters = Base64.getUrlEncoder().encodeToString(Bytes.concat(keypair.publicKey(), buffer));
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(URI.create("%s%s?ENC=%s".formatted("https://v.whatsapp.net/v2", path, cipheredParameters))).GET().header("User-Agent", userAgent);
        if (this.store.device().platform().isAndroid()) {
            request.header("Accept", "text/json");
            request.header("WaMsysRequest", "1");
            request.header("request_token", UUID.randomUUID().toString());
            request.header("Content-Type", "application/x-www-form-urlencoded");
        }
        return request.build();
    }

    private HttpClient createClient() {
        try {
            HttpClient.Builder clientBuilder = HttpClient.newBuilder();
            this.store.proxy().ifPresent(proxy -> {
                clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(proxy.getHost(), proxy.getPort())));
                clientBuilder.authenticator(ProxyAuthenticator.globalAuthenticator());
            });
            return clientBuilder.build();
        }
        catch (Throwable exception) {
            throw new RuntimeException(exception);
        }
    }

    @SafeVarargs
    private CompletableFuture<Map<String, Object>> getRegistrationOptions(Store store, Keys keys, boolean useToken, Map.Entry<String, Object> ... attributes) {
        PhoneNumber phoneNumber = store.phoneNumber().orElseThrow(() -> new NoSuchElementException("Missing phone number"));
        CompletableFuture<Object> tokenFuture = !useToken ? CompletableFuture.completedFuture(null) : WhatsappMetadata.getToken(phoneNumber.numberWithoutPrefix(), store.device().platform(), store.version());
        return tokenFuture.thenApplyAsync(token -> {
            String certificate = store.device().platform().isBusiness() ? WhatsappMetadata.generateBusinessCertificate(keys) : null;
            LinkedHashMap requiredAttributes = Arrays.stream(attributes).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> first, LinkedHashMap::new));
            LinkedHashMap<String, Object> result = Attributes.of(new Map.Entry[0]).put("cc", phoneNumber.countryCode().prefix()).put("in", phoneNumber.numberWithoutPrefix()).put("rc", (Object)store.releaseChannel().index(), !store.device().platform().isKaiOs()).put("lg", phoneNumber.countryCode().lg()).put("lc", phoneNumber.countryCode().lc()).put("authkey", Base64.getUrlEncoder().encodeToString(keys.noiseKeyPair().publicKey())).put("vname", (Object)certificate, certificate != null).put("e_regid", Base64.getUrlEncoder().encodeToString(keys.encodedRegistrationId())).put("e_keytype", Base64.getUrlEncoder().encodeToString(Specification.Signal.KEY_BUNDLE_TYPE)).put("e_ident", Base64.getUrlEncoder().encodeToString(keys.identityKeyPair().publicKey())).put("e_skey_id", Base64.getUrlEncoder().encodeToString(keys.signedKeyPair().encodedId())).put("e_skey_val", Base64.getUrlEncoder().encodeToString(keys.signedKeyPair().publicKey())).put("e_skey_sig", Base64.getUrlEncoder().encodeToString(keys.signedKeyPair().signature())).put("fdid", (Object)keys.fdid().toLowerCase(Locale.ROOT), store.device().platform().isAndroid()).put("fdid", (Object)keys.fdid().toUpperCase(Locale.ROOT), store.device().platform().isIOS()).put("expid", (Object)Base64.getUrlEncoder().encodeToString(keys.deviceId()), !store.device().platform().isKaiOs()).put("id", this.convertBufferToUrlHex(keys.identityId())).put("token", token, useToken).putAll(requiredAttributes).toMap();
            System.out.println(Json.writeValueAsString(result, true));
            return result;
        });
    }

    private String toFormParams(Map<String, ?> values) {
        return values.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + String.valueOf(entry.getValue())).collect(Collectors.joining("&"));
    }

    private void dispose() {
        this.httpClient.close();
    }

    static {
        Authenticator.setDefault(ProxyAuthenticator.globalAuthenticator());
    }
}

