/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.socket.SocketListener;
import it.auties.whatsapp.util.Exceptions;
import it.auties.whatsapp.util.ProxyAuthenticator;
import it.auties.whatsapp.util.Specification;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

public abstract sealed class SocketSession {
    private static final int MESSAGE_LENGTH = 3;
    final URI proxy;
    SocketListener listener;

    private SocketSession(URI proxy) {
        this.proxy = proxy;
    }

    CompletableFuture<Void> connect(SocketListener listener) {
        this.listener = listener;
        return CompletableFuture.completedFuture(null);
    }

    abstract void disconnect();

    public abstract CompletableFuture<?> sendBinary(byte[] var1);

    static SocketSession of(URI proxy, boolean webSocket) {
        if (webSocket) {
            return new WebSocketSession(proxy);
        }
        return new RawSocketSession(proxy);
    }

    static {
        ProxyAuthenticator.allowAll();
    }

    public static final class WebSocketSession
    extends SocketSession
    implements WebSocket.Listener {
        private WebSocket session;
        private byte[] message;
        private int messageOffset;

        WebSocketSession(URI proxy) {
            super(proxy);
        }

        @Override
        CompletableFuture<Void> connect(SocketListener listener) {
            if (this.session != null) {
                return CompletableFuture.completedFuture(null);
            }
            super.connect(listener);
            return ((CompletableFuture)HttpClient.newBuilder().executor(command -> Thread.ofPlatform().start(command)).proxy(ProxySelector.of((InetSocketAddress)ProxyAuthenticator.getProxy(this.proxy).address())).authenticator(ProxyAuthenticator.globalAuthenticator()).build().newWebSocketBuilder().buildAsync(Specification.Whatsapp.WEB_SOCKET_ENDPOINT, this).thenAcceptAsync(webSocket -> {
                this.session = webSocket;
                listener.onOpen(this);
            })).exceptionallyAsync(throwable -> {
                if (throwable instanceof CompletionException && throwable.getCause() instanceof ConnectException) {
                    throw new RuntimeException("Cannot connect to Whatsapp: check your connection and whether it's available in your country");
                }
                Exceptions.rethrow(throwable);
                return null;
            });
        }

        @Override
        void disconnect() {
            if (this.session == null) {
                return;
            }
            this.session.sendClose(1000, "");
        }

        @Override
        public CompletableFuture<?> sendBinary(byte[] bytes) {
            if (this.session == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.session.sendBinary(ByteBuffer.wrap(bytes), true);
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            this.message = null;
            this.listener.onClose();
            this.session = null;
            return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            this.listener.onError(error);
        }

        @Override
        public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
            if (this.message == null) {
                int length = data.get() << 16 | Short.toUnsignedInt(data.getShort());
                if (length < 0) {
                    return WebSocket.Listener.super.onBinary(webSocket, data, last);
                }
                this.message = new byte[length];
                this.messageOffset = 0;
            }
            int currentDataLength = data.remaining();
            int remainingDataLength = this.message.length - this.messageOffset;
            int actualDataLength = Math.min(currentDataLength, remainingDataLength);
            data.get(this.message, this.messageOffset, actualDataLength);
            this.messageOffset += actualDataLength;
            if (this.messageOffset != this.message.length) {
                return WebSocket.Listener.super.onBinary(webSocket, data, last);
            }
            this.notifyMessage();
            if (remainingDataLength - currentDataLength != 0) {
                return this.onBinary(webSocket, data, true);
            }
            return WebSocket.Listener.super.onBinary(webSocket, data, last);
        }

        private void notifyMessage() {
            try {
                this.listener.onMessage(this.message);
            }
            catch (Throwable throwable) {
                this.listener.onError(throwable);
            }
            finally {
                this.message = null;
            }
        }
    }

    static final class RawSocketSession
    extends SocketSession {
        private Socket socket;

        RawSocketSession(URI proxy) {
            super(proxy);
        }

        @Override
        CompletableFuture<Void> connect(SocketListener listener) {
            if (this.isOpen()) {
                return CompletableFuture.completedFuture(null);
            }
            super.connect(listener);
            return CompletableFuture.runAsync(() -> this.createConnection(listener));
        }

        private void createConnection(SocketListener listener) {
            try {
                this.socket = new Socket(ProxyAuthenticator.getProxy(this.proxy));
                this.socket.setKeepAlive(true);
                this.socket.connect(this.proxy != null ? InetSocketAddress.createUnresolved(Specification.Whatsapp.SOCKET_ENDPOINT.getHost(), Specification.Whatsapp.SOCKET_ENDPOINT.getPort()) : new InetSocketAddress(Specification.Whatsapp.SOCKET_ENDPOINT.getHost(), Specification.Whatsapp.SOCKET_ENDPOINT.getPort()));
                listener.onOpen(this);
                this.readMessages();
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }

        private void readMessages() {
            Thread.ofPlatform().start(() -> {
                byte[] lengthBytes = new byte[3];
                while (this.isOpen()) {
                    try {
                        byte[] messageBytes;
                        boolean messageResult;
                        int length;
                        boolean lengthResult = this.readBytes(lengthBytes);
                        if (!lengthResult || (length = lengthBytes[0] << 16 | (lengthBytes[1] & 0xFF) << 8 | lengthBytes[2] & 0xFF) < 0 || !(messageResult = this.readBytes(messageBytes = new byte[length]))) break;
                        this.listener.onMessage(messageBytes);
                    }
                    catch (Throwable throwable) {
                        this.listener.onError(throwable);
                    }
                }
                this.disconnect();
            });
        }

        private boolean readBytes(byte[] data) {
            try {
                int chunk;
                for (int read = 0; read != data.length; read += chunk) {
                    chunk = this.socket.getInputStream().read(data, read, data.length - read);
                    if (chunk >= 0) continue;
                    return false;
                }
                return true;
            }
            catch (SocketException exception) {
                return false;
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }

        @Override
        void disconnect() {
            try {
                if (this.socket == null) {
                    return;
                }
                this.listener.onClose();
                this.socket.close();
                this.socket = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private boolean isOpen() {
            return this.socket != null && this.socket.isConnected();
        }

        public CompletableFuture<Void> sendBinary(byte[] bytes) {
            if (this.socket == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.runAsync(() -> {
                try {
                    this.socket.getOutputStream().write(bytes);
                    this.socket.getOutputStream().flush();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            });
        }

        static {
            Authenticator.setDefault(ProxyAuthenticator.globalAuthenticator());
        }
    }
}

