/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import it.auties.whatsapp.util.Validate;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyAuthenticator
extends Authenticator {
    private static volatile ProxyAuthenticator instance;
    private final Map<String, URI> credentials = new ConcurrentHashMap<String, URI>();

    public static void allowAll() {
        System.setProperty("jdk.http.auth.proxying.disabledSchemes", "");
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
    }

    public static Proxy getProxy(URI uri) {
        if (uri == null) {
            return Proxy.NO_PROXY;
        }
        String scheme = Objects.requireNonNull(uri.getScheme(), "Invalid proxy, expected a scheme: %s".formatted(uri));
        String host = Objects.requireNonNull(uri.getHost(), "Invalid proxy, expected a host: %s".formatted(uri));
        int port = ProxyAuthenticator.getProxyPort(scheme, uri.getPort()).orElseThrow(() -> new NullPointerException("Invalid proxy, expected a port: %s".formatted(uri)));
        return switch (scheme) {
            case "http", "https" -> new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(host, port));
            case "socks5" -> new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved(host, port));
            default -> throw new IllegalStateException("Unexpected scheme: " + scheme);
        };
    }

    private static OptionalInt getProxyPort(String scheme, int port) {
        OptionalInt optionalInt;
        if (port != -1) {
            optionalInt = OptionalInt.of(port);
        } else {
            switch (scheme) {
                case "http": {
                    optionalInt = OptionalInt.of(80);
                    break;
                }
                case "https": {
                    optionalInt = OptionalInt.of(443);
                    break;
                }
                default: {
                    optionalInt = OptionalInt.empty();
                }
            }
        }
        return optionalInt;
    }

    public static ProxyAuthenticator globalAuthenticator() {
        if (instance == null) {
            instance = new ProxyAuthenticator();
        }
        return instance;
    }

    private ProxyAuthenticator() {
    }

    public void register(URI uri) {
        this.credentials.put("%s:%s".formatted(uri.getHost(), uri.getPort()), uri);
    }

    public void unregister(URI uri) {
        this.credentials.remove("%s:%s".formatted(uri.getHost(), uri.getPort()));
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String host = "%s:%s".formatted(this.getRequestingHost(), this.getRequestingPort());
        URI info = this.credentials.get(host);
        if (info == null) {
            return super.getPasswordAuthentication();
        }
        String[] userInfo = info.getUserInfo().split(":", 2);
        Validate.isTrue(userInfo.length == 2, "Invalid proxy credentials", new Object[0]);
        return new PasswordAuthentication(userInfo[0], userInfo[1].toCharArray());
    }

    static {
        ProxyAuthenticator.allowAll();
    }
}

