package it.auties.whatsapp.api;

/**
 * A list of all emojis supported by Whatsapp
 * <a href="https://unicode.org/emoji/charts/full-emoji-list.html">Source</a>
 */
@SuppressWarnings("SpellCheckingInspection")
public enum Emoji {
    GRINNING_FACE("😀"),
    GRINNING_FACE_WITH_BIG_EYES("😃"),
    GRINNING_FACE_WITH_SMILING_EYES("😄"),
    BEAMING_FACE_WITH_SMILING_EYES("😁"),
    GRINNING_SQUINTING_FACE("😆"),
    GRINNING_FACE_WITH_SWEAT("😅"),
    ROLLING_ON_THE_FLOOR_LAUGHING("🤣"),
    FACE_WITH_TEARS_OF_JOY("😂"),
    SLIGHTLY_SMILING_FACE("🙂"),
    UPSIDE_DOWN_FACE("🙃"),
    MELTING_FACE("🫠"),
    WINKING_FACE("😉"),
    SMILING_FACE_WITH_SMILING_EYES("😊"),
    SMILING_FACE_WITH_HALO("😇"),
    SMILING_FACE_WITH_HEARTS("🥰"),
    SMILING_FACE_WITH_HEART_EYES("😍"),
    STAR_STRUCK("🤩"),
    FACE_BLOWING_A_KISS("😘"),
    KISSING_FACE("😗"),
    SMILING_FACE("☺"),
    KISSING_FACE_WITH_CLOSED_EYES("😚"),
    KISSING_FACE_WITH_SMILING_EYES("😙"),
    SMILING_FACE_WITH_TEAR("🥲"),
    FACE_SAVORING_FOOD("😋"),
    FACE_WITH_TONGUE("😛"),
    WINKING_FACE_WITH_TONGUE("😜"),
    ZANY_FACE("🤪"),
    SQUINTING_FACE_WITH_TONGUE("😝"),
    MONEY_MOUTH_FACE("🤑"),
    SMILING_FACE_WITH_OPEN_HANDS("🤗"),
    FACE_WITH_HAND_OVER_MOUTH("🤭"),
    FACE_WITH_OPEN_EYES_AND_HAND_OVER_MOUTH("🫢"),
    FACE_WITH_PEEKING_EYE("🫣"),
    SHUSHING_FACE("🤫"),
    THINKING_FACE("🤔"),
    SALUTING_FACE("🫡"),
    ZIPPER_MOUTH_FACE("🤐"),
    FACE_WITH_RAISED_EYEBROW("🤨"),
    NEUTRAL_FACE("😐"),
    EXPRESSIONLESS_FACE("😑"),
    FACE_WITHOUT_MOUTH("😶"),
    DOTTED_LINE_FACE("🫥"),
    FACE_IN_CLOUDS("😶‍🌫️"),
    SMIRKING_FACE("😏"),
    UNAMUSED_FACE("😒"),
    FACE_WITH_ROLLING_EYES("🙄"),
    GRIMACING_FACE("😬"),
    FACE_EXHALING("😮‍💨"),
    LYING_FACE("🤥"),
    SHAKING_FACE("🫨"),
    RELIEVED_FACE("😌"),
    PENSIVE_FACE("😔"),
    SLEEPY_FACE("😪"),
    DROOLING_FACE("🤤"),
    SLEEPING_FACE("😴"),
    FACE_WITH_MEDICAL_MASK("😷"),
    FACE_WITH_THERMOMETER("🤒"),
    FACE_WITH_HEAD_BANDAGE("🤕"),
    NAUSEATED_FACE("🤢"),
    FACE_VOMITING("🤮"),
    SNEEZING_FACE("🤧"),
    HOT_FACE("🥵"),
    COLD_FACE("🥶"),
    WOOZY_FACE("🥴"),
    FACE_WITH_CROSSED_OUT_EYES("😵"),
    FACE_WITH_SPIRAL_EYES("😵‍💫"),
    EXPLODING_HEAD("🤯"),
    COWBOY_HAT_FACE("🤠"),
    PARTYING_FACE("🥳"),
    DISGUISED_FACE("🥸"),
    SMILING_FACE_WITH_SUNGLASSES("😎"),
    NERD_FACE("🤓"),
    FACE_WITH_MONOCLE("🧐"),
    CONFUSED_FACE("😕"),
    FACE_WITH_DIAGONAL_MOUTH("🫤"),
    WORRIED_FACE("😟"),
    SLIGHTLY_FROWNING_FACE("🙁"),
    FROWNING_FACE("☹"),
    FACE_WITH_OPEN_MOUTH("😮"),
    HUSHED_FACE("😯"),
    ASTONISHED_FACE("😲"),
    FLUSHED_FACE("😳"),
    PLEADING_FACE("🥺"),
    FACE_HOLDING_BACK_TEARS("🥹"),
    FROWNING_FACE_WITH_OPEN_MOUTH("😦"),
    ANGUISHED_FACE("😧"),
    FEARFUL_FACE("😨"),
    ANXIOUS_FACE_WITH_SWEAT("😰"),
    SAD_BUT_RELIEVED_FACE("😥"),
    CRYING_FACE("😢"),
    LOUDLY_CRYING_FACE("😭"),
    FACE_SCREAMING_IN_FEAR("😱"),
    CONFOUNDED_FACE("😖"),
    PERSEVERING_FACE("😣"),
    DISAPPOINTED_FACE("😞"),
    DOWNCAST_FACE_WITH_SWEAT("😓"),
    WEARY_FACE("😩"),
    TIRED_FACE("😫"),
    YAWNING_FACE("🥱"),
    FACE_WITH_STEAM_FROM_NOSE("😤"),
    ENRAGED_FACE("😡"),
    ANGRY_FACE("😠"),
    FACE_WITH_SYMBOLS_ON_MOUTH("🤬"),
    SMILING_FACE_WITH_HORNS("😈"),
    ANGRY_FACE_WITH_HORNS("👿"),
    SKULL("💀"),
    SKULL_AND_CROSSBONES("☠"),
    PILE_OF_POO("💩"),
    CLOWN_FACE("🤡"),
    OGRE("👹"),
    GOBLIN("👺"),
    GHOST("👻"),
    ALIEN("👽"),
    ALIEN_MONSTER("👾"),
    ROBOT("🤖"),
    GRINNING_CAT("😺"),
    GRINNING_CAT_WITH_SMILING_EYES("😸"),
    CAT_WITH_TEARS_OF_JOY("😹"),
    SMILING_CAT_WITH_HEART_EYES("😻"),
    CAT_WITH_WRY_SMILE("😼"),
    KISSING_CAT("😽"),
    WEARY_CAT("🙀"),
    CRYING_CAT("😿"),
    POUTING_CAT("😾"),
    SEE_NO_EVIL_MONKEY("🙈"),
    HEAR_NO_EVIL_MONKEY("🙉"),
    SPEAK_NO_EVIL_MONKEY("🙊"),
    LOVE_LETTER("💌"),
    HEART_WITH_ARROW("💘"),
    HEART_WITH_RIBBON("💝"),
    SPARKLING_HEART("💖"),
    GROWING_HEART("💗"),
    BEATING_HEART("💓"),
    REVOLVING_HEARTS("💞"),
    TWO_HEARTS("💕"),
    HEART_DECORATION("💟"),
    HEART_EXCLAMATION("❣"),
    BROKEN_HEART("💔"),
    HEART_ON_FIRE("❤️‍🔥"),
    MENDING_HEART("❤️‍🩹"),
    RED_HEART("❤"),
    PINK_HEART("🩷"),
    ORANGE_HEART("🧡"),
    YELLOW_HEART("💛"),
    GREEN_HEART("💚"),
    BLUE_HEART("💙"),
    LIGHT_BLUE_HEART("🩵"),
    PURPLE_HEART("💜"),
    BROWN_HEART("🤎"),
    BLACK_HEART("🖤"),
    GREY_HEART("🩶"),
    WHITE_HEART("🤍"),
    KISS_MARK("💋"),
    HUNDRED_POINTS("💯"),
    ANGER_SYMBOL("💢"),
    COLLISION("💥"),
    DIZZY("💫"),
    SWEAT_DROPLETS("💦"),
    DASHING_AWAY("💨"),
    HOLE("🕳"),
    SPEECH_BALLOON("💬"),
    EYE_IN_SPEECH_BUBBLE("👁️‍🗨️"),
    LEFT_SPEECH_BUBBLE("🗨"),
    RIGHT_ANGER_BUBBLE("🗯"),
    THOUGHT_BALLOON("💭"),
    ZZZ("💤"),
    WAVING_HAND("👋"),
    RAISED_BACK_OF_HAND("🤚"),
    HAND_WITH_FINGERS_SPLAYED("🖐"),
    RAISED_HAND("✋"),
    VULCAN_SALUTE("🖖"),
    RIGHTWARDS_HAND("🫱"),
    LEFTWARDS_HAND("🫲"),
    PALM_DOWN_HAND("🫳"),
    PALM_UP_HAND("🫴"),
    LEFTWARDS_PUSHING_HAND("🫷"),
    RIGHTWARDS_PUSHING_HAND("🫸"),
    OK_HAND("👌"),
    PINCHED_FINGERS("🤌"),
    PINCHING_HAND("🤏"),
    VICTORY_HAND("✌"),
    CROSSED_FINGERS("🤞"),
    HAND_WITH_INDEX_FINGER_AND_THUMB_CROSSED("🫰"),
    LOVE_YOU_GESTURE("🤟"),
    SIGN_OF_THE_HORNS("🤘"),
    CALL_ME_HAND("🤙"),
    BACKHAND_INDEX_POINTING_LEFT("👈"),
    BACKHAND_INDEX_POINTING_RIGHT("👉"),
    BACKHAND_INDEX_POINTING_UP("👆"),
    MIDDLE_FINGER("🖕"),
    BACKHAND_INDEX_POINTING_DOWN("👇"),
    INDEX_POINTING_UP("☝"),
    INDEX_POINTING_AT_THE_VIEWER("🫵"),
    THUMBS_UP("👍"),
    THUMBS_DOWN("👎"),
    RAISED_FIST("✊"),
    ONCOMING_FIST("👊"),
    LEFT_FACING_FIST("🤛"),
    RIGHT_FACING_FIST("🤜"),
    CLAPPING_HANDS("👏"),
    RAISING_HANDS("🙌"),
    HEART_HANDS("🫶"),
    OPEN_HANDS("👐"),
    PALMS_UP_TOGETHER("🤲"),
    HANDSHAKE("🤝"),
    FOLDED_HANDS("🙏"),
    WRITING_HAND("✍"),
    NAIL_POLISH("💅"),
    SELFIE("🤳"),
    FLEXED_BICEPS("💪"),
    MECHANICAL_ARM("🦾"),
    MECHANICAL_LEG("🦿"),
    LEG("🦵"),
    FOOT("🦶"),
    EAR("👂"),
    EAR_WITH_HEARING_AID("🦻"),
    NOSE("👃"),
    BRAIN("🧠"),
    ANATOMICAL_HEART("🫀"),
    LUNGS("🫁"),
    TOOTH("🦷"),
    BONE("🦴"),
    EYES("👀"),
    EYE("👁"),
    TONGUE("👅"),
    MOUTH("👄"),
    BITING_LIP("🫦"),
    BABY("👶"),
    CHILD("🧒"),
    BOY("👦"),
    GIRL("👧"),
    PERSON("🧑"),
    PERSON_BLOND_HAIR("👱"),
    MAN("👨"),
    PERSON_BEARD("🧔"),
    MAN_BEARD("🧔‍♂️"),
    WOMAN_BEARD("🧔‍♀️"),
    MAN_RED_HAIR("👨‍🦰"),
    MAN_CURLY_HAIR("👨‍🦱"),
    MAN_WHITE_HAIR("👨‍🦳"),
    MAN_BALD("👨‍🦲"),
    WOMAN("👩"),
    WOMAN_RED_HAIR("👩‍🦰"),
    PERSON_RED_HAIR("🧑‍🦰"),
    WOMAN_CURLY_HAIR("👩‍🦱"),
    PERSON_CURLY_HAIR("🧑‍🦱"),
    WOMAN_WHITE_HAIR("👩‍🦳"),
    PERSON_WHITE_HAIR("🧑‍🦳"),
    WOMAN_BALD("👩‍🦲"),
    PERSON_BALD("🧑‍🦲"),
    WOMAN_BLOND_HAIR("👱‍♀️"),
    MAN_BLOND_HAIR("👱‍♂️"),
    OLDER_PERSON("🧓"),
    OLD_MAN("👴"),
    OLD_WOMAN("👵"),
    PERSON_FROWNING("🙍"),
    MAN_FROWNING("🙍‍♂️"),
    WOMAN_FROWNING("🙍‍♀️"),
    PERSON_POUTING("🙎"),
    MAN_POUTING("🙎‍♂️"),
    WOMAN_POUTING("🙎‍♀️"),
    PERSON_GESTURING_NO("🙅"),
    MAN_GESTURING_NO("🙅‍♂️"),
    WOMAN_GESTURING_NO("🙅‍♀️"),
    PERSON_GESTURING_OK("🙆"),
    MAN_GESTURING_OK("🙆‍♂️"),
    WOMAN_GESTURING_OK("🙆‍♀️"),
    PERSON_TIPPING_HAND("💁"),
    MAN_TIPPING_HAND("💁‍♂️"),
    WOMAN_TIPPING_HAND("💁‍♀️"),
    PERSON_RAISING_HAND("🙋"),
    MAN_RAISING_HAND("🙋‍♂️"),
    WOMAN_RAISING_HAND("🙋‍♀️"),
    DEAF_PERSON("🧏"),
    DEAF_MAN("🧏‍♂️"),
    DEAF_WOMAN("🧏‍♀️"),
    PERSON_BOWING("🙇"),
    MAN_BOWING("🙇‍♂️"),
    WOMAN_BOWING("🙇‍♀️"),
    PERSON_FACEPALMING("🤦"),
    MAN_FACEPALMING("🤦‍♂️"),
    WOMAN_FACEPALMING("🤦‍♀️"),
    PERSON_SHRUGGING("🤷"),
    MAN_SHRUGGING("🤷‍♂️"),
    WOMAN_SHRUGGING("🤷‍♀️"),
    HEALTH_WORKER("🧑‍⚕️"),
    MAN_HEALTH_WORKER("👨‍⚕️"),
    WOMAN_HEALTH_WORKER("👩‍⚕️"),
    STUDENT("🧑‍🎓"),
    MAN_STUDENT("👨‍🎓"),
    WOMAN_STUDENT("👩‍🎓"),
    TEACHER("🧑‍🏫"),
    MAN_TEACHER("👨‍🏫"),
    WOMAN_TEACHER("👩‍🏫"),
    JUDGE("🧑‍⚖️"),
    MAN_JUDGE("👨‍⚖️"),
    WOMAN_JUDGE("👩‍⚖️"),
    FARMER("🧑‍🌾"),
    MAN_FARMER("👨‍🌾"),
    WOMAN_FARMER("👩‍🌾"),
    COOK("🧑‍🍳"),
    MAN_COOK("👨‍🍳"),
    WOMAN_COOK("👩‍🍳"),
    MECHANIC("🧑‍🔧"),
    MAN_MECHANIC("👨‍🔧"),
    WOMAN_MECHANIC("👩‍🔧"),
    FACTORY_WORKER("🧑‍🏭"),
    MAN_FACTORY_WORKER("👨‍🏭"),
    WOMAN_FACTORY_WORKER("👩‍🏭"),
    OFFICE_WORKER("🧑‍💼"),
    MAN_OFFICE_WORKER("👨‍💼"),
    WOMAN_OFFICE_WORKER("👩‍💼"),
    SCIENTIST("🧑‍🔬"),
    MAN_SCIENTIST("👨‍🔬"),
    WOMAN_SCIENTIST("👩‍🔬"),
    TECHNOLOGIST("🧑‍💻"),
    MAN_TECHNOLOGIST("👨‍💻"),
    WOMAN_TECHNOLOGIST("👩‍💻"),
    SINGER("🧑‍🎤"),
    MAN_SINGER("👨‍🎤"),
    WOMAN_SINGER("👩‍🎤"),
    ARTIST("🧑‍🎨"),
    MAN_ARTIST("👨‍🎨"),
    WOMAN_ARTIST("👩‍🎨"),
    PILOT("🧑‍✈️"),
    MAN_PILOT("👨‍✈️"),
    WOMAN_PILOT("👩‍✈️"),
    ASTRONAUT("🧑‍🚀"),
    MAN_ASTRONAUT("👨‍🚀"),
    WOMAN_ASTRONAUT("👩‍🚀"),
    FIREFIGHTER("🧑‍🚒"),
    MAN_FIREFIGHTER("👨‍🚒"),
    WOMAN_FIREFIGHTER("👩‍🚒"),
    POLICE_OFFICER("👮"),
    MAN_POLICE_OFFICER("👮‍♂️"),
    WOMAN_POLICE_OFFICER("👮‍♀️"),
    DETECTIVE("🕵"),
    MAN_DETECTIVE("🕵️‍♂️"),
    WOMAN_DETECTIVE("🕵️‍♀️"),
    GUARD("💂"),
    MAN_GUARD("💂‍♂️"),
    WOMAN_GUARD("💂‍♀️"),
    NINJA("🥷"),
    CONSTRUCTION_WORKER("👷"),
    MAN_CONSTRUCTION_WORKER("👷‍♂️"),
    WOMAN_CONSTRUCTION_WORKER("👷‍♀️"),
    PERSON_WITH_CROWN("🫅"),
    PRINCE("🤴"),
    PRINCESS("👸"),
    PERSON_WEARING_TURBAN("👳"),
    MAN_WEARING_TURBAN("👳‍♂️"),
    WOMAN_WEARING_TURBAN("👳‍♀️"),
    PERSON_WITH_SKULLCAP("👲"),
    WOMAN_WITH_HEADSCARF("🧕"),
    PERSON_IN_TUXEDO("🤵"),
    MAN_IN_TUXEDO("🤵‍♂️"),
    WOMAN_IN_TUXEDO("🤵‍♀️"),
    PERSON_WITH_VEIL("👰"),
    MAN_WITH_VEIL("👰‍♂️"),
    WOMAN_WITH_VEIL("👰‍♀️"),
    PREGNANT_WOMAN("🤰"),
    PREGNANT_MAN("🫃"),
    PREGNANT_PERSON("🫄"),
    BREAST_FEEDING("🤱"),
    WOMAN_FEEDING_BABY("👩‍🍼"),
    MAN_FEEDING_BABY("👨‍🍼"),
    PERSON_FEEDING_BABY("🧑‍🍼"),
    BABY_ANGEL("👼"),
    SANTA_CLAUS("🎅"),
    MRS__CLAUS("🤶"),
    MX_CLAUS("🧑‍🎄"),
    SUPERHERO("🦸"),
    MAN_SUPERHERO("🦸‍♂️"),
    WOMAN_SUPERHERO("🦸‍♀️"),
    SUPERVILLAIN("🦹"),
    MAN_SUPERVILLAIN("🦹‍♂️"),
    WOMAN_SUPERVILLAIN("🦹‍♀️"),
    MAGE("🧙"),
    MAN_MAGE("🧙‍♂️"),
    WOMAN_MAGE("🧙‍♀️"),
    FAIRY("🧚"),
    MAN_FAIRY("🧚‍♂️"),
    WOMAN_FAIRY("🧚‍♀️"),
    VAMPIRE("🧛"),
    MAN_VAMPIRE("🧛‍♂️"),
    WOMAN_VAMPIRE("🧛‍♀️"),
    MERPERSON("🧜"),
    MERMAN("🧜‍♂️"),
    MERMAID("🧜‍♀️"),
    ELF("🧝"),
    MAN_ELF("🧝‍♂️"),
    WOMAN_ELF("🧝‍♀️"),
    GENIE("🧞"),
    MAN_GENIE("🧞‍♂️"),
    WOMAN_GENIE("🧞‍♀️"),
    ZOMBIE("🧟"),
    MAN_ZOMBIE("🧟‍♂️"),
    WOMAN_ZOMBIE("🧟‍♀️"),
    TROLL("🧌"),
    PERSON_GETTING_MASSAGE("💆"),
    MAN_GETTING_MASSAGE("💆‍♂️"),
    WOMAN_GETTING_MASSAGE("💆‍♀️"),
    PERSON_GETTING_HAIRCUT("💇"),
    MAN_GETTING_HAIRCUT("💇‍♂️"),
    WOMAN_GETTING_HAIRCUT("💇‍♀️"),
    PERSON_WALKING("🚶"),
    MAN_WALKING("🚶‍♂️"),
    WOMAN_WALKING("🚶‍♀️"),
    PERSON_STANDING("🧍"),
    MAN_STANDING("🧍‍♂️"),
    WOMAN_STANDING("🧍‍♀️"),
    PERSON_KNEELING("🧎"),
    MAN_KNEELING("🧎‍♂️"),
    WOMAN_KNEELING("🧎‍♀️"),
    PERSON_WITH_WHITE_CANE("🧑‍🦯"),
    MAN_WITH_WHITE_CANE("👨‍🦯"),
    WOMAN_WITH_WHITE_CANE("👩‍🦯"),
    PERSON_IN_MOTORIZED_WHEELCHAIR("🧑‍🦼"),
    MAN_IN_MOTORIZED_WHEELCHAIR("👨‍🦼"),
    WOMAN_IN_MOTORIZED_WHEELCHAIR("👩‍🦼"),
    PERSON_IN_MANUAL_WHEELCHAIR("🧑‍🦽"),
    MAN_IN_MANUAL_WHEELCHAIR("👨‍🦽"),
    WOMAN_IN_MANUAL_WHEELCHAIR("👩‍🦽"),
    PERSON_RUNNING("🏃"),
    MAN_RUNNING("🏃‍♂️"),
    WOMAN_RUNNING("🏃‍♀️"),
    WOMAN_DANCING("💃"),
    MAN_DANCING("🕺"),
    PERSON_IN_SUIT_LEVITATING("🕴"),
    PEOPLE_WITH_BUNNY_EARS("👯"),
    MEN_WITH_BUNNY_EARS("👯‍♂️"),
    WOMEN_WITH_BUNNY_EARS("👯‍♀️"),
    PERSON_IN_STEAMY_ROOM("🧖"),
    MAN_IN_STEAMY_ROOM("🧖‍♂️"),
    WOMAN_IN_STEAMY_ROOM("🧖‍♀️"),
    PERSON_CLIMBING("🧗"),
    MAN_CLIMBING("🧗‍♂️"),
    WOMAN_CLIMBING("🧗‍♀️"),
    PERSON_FENCING("🤺"),
    HORSE_RACING("🏇"),
    SKIER("⛷"),
    SNOWBOARDER("🏂"),
    PERSON_GOLFING("🏌"),
    MAN_GOLFING("🏌️‍♂️"),
    WOMAN_GOLFING("🏌️‍♀️"),
    PERSON_SURFING("🏄"),
    MAN_SURFING("🏄‍♂️"),
    WOMAN_SURFING("🏄‍♀️"),
    PERSON_ROWING_BOAT("🚣"),
    MAN_ROWING_BOAT("🚣‍♂️"),
    WOMAN_ROWING_BOAT("🚣‍♀️"),
    PERSON_SWIMMING("🏊"),
    MAN_SWIMMING("🏊‍♂️"),
    WOMAN_SWIMMING("🏊‍♀️"),
    PERSON_BOUNCING_BALL("⛹"),
    MAN_BOUNCING_BALL("⛹️‍♂️"),
    WOMAN_BOUNCING_BALL("⛹️‍♀️"),
    PERSON_LIFTING_WEIGHTS("🏋"),
    MAN_LIFTING_WEIGHTS("🏋️‍♂️"),
    WOMAN_LIFTING_WEIGHTS("🏋️‍♀️"),
    PERSON_BIKING("🚴"),
    MAN_BIKING("🚴‍♂️"),
    WOMAN_BIKING("🚴‍♀️"),
    PERSON_MOUNTAIN_BIKING("🚵"),
    MAN_MOUNTAIN_BIKING("🚵‍♂️"),
    WOMAN_MOUNTAIN_BIKING("🚵‍♀️"),
    PERSON_CARTWHEELING("🤸"),
    MAN_CARTWHEELING("🤸‍♂️"),
    WOMAN_CARTWHEELING("🤸‍♀️"),
    PEOPLE_WRESTLING("🤼"),
    MEN_WRESTLING("🤼‍♂️"),
    WOMEN_WRESTLING("🤼‍♀️"),
    PERSON_PLAYING_WATER_POLO("🤽"),
    MAN_PLAYING_WATER_POLO("🤽‍♂️"),
    WOMAN_PLAYING_WATER_POLO("🤽‍♀️"),
    PERSON_PLAYING_HANDBALL("🤾"),
    MAN_PLAYING_HANDBALL("🤾‍♂️"),
    WOMAN_PLAYING_HANDBALL("🤾‍♀️"),
    PERSON_JUGGLING("🤹"),
    MAN_JUGGLING("🤹‍♂️"),
    WOMAN_JUGGLING("🤹‍♀️"),
    PERSON_IN_LOTUS_POSITION("🧘"),
    MAN_IN_LOTUS_POSITION("🧘‍♂️"),
    WOMAN_IN_LOTUS_POSITION("🧘‍♀️"),
    PERSON_TAKING_BATH("🛀"),
    PERSON_IN_BED("🛌"),
    PEOPLE_HOLDING_HANDS("🧑‍🤝‍🧑"),
    WOMEN_HOLDING_HANDS("👭"),
    WOMAN_AND_MAN_HOLDING_HANDS("👫"),
    MEN_HOLDING_HANDS("👬"),
    KISS("💏"),
    KISS_WOMAN_MAN("👩‍❤️‍💋‍👨"),
    KISS_MAN_MAN("👨‍❤️‍💋‍👨"),
    KISS_WOMAN_WOMAN("👩‍❤️‍💋‍👩"),
    COUPLE_WITH_HEART("💑"),
    COUPLE_WITH_HEART_WOMAN_MAN("👩‍❤️‍👨"),
    COUPLE_WITH_HEART_MAN_MAN("👨‍❤️‍👨"),
    COUPLE_WITH_HEART_WOMAN_WOMAN("👩‍❤️‍👩"),
    FAMILY("👪"),
    FAMILY_MAN_WOMAN_BOY("👨‍👩‍👦"),
    FAMILY_MAN_WOMAN_GIRL("👨‍👩‍👧"),
    FAMILY_MAN_WOMAN_GIRL_BOY("👨‍👩‍👧‍👦"),
    FAMILY_MAN_WOMAN_BOY_BOY("👨‍👩‍👦‍👦"),
    FAMILY_MAN_WOMAN_GIRL_GIRL("👨‍👩‍👧‍👧"),
    FAMILY_MAN_MAN_BOY("👨‍👨‍👦"),
    FAMILY_MAN_MAN_GIRL("👨‍👨‍👧"),
    FAMILY_MAN_MAN_GIRL_BOY("👨‍👨‍👧‍👦"),
    FAMILY_MAN_MAN_BOY_BOY("👨‍👨‍👦‍👦"),
    FAMILY_MAN_MAN_GIRL_GIRL("👨‍👨‍👧‍👧"),
    FAMILY_WOMAN_WOMAN_BOY("👩‍👩‍👦"),
    FAMILY_WOMAN_WOMAN_GIRL("👩‍👩‍👧"),
    FAMILY_WOMAN_WOMAN_GIRL_BOY("👩‍👩‍👧‍👦"),
    FAMILY_WOMAN_WOMAN_BOY_BOY("👩‍👩‍👦‍👦"),
    FAMILY_WOMAN_WOMAN_GIRL_GIRL("👩‍👩‍👧‍👧"),
    FAMILY_MAN_BOY("👨‍👦"),
    FAMILY_MAN_BOY_BOY("👨‍👦‍👦"),
    FAMILY_MAN_GIRL("👨‍👧"),
    FAMILY_MAN_GIRL_BOY("👨‍👧‍👦"),
    FAMILY_MAN_GIRL_GIRL("👨‍👧‍👧"),
    FAMILY_WOMAN_BOY("👩‍👦"),
    FAMILY_WOMAN_BOY_BOY("👩‍👦‍👦"),
    FAMILY_WOMAN_GIRL("👩‍👧"),
    FAMILY_WOMAN_GIRL_BOY("👩‍👧‍👦"),
    FAMILY_WOMAN_GIRL_GIRL("👩‍👧‍👧"),
    SPEAKING_HEAD("🗣"),
    BUST_IN_SILHOUETTE("👤"),
    BUSTS_IN_SILHOUETTE("👥"),
    PEOPLE_HUGGING("🫂"),
    FOOTPRINTS("👣"),
    RED_HAIR("🦰"),
    CURLY_HAIR("🦱"),
    WHITE_HAIR("🦳"),
    BALD("🦲"),
    MONKEY_FACE("🐵"),
    MONKEY("🐒"),
    GORILLA("🦍"),
    ORANGUTAN("🦧"),
    DOG_FACE("🐶"),
    DOG("🐕"),
    GUIDE_DOG("🦮"),
    SERVICE_DOG("🐕‍🦺"),
    POODLE("🐩"),
    WOLF("🐺"),
    FOX("🦊"),
    RACCOON("🦝"),
    CAT_FACE("🐱"),
    CAT("🐈"),
    BLACK_CAT("🐈‍⬛"),
    LION("🦁"),
    TIGER_FACE("🐯"),
    TIGER("🐅"),
    LEOPARD("🐆"),
    HORSE_FACE("🐴"),
    MOOSE("🫎"),
    DONKEY("🫏"),
    HORSE("🐎"),
    UNICORN("🦄"),
    ZEBRA("🦓"),
    DEER("🦌"),
    BISON("🦬"),
    COW_FACE("🐮"),
    OX("🐂"),
    WATER_BUFFALO("🐃"),
    COW("🐄"),
    PIG_FACE("🐷"),
    PIG("🐖"),
    BOAR("🐗"),
    PIG_NOSE("🐽"),
    RAM("🐏"),
    EWE("🐑"),
    GOAT("🐐"),
    CAMEL("🐪"),
    TWO_HUMP_CAMEL("🐫"),
    LLAMA("🦙"),
    GIRAFFE("🦒"),
    ELEPHANT("🐘"),
    MAMMOTH("🦣"),
    RHINOCEROS("🦏"),
    HIPPOPOTAMUS("🦛"),
    MOUSE_FACE("🐭"),
    MOUSE("🐁"),
    RAT("🐀"),
    HAMSTER("🐹"),
    RABBIT_FACE("🐰"),
    RABBIT("🐇"),
    CHIPMUNK("🐿"),
    BEAVER("🦫"),
    HEDGEHOG("🦔"),
    BAT("🦇"),
    BEAR("🐻"),
    POLAR_BEAR("🐻‍❄️"),
    KOALA("🐨"),
    PANDA("🐼"),
    SLOTH("🦥"),
    OTTER("🦦"),
    SKUNK("🦨"),
    KANGAROO("🦘"),
    BADGER("🦡"),
    PAW_PRINTS("🐾"),
    TURKEY("🦃"),
    CHICKEN("🐔"),
    ROOSTER("🐓"),
    HATCHING_CHICK("🐣"),
    BABY_CHICK("🐤"),
    FRONT_FACING_BABY_CHICK("🐥"),
    BIRD("🐦"),
    PENGUIN("🐧"),
    DOVE("🕊"),
    EAGLE("🦅"),
    DUCK("🦆"),
    SWAN("🦢"),
    OWL("🦉"),
    DODO("🦤"),
    FEATHER("🪶"),
    FLAMINGO("🦩"),
    PEACOCK("🦚"),
    PARROT("🦜"),
    WING("🪽"),
    BLACK_BIRD("🐦‍⬛"),
    GOOSE("🪿"),
    FROG("🐸"),
    CROCODILE("🐊"),
    TURTLE("🐢"),
    LIZARD("🦎"),
    SNAKE("🐍"),
    DRAGON_FACE("🐲"),
    DRAGON("🐉"),
    SAUROPOD("🦕"),
    T_REX("🦖"),
    SPOUTING_WHALE("🐳"),
    WHALE("🐋"),
    DOLPHIN("🐬"),
    SEAL("🦭"),
    FISH("🐟"),
    TROPICAL_FISH("🐠"),
    BLOWFISH("🐡"),
    SHARK("🦈"),
    OCTOPUS("🐙"),
    SPIRAL_SHELL("🐚"),
    CORAL("🪸"),
    JELLYFISH("🪼"),
    SNAIL("🐌"),
    BUTTERFLY("🦋"),
    BUG("🐛"),
    ANT("🐜"),
    HONEYBEE("🐝"),
    BEETLE("🪲"),
    LADY_BEETLE("🐞"),
    CRICKET("🦗"),
    COCKROACH("🪳"),
    SPIDER("🕷"),
    SPIDER_WEB("🕸"),
    SCORPION("🦂"),
    MOSQUITO("🦟"),
    FLY("🪰"),
    WORM("🪱"),
    MICROBE("🦠"),
    BOUQUET("💐"),
    CHERRY_BLOSSOM("🌸"),
    WHITE_FLOWER("💮"),
    LOTUS("🪷"),
    ROSETTE("🏵"),
    ROSE("🌹"),
    WILTED_FLOWER("🥀"),
    HIBISCUS("🌺"),
    SUNFLOWER("🌻"),
    BLOSSOM("🌼"),
    TULIP("🌷"),
    HYACINTH("🪻"),
    SEEDLING("🌱"),
    POTTED_PLANT("🪴"),
    EVERGREEN_TREE("🌲"),
    DECIDUOUS_TREE("🌳"),
    PALM_TREE("🌴"),
    CACTUS("🌵"),
    SHEAF_OF_RICE("🌾"),
    HERB("🌿"),
    SHAMROCK("☘"),
    FOUR_LEAF_CLOVER("🍀"),
    MAPLE_LEAF("🍁"),
    FALLEN_LEAF("🍂"),
    LEAF_FLUTTERING_IN_WIND("🍃"),
    EMPTY_NEST("🪹"),
    NEST_WITH_EGGS("🪺"),
    MUSHROOM("🍄"),
    GRAPES("🍇"),
    MELON("🍈"),
    WATERMELON("🍉"),
    TANGERINE("🍊"),
    LEMON("🍋"),
    BANANA("🍌"),
    PINEAPPLE("🍍"),
    MANGO("🥭"),
    RED_APPLE("🍎"),
    GREEN_APPLE("🍏"),
    PEAR("🍐"),
    PEACH("🍑"),
    CHERRIES("🍒"),
    STRAWBERRY("🍓"),
    BLUEBERRIES("🫐"),
    KIWI_FRUIT("🥝"),
    TOMATO("🍅"),
    OLIVE("🫒"),
    COCONUT("🥥"),
    AVOCADO("🥑"),
    EGGPLANT("🍆"),
    POTATO("🥔"),
    CARROT("🥕"),
    EAR_OF_CORN("🌽"),
    HOT_PEPPER("🌶"),
    BELL_PEPPER("🫑"),
    CUCUMBER("🥒"),
    LEAFY_GREEN("🥬"),
    BROCCOLI("🥦"),
    GARLIC("🧄"),
    ONION("🧅"),
    PEANUTS("🥜"),
    BEANS("🫘"),
    CHESTNUT("🌰"),
    GINGER_ROOT("🫚"),
    PEA_POD("🫛"),
    BREAD("🍞"),
    CROISSANT("🥐"),
    BAGUETTE_BREAD("🥖"),
    FLATBREAD("🫓"),
    PRETZEL("🥨"),
    BAGEL("🥯"),
    PANCAKES("🥞"),
    WAFFLE("🧇"),
    CHEESE_WEDGE("🧀"),
    MEAT_ON_BONE("🍖"),
    POULTRY_LEG("🍗"),
    CUT_OF_MEAT("🥩"),
    BACON("🥓"),
    HAMBURGER("🍔"),
    FRENCH_FRIES("🍟"),
    PIZZA("🍕"),
    HOT_DOG("🌭"),
    SANDWICH("🥪"),
    TACO("🌮"),
    BURRITO("🌯"),
    TAMALE("🫔"),
    STUFFED_FLATBREAD("🥙"),
    FALAFEL("🧆"),
    EGG("🥚"),
    COOKING("🍳"),
    SHALLOW_PAN_OF_FOOD("🥘"),
    POT_OF_FOOD("🍲"),
    FONDUE("🫕"),
    BOWL_WITH_SPOON("🥣"),
    GREEN_SALAD("🥗"),
    POPCORN("🍿"),
    BUTTER("🧈"),
    SALT("🧂"),
    CANNED_FOOD("🥫"),
    BENTO_BOX("🍱"),
    RICE_CRACKER("🍘"),
    RICE_BALL("🍙"),
    COOKED_RICE("🍚"),
    CURRY_RICE("🍛"),
    STEAMING_BOWL("🍜"),
    SPAGHETTI("🍝"),
    ROASTED_SWEET_POTATO("🍠"),
    ODEN("🍢"),
    SUSHI("🍣"),
    FRIED_SHRIMP("🍤"),
    FISH_CAKE_WITH_SWIRL("🍥"),
    MOON_CAKE("🥮"),
    DANGO("🍡"),
    DUMPLING("🥟"),
    FORTUNE_COOKIE("🥠"),
    TAKEOUT_BOX("🥡"),
    CRAB("🦀"),
    LOBSTER("🦞"),
    SHRIMP("🦐"),
    SQUID("🦑"),
    OYSTER("🦪"),
    SOFT_ICE_CREAM("🍦"),
    SHAVED_ICE("🍧"),
    ICE_CREAM("🍨"),
    DOUGHNUT("🍩"),
    COOKIE("🍪"),
    BIRTHDAY_CAKE("🎂"),
    SHORTCAKE("🍰"),
    CUPCAKE("🧁"),
    PIE("🥧"),
    CHOCOLATE_BAR("🍫"),
    CANDY("🍬"),
    LOLLIPOP("🍭"),
    CUSTARD("🍮"),
    HONEY_POT("🍯"),
    BABY_BOTTLE("🍼"),
    GLASS_OF_MILK("🥛"),
    HOT_BEVERAGE("☕"),
    TEAPOT("🫖"),
    TEACUP_WITHOUT_HANDLE("🍵"),
    SAKE("🍶"),
    BOTTLE_WITH_POPPING_CORK("🍾"),
    WINE_GLASS("🍷"),
    COCKTAIL_GLASS("🍸"),
    TROPICAL_DRINK("🍹"),
    BEER_MUG("🍺"),
    CLINKING_BEER_MUGS("🍻"),
    CLINKING_GLASSES("🥂"),
    TUMBLER_GLASS("🥃"),
    POURING_LIQUID("🫗"),
    CUP_WITH_STRAW("🥤"),
    BUBBLE_TEA("🧋"),
    BEVERAGE_BOX("🧃"),
    MATE("🧉"),
    ICE("🧊"),
    CHOPSTICKS("🥢"),
    FORK_AND_KNIFE_WITH_PLATE("🍽"),
    FORK_AND_KNIFE("🍴"),
    SPOON("🥄"),
    KITCHEN_KNIFE("🔪"),
    JAR("🫙"),
    AMPHORA("🏺"),
    GLOBE_SHOWING_EUROPE_AFRICA("🌍"),
    GLOBE_SHOWING_AMERICAS("🌎"),
    GLOBE_SHOWING_ASIA_AUSTRALIA("🌏"),
    GLOBE_WITH_MERIDIANS("🌐"),
    WORLD_MAP("🗺"),
    MAP_OF_JAPAN("🗾"),
    COMPASS("🧭"),
    SNOW_CAPPED_MOUNTAIN("🏔"),
    MOUNTAIN("⛰"),
    VOLCANO("🌋"),
    MOUNT_FUJI("🗻"),
    CAMPING("🏕"),
    BEACH_WITH_UMBRELLA("🏖"),
    DESERT("🏜"),
    DESERT_ISLAND("🏝"),
    NATIONAL_PARK("🏞"),
    STADIUM("🏟"),
    CLASSICAL_BUILDING("🏛"),
    BUILDING_CONSTRUCTION("🏗"),
    BRICK("🧱"),
    ROCK("🪨"),
    WOOD("🪵"),
    HUT("🛖"),
    HOUSES("🏘"),
    DERELICT_HOUSE("🏚"),
    HOUSE("🏠"),
    HOUSE_WITH_GARDEN("🏡"),
    OFFICE_BUILDING("🏢"),
    JAPANESE_POST_OFFICE("🏣"),
    POST_OFFICE("🏤"),
    HOSPITAL("🏥"),
    BANK("🏦"),
    HOTEL("🏨"),
    LOVE_HOTEL("🏩"),
    CONVENIENCE_STORE("🏪"),
    SCHOOL("🏫"),
    DEPARTMENT_STORE("🏬"),
    FACTORY("🏭"),
    JAPANESE_CASTLE("🏯"),
    CASTLE("🏰"),
    WEDDING("💒"),
    TOKYO_TOWER("🗼"),
    STATUE_OF_LIBERTY("🗽"),
    CHURCH("⛪"),
    MOSQUE("🕌"),
    HINDU_TEMPLE("🛕"),
    SYNAGOGUE("🕍"),
    SHINTO_SHRINE("⛩"),
    KAABA("🕋"),
    FOUNTAIN("⛲"),
    TENT("⛺"),
    FOGGY("🌁"),
    NIGHT_WITH_STARS("🌃"),
    CITYSCAPE("🏙"),
    SUNRISE_OVER_MOUNTAINS("🌄"),
    SUNRISE("🌅"),
    CITYSCAPE_AT_DUSK("🌆"),
    SUNSET("🌇"),
    BRIDGE_AT_NIGHT("🌉"),
    HOT_SPRINGS("♨"),
    CAROUSEL_HORSE("🎠"),
    PLAYGROUND_SLIDE("🛝"),
    FERRIS_WHEEL("🎡"),
    ROLLER_COASTER("🎢"),
    BARBER_POLE("💈"),
    CIRCUS_TENT("🎪"),
    LOCOMOTIVE("🚂"),
    RAILWAY_CAR("🚃"),
    HIGH_SPEED_TRAIN("🚄"),
    BULLET_TRAIN("🚅"),
    TRAIN("🚆"),
    METRO("🚇"),
    LIGHT_RAIL("🚈"),
    STATION("🚉"),
    TRAM("🚊"),
    MONORAIL("🚝"),
    MOUNTAIN_RAILWAY("🚞"),
    TRAM_CAR("🚋"),
    BUS("🚌"),
    ONCOMING_BUS("🚍"),
    TROLLEYBUS("🚎"),
    MINIBUS("🚐"),
    AMBULANCE("🚑"),
    FIRE_ENGINE("🚒"),
    POLICE_CAR("🚓"),
    ONCOMING_POLICE_CAR("🚔"),
    TAXI("🚕"),
    ONCOMING_TAXI("🚖"),
    AUTOMOBILE("🚗"),
    ONCOMING_AUTOMOBILE("🚘"),
    SPORT_UTILITY_VEHICLE("🚙"),
    PICKUP_TRUCK("🛻"),
    DELIVERY_TRUCK("🚚"),
    ARTICULATED_LORRY("🚛"),
    TRACTOR("🚜"),
    RACING_CAR("🏎"),
    MOTORCYCLE("🏍"),
    MOTOR_SCOOTER("🛵"),
    MANUAL_WHEELCHAIR("🦽"),
    MOTORIZED_WHEELCHAIR("🦼"),
    AUTO_RICKSHAW("🛺"),
    BICYCLE("🚲"),
    KICK_SCOOTER("🛴"),
    SKATEBOARD("🛹"),
    ROLLER_SKATE("🛼"),
    BUS_STOP("🚏"),
    MOTORWAY("🛣"),
    RAILWAY_TRACK("🛤"),
    OIL_DRUM("🛢"),
    FUEL_PUMP("⛽"),
    WHEEL("🛞"),
    POLICE_CAR_LIGHT("🚨"),
    HORIZONTAL_TRAFFIC_LIGHT("🚥"),
    VERTICAL_TRAFFIC_LIGHT("🚦"),
    STOP_SIGN("🛑"),
    CONSTRUCTION("🚧"),
    ANCHOR("⚓"),
    RING_BUOY("🛟"),
    SAILBOAT("⛵"),
    CANOE("🛶"),
    SPEEDBOAT("🚤"),
    PASSENGER_SHIP("🛳"),
    FERRY("⛴"),
    MOTOR_BOAT("🛥"),
    SHIP("🚢"),
    AIRPLANE("✈"),
    SMALL_AIRPLANE("🛩"),
    AIRPLANE_DEPARTURE("🛫"),
    AIRPLANE_ARRIVAL("🛬"),
    PARACHUTE("🪂"),
    SEAT("💺"),
    HELICOPTER("🚁"),
    SUSPENSION_RAILWAY("🚟"),
    MOUNTAIN_CABLEWAY("🚠"),
    AERIAL_TRAMWAY("🚡"),
    SATELLITE("🛰"),
    ROCKET("🚀"),
    FLYING_SAUCER("🛸"),
    BELLHOP_BELL("🛎"),
    LUGGAGE("🧳"),
    HOURGLASS_DONE("⌛"),
    HOURGLASS_NOT_DONE("⏳"),
    WATCH("⌚"),
    ALARM_CLOCK("⏰"),
    STOPWATCH("⏱"),
    TIMER_CLOCK("⏲"),
    MANTELPIECE_CLOCK("🕰"),
    TWELVE_O_CLOCK("🕛"),
    TWELVE_THIRTY("🕧"),
    ONE_O_CLOCK("🕐"),
    ONE_THIRTY("🕜"),
    TWO_O_CLOCK("🕑"),
    TWO_THIRTY("🕝"),
    THREE_O_CLOCK("🕒"),
    THREE_THIRTY("🕞"),
    FOUR_O_CLOCK("🕓"),
    FOUR_THIRTY("🕟"),
    FIVE_O_CLOCK("🕔"),
    FIVE_THIRTY("🕠"),
    SIX_O_CLOCK("🕕"),
    SIX_THIRTY("🕡"),
    SEVEN_O_CLOCK("🕖"),
    SEVEN_THIRTY("🕢"),
    EIGHT_O_CLOCK("🕗"),
    EIGHT_THIRTY("🕣"),
    NINE_O_CLOCK("🕘"),
    NINE_THIRTY("🕤"),
    TEN_O_CLOCK("🕙"),
    TEN_THIRTY("🕥"),
    ELEVEN_O_CLOCK("🕚"),
    ELEVEN_THIRTY("🕦"),
    NEW_MOON("🌑"),
    WAXING_CRESCENT_MOON("🌒"),
    FIRST_QUARTER_MOON("🌓"),
    WAXING_GIBBOUS_MOON("🌔"),
    FULL_MOON("🌕"),
    WANING_GIBBOUS_MOON("🌖"),
    LAST_QUARTER_MOON("🌗"),
    WANING_CRESCENT_MOON("🌘"),
    CRESCENT_MOON("🌙"),
    NEW_MOON_FACE("🌚"),
    FIRST_QUARTER_MOON_FACE("🌛"),
    LAST_QUARTER_MOON_FACE("🌜"),
    THERMOMETER("🌡"),
    SUN("☀"),
    FULL_MOON_FACE("🌝"),
    SUN_WITH_FACE("🌞"),
    RINGED_PLANET("🪐"),
    STAR("⭐"),
    GLOWING_STAR("🌟"),
    SHOOTING_STAR("🌠"),
    MILKY_WAY("🌌"),
    CLOUD("☁"),
    SUN_BEHIND_CLOUD("⛅"),
    CLOUD_WITH_LIGHTNING_AND_RAIN("⛈"),
    SUN_BEHIND_SMALL_CLOUD("🌤"),
    SUN_BEHIND_LARGE_CLOUD("🌥"),
    SUN_BEHIND_RAIN_CLOUD("🌦"),
    CLOUD_WITH_RAIN("🌧"),
    CLOUD_WITH_SNOW("🌨"),
    CLOUD_WITH_LIGHTNING("🌩"),
    TORNADO("🌪"),
    FOG("🌫"),
    WIND_FACE("🌬"),
    CYCLONE("🌀"),
    RAINBOW("🌈"),
    CLOSED_UMBRELLA("🌂"),
    UMBRELLA("☂"),
    UMBRELLA_WITH_RAIN_DROPS("☔"),
    UMBRELLA_ON_GROUND("⛱"),
    HIGH_VOLTAGE("⚡"),
    SNOWFLAKE("❄"),
    SNOWMAN("☃"),
    SNOWMAN_WITHOUT_SNOW("⛄"),
    COMET("☄"),
    FIRE("🔥"),
    DROPLET("💧"),
    WATER_WAVE("🌊"),
    JACK_O_LANTERN("🎃"),
    CHRISTMAS_TREE("🎄"),
    FIREWORKS("🎆"),
    SPARKLER("🎇"),
    FIRECRACKER("🧨"),
    SPARKLES("✨"),
    BALLOON("🎈"),
    PARTY_POPPER("🎉"),
    CONFETTI_BALL("🎊"),
    TANABATA_TREE("🎋"),
    PINE_DECORATION("🎍"),
    JAPANESE_DOLLS("🎎"),
    CARP_STREAMER("🎏"),
    WIND_CHIME("🎐"),
    MOON_VIEWING_CEREMONY("🎑"),
    RED_ENVELOPE("🧧"),
    RIBBON("🎀"),
    WRAPPED_GIFT("🎁"),
    REMINDER_RIBBON("🎗"),
    ADMISSION_TICKETS("🎟"),
    TICKET("🎫"),
    MILITARY_MEDAL("🎖"),
    TROPHY("🏆"),
    SPORTS_MEDAL("🏅"),
    FIRST_PLACE_MEDAL("🥇"),
    SECOND_PLACE_MEDAL("🥈"),
    THIRD_PLACE_MEDAL("🥉"),
    SOCCER_BALL("⚽"),
    BASEBALL("⚾"),
    SOFTBALL("🥎"),
    BASKETBALL("🏀"),
    VOLLEYBALL("🏐"),
    AMERICAN_FOOTBALL("🏈"),
    RUGBY_FOOTBALL("🏉"),
    TENNIS("🎾"),
    FLYING_DISC("🥏"),
    BOWLING("🎳"),
    CRICKET_GAME("🏏"),
    FIELD_HOCKEY("🏑"),
    ICE_HOCKEY("🏒"),
    LACROSSE("🥍"),
    PING_PONG("🏓"),
    BADMINTON("🏸"),
    BOXING_GLOVE("🥊"),
    MARTIAL_ARTS_UNIFORM("🥋"),
    GOAL_NET("🥅"),
    FLAG_IN_HOLE("⛳"),
    ICE_SKATE("⛸"),
    FISHING_POLE("🎣"),
    DIVING_MASK("🤿"),
    RUNNING_SHIRT("🎽"),
    SKIS("🎿"),
    SLED("🛷"),
    CURLING_STONE("🥌"),
    BULLSEYE("🎯"),
    YO_YO("🪀"),
    KITE("🪁"),
    WATER_PISTOL("🔫"),
    POOL_8_BALL("🎱"),
    CRYSTAL_BALL("🔮"),
    MAGIC_WAND("🪄"),
    VIDEO_GAME("🎮"),
    JOYSTICK("🕹"),
    SLOT_MACHINE("🎰"),
    GAME_DIE("🎲"),
    PUZZLE_PIECE("🧩"),
    TEDDY_BEAR("🧸"),
    PINATA("🪅"),
    MIRROR_BALL("🪩"),
    NESTING_DOLLS("🪆"),
    SPADE_SUIT("♠"),
    HEART_SUIT("♥"),
    DIAMOND_SUIT("♦"),
    CLUB_SUIT("♣"),
    CHESS_PAWN("♟"),
    JOKER("🃏"),
    MAHJONG_RED_DRAGON("🀄"),
    FLOWER_PLAYING_CARDS("🎴"),
    PERFORMING_ARTS("🎭"),
    FRAMED_PICTURE("🖼"),
    ARTIST_PALETTE("🎨"),
    THREAD("🧵"),
    SEWING_NEEDLE("🪡"),
    YARN("🧶"),
    KNOT("🪢"),
    GLASSES("👓"),
    SUNGLASSES("🕶"),
    GOGGLES("🥽"),
    LAB_COAT("🥼"),
    SAFETY_VEST("🦺"),
    NECKTIE("👔"),
    T_SHIRT("👕"),
    JEANS("👖"),
    SCARF("🧣"),
    GLOVES("🧤"),
    COAT("🧥"),
    SOCKS("🧦"),
    DRESS("👗"),
    KIMONO("👘"),
    SARI("🥻"),
    ONE_PIECE_SWIMSUIT("🩱"),
    BRIEFS("🩲"),
    SHORTS("🩳"),
    BIKINI("👙"),
    WOMAN_S_CLOTHES("👚"),
    FOLDING_HAND_FAN("🪭"),
    PURSE("👛"),
    HANDBAG("👜"),
    CLUTCH_BAG("👝"),
    SHOPPING_BAGS("🛍"),
    BACKPACK("🎒"),
    THONG_SANDAL("🩴"),
    MAN_S_SHOE("👞"),
    RUNNING_SHOE("👟"),
    HIKING_BOOT("🥾"),
    FLAT_SHOE("🥿"),
    HIGH_HEELED_SHOE("👠"),
    WOMAN_S_SANDAL("👡"),
    BALLET_SHOES("🩰"),
    WOMAN_S_BOOT("👢"),
    HAIR_PICK("🪮"),
    CROWN("👑"),
    WOMAN_S_HAT("👒"),
    TOP_HAT("🎩"),
    GRADUATION_CAP("🎓"),
    BILLED_CAP("🧢"),
    MILITARY_HELMET("🪖"),
    RESCUE_WORKER_S_HELMET("⛑"),
    PRAYER_BEADS("📿"),
    LIPSTICK("💄"),
    RING("💍"),
    GEM_STONE("💎"),
    MUTED_SPEAKER("🔇"),
    SPEAKER_LOW_VOLUME("🔈"),
    SPEAKER_MEDIUM_VOLUME("🔉"),
    SPEAKER_HIGH_VOLUME("🔊"),
    LOUDSPEAKER("📢"),
    MEGAPHONE("📣"),
    POSTAL_HORN("📯"),
    BELL("🔔"),
    BELL_WITH_SLASH("🔕"),
    MUSICAL_SCORE("🎼"),
    MUSICAL_NOTE("🎵"),
    MUSICAL_NOTES("🎶"),
    STUDIO_MICROPHONE("🎙"),
    LEVEL_SLIDER("🎚"),
    CONTROL_KNOBS("🎛"),
    MICROPHONE("🎤"),
    HEADPHONE("🎧"),
    RADIO("📻"),
    SAXOPHONE("🎷"),
    ACCORDION("🪗"),
    GUITAR("🎸"),
    MUSICAL_KEYBOARD("🎹"),
    TRUMPET("🎺"),
    VIOLIN("🎻"),
    BANJO("🪕"),
    DRUM("🥁"),
    LONG_DRUM("🪘"),
    MARACAS("🪇"),
    FLUTE("🪈"),
    MOBILE_PHONE("📱"),
    MOBILE_PHONE_WITH_ARROW("📲"),
    TELEPHONE("☎"),
    TELEPHONE_RECEIVER("📞"),
    PAGER("📟"),
    FAX_MACHINE("📠"),
    BATTERY("🔋"),
    LOW_BATTERY("🪫"),
    ELECTRIC_PLUG("🔌"),
    LAPTOP("💻"),
    DESKTOP_COMPUTER("🖥"),
    PRINTER("🖨"),
    KEYBOARD("⌨"),
    COMPUTER_MOUSE("🖱"),
    TRACKBALL("🖲"),
    COMPUTER_DISK("💽"),
    FLOPPY_DISK("💾"),
    OPTICAL_DISK("💿"),
    DVD("📀"),
    ABACUS("🧮"),
    MOVIE_CAMERA("🎥"),
    FILM_FRAMES("🎞"),
    FILM_PROJECTOR("📽"),
    CLAPPER_BOARD("🎬"),
    TELEVISION("📺"),
    CAMERA("📷"),
    CAMERA_WITH_FLASH("📸"),
    VIDEO_CAMERA("📹"),
    VIDEOCASSETTE("📼"),
    MAGNIFYING_GLASS_TILTED_LEFT("🔍"),
    MAGNIFYING_GLASS_TILTED_RIGHT("🔎"),
    CANDLE("🕯"),
    LIGHT_BULB("💡"),
    FLASHLIGHT("🔦"),
    RED_PAPER_LANTERN("🏮"),
    DIYA_LAMP("🪔"),
    NOTEBOOK_WITH_DECORATIVE_COVER("📔"),
    CLOSED_BOOK("📕"),
    OPEN_BOOK("📖"),
    GREEN_BOOK("📗"),
    BLUE_BOOK("📘"),
    ORANGE_BOOK("📙"),
    BOOKS("📚"),
    NOTEBOOK("📓"),
    LEDGER("📒"),
    PAGE_WITH_CURL("📃"),
    SCROLL("📜"),
    PAGE_FACING_UP("📄"),
    NEWSPAPER("📰"),
    ROLLED_UP_NEWSPAPER("🗞"),
    BOOKMARK_TABS("📑"),
    BOOKMARK("🔖"),
    LABEL("🏷"),
    MONEY_BAG("💰"),
    COIN("🪙"),
    YEN_BANKNOTE("💴"),
    DOLLAR_BANKNOTE("💵"),
    EURO_BANKNOTE("💶"),
    POUND_BANKNOTE("💷"),
    MONEY_WITH_WINGS("💸"),
    CREDIT_CARD("💳"),
    RECEIPT("🧾"),
    CHART_INCREASING_WITH_YEN("💹"),
    ENVELOPE("✉"),
    E_MAIL("📧"),
    INCOMING_ENVELOPE("📨"),
    ENVELOPE_WITH_ARROW("📩"),
    OUTBOX_TRAY("📤"),
    INBOX_TRAY("📥"),
    PACKAGE("📦"),
    CLOSED_MAILBOX_WITH_RAISED_FLAG("📫"),
    CLOSED_MAILBOX_WITH_LOWERED_FLAG("📪"),
    OPEN_MAILBOX_WITH_RAISED_FLAG("📬"),
    OPEN_MAILBOX_WITH_LOWERED_FLAG("📭"),
    POSTBOX("📮"),
    BALLOT_BOX_WITH_BALLOT("🗳"),
    PENCIL("✏"),
    BLACK_NIB("✒"),
    FOUNTAIN_PEN("🖋"),
    PEN("🖊"),
    PAINTBRUSH("🖌"),
    CRAYON("🖍"),
    MEMO("📝"),
    BRIEFCASE("💼"),
    FILE_FOLDER("📁"),
    OPEN_FILE_FOLDER("📂"),
    CARD_INDEX_DIVIDERS("🗂"),
    CALENDAR("📅"),
    TEAR_OFF_CALENDAR("📆"),
    SPIRAL_NOTEPAD("🗒"),
    SPIRAL_CALENDAR("🗓"),
    CARD_INDEX("📇"),
    CHART_INCREASING("📈"),
    CHART_DECREASING("📉"),
    BAR_CHART("📊"),
    CLIPBOARD("📋"),
    PUSHPIN("📌"),
    ROUND_PUSHPIN("📍"),
    PAPERCLIP("📎"),
    LINKED_PAPERCLIPS("🖇"),
    STRAIGHT_RULER("📏"),
    TRIANGULAR_RULER("📐"),
    SCISSORS("✂"),
    CARD_FILE_BOX("🗃"),
    FILE_CABINET("🗄"),
    WASTEBASKET("🗑"),
    LOCKED("🔒"),
    UNLOCKED("🔓"),
    LOCKED_WITH_PEN("🔏"),
    LOCKED_WITH_KEY("🔐"),
    KEY("🔑"),
    OLD_KEY("🗝"),
    HAMMER("🔨"),
    AXE("🪓"),
    PICK("⛏"),
    HAMMER_AND_PICK("⚒"),
    HAMMER_AND_WRENCH("🛠"),
    DAGGER("🗡"),
    CROSSED_SWORDS("⚔"),
    BOMB("💣"),
    BOOMERANG("🪃"),
    BOW_AND_ARROW("🏹"),
    SHIELD("🛡"),
    CARPENTRY_SAW("🪚"),
    WRENCH("🔧"),
    SCREWDRIVER("🪛"),
    NUT_AND_BOLT("🔩"),
    GEAR("⚙"),
    CLAMP("🗜"),
    BALANCE_SCALE("⚖"),
    WHITE_CANE("🦯"),
    LINK("🔗"),
    CHAINS("⛓"),
    HOOK("🪝"),
    TOOLBOX("🧰"),
    MAGNET("🧲"),
    LADDER("🪜"),
    ALEMBIC("⚗"),
    TEST_TUBE("🧪"),
    PETRI_DISH("🧫"),
    DNA("🧬"),
    MICROSCOPE("🔬"),
    TELESCOPE("🔭"),
    SATELLITE_ANTENNA("📡"),
    SYRINGE("💉"),
    DROP_OF_BLOOD("🩸"),
    PILL("💊"),
    ADHESIVE_BANDAGE("🩹"),
    CRUTCH("🩼"),
    STETHOSCOPE("🩺"),
    X_RAY("🩻"),
    DOOR("🚪"),
    ELEVATOR("🛗"),
    MIRROR("🪞"),
    WINDOW("🪟"),
    BED("🛏"),
    COUCH_AND_LAMP("🛋"),
    CHAIR("🪑"),
    TOILET("🚽"),
    PLUNGER("🪠"),
    SHOWER("🚿"),
    BATHTUB("🛁"),
    MOUSE_TRAP("🪤"),
    RAZOR("🪒"),
    LOTION_BOTTLE("🧴"),
    SAFETY_PIN("🧷"),
    BROOM("🧹"),
    BASKET("🧺"),
    ROLL_OF_PAPER("🧻"),
    BUCKET("🪣"),
    SOAP("🧼"),
    BUBBLES("🫧"),
    TOOTHBRUSH("🪥"),
    SPONGE("🧽"),
    FIRE_EXTINGUISHER("🧯"),
    SHOPPING_CART("🛒"),
    CIGARETTE("🚬"),
    COFFIN("⚰"),
    HEADSTONE("🪦"),
    FUNERAL_URN("⚱"),
    NAZAR_AMULET("🧿"),
    HAMSA("🪬"),
    MOAI("🗿"),
    PLACARD("🪧"),
    IDENTIFICATION_CARD("🪪"),
    ATM_SIGN("🏧"),
    LITTER_IN_BIN_SIGN("🚮"),
    POTABLE_WATER("🚰"),
    WHEELCHAIR_SYMBOL("♿"),
    MEN_S_ROOM("🚹"),
    WOMEN_S_ROOM("🚺"),
    RESTROOM("🚻"),
    BABY_SYMBOL("🚼"),
    WATER_CLOSET("🚾"),
    PASSPORT_CONTROL("🛂"),
    CUSTOMS("🛃"),
    BAGGAGE_CLAIM("🛄"),
    LEFT_LUGGAGE("🛅"),
    WARNING("⚠"),
    CHILDREN_CROSSING("🚸"),
    NO_ENTRY("⛔"),
    PROHIBITED("🚫"),
    NO_BICYCLES("🚳"),
    NO_SMOKING("🚭"),
    NO_LITTERING("🚯"),
    NON_POTABLE_WATER("🚱"),
    NO_PEDESTRIANS("🚷"),
    NO_MOBILE_PHONES("📵"),
    NO_ONE_UNDER_EIGHTEEN("🔞"),
    RADIOACTIVE("☢"),
    BIOHAZARD("☣"),
    UP_ARROW("⬆"),
    UP_RIGHT_ARROW("↗"),
    RIGHT_ARROW("➡"),
    DOWN_RIGHT_ARROW("↘"),
    DOWN_ARROW("⬇"),
    DOWN_LEFT_ARROW("↙"),
    LEFT_ARROW("⬅"),
    UP_LEFT_ARROW("↖"),
    UP_DOWN_ARROW("↕"),
    LEFT_RIGHT_ARROW("↔"),
    RIGHT_ARROW_CURVING_LEFT("↩"),
    LEFT_ARROW_CURVING_RIGHT("↪"),
    RIGHT_ARROW_CURVING_UP("⤴"),
    RIGHT_ARROW_CURVING_DOWN("⤵"),
    CLOCKWISE_VERTICAL_ARROWS("🔃"),
    COUNTERCLOCKWISE_ARROWS_BUTTON("🔄"),
    BACK_ARROW("🔙"),
    END_ARROW("🔚"),
    ON_ARROW("🔛"),
    SOON_ARROW("🔜"),
    TOP_ARROW("🔝"),
    PLACE_OF_WORSHIP("🛐"),
    ATOM_SYMBOL("⚛"),
    OM("🕉"),
    STAR_OF_DAVID("✡"),
    WHEEL_OF_DHARMA("☸"),
    YIN_YANG("☯"),
    LATIN_CROSS("✝"),
    ORTHODOX_CROSS("☦"),
    STAR_AND_CRESCENT("☪"),
    PEACE_SYMBOL("☮"),
    MENORAH("🕎"),
    DOTTED_SIX_POINTED_STAR("🔯"),
    KHANDA("🪯"),
    ARIES("♈"),
    TAURUS("♉"),
    GEMINI("♊"),
    CANCER("♋"),
    LEO("♌"),
    VIRGO("♍"),
    LIBRA("♎"),
    SCORPIO("♏"),
    SAGITTARIUS("♐"),
    CAPRICORN("♑"),
    AQUARIUS("♒"),
    PISCES("♓"),
    OPHIUCHUS("⛎"),
    SHUFFLE_TRACKS_BUTTON("🔀"),
    REPEAT_BUTTON("🔁"),
    REPEAT_SINGLE_BUTTON("🔂"),
    PLAY_BUTTON("▶"),
    FAST_FORWARD_BUTTON("⏩"),
    NEXT_TRACK_BUTTON("⏭"),
    PLAY_OR_PAUSE_BUTTON("⏯"),
    REVERSE_BUTTON("◀"),
    FAST_REVERSE_BUTTON("⏪"),
    LAST_TRACK_BUTTON("⏮"),
    UPWARDS_BUTTON("🔼"),
    FAST_UP_BUTTON("⏫"),
    DOWNWARDS_BUTTON("🔽"),
    FAST_DOWN_BUTTON("⏬"),
    PAUSE_BUTTON("⏸"),
    STOP_BUTTON("⏹"),
    RECORD_BUTTON("⏺"),
    EJECT_BUTTON("⏏"),
    CINEMA("🎦"),
    DIM_BUTTON("🔅"),
    BRIGHT_BUTTON("🔆"),
    ANTENNA_BARS("📶"),
    WIRELESS("🛜"),
    VIBRATION_MODE("📳"),
    MOBILE_PHONE_OFF("📴"),
    FEMALE_SIGN("♀"),
    MALE_SIGN("♂"),
    TRANSGENDER_SYMBOL("⚧"),
    MULTIPLY("✖"),
    PLUS("➕"),
    MINUS("➖"),
    DIVIDE("➗"),
    HEAVY_EQUALS_SIGN("🟰"),
    INFINITY("♾"),
    DOUBLE_EXCLAMATION_MARK("‼"),
    EXCLAMATION_QUESTION_MARK("⁉"),
    RED_QUESTION_MARK("❓"),
    WHITE_QUESTION_MARK("❔"),
    WHITE_EXCLAMATION_MARK("❕"),
    RED_EXCLAMATION_MARK("❗"),
    WAVY_DASH("〰"),
    CURRENCY_EXCHANGE("💱"),
    HEAVY_DOLLAR_SIGN("💲"),
    MEDICAL_SYMBOL("⚕"),
    RECYCLING_SYMBOL("♻"),
    FLEUR_DE_LIS("⚜"),
    TRIDENT_EMBLEM("🔱"),
    NAME_BADGE("📛"),
    JAPANESE_SYMBOL_FOR_BEGINNER("🔰"),
    HOLLOW_RED_CIRCLE("⭕"),
    CHECK_MARK_BUTTON("✅"),
    CHECK_BOX_WITH_CHECK("☑"),
    CHECK_MARK("✔"),
    CROSS_MARK("❌"),
    CROSS_MARK_BUTTON("❎"),
    CURLY_LOOP("➰"),
    DOUBLE_CURLY_LOOP("➿"),
    PART_ALTERNATION_MARK("〽"),
    EIGHT_SPOKED_ASTERISK("✳"),
    EIGHT_POINTED_STAR("✴"),
    SPARKLE("❇"),
    COPYRIGHT("©"),
    REGISTERED("®"),
    TRADE_MARK("™"),
    KEYCAP_SHARP("#️⃣"),
    KEYCAP_ASTERISK("*️⃣"),
    KEYCAP_0("0️⃣"),
    KEYCAP_1("1️⃣"),
    KEYCAP_2("2️⃣"),
    KEYCAP_3("3️⃣"),
    KEYCAP_4("4️⃣"),
    KEYCAP_5("5️⃣"),
    KEYCAP_6("6️⃣"),
    KEYCAP_7("7️⃣"),
    KEYCAP_8("8️⃣"),
    KEYCAP_9("9️⃣"),
    KEYCAP_10("🔟"),
    INPUT_LATIN_UPPERCASE("🔠"),
    INPUT_LATIN_LOWERCASE("🔡"),
    INPUT_NUMBERS("🔢"),
    INPUT_SYMBOLS("🔣"),
    INPUT_LATIN_LETTERS("🔤"),
    A_BUTTON_BLOOD_TYPE("🅰"),
    AB_BUTTON_BLOOD_TYPE("🆎"),
    B_BUTTON_BLOOD_TYPE("🅱"),
    CL_BUTTON("🆑"),
    COOL_BUTTON("🆒"),
    FREE_BUTTON("🆓"),
    INFORMATION("ℹ"),
    ID_BUTTON("🆔"),
    CIRCLED_M("Ⓜ"),
    NEW_BUTTON("🆕"),
    NG_BUTTON("🆖"),
    O_BUTTON_BLOOD_TYPE("🅾"),
    OK_BUTTON("🆗"),
    P_BUTTON("🅿"),
    SOS_BUTTON("🆘"),
    UP_BUTTON("🆙"),
    VS_BUTTON("🆚"),
    JAPANESE_HERE_BUTTON("🈁"),
    JAPANESE_SERVICE_CHARGE_BUTTON("🈂"),
    JAPANESE_MONTHLY_AMOUNT_BUTTON("🈷"),
    JAPANESE_NOT_FREE_OF_CHARGE_BUTTON("🈶"),
    JAPANESE_RESERVED_BUTTON("🈯"),
    JAPANESE_BARGAIN_BUTTON("🉐"),
    JAPANESE_DISCOUNT_BUTTON("🈹"),
    JAPANESE_FREE_OF_CHARGE_BUTTON("🈚"),
    JAPANESE_PROHIBITED_BUTTON("🈲"),
    JAPANESE_ACCEPTABLE_BUTTON("🉑"),
    JAPANESE_APPLICATION_BUTTON("🈸"),
    JAPANESE_PASSING_GRADE_BUTTON("🈴"),
    JAPANESE_VACANCY_BUTTON("🈳"),
    JAPANESE_CONGRATULATIONS_BUTTON("㊗"),
    JAPANESE_SECRET_BUTTON("㊙"),
    JAPANESE_OPEN_FOR_BUSINESS_BUTTON("🈺"),
    JAPANESE_NO_VACANCY_BUTTON("🈵"),
    RED_CIRCLE("🔴"),
    ORANGE_CIRCLE("🟠"),
    YELLOW_CIRCLE("🟡"),
    GREEN_CIRCLE("🟢"),
    BLUE_CIRCLE("🔵"),
    PURPLE_CIRCLE("🟣"),
    BROWN_CIRCLE("🟤"),
    BLACK_CIRCLE("⚫"),
    WHITE_CIRCLE("⚪"),
    RED_SQUARE("🟥"),
    ORANGE_SQUARE("🟧"),
    YELLOW_SQUARE("🟨"),
    GREEN_SQUARE("🟩"),
    BLUE_SQUARE("🟦"),
    PURPLE_SQUARE("🟪"),
    BROWN_SQUARE("🟫"),
    BLACK_LARGE_SQUARE("⬛"),
    WHITE_LARGE_SQUARE("⬜"),
    BLACK_MEDIUM_SQUARE("◼"),
    WHITE_MEDIUM_SQUARE("◻"),
    BLACK_MEDIUM_SMALL_SQUARE("◾"),
    WHITE_MEDIUM_SMALL_SQUARE("◽"),
    BLACK_SMALL_SQUARE("▪"),
    WHITE_SMALL_SQUARE("▫"),
    LARGE_ORANGE_DIAMOND("🔶"),
    LARGE_BLUE_DIAMOND("🔷"),
    SMALL_ORANGE_DIAMOND("🔸"),
    SMALL_BLUE_DIAMOND("🔹"),
    RED_TRIANGLE_POINTED_UP("🔺"),
    RED_TRIANGLE_POINTED_DOWN("🔻"),
    DIAMOND_WITH_A_DOT("💠"),
    RADIO_BUTTON("🔘"),
    WHITE_SQUARE_BUTTON("🔳"),
    BLACK_SQUARE_BUTTON("🔲"),
    CHEQUERED_FLAG("🏁"),
    TRIANGULAR_FLAG("🚩"),
    CROSSED_FLAGS("🎌"),
    BLACK_FLAG("🏴"),
    WHITE_FLAG("🏳"),
    RAINBOW_FLAG("🏳️‍🌈"),
    TRANSGENDER_FLAG("🏳️‍⚧️"),
    PIRATE_FLAG("🏴‍☠️"),
    FLAG_ASCENSION_ISLAND("🇦🇨"),
    FLAG_ANDORRA("🇦🇩"),
    FLAG_UNITED_ARAB_EMIRATES("🇦🇪"),
    FLAG_AFGHANISTAN("🇦🇫"),
    FLAG_ANTIGUA_BARBUDA("🇦🇬"),
    FLAG_ANGUILLA("🇦🇮"),
    FLAG_ALBANIA("🇦🇱"),
    FLAG_ARMENIA("🇦🇲"),
    FLAG_ANGOLA("🇦🇴"),
    FLAG_ANTARCTICA("🇦🇶"),
    FLAG_ARGENTINA("🇦🇷"),
    FLAG_AMERICAN_SAMOA("🇦🇸"),
    FLAG_AUSTRIA("🇦🇹"),
    FLAG_AUSTRALIA("🇦🇺"),
    FLAG_ARUBA("🇦🇼"),
    FLAG_ALAND_ISLANDS("🇦🇽"),
    FLAG_AZERBAIJAN("🇦🇿"),
    FLAG_BOSNIA_HERZEGOVINA("🇧🇦"),
    FLAG_BARBADOS("🇧🇧"),
    FLAG_BANGLADESH("🇧🇩"),
    FLAG_BELGIUM("🇧🇪"),
    FLAG_BURKINA_FASO("🇧🇫"),
    FLAG_BULGARIA("🇧🇬"),
    FLAG_BAHRAIN("🇧🇭"),
    FLAG_BURUNDI("🇧🇮"),
    FLAG_BENIN("🇧🇯"),
    FLAG_ST_BARTHELEMY("🇧🇱"),
    FLAG_BERMUDA("🇧🇲"),
    FLAG_BRUNEI("🇧🇳"),
    FLAG_BOLIVIA("🇧🇴"),
    FLAG_CARIBBEAN_NETHERLANDS("🇧🇶"),
    FLAG_BRAZIL("🇧🇷"),
    FLAG_BAHAMAS("🇧🇸"),
    FLAG_BHUTAN("🇧🇹"),
    FLAG_BOUVET_ISLAND("🇧🇻"),
    FLAG_BOTSWANA("🇧🇼"),
    FLAG_BELARUS("🇧🇾"),
    FLAG_BELIZE("🇧🇿"),
    FLAG_CANADA("🇨🇦"),
    FLAG_COCOS_KEELING_ISLANDS("🇨🇨"),
    FLAG_CONGO___KINSHASA("🇨🇩"),
    FLAG_CENTRAL_AFRICAN_REPUBLIC("🇨🇫"),
    FLAG_CONGO___BRAZZAVILLE("🇨🇬"),
    FLAG_SWITZERLAND("🇨🇭"),
    FLAG_COTE_IVOIRE("🇨🇮"),
    FLAG_COOK_ISLANDS("🇨🇰"),
    FLAG_CHILE("🇨🇱"),
    FLAG_CAMEROON("🇨🇲"),
    FLAG_CHINA("🇨🇳"),
    FLAG_COLOMBIA("🇨🇴"),
    FLAG_CLIPPERTON_ISLAND("🇨🇵"),
    FLAG_COSTA_RICA("🇨🇷"),
    FLAG_CUBA("🇨🇺"),
    FLAG_CAPE_VERDE("🇨🇻"),
    FLAG_CURACAO("🇨🇼"),
    FLAG_CHRISTMAS_ISLAND("🇨🇽"),
    FLAG_CYPRUS("🇨🇾"),
    FLAG_CZECHIA("🇨🇿"),
    FLAG_GERMANY("🇩🇪"),
    FLAG_DIEGO_GARCIA("🇩🇬"),
    FLAG_DJIBOUTI("🇩🇯"),
    FLAG_DENMARK("🇩🇰"),
    FLAG_DOMINICA("🇩🇲"),
    FLAG_DOMINICAN_REPUBLIC("🇩🇴"),
    FLAG_ALGERIA("🇩🇿"),
    FLAG_CEUTA_MELILLA("🇪🇦"),
    FLAG_ECUADOR("🇪🇨"),
    FLAG_ESTONIA("🇪🇪"),
    FLAG_EGYPT("🇪🇬"),
    FLAG_WESTERN_SAHARA("🇪🇭"),
    FLAG_ERITREA("🇪🇷"),
    FLAG_SPAIN("🇪🇸"),
    FLAG_ETHIOPIA("🇪🇹"),
    FLAG_EUROPEAN_UNION("🇪🇺"),
    FLAG_FINLAND("🇫🇮"),
    FLAG_FIJI("🇫🇯"),
    FLAG_FALKLAND_ISLANDS("🇫🇰"),
    FLAG_MICRONESIA("🇫🇲"),
    FLAG_FAROE_ISLANDS("🇫🇴"),
    FLAG_FRANCE("🇫🇷"),
    FLAG_GABON("🇬🇦"),
    FLAG_UNITED_KINGDOM("🇬🇧"),
    FLAG_GRENADA("🇬🇩"),
    FLAG_GEORGIA("🇬🇪"),
    FLAG_FRENCH_GUIANA("🇬🇫"),
    FLAG_GUERNSEY("🇬🇬"),
    FLAG_GHANA("🇬🇭"),
    FLAG_GIBRALTAR("🇬🇮"),
    FLAG_GREENLAND("🇬🇱"),
    FLAG_GAMBIA("🇬🇲"),
    FLAG_GUINEA("🇬🇳"),
    FLAG_GUADELOUPE("🇬🇵"),
    FLAG_EQUATORIAL_GUINEA("🇬🇶"),
    FLAG_GREECE("🇬🇷"),
    FLAG_SOUTH_GEORGIA_SOUTH_SANDWICH_ISLANDS("🇬🇸"),
    FLAG_GUATEMALA("🇬🇹"),
    FLAG_GUAM("🇬🇺"),
    FLAG_GUINEA_BISSAU("🇬🇼"),
    FLAG_GUYANA("🇬🇾"),
    FLAG_HONG_KONG_SAR_CHINA("🇭🇰"),
    FLAG_HEARD_MCDONALD_ISLANDS("🇭🇲"),
    FLAG_HONDURAS("🇭🇳"),
    FLAG_CROATIA("🇭🇷"),
    FLAG_HAITI("🇭🇹"),
    FLAG_HUNGARY("🇭🇺"),
    FLAG_CANARY_ISLANDS("🇮🇨"),
    FLAG_INDONESIA("🇮🇩"),
    FLAG_IRELAND("🇮🇪"),
    FLAG_ISRAEL("🇮🇱"),
    FLAG_ISLE_OF_MAN("🇮🇲"),
    FLAG_INDIA("🇮🇳"),
    FLAG_BRITISH_INDIAN_OCEAN_TERRITORY("🇮🇴"),
    FLAG_IRAQ("🇮🇶"),
    FLAG_IRAN("🇮🇷"),
    FLAG_ICELAND("🇮🇸"),
    FLAG_ITALY("🇮🇹"),
    FLAG_JERSEY("🇯🇪"),
    FLAG_JAMAICA("🇯🇲"),
    FLAG_JORDAN("🇯🇴"),
    FLAG_JAPAN("🇯🇵"),
    FLAG_KENYA("🇰🇪"),
    FLAG_KYRGYZSTAN("🇰🇬"),
    FLAG_CAMBODIA("🇰🇭"),
    FLAG_KIRIBATI("🇰🇮"),
    FLAG_COMOROS("🇰🇲"),
    FLAG_ST__KITTS_NEVIS("🇰🇳"),
    FLAG_NORTH_KOREA("🇰🇵"),
    FLAG_SOUTH_KOREA("🇰🇷"),
    FLAG_KUWAIT("🇰🇼"),
    FLAG_CAYMAN_ISLANDS("🇰🇾"),
    FLAG_KAZAKHSTAN("🇰🇿"),
    FLAG_LAOS("🇱🇦"),
    FLAG_LEBANON("🇱🇧"),
    FLAG_ST__LUCIA("🇱🇨"),
    FLAG_LIECHTENSTEIN("🇱🇮"),
    FLAG_SRI_LANKA("🇱🇰"),
    FLAG_LIBERIA("🇱🇷"),
    FLAG_LESOTHO("🇱🇸"),
    FLAG_LITHUANIA("🇱🇹"),
    FLAG_LUXEMBOURG("🇱🇺"),
    FLAG_LATVIA("🇱🇻"),
    FLAG_LIBYA("🇱🇾"),
    FLAG_MOROCCO("🇲🇦"),
    FLAG_MONACO("🇲🇨"),
    FLAG_MOLDOVA("🇲🇩"),
    FLAG_MONTENEGRO("🇲🇪"),
    FLAG_ST__MARTIN("🇲🇫"),
    FLAG_MADAGASCAR("🇲🇬"),
    FLAG_MARSHALL_ISLANDS("🇲🇭"),
    FLAG_NORTH_MACEDONIA("🇲🇰"),
    FLAG_MALI("🇲🇱"),
    FLAG_MYANMAR_BURMA("🇲🇲"),
    FLAG_MONGOLIA("🇲🇳"),
    FLAG_MACAO_SAR_CHINA("🇲🇴"),
    FLAG_NORTHERN_MARIANA_ISLANDS("🇲🇵"),
    FLAG_MARTINIQUE("🇲🇶"),
    FLAG_MAURITANIA("🇲🇷"),
    FLAG_MONTSERRAT("🇲🇸"),
    FLAG_MALTA("🇲🇹"),
    FLAG_MAURITIUS("🇲🇺"),
    FLAG_MALDIVES("🇲🇻"),
    FLAG_MALAWI("🇲🇼"),
    FLAG_MEXICO("🇲🇽"),
    FLAG_MALAYSIA("🇲🇾"),
    FLAG_MOZAMBIQUE("🇲🇿"),
    FLAG_NAMIBIA("🇳🇦"),
    FLAG_NEW_CALEDONIA("🇳🇨"),
    FLAG_NIGER("🇳🇪"),
    FLAG_NORFOLK_ISLAND("🇳🇫"),
    FLAG_NIGERIA("🇳🇬"),
    FLAG_NICARAGUA("🇳🇮"),
    FLAG_NETHERLANDS("🇳🇱"),
    FLAG_NORWAY("🇳🇴"),
    FLAG_NEPAL("🇳🇵"),
    FLAG_NAURU("🇳🇷"),
    FLAG_NIUE("🇳🇺"),
    FLAG_NEW_ZEALAND("🇳🇿"),
    FLAG_OMAN("🇴🇲"),
    FLAG_PANAMA("🇵🇦"),
    FLAG_PERU("🇵🇪"),
    FLAG_FRENCH_POLYNESIA("🇵🇫"),
    FLAG_PAPUA_NEW_GUINEA("🇵🇬"),
    FLAG_PHILIPPINES("🇵🇭"),
    FLAG_PAKISTAN("🇵🇰"),
    FLAG_POLAND("🇵🇱"),
    FLAG_ST__PIERRE_MIQUELON("🇵🇲"),
    FLAG_PITCAIRN_ISLANDS("🇵🇳"),
    FLAG_PUERTO_RICO("🇵🇷"),
    FLAG_PALESTINIAN_TERRITORIES("🇵🇸"),
    FLAG_PORTUGAL("🇵🇹"),
    FLAG_PALAU("🇵🇼"),
    FLAG_PARAGUAY("🇵🇾"),
    FLAG_QATAR("🇶🇦"),
    FLAG_REUNION("🇷🇪"),
    FLAG_ROMANIA("🇷🇴"),
    FLAG_SERBIA("🇷🇸"),
    FLAG_RUSSIA("🇷🇺"),
    FLAG_RWANDA("🇷🇼"),
    FLAG_SAUDI_ARABIA("🇸🇦"),
    FLAG_SOLOMON_ISLANDS("🇸🇧"),
    FLAG_SEYCHELLES("🇸🇨"),
    FLAG_SUDAN("🇸🇩"),
    FLAG_SWEDEN("🇸🇪"),
    FLAG_SINGAPORE("🇸🇬"),
    FLAG_ST__HELENA("🇸🇭"),
    FLAG_SLOVENIA("🇸🇮"),
    FLAG_SVALBARD_JAN_MAYEN("🇸🇯"),
    FLAG_SLOVAKIA("🇸🇰"),
    FLAG_SIERRA_LEONE("🇸🇱"),
    FLAG_SAN_MARINO("🇸🇲"),
    FLAG_SENEGAL("🇸🇳"),
    FLAG_SOMALIA("🇸🇴"),
    FLAG_SURINAME("🇸🇷"),
    FLAG_SOUTH_SUDAN("🇸🇸"),
    FLAG_SAO_TOME_PRINCIPE("🇸🇹"),
    FLAG_EL_SALVADOR("🇸🇻"),
    FLAG_SINT_MAARTEN("🇸🇽"),
    FLAG_SYRIA("🇸🇾"),
    FLAG_ESWATINI("🇸🇿"),
    FLAG_TRISTAN_DA_CUNHA("🇹🇦"),
    FLAG_TURKS_CAICOS_ISLANDS("🇹🇨"),
    FLAG_CHAD("🇹🇩"),
    FLAG_FRENCH_SOUTHERN_TERRITORIES("🇹🇫"),
    FLAG_TOGO("🇹🇬"),
    FLAG_THAILAND("🇹🇭"),
    FLAG_TAJIKISTAN("🇹🇯"),
    FLAG_TOKELAU("🇹🇰"),
    FLAG_TIMOR_LESTE("🇹🇱"),
    FLAG_TURKMENISTAN("🇹🇲"),
    FLAG_TUNISIA("🇹🇳"),
    FLAG_TONGA("🇹🇴"),
    FLAG_TURKEY("🇹🇷"),
    FLAG_TRINIDAD_TOBAGO("🇹🇹"),
    FLAG_TUVALU("🇹🇻"),
    FLAG_TAIWAN("🇹🇼"),
    FLAG_TANZANIA("🇹🇿"),
    FLAG_UKRAINE("🇺🇦"),
    FLAG_UGANDA("🇺🇬"),
    FLAG_U_S__OUTLYING_ISLANDS("🇺🇲"),
    FLAG_UNITED_NATIONS("🇺🇳"),
    FLAG_UNITED_STATES("🇺🇸"),
    FLAG_URUGUAY("🇺🇾"),
    FLAG_UZBEKISTAN("🇺🇿"),
    FLAG_VATICAN_CITY("🇻🇦"),
    FLAG_ST__VINCENT_GRENADINES("🇻🇨"),
    FLAG_VENEZUELA("🇻🇪"),
    FLAG_BRITISH_VIRGIN_ISLANDS("🇻🇬"),
    FLAG_U_S__VIRGIN_ISLANDS("🇻🇮"),
    FLAG_VIETNAM("🇻🇳"),
    FLAG_VANUATU("🇻🇺"),
    FLAG_WALLIS_FUTUNA("🇼🇫"),
    FLAG_SAMOA("🇼🇸"),
    FLAG_KOSOVO("🇽🇰"),
    FLAG_YEMEN("🇾🇪"),
    FLAG_MAYOTTE("🇾🇹"),
    FLAG_SOUTH_AFRICA("🇿🇦"),
    FLAG_ZAMBIA("🇿🇲"),
    FLAG_ZIMBABWE("🇿🇼"),
    FLAG_ENGLAND("🏴󠁧󠁢󠁥󠁮󠁧󠁿"),
    FLAG_SCOTLAND("🏴󠁧󠁢󠁳󠁣󠁴󠁿"),
    FLAG_WALES("🏴󠁧󠁢󠁷󠁬󠁳󠁿");

    private final String value;

    Emoji(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }
}
