package it.auties.whatsapp.model.button.template.hsm;

import it.auties.whatsapp.model.button.template.hsm.HighlyStructuredCallButton;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.protobuf.model.ProtobufWireType;

public class HighlyStructuredCallButtonSpec {
    public static byte[] encode(HighlyStructuredCallButton protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        var outputStream = new ProtobufOutputStream(sizeOf(protoInputObject));
        outputStream.writeBytes(1, it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessageSpec.encode(protoInputObject.text()));
        outputStream.writeBytes(2, it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessageSpec.encode(protoInputObject.phoneNumber()));
        return outputStream.toByteArray();
    }

    public static HighlyStructuredCallButton decode(byte[] input) {
        if (input == null) {
            return null;
        }
        return decode(new ProtobufInputStream(input, 0, input.length));
    }

    public static HighlyStructuredCallButton decode(ProtobufInputStream protoInputStream) {
        it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessage text = null;
        it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessage phoneNumber = null;
        while (protoInputStream.readTag()) {
            var protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1 -> text = it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessageSpec.decode(protoInputStream.lengthDelimitedStream());
                case 2 -> phoneNumber = it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessageSpec.decode(protoInputStream.lengthDelimitedStream());
                default -> protoInputStream.readUnknown(false);
            }
        }
        return new it.auties.whatsapp.model.button.template.hsm.HighlyStructuredCallButton(text, phoneNumber);
    }

    public static int sizeOf(HighlyStructuredCallButton object) {
        if (object == null) {
            return 0;
        }
        var protoSize = 0;
        var text = object.text();
        if (text != null) {
            protoSize += ProtobufOutputStream.getFieldSize(1, 2);
            var textSerializedSize = it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessageSpec.sizeOf(text);
            protoSize += ProtobufOutputStream.getVarIntSize(textSerializedSize);
            protoSize += textSerializedSize;
        }
        var phoneNumber = object.phoneNumber();
        if (phoneNumber != null) {
            protoSize += ProtobufOutputStream.getFieldSize(2, 2);
            var phoneNumberSerializedSize = it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessageSpec.sizeOf(phoneNumber);
            protoSize += ProtobufOutputStream.getVarIntSize(phoneNumberSerializedSize);
            protoSize += phoneNumberSerializedSize;
        }
        return protoSize;
    }

}
