package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.BusinessIdentityInfo.ActorsType;
import java.util.Arrays;
import java.util.Optional;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class BusinessIdentityInfoActorsTypeSpec {
    public static Integer encode(ActorsType protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return protoInputObject.index;
    }

    public static Optional<ActorsType> decode(int index) {
        return Arrays.stream(ActorsType.values())
                .filter(entry -> entry.index == index)
                .findFirst();
    }

    public static int sizeOf(ActorsType object) {
        if (object == null) {
            return 0;
        }
        return ProtobufOutputStream.getVarIntSize(object.index);
    }

}
