/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.exception.HmacValidationException;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.util.Exceptions;
import java.nio.file.Path;
import java.util.function.BiConsumer;

public interface ErrorHandler {
    public Result handleError(Whatsapp var1, Location var2, Throwable var3);

    public static ErrorHandler toTerminal() {
        return ErrorHandler.defaultErrorHandler((api, error) -> error.printStackTrace());
    }

    public static ErrorHandler toFile() {
        return ErrorHandler.defaultErrorHandler((api, error) -> Exceptions.save(error));
    }

    public static ErrorHandler toFile(Path directory) {
        return ErrorHandler.defaultErrorHandler((api, error) -> Exceptions.save(directory, error));
    }

    private static ErrorHandler defaultErrorHandler(BiConsumer<Whatsapp, Throwable> printer) {
        return (whatsapp, location, throwable) -> {
            System.Logger logger = System.getLogger("ErrorHandler");
            String jid = whatsapp.store().jid().map(Jid::user).orElse("UNKNOWN");
            if (location == Location.RECONNECT) {
                logger.log(System.Logger.Level.WARNING, "[{0}] Cannot reconnect: retrying on next timeout", jid);
                return Result.DISCARD;
            }
            logger.log(System.Logger.Level.ERROR, "[{0}] Socket failure at {1}", new Object[]{jid, location});
            if (printer != null) {
                printer.accept(whatsapp, throwable);
            }
            if (location == Location.LOGIN) {
                logger.log(System.Logger.Level.WARNING, "[{0}] Cannot login", jid);
                return Result.DISCONNECT;
            }
            if (location == Location.CRYPTOGRAPHY && whatsapp.store().clientType() == ClientType.MOBILE) {
                logger.log(System.Logger.Level.WARNING, "[{0}] Reconnecting", jid);
                return Result.RECONNECT;
            }
            if (location == Location.INITIAL_APP_STATE_SYNC || location == Location.CRYPTOGRAPHY || location == Location.MESSAGE && throwable instanceof HmacValidationException) {
                logger.log(System.Logger.Level.WARNING, "[{0}] Restore", jid);
                return Result.RESTORE;
            }
            logger.log(System.Logger.Level.WARNING, "[{0}] Ignored failure", jid);
            return Result.DISCARD;
        };
    }

    public static enum Location {
        UNKNOWN,
        LOGIN,
        CRYPTOGRAPHY,
        MEDIA_CONNECTION,
        STREAM,
        PULL_APP_STATE,
        PUSH_APP_STATE,
        INITIAL_APP_STATE_SYNC,
        MESSAGE,
        HISTORY_SYNC,
        RECONNECT;

    }

    public static enum Result {
        DISCARD,
        RESTORE,
        DISCONNECT,
        RECONNECT,
        LOG_OUT;

    }
}

