/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import java.util.Objects;

@ProtobufMessage
public final class WebHistorySetting {
    private static final WebHistorySetting ZERO = new WebHistorySetting(0, false);
    private static final WebHistorySetting ZERO_WITH_NEWSLETTERS = new WebHistorySetting(0, true);
    private static final WebHistorySetting STANDARD = new WebHistorySetting(59206, false);
    private static final WebHistorySetting STANDARD_WITH_NEWSLETTERS = new WebHistorySetting(59206, true);
    private static final WebHistorySetting EXTENDED = new WebHistorySetting(Integer.MAX_VALUE, false);
    private static final WebHistorySetting EXTENDED_WITH_NEWSLETTERS = new WebHistorySetting(Integer.MAX_VALUE, true);
    @ProtobufProperty(index=1, type=ProtobufType.INT32)
    final int size;
    @ProtobufProperty(index=2, type=ProtobufType.BOOL)
    final boolean newsletters;

    WebHistorySetting(int size, boolean newsletters) {
        this.size = size;
        this.newsletters = newsletters;
    }

    public static WebHistorySetting discard(boolean newsletters) {
        return newsletters ? ZERO_WITH_NEWSLETTERS : ZERO;
    }

    public static WebHistorySetting standard(boolean newsletters) {
        return newsletters ? STANDARD_WITH_NEWSLETTERS : STANDARD;
    }

    public static WebHistorySetting extended(boolean newsletters) {
        return newsletters ? EXTENDED_WITH_NEWSLETTERS : EXTENDED;
    }

    public static WebHistorySetting custom(int size, boolean newsletters) {
        return new WebHistorySetting(size, newsletters);
    }

    public boolean isZero() {
        return this.size == 0;
    }

    public boolean isExtended() {
        return this.size > STANDARD.size();
    }

    public int size() {
        return this.size;
    }

    public boolean hasNewsletters() {
        return this.newsletters;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        WebHistorySetting that = (WebHistorySetting)obj;
        return this.size == that.size && this.newsletters == that.newsletters;
    }

    public int hashCode() {
        return Objects.hash(this.size, this.newsletters);
    }

    public String toString() {
        return "WebHistorySetting[size=" + this.size + ", newsletters=" + this.newsletters + "]";
    }
}

