/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.OptionsBuilder;
import it.auties.whatsapp.api.PairingCodeHandler;
import it.auties.whatsapp.api.QrHandler;
import it.auties.whatsapp.api.WebHistorySetting;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import java.util.Optional;

public final class WebOptionsBuilder
extends OptionsBuilder<WebOptionsBuilder> {
    private Whatsapp whatsapp;

    WebOptionsBuilder(Store store, Keys keys) {
        super(store, keys);
    }

    public WebOptionsBuilder automaticMessageReceipts(boolean automaticMessageReceipts) {
        this.store.setAutomaticMessageReceipts(automaticMessageReceipts);
        return this;
    }

    public WebOptionsBuilder historySetting(WebHistorySetting historyLength) {
        this.store.setWebHistorySetting(historyLength);
        return this;
    }

    public Whatsapp unregistered(QrHandler qrHandler) {
        if (this.whatsapp == null) {
            this.whatsapp = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).webVerificationSupport(qrHandler).build();
        }
        return this.whatsapp;
    }

    public Whatsapp unregistered(long phoneNumber, PairingCodeHandler pairingCodeHandler) {
        if (this.whatsapp == null) {
            this.store.setPhoneNumber(PhoneNumber.of(phoneNumber));
            this.whatsapp = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).webVerificationSupport(pairingCodeHandler).build();
        }
        return this.whatsapp;
    }

    public Optional<Whatsapp> registered() {
        if (!this.keys.registered()) {
            return Optional.empty();
        }
        if (this.whatsapp == null) {
            this.whatsapp = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).build();
        }
        return Optional.of(this.whatsapp);
    }
}

