/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.QrHandler;
import it.auties.whatsapp.api.WebVerificationHandler;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.util.Validate;
import java.util.Objects;
import java.util.Optional;

public class WhatsappCustomBuilder {
    private Store store;
    private Keys keys;
    private ErrorHandler errorHandler;
    private WebVerificationHandler webVerificationHandler;

    WhatsappCustomBuilder() {
    }

    public WhatsappCustomBuilder store(Store store) {
        this.store = store;
        return this;
    }

    public WhatsappCustomBuilder keys(Keys keys) {
        this.keys = keys;
        return this;
    }

    public WhatsappCustomBuilder errorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public WhatsappCustomBuilder webVerificationSupport(WebVerificationHandler webVerificationHandler) {
        this.webVerificationHandler = webVerificationHandler;
        return this;
    }

    public Whatsapp build() {
        Validate.isTrue(Objects.equals(this.store.uuid(), this.keys.uuid()), "UUID mismatch: %s != %s", this.store.uuid(), this.keys.uuid());
        Optional<Whatsapp> knownInstance = Whatsapp.getInstanceByUuid(this.store.uuid());
        if (knownInstance.isPresent()) {
            return knownInstance.get();
        }
        WebVerificationHandler checkedSupport = WhatsappCustomBuilder.getWebVerificationMethod(this.store, this.keys, this.webVerificationHandler);
        return new Whatsapp(this.store, this.keys, this.errorHandler, checkedSupport);
    }

    private static WebVerificationHandler getWebVerificationMethod(Store store, Keys keys, WebVerificationHandler webVerificationHandler) {
        if (store.clientType() != ClientType.WEB) {
            return null;
        }
        if (!keys.registered() && webVerificationHandler == null) {
            return QrHandler.toTerminal();
        }
        return webVerificationHandler;
    }
}

