/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.controller.Controller;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.controller.StoreKeysPair;
import it.auties.whatsapp.controller.builtin.DiscardingControllerSerializer;
import it.auties.whatsapp.controller.builtin.JsonControllerSerializer;
import it.auties.whatsapp.controller.builtin.ProtobufControllerSerializer;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public interface ControllerSerializer {
    public static ControllerSerializer discarding() {
        return DiscardingControllerSerializer.instance();
    }

    public static ControllerSerializer toProtobuf() {
        return new ProtobufControllerSerializer();
    }

    public static ControllerSerializer toProtobuf(Path baseDirectory) {
        return new ProtobufControllerSerializer(baseDirectory);
    }

    public static ControllerSerializer toJson() {
        return new JsonControllerSerializer();
    }

    public static ControllerSerializer toJson(Path baseDirectory) {
        return new JsonControllerSerializer(baseDirectory);
    }

    public LinkedList<UUID> listIds(ClientType var1);

    public LinkedList<PhoneNumber> listPhoneNumbers(ClientType var1);

    default public StoreKeysPair newStoreKeysPair(UUID uuid, Long phoneNumber, Collection<String> alias, ClientType clientType) {
        Store store = Store.newStore(uuid, phoneNumber, alias, clientType);
        store.setSerializer(this);
        this.linkMetadata(store);
        Keys keys = Keys.newKeys(uuid, phoneNumber, alias, clientType);
        keys.setSerializer(this);
        this.serializeKeys(keys, true);
        return new StoreKeysPair(store, keys);
    }

    default public Optional<StoreKeysPair> deserializeStoreKeysPair(UUID uuid, Long phoneNumber, String alias, ClientType clientType) {
        if (uuid != null) {
            Optional<Store> store = this.deserializeStore(clientType, uuid);
            if (store.isEmpty()) {
                return Optional.empty();
            }
            store.get().setSerializer(this);
            this.attributeStore(store.get());
            Optional<Keys> keys = this.deserializeKeys(clientType, uuid);
            if (keys.isEmpty()) {
                return Optional.empty();
            }
            keys.get().setSerializer(this);
            return Optional.of(new StoreKeysPair(store.get(), keys.get()));
        }
        if (phoneNumber != null) {
            Optional<Store> store = this.deserializeStore(clientType, phoneNumber);
            if (store.isEmpty()) {
                return Optional.empty();
            }
            store.get().setSerializer(this);
            this.attributeStore(store.get());
            Optional<Keys> keys = this.deserializeKeys(clientType, phoneNumber);
            if (keys.isEmpty()) {
                return Optional.empty();
            }
            keys.get().setSerializer(this);
            return Optional.of(new StoreKeysPair(store.get(), keys.get()));
        }
        if (alias != null) {
            Optional<Store> store = this.deserializeStore(clientType, alias);
            if (store.isEmpty()) {
                return Optional.empty();
            }
            store.get().setSerializer(this);
            this.attributeStore(store.get());
            Optional<Keys> keys = this.deserializeKeys(clientType, alias);
            if (keys.isEmpty()) {
                return Optional.empty();
            }
            keys.get().setSerializer(this);
            return Optional.of(new StoreKeysPair(store.get(), keys.get()));
        }
        return Optional.empty();
    }

    public CompletableFuture<Void> serializeKeys(Keys var1, boolean var2);

    public CompletableFuture<Void> serializeStore(Store var1, boolean var2);

    public Optional<Keys> deserializeKeys(ClientType var1, UUID var2);

    public Optional<Keys> deserializeKeys(ClientType var1, long var2);

    public Optional<Keys> deserializeKeys(ClientType var1, String var2);

    public Optional<Store> deserializeStore(ClientType var1, UUID var2);

    public Optional<Store> deserializeStore(ClientType var1, long var2);

    public Optional<Store> deserializeStore(ClientType var1, String var2);

    public void deleteSession(Controller<?> var1);

    default public void linkMetadata(Controller<?> controller) {
    }

    default public CompletableFuture<Void> attributeStore(Store store) {
        return CompletableFuture.completedFuture(null);
    }
}

