/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.controller.Controller;
import it.auties.whatsapp.controller.KeysBuilder;
import it.auties.whatsapp.model.companion.CompanionHashState;
import it.auties.whatsapp.model.companion.CompanionSyncKey;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair;
import it.auties.whatsapp.model.signal.sender.SenderKeyName;
import it.auties.whatsapp.model.signal.sender.SenderKeyRecord;
import it.auties.whatsapp.model.signal.sender.SenderPreKeys;
import it.auties.whatsapp.model.signal.session.Session;
import it.auties.whatsapp.model.signal.session.SessionAddress;
import it.auties.whatsapp.model.sync.AppStateSyncKey;
import it.auties.whatsapp.model.sync.PatchType;
import it.auties.whatsapp.util.Bytes;
import it.auties.whatsapp.util.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ProtobufMessage
public final class Keys
extends Controller<Keys> {
    @ProtobufProperty(index=5, type=ProtobufType.INT32)
    final Integer registrationId;
    @ProtobufProperty(index=6, type=ProtobufType.MESSAGE)
    final SignalKeyPair noiseKeyPair;
    @ProtobufProperty(index=7, type=ProtobufType.MESSAGE)
    final SignalKeyPair ephemeralKeyPair;
    @ProtobufProperty(index=8, type=ProtobufType.MESSAGE)
    final SignalKeyPair identityKeyPair;
    @ProtobufProperty(index=9, type=ProtobufType.MESSAGE)
    SignalKeyPair companionKeyPair;
    @ProtobufProperty(index=10, type=ProtobufType.MESSAGE)
    SignalSignedKeyPair signedKeyPair;
    @ProtobufProperty(index=11, type=ProtobufType.BYTES)
    byte[] signedKeyIndex;
    @ProtobufProperty(index=12, type=ProtobufType.UINT64)
    Long signedKeyIndexTimestamp;
    @ProtobufProperty(index=13, type=ProtobufType.MESSAGE)
    final List<SignalPreKeyPair> preKeys;
    @ProtobufProperty(index=14, type=ProtobufType.STRING)
    final String fdid;
    @ProtobufProperty(index=15, type=ProtobufType.BYTES)
    final byte[] deviceId;
    @ProtobufProperty(index=26, type=ProtobufType.STRING)
    final UUID advertisingId;
    @ProtobufProperty(index=16, type=ProtobufType.BYTES)
    final byte[] identityId;
    @ProtobufProperty(index=27, type=ProtobufType.BYTES)
    final byte[] backupToken;
    @ProtobufProperty(index=17, type=ProtobufType.MESSAGE)
    SignedDeviceIdentity companionIdentity;
    @ProtobufProperty(index=18, type=ProtobufType.MAP, mapKeyType=ProtobufType.STRING, mapValueType=ProtobufType.MESSAGE)
    final Map<SenderKeyName, SenderKeyRecord> senderKeys;
    @ProtobufProperty(index=19, type=ProtobufType.MESSAGE)
    final List<CompanionSyncKey> appStateKeys;
    @ProtobufProperty(index=20, type=ProtobufType.MAP, mapKeyType=ProtobufType.STRING, mapValueType=ProtobufType.MESSAGE)
    final ConcurrentMap<SessionAddress, Session> sessions;
    @ProtobufProperty(index=21, type=ProtobufType.MESSAGE, mapKeyType=ProtobufType.STRING, mapValueType=ProtobufType.MESSAGE)
    final ConcurrentMap<String, CompanionHashState> hashStates;
    @ProtobufProperty(index=22, type=ProtobufType.MAP, mapKeyType=ProtobufType.STRING, mapValueType=ProtobufType.MESSAGE)
    final ConcurrentMap<Jid, SenderPreKeys> groupsPreKeys;
    @ProtobufProperty(index=23, type=ProtobufType.BOOL)
    boolean registered;
    @ProtobufProperty(index=24, type=ProtobufType.BOOL)
    boolean businessCertificate;
    @ProtobufProperty(index=25, type=ProtobufType.BOOL)
    boolean initialAppSync;
    @JsonIgnore
    final AtomicLong writeCounter;
    @JsonIgnore
    final AtomicLong readCounter;
    @JsonIgnore
    byte[] writeKey;
    @JsonIgnore
    byte[] readKey;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Keys(UUID uuid, PhoneNumber phoneNumber, ClientType clientType, Collection<String> alias, Integer registrationId, SignalKeyPair noiseKeyPair, SignalKeyPair ephemeralKeyPair, SignalKeyPair identityKeyPair, SignalKeyPair companionKeyPair, SignalSignedKeyPair signedKeyPair, byte[] signedKeyIndex, Long signedKeyIndexTimestamp, List<SignalPreKeyPair> preKeys, String fdid, byte[] deviceId, UUID advertisingId, byte[] identityId, byte[] backupToken, SignedDeviceIdentity companionIdentity, Map<SenderKeyName, SenderKeyRecord> senderKeys, List<CompanionSyncKey> appStateKeys, ConcurrentMap<SessionAddress, Session> sessions, ConcurrentMap<String, CompanionHashState> hashStates, ConcurrentMap<Jid, SenderPreKeys> groupsPreKeys, boolean registered, boolean businessCertificate, boolean initialAppSync) {
        super(uuid, phoneNumber, null, clientType, alias);
        this.registrationId = Objects.requireNonNullElseGet(registrationId, () -> ThreadLocalRandom.current().nextInt(16380) + 1);
        this.noiseKeyPair = Objects.requireNonNull(noiseKeyPair, "Missing noise keypair");
        this.ephemeralKeyPair = Objects.requireNonNullElseGet(ephemeralKeyPair, SignalKeyPair::random);
        this.identityKeyPair = Objects.requireNonNull(identityKeyPair, "Missing identity keypair");
        this.companionKeyPair = Objects.requireNonNullElseGet(companionKeyPair, SignalKeyPair::random);
        this.signedKeyPair = Objects.requireNonNullElseGet(signedKeyPair, () -> SignalSignedKeyPair.of(this.registrationId, identityKeyPair));
        this.signedKeyIndex = signedKeyIndex;
        this.signedKeyIndexTimestamp = signedKeyIndexTimestamp;
        this.preKeys = Objects.requireNonNullElseGet(preKeys, ArrayList::new);
        this.fdid = Objects.requireNonNullElseGet(fdid, UUID.randomUUID()::toString);
        this.deviceId = Objects.requireNonNullElseGet(deviceId, () -> HexFormat.of().parseHex(UUID.randomUUID().toString().replaceAll("-", "")));
        this.advertisingId = Objects.requireNonNullElseGet(advertisingId, UUID::randomUUID);
        this.identityId = Objects.requireNonNull(identityId, "Missing identity id");
        this.backupToken = Objects.requireNonNullElseGet(backupToken, () -> Bytes.random(20));
        this.companionIdentity = companionIdentity;
        this.senderKeys = Objects.requireNonNullElseGet(senderKeys, ConcurrentHashMap::new);
        this.appStateKeys = Objects.requireNonNullElseGet(appStateKeys, ArrayList::new);
        this.sessions = Objects.requireNonNullElseGet(sessions, ConcurrentHashMap::new);
        this.hashStates = Objects.requireNonNullElseGet(hashStates, ConcurrentHashMap::new);
        this.groupsPreKeys = Objects.requireNonNullElseGet(groupsPreKeys, ConcurrentHashMap::new);
        this.registered = registered;
        this.businessCertificate = businessCertificate;
        this.initialAppSync = initialAppSync;
        this.writeCounter = new AtomicLong();
        this.readCounter = new AtomicLong();
    }

    public static Keys newKeys(UUID uuid, Long phoneNumber, Collection<String> alias, ClientType clientType) {
        return new KeysBuilder().uuid(uuid).phoneNumber(PhoneNumber.ofNullable(phoneNumber).orElse(null)).alias(alias).clientType(clientType).noiseKeyPair(SignalKeyPair.random()).identityKeyPair(SignalKeyPair.random()).identityId(Bytes.random(16)).build();
    }

    public byte[] encodedRegistrationId() {
        return Bytes.intToBytes(this.registrationId(), 4);
    }

    public void clearReadWriteKey() {
        this.writeKey = null;
        this.writeCounter.set(0L);
        this.readCounter.set(0L);
    }

    public boolean hasPreKeys() {
        return !this.preKeys.isEmpty();
    }

    public SenderKeyRecord findSenderKeyByName(SenderKeyName name) {
        return Objects.requireNonNullElseGet(this.senderKeys.get(name), () -> {
            SenderKeyRecord record = new SenderKeyRecord();
            this.senderKeys.put(name, record);
            return record;
        });
    }

    public Optional<Session> findSessionByAddress(SessionAddress address) {
        return Optional.ofNullable((Session)this.sessions.get(address));
    }

    public Optional<SignalSignedKeyPair> findSignedKeyPairById(int id) {
        return id == this.signedKeyPair.id() ? Optional.of(this.signedKeyPair) : Optional.empty();
    }

    public Optional<SignalPreKeyPair> findPreKeyById(Integer id) {
        return id == null ? Optional.empty() : this.preKeys.stream().filter(preKey -> preKey.id() == id.intValue()).findFirst();
    }

    public Optional<AppStateSyncKey> findAppKeyById(Jid jid, byte[] id) {
        return this.appStateKeys.stream().filter(preKey -> Objects.equals(preKey.companion(), jid)).map(CompanionSyncKey::keys).flatMap(Collection::stream).filter(preKey -> preKey.keyId() != null && Arrays.equals(preKey.keyId().keyId(), id)).findFirst();
    }

    public Optional<CompanionHashState> findHashStateByName(Jid device, PatchType patchType) {
        return Optional.ofNullable((CompanionHashState)this.hashStates.get("%s_%s".formatted(new Object[]{device, patchType})));
    }

    public boolean hasTrust(SessionAddress address, byte[] identityKey) {
        return true;
    }

    public boolean hasSession(SessionAddress address) {
        return this.sessions.containsKey(address);
    }

    public Keys putSession(SessionAddress address, Session record) {
        this.sessions.put(address, record);
        return this;
    }

    public Keys putState(Jid device, CompanionHashState state) {
        this.hashStates.put("%s_%s".formatted(new Object[]{device, state.type()}), state);
        return this;
    }

    public Keys addAppKeys(Jid jid, Collection<AppStateSyncKey> keys) {
        this.appStateKeys.stream().filter(preKey -> Objects.equals(preKey.companion(), jid)).findFirst().ifPresentOrElse(key -> key.keys().addAll(keys), () -> {
            CompanionSyncKey syncKey = new CompanionSyncKey(jid, new LinkedList<AppStateSyncKey>(keys));
            this.appStateKeys.add(syncKey);
        });
        return this;
    }

    public AppStateSyncKey getLatestAppKey(Jid jid) {
        return this.getAppKeys(jid).getLast();
    }

    public LinkedList<AppStateSyncKey> getAppKeys(Jid jid) {
        return this.appStateKeys.stream().filter(preKey -> Objects.equals(preKey.companion(), jid)).findFirst().orElseThrow(() -> new NoSuchElementException("Missing keys")).keys();
    }

    public Keys addPreKey(SignalPreKeyPair preKey) {
        this.preKeys.add(preKey);
        return this;
    }

    public synchronized long nextWriteCounter(boolean increment) {
        return increment ? this.writeCounter.getAndIncrement() : this.writeCounter.get();
    }

    public synchronized long nextReadCounter(boolean increment) {
        return increment ? this.readCounter.getAndIncrement() : this.readCounter.get();
    }

    public int lastPreKeyId() {
        return this.preKeys.isEmpty() ? 0 : this.preKeys.getLast().id();
    }

    public Keys companionIdentity(SignedDeviceIdentity companionIdentity) {
        this.companionIdentity = companionIdentity;
        return this;
    }

    public Optional<SignedDeviceIdentity> companionIdentity() {
        return Optional.ofNullable(this.companionIdentity);
    }

    public Collection<SignalPreKeyPair> preKeys() {
        return Collections.unmodifiableList(this.preKeys);
    }

    public void addRecipientWithPreKeys(Jid group, Jid recipient) {
        SenderPreKeys preKeys = (SenderPreKeys)this.groupsPreKeys.get(group);
        if (preKeys != null) {
            preKeys.addPreKey(recipient);
            return;
        }
        SenderPreKeys newPreKeys = new SenderPreKeys();
        newPreKeys.addPreKey(recipient);
        this.groupsPreKeys.put(group, newPreKeys);
    }

    public void addRecipientsWithPreKeys(Jid group, Collection<Jid> recipients) {
        SenderPreKeys preKeys = (SenderPreKeys)this.groupsPreKeys.get(group);
        if (preKeys != null) {
            preKeys.addPreKeys(recipients);
            return;
        }
        SenderPreKeys newPreKeys = new SenderPreKeys();
        newPreKeys.addPreKeys(recipients);
        this.groupsPreKeys.put(group, newPreKeys);
    }

    public boolean hasGroupKeys(Jid group, Jid recipient) {
        SenderPreKeys preKeys = (SenderPreKeys)this.groupsPreKeys.get(group);
        return preKeys != null && preKeys.contains(recipient);
    }

    @Override
    public void dispose() {
        this.serialize(false);
    }

    @Override
    public void serialize(boolean async) {
        this.serializer.serializeKeys(this, async);
    }

    public int registrationId() {
        return this.registrationId;
    }

    public SignalKeyPair noiseKeyPair() {
        return this.noiseKeyPair;
    }

    public SignalKeyPair ephemeralKeyPair() {
        return this.ephemeralKeyPair;
    }

    public SignalKeyPair identityKeyPair() {
        return this.identityKeyPair;
    }

    public SignalSignedKeyPair signedKeyPair() {
        return this.signedKeyPair;
    }

    public Optional<byte[]> signedKeyIndex() {
        return Optional.ofNullable(this.signedKeyIndex);
    }

    public OptionalLong signedKeyIndexTimestamp() {
        return Clock.parseTimestamp(this.signedKeyIndexTimestamp);
    }

    public SignalKeyPair companionKeyPair() {
        return this.companionKeyPair;
    }

    public String fdid() {
        return this.fdid;
    }

    public byte[] deviceId() {
        return this.deviceId;
    }

    public UUID advertisingId() {
        return this.advertisingId;
    }

    public byte[] identityId() {
        return this.identityId;
    }

    public byte[] backupToken() {
        return this.backupToken;
    }

    public boolean registered() {
        return this.registered;
    }

    public boolean businessCertificate() {
        return this.businessCertificate;
    }

    public boolean initialAppSync() {
        return this.initialAppSync;
    }

    public AtomicLong writeCounter() {
        return this.writeCounter;
    }

    public AtomicLong readCounter() {
        return this.readCounter;
    }

    public Optional<byte[]> writeKey() {
        return Optional.ofNullable(this.writeKey);
    }

    public Optional<byte[]> readKey() {
        return Optional.ofNullable(this.readKey);
    }

    public void setSignedKeyPair(SignalSignedKeyPair signedKeyPair) {
        this.signedKeyPair = signedKeyPair;
    }

    public Keys setCompanionKeyPair(SignalKeyPair companionKeyPair) {
        this.companionKeyPair = companionKeyPair;
        return this;
    }

    public Keys setSignedKeyIndex(byte[] signedKeyIndex) {
        this.signedKeyIndex = signedKeyIndex;
        return this;
    }

    public Keys setSignedKeyIndexTimestamp(Long signedKeyIndexTimestamp) {
        this.signedKeyIndexTimestamp = signedKeyIndexTimestamp;
        return this;
    }

    public Keys setCompanionIdentity(SignedDeviceIdentity companionIdentity) {
        this.companionIdentity = companionIdentity;
        return this;
    }

    public Keys setRegistered(boolean registered) {
        this.registered = registered;
        return this;
    }

    public Keys setBusinessCertificate(boolean businessCertificate) {
        this.businessCertificate = businessCertificate;
        return this;
    }

    public Keys setInitialAppSync(boolean initialAppSync) {
        this.initialAppSync = initialAppSync;
        return this;
    }

    public Keys setWriteKey(byte[] writeKey) {
        this.writeKey = writeKey;
        return this;
    }

    public Keys setReadKey(byte[] readKey) {
        this.readKey = readKey;
        return this;
    }

    public String toString() {
        String cryptographicKeys = Stream.of(this.noiseKeyPair.publicKey(), this.noiseKeyPair.privateKey(), this.identityKeyPair.publicKey(), this.identityKeyPair.privateKey(), this.identityId()).map(Base64.getEncoder()::encodeToString).collect(Collectors.joining(","));
        return this.phoneNumber().map(phoneNumber -> String.valueOf(phoneNumber) + "," + cryptographicKeys).orElse(cryptographicKeys);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Keys)) return false;
        Keys keys = (Keys)o;
        if (this.registered != keys.registered) return false;
        if (this.businessCertificate != keys.businessCertificate) return false;
        if (this.initialAppSync != keys.initialAppSync) return false;
        if (!Objects.equals(this.registrationId, keys.registrationId)) return false;
        if (!Objects.equals(this.noiseKeyPair, keys.noiseKeyPair)) return false;
        if (!Objects.equals(this.ephemeralKeyPair, keys.ephemeralKeyPair)) return false;
        if (!Objects.equals(this.identityKeyPair, keys.identityKeyPair)) return false;
        if (!Objects.equals(this.companionKeyPair, keys.companionKeyPair)) return false;
        if (!Objects.equals(this.signedKeyPair, keys.signedKeyPair)) return false;
        if (!Objects.deepEquals(this.signedKeyIndex, keys.signedKeyIndex)) return false;
        if (!Objects.equals(this.signedKeyIndexTimestamp, keys.signedKeyIndexTimestamp)) return false;
        if (!Objects.equals(this.preKeys, keys.preKeys)) return false;
        if (!Objects.equals(this.fdid, keys.fdid)) return false;
        if (!Objects.deepEquals(this.deviceId, keys.deviceId)) return false;
        if (!Objects.equals(this.advertisingId, keys.advertisingId)) return false;
        if (!Objects.deepEquals(this.identityId, keys.identityId)) return false;
        if (!Objects.deepEquals(this.backupToken, keys.backupToken)) return false;
        if (!Objects.equals(this.companionIdentity, keys.companionIdentity)) return false;
        if (!Objects.equals(this.senderKeys, keys.senderKeys)) return false;
        if (!Objects.equals(this.appStateKeys, keys.appStateKeys)) return false;
        if (!Objects.equals(this.sessions, keys.sessions)) return false;
        if (!Objects.equals(this.hashStates, keys.hashStates)) return false;
        if (!Objects.equals(this.groupsPreKeys, keys.groupsPreKeys)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.registrationId, this.noiseKeyPair, this.ephemeralKeyPair, this.identityKeyPair, this.companionKeyPair, this.signedKeyPair, Arrays.hashCode(this.signedKeyIndex), this.signedKeyIndexTimestamp, this.preKeys, this.fdid, Arrays.hashCode(this.deviceId), this.advertisingId, Arrays.hashCode(this.identityId), Arrays.hashCode(this.backupToken), this.companionIdentity, this.senderKeys, this.appStateKeys, this.sessions, this.hashStates, this.groupsPreKeys, this.registered, this.businessCertificate, this.initialAppSync);
    }
}

