/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller.builtin;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.controller.Controller;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatBuilder;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.util.ImmutableLinkedList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class FileControllerSerializer
implements ControllerSerializer {
    private static final String CHAT_PREFIX = "chat_";
    private static final String NEWSLETTER_PREFIX = "newsletter_";
    private final Path baseDirectory;
    private int keysHashCode;
    private int storeHashCode;
    private final ConcurrentMap<Jid, Integer> jidsHashCodes;

    FileControllerSerializer(Path baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.keysHashCode = -1;
        this.storeHashCode = -1;
        this.jidsHashCodes = new ConcurrentHashMap<Jid, Integer>();
    }

    abstract String fileExtension();

    abstract void encodeKeys(Keys var1, Path var2);

    abstract void encodeStore(Store var1, Path var2);

    abstract void encodeChat(Chat var1, Path var2);

    abstract void encodeNewsletter(Newsletter var1, Path var2);

    abstract Keys decodeKeys(Path var1) throws IOException;

    abstract Store decodeStore(Path var1) throws IOException;

    abstract Chat decodeChat(Path var1) throws IOException;

    abstract Newsletter decodeNewsletter(Path var1) throws IOException;

    @Override
    public LinkedList<UUID> listIds(ClientType type) {
        LinkedList linkedList;
        block9: {
            Path directory = this.getHome(type);
            if (Files.notExists(directory, new LinkOption[0])) {
                return ImmutableLinkedList.empty();
            }
            Stream<Path> walker = Files.walk(directory, 1, new FileVisitOption[0]).sorted(Comparator.comparing(this::getLastModifiedTime));
            try {
                linkedList = walker.map(this::parsePathAsId).flatMap(Optional::stream).collect(Collectors.toCollection(LinkedList::new));
                if (walker == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return ImmutableLinkedList.empty();
                }
            }
            walker.close();
        }
        return linkedList;
    }

    @Override
    public LinkedList<PhoneNumber> listPhoneNumbers(ClientType type) {
        LinkedList linkedList;
        block9: {
            Path directory = this.getHome(type);
            if (Files.notExists(directory, new LinkOption[0])) {
                return ImmutableLinkedList.empty();
            }
            Stream<Path> walker = Files.walk(directory, 1, new FileVisitOption[0]).sorted(Comparator.comparing(this::getLastModifiedTime));
            try {
                linkedList = walker.map(this::parsePathAsPhoneNumber).flatMap(Optional::stream).collect(Collectors.toCollection(LinkedList::new));
                if (walker == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return ImmutableLinkedList.empty();
                }
            }
            walker.close();
        }
        return linkedList;
    }

    private FileTime getLastModifiedTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]);
        }
        catch (IOException exception) {
            return FileTime.fromMillis(0L);
        }
    }

    private Optional<UUID> parsePathAsId(Path file) {
        try {
            return Optional.of(UUID.fromString(file.getFileName().toString()));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    private Optional<PhoneNumber> parsePathAsPhoneNumber(Path file) {
        try {
            long longValue = Long.parseLong(file.getFileName().toString());
            return PhoneNumber.ofNullable(longValue);
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    @Override
    public CompletableFuture<Void> serializeKeys(Keys keys, boolean async) {
        int newHashCode = keys.hashCode();
        if (newHashCode == this.keysHashCode) {
            return CompletableFuture.completedFuture(null);
        }
        this.keysHashCode = newHashCode;
        String keysName = "keys" + this.fileExtension();
        Path outputFile = this.getSessionFile(keys.clientType(), keys.uuid().toString(), keysName);
        if (async) {
            return CompletableFuture.runAsync(() -> this.encodeKeys(keys, outputFile)).exceptionallyAsync(error -> this.onError(outputFile, (Throwable)error));
        }
        this.encodeKeys(keys, outputFile);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> serializeStore(Store store, boolean async) {
        int newHashCode = store.hashCode();
        if (newHashCode == this.storeHashCode) {
            return CompletableFuture.completedFuture(null);
        }
        this.storeHashCode = newHashCode;
        CompletableFuture<?>[] chatsFutures = this.serializeChatsAsync(store);
        CompletableFuture<?>[] newslettersFutures = this.serializeNewslettersAsync(store);
        CompletableFuture[] dependableFutures = (CompletableFuture[])Stream.of(chatsFutures, newslettersFutures).flatMap(Arrays::stream).toArray(CompletableFuture[]::new);
        CompletionStage result = CompletableFuture.allOf(dependableFutures).thenRunAsync(() -> {
            String storeName = "store" + this.fileExtension();
            Path storePath = this.getSessionFile(store, storeName);
            this.encodeStore(store, storePath);
        });
        if (async) {
            return result;
        }
        ((CompletableFuture)result).join();
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<?>[] serializeChatsAsync(Store store) {
        return (CompletableFuture[])store.chats().stream().map(chat -> this.serializeChatAsync(store, (Chat)chat)).toArray(CompletableFuture[]::new);
    }

    private CompletableFuture<Void> serializeChatAsync(Store store, Chat chat) {
        int newHashCode = chat.hashCode();
        if (newHashCode == this.jidsHashCodes.getOrDefault(chat.jid(), -1)) {
            return CompletableFuture.completedFuture(null);
        }
        this.jidsHashCodes.put(chat.jid(), newHashCode);
        String fileName = CHAT_PREFIX + chat.jid().user() + this.fileExtension();
        Path outputFile = this.getSessionFile(store, fileName);
        return CompletableFuture.runAsync(() -> this.encodeChat(chat, outputFile)).exceptionallyAsync(error -> this.onError(outputFile, (Throwable)error));
    }

    private Void onError(Path path, Throwable error) {
        System.Logger logger = System.getLogger("FileSerializer - " + String.valueOf(path));
        logger.log(System.Logger.Level.ERROR, error);
        return null;
    }

    private CompletableFuture<?>[] serializeNewslettersAsync(Store store) {
        return (CompletableFuture[])store.newsletters().stream().map(newsletter -> this.serializeNewsletterAsync(store, (Newsletter)newsletter)).toArray(CompletableFuture[]::new);
    }

    private CompletableFuture<Void> serializeNewsletterAsync(Store store, Newsletter newsletter) {
        int newHashCode = newsletter.hashCode();
        if (newHashCode == this.jidsHashCodes.getOrDefault(newsletter.jid(), -1)) {
            return CompletableFuture.completedFuture(null);
        }
        this.jidsHashCodes.put(newsletter.jid(), newHashCode);
        String fileName = NEWSLETTER_PREFIX + newsletter.jid().user() + this.fileExtension();
        Path outputFile = this.getSessionFile(store, fileName);
        return CompletableFuture.runAsync(() -> this.encodeNewsletter(newsletter, outputFile));
    }

    @Override
    public Optional<Keys> deserializeKeys(ClientType type, UUID id) {
        return this.deserializeKeysFromId(type, id.toString());
    }

    @Override
    public Optional<Keys> deserializeKeys(ClientType type, String alias) {
        Path file = this.getSessionDirectory(type, alias);
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeKeysFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Keys> deserializeKeys(ClientType type, long phoneNumber) {
        Path file = this.getSessionDirectory(type, String.valueOf(phoneNumber));
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeKeysFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    private Optional<Keys> deserializeKeysFromId(ClientType type, String id) {
        Path path = this.getSessionFile(type, id, "keys.proto");
        if (Files.notExists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            Keys keys = this.decodeKeys(path);
            this.keysHashCode = keys.hashCode();
            return Optional.of(keys);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Store> deserializeStore(ClientType type, UUID id) {
        return this.deserializeStoreFromId(type, id.toString());
    }

    @Override
    public Optional<Store> deserializeStore(ClientType type, String alias) {
        Path file = this.getSessionDirectory(type, alias);
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeStoreFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Store> deserializeStore(ClientType type, long phoneNumber) {
        Path file = this.getSessionDirectory(type, String.valueOf(phoneNumber));
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeStoreFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    private Optional<Store> deserializeStoreFromId(ClientType type, String id) {
        Path path = this.getSessionFile(type, id, "store.proto");
        if (Files.notExists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            Store store = this.decodeStore(path);
            this.storeHashCode = store.hashCode();
            return Optional.of(store);
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    @Override
    public CompletableFuture<Void> attributeStore(Store store) {
        CompletionStage completionStage;
        block9: {
            Path directory = this.getSessionDirectory(store.clientType(), store.uuid().toString());
            if (Files.notExists(directory, new LinkOption[0])) {
                return CompletableFuture.completedFuture(null);
            }
            Stream<Path> walker = Files.walk(directory, new FileVisitOption[0]);
            try {
                CompletableFuture[] futures = (CompletableFuture[])walker.map(entry -> this.handleStoreFile(store, (Path)entry)).filter(Objects::nonNull).toArray(CompletableFuture[]::new);
                completionStage = CompletableFuture.allOf(futures).thenRun(() -> this.attributeStoreContextualMessages(store));
                if (walker == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return CompletableFuture.failedFuture(exception);
                }
            }
            walker.close();
        }
        return completionStage;
    }

    private void attributeStoreContextualMessages(Store store) {
        store.chats().stream().flatMap(chat -> chat.messages().stream()).forEach(message -> this.attributeStoreContextualMessage(store, (HistorySyncMessage)message));
    }

    private void attributeStoreContextualMessage(Store store, HistorySyncMessage message) {
        message.messageInfo().message().contentWithContext().flatMap(ContextualMessage::contextInfo).ifPresent(contextInfo -> this.attributeStoreContextInfo(store, (ContextInfo)contextInfo));
    }

    private void attributeStoreContextInfo(Store store, ContextInfo contextInfo) {
        contextInfo.quotedMessageChatJid().flatMap(store::findChatByJid).ifPresent(contextInfo::setQuotedMessageChat);
        contextInfo.quotedMessageSenderJid().flatMap(store::findContactByJid).ifPresent(contextInfo::setQuotedMessageSender);
    }

    private CompletableFuture<Void> handleStoreFile(Store store, Path entry) {
        return switch (FileType.of(entry).ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> CompletableFuture.runAsync(() -> this.deserializeNewsletter(store, entry)).exceptionallyAsync(error -> this.onError(entry, (Throwable)error));
            case 1 -> CompletableFuture.runAsync(() -> this.deserializeChat(store, entry)).exceptionallyAsync(error -> this.onError(entry, (Throwable)error));
            case 0 -> null;
        };
    }

    @Override
    public void deleteSession(Controller<?> controller) {
        try {
            Path folderPath = this.getSessionDirectory(controller.clientType(), controller.uuid().toString());
            this.delete(folderPath);
            PhoneNumber phoneNumber = controller.phoneNumber().orElse(null);
            if (phoneNumber == null) {
                return;
            }
            Path linkedFolderPath = this.getSessionDirectory(controller.clientType(), phoneNumber.toString());
            Files.deleteIfExists(linkedFolderPath);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot delete session", exception);
        }
    }

    private void delete(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public void linkMetadata(Controller<?> controller) {
        controller.phoneNumber().ifPresent(phoneNumber -> this.linkToUuid(controller.clientType(), controller.uuid(), phoneNumber.toString()));
        controller.alias().forEach(alias -> this.linkToUuid(controller.clientType(), controller.uuid(), (String)alias));
    }

    private void linkToUuid(ClientType type, UUID uuid, String string) {
        try {
            Path link = this.getSessionDirectory(type, string);
            Files.writeString(link, (CharSequence)uuid.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deserializeChat(Store store, Path chatFile) {
        try {
            Chat chat = this.decodeChat(chatFile);
            this.jidsHashCodes.put(chat.jid(), chat.hashCode());
            for (HistorySyncMessage message : chat.messages()) {
                message.messageInfo().setChat(chat);
                store.findContactByJid(message.messageInfo().senderJid()).ifPresent(message.messageInfo()::setSender);
            }
            store.addChatDirect(chat);
        }
        catch (IOException exception) {
            store.addChatDirect(this.rescueChat(chatFile));
        }
    }

    private Chat rescueChat(Path entry) {
        try {
            Files.deleteIfExists(entry);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String chatName = entry.getFileName().toString().replaceFirst(CHAT_PREFIX, "").replace(this.fileExtension(), "");
        return new ChatBuilder().jid(Jid.of(chatName)).build();
    }

    private void deserializeNewsletter(Store store, Path newsletterFile) {
        try {
            Newsletter newsletter = this.decodeNewsletter(newsletterFile);
            this.jidsHashCodes.put(newsletter.jid(), newsletter.hashCode());
            for (NewsletterMessageInfo message : newsletter.messages()) {
                message.setNewsletter(newsletter);
            }
            store.addNewsletter(newsletter);
        }
        catch (IOException exception) {
            store.addNewsletter(this.rescueNewsletter(newsletterFile));
        }
    }

    private Newsletter rescueNewsletter(Path entry) {
        try {
            Files.deleteIfExists(entry);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String newsletterName = entry.getFileName().toString().replaceFirst(CHAT_PREFIX, "").replace(this.fileExtension(), "");
        return new Newsletter(Jid.of(newsletterName), null, null, null);
    }

    private Path getHome(ClientType type) {
        return this.baseDirectory.resolve(type == ClientType.MOBILE ? "mobile" : "web");
    }

    private Path getSessionDirectory(ClientType clientType, String path) {
        try {
            Path result = this.getHome(clientType).resolve(path);
            Files.createDirectories(result.getParent(), new FileAttribute[0]);
            return result;
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    private Path getSessionFile(Store store, String fileName) {
        try {
            Path result = this.getSessionFile(store.clientType(), store.uuid().toString(), fileName);
            Files.createDirectories(result.getParent(), new FileAttribute[0]);
            return result;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot create directory", exception);
        }
    }

    private Path getSessionFile(ClientType clientType, String uuid, String fileName) {
        try {
            Path result = this.getSessionDirectory(clientType, uuid).resolve(fileName);
            Files.createDirectories(result.getParent(), new FileAttribute[0]);
            return result;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot create directory", exception);
        }
    }

    private static enum FileType {
        UNKNOWN(null),
        CHAT("chat_"),
        NEWSLETTER("newsletter_");

        private final String prefix;

        private FileType(String prefix) {
            this.prefix = prefix;
        }

        private static FileType of(Path path) {
            return Arrays.stream(FileType.values()).filter(entry -> entry.prefix() != null && path.getFileName().toString().startsWith(entry.prefix())).findFirst().orElse(UNKNOWN);
        }

        private String prefix() {
            return this.prefix;
        }
    }
}

