/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller.builtin;

import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.controller.builtin.FileControllerSerializer;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.util.Json;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class JsonControllerSerializer
extends FileControllerSerializer {
    private static final Path DEFAULT_SERIALIZER_PATH = Path.of(System.getProperty("user.home") + "/.cobalt/", new String[0]);

    public JsonControllerSerializer() {
        this(DEFAULT_SERIALIZER_PATH);
    }

    public JsonControllerSerializer(Path baseDirectory) {
        super(baseDirectory);
    }

    @Override
    String fileExtension() {
        return ".json";
    }

    @Override
    void encodeKeys(Keys keys, Path path) {
        try {
            Json.writeValueAsBytes(keys, Files.newOutputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    void encodeStore(Store store, Path path) {
        try {
            Json.writeValueAsBytes(store, Files.newOutputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    void encodeChat(Chat chat, Path path) {
        try {
            Json.writeValueAsBytes(chat, Files.newOutputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    void encodeNewsletter(Newsletter newsletter, Path path) {
        try {
            Json.writeValueAsBytes(newsletter, Files.newOutputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    Keys decodeKeys(Path keys) throws IOException {
        return Json.readValue(Channels.newInputStream(FileChannel.open(keys, new OpenOption[0])), Keys.class);
    }

    @Override
    Store decodeStore(Path store) throws IOException {
        return Json.readValue(Channels.newInputStream(FileChannel.open(store, new OpenOption[0])), Store.class);
    }

    @Override
    Chat decodeChat(Path chat) throws IOException {
        return Json.readValue(Channels.newInputStream(FileChannel.open(chat, new OpenOption[0])), Chat.class);
    }

    @Override
    Newsletter decodeNewsletter(Path newsletter) throws IOException {
        return Json.readValue(Channels.newInputStream(FileChannel.open(newsletter, new OpenOption[0])), Newsletter.class);
    }
}

