/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller.builtin;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.KeysSpec;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.controller.StoreSpec;
import it.auties.whatsapp.controller.builtin.FileControllerSerializer;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatSpec;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.newsletter.NewsletterSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class ProtobufControllerSerializer
extends FileControllerSerializer {
    private static final Path DEFAULT_SERIALIZER_PATH = Path.of(System.getProperty("user.home") + "/.cobalt/", new String[0]);

    public ProtobufControllerSerializer() {
        this(DEFAULT_SERIALIZER_PATH);
    }

    public ProtobufControllerSerializer(Path baseDirectory) {
        super(baseDirectory);
    }

    @Override
    String fileExtension() {
        return ".proto";
    }

    @Override
    void encodeKeys(Keys keys, Path path) {
        try {
            Path tempFile = Files.createTempFile(path.getFileName().toString(), ".tmp", new FileAttribute[0]);
            try (OutputStream stream = Files.newOutputStream(tempFile, new OpenOption[0]);){
                KeysSpec.encode(keys, ProtobufOutputStream.toStream((OutputStream)stream));
                stream.flush();
            }
            Files.move(tempFile, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    @Override
    void encodeStore(Store store, Path path) {
        try {
            Path tempFile = Files.createTempFile(path.getFileName().toString(), ".tmp", new FileAttribute[0]);
            try (OutputStream stream = Files.newOutputStream(tempFile, new OpenOption[0]);){
                StoreSpec.encode(store, ProtobufOutputStream.toStream((OutputStream)stream));
                stream.flush();
            }
            Files.move(tempFile, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    @Override
    void encodeChat(Chat chat, Path path) {
        try {
            Path tempFile = Files.createTempFile(path.getFileName().toString(), ".tmp", new FileAttribute[0]);
            try (OutputStream stream = Files.newOutputStream(tempFile, new OpenOption[0]);){
                ChatSpec.encode(chat, ProtobufOutputStream.toStream((OutputStream)stream));
                stream.flush();
            }
            Files.move(tempFile, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    @Override
    void encodeNewsletter(Newsletter newsletter, Path path) {
        try {
            Path tempFile = Files.createTempFile(path.getFileName().toString(), ".tmp", new FileAttribute[0]);
            try (OutputStream stream = Files.newOutputStream(tempFile, new OpenOption[0]);){
                NewsletterSpec.encode(newsletter, ProtobufOutputStream.toStream((OutputStream)stream));
                stream.flush();
            }
            Files.move(tempFile, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    @Override
    Keys decodeKeys(Path keys) throws IOException {
        try (InputStream stream = Files.newInputStream(keys, new OpenOption[0]);){
            Keys keys2 = KeysSpec.decode(ProtobufInputStream.fromStream((InputStream)stream));
            return keys2;
        }
    }

    @Override
    Store decodeStore(Path store) throws IOException {
        try (InputStream stream = Files.newInputStream(store, new OpenOption[0]);){
            Store store2 = StoreSpec.decode(ProtobufInputStream.fromStream((InputStream)stream));
            return store2;
        }
    }

    @Override
    Chat decodeChat(Path chat) throws IOException {
        try (InputStream stream = Files.newInputStream(chat, new OpenOption[0]);){
            Chat chat2 = ChatSpec.decode(ProtobufInputStream.fromStream((InputStream)stream));
            return chat2;
        }
    }

    @Override
    Newsletter decodeNewsletter(Path newsletter) throws IOException {
        try (InputStream stream = Files.newInputStream(newsletter, new OpenOption[0]);){
            Newsletter newsletter2 = NewsletterSpec.decode(ProtobufInputStream.fromStream((InputStream)stream));
            return newsletter2;
        }
    }
}

