/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import it.auties.whatsapp.util.Bytes;
import it.auties.whatsapp.util.Validate;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesCbc {
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    private static final String AES = "AES";
    private static final int AES_BLOCK_SIZE = 16;

    public static byte[] encryptAndPrefix(byte[] plaintext, byte[] key) {
        byte[] iv = Bytes.random(16);
        byte[] encrypted = AesCbc.encrypt(iv, plaintext, key);
        return Bytes.concat(iv, encrypted);
    }

    public static byte[] encrypt(byte[] iv, byte[] plaintext, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC);
            SecretKeySpec keySpec = new SecretKeySpec(key, AES);
            cipher.init(1, (Key)keySpec, new IvParameterSpec(iv));
            return cipher.doFinal(plaintext);
        }
        catch (GeneralSecurityException exception) {
            throw new IllegalArgumentException("Cannot encrypt data", exception);
        }
    }

    public static byte[] decrypt(byte[] encrypted, byte[] key) {
        byte[] iv = Arrays.copyOfRange(encrypted, 0, 16);
        byte[] encryptedNoIv = Arrays.copyOfRange(encrypted, iv.length, encrypted.length);
        return AesCbc.decrypt(iv, encryptedNoIv, key);
    }

    public static byte[] decrypt(byte[] iv, byte[] encrypted, byte[] key) {
        try {
            Validate.isTrue(iv.length == 16, "Invalid iv size: expected %s, got %s", 16, iv.length);
            Validate.isTrue(encrypted.length % 16 == 0, "Invalid encrypted size", new Object[0]);
            Cipher cipher = Cipher.getInstance(AES_CBC);
            SecretKeySpec keySpec = new SecretKeySpec(key, AES);
            cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
            return cipher.doFinal(encrypted);
        }
        catch (GeneralSecurityException exception) {
            throw new IllegalArgumentException("Cannot encrypt data", exception);
        }
    }
}

