/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesGcm {
    private static final int TAG_LENGTH = 128;

    private static byte[] cipher(byte[] iv, byte[] input, int offset, int length, byte[] key, byte[] additionalData, boolean encrypt) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(encrypt ? 1 : 2, (Key)keySpec, gcmSpec);
            if (additionalData != null) {
                cipher.updateAAD(additionalData);
            }
            int outputLength = cipher.getOutputSize(length);
            byte[] output = new byte[outputLength];
            int outputOffset = cipher.update(input, offset, length, output, 0);
            cipher.doFinal(output, outputOffset);
            return output;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Cannot %s data".formatted(encrypt ? "encrypt" : "decrypt"), throwable);
        }
    }

    private static byte[] toIv(long iv) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.write(new byte[4]);
            dataOutputStream.writeLong(iv);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }
        dataOutputStream.close();
        return byArray;
    }

    public static byte[] encrypt(long iv, byte[] input, byte[] key) {
        return AesGcm.encrypt(iv, input, key, null);
    }

    public static byte[] encrypt(long iv, byte[] input, byte[] key, byte[] additionalData) {
        return AesGcm.cipher(AesGcm.toIv(iv), input, 0, input.length, key, additionalData, true);
    }

    public static byte[] encrypt(byte[] iv, byte[] input, byte[] key, byte[] additionalData) {
        return AesGcm.cipher(iv, input, 0, input.length, key, additionalData, true);
    }

    public static byte[] encrypt(byte[] iv, byte[] input, byte[] key) {
        return AesGcm.cipher(iv, input, 0, input.length, key, null, true);
    }

    public static byte[] decrypt(long iv, byte[] input, byte[] key) {
        return AesGcm.decrypt(iv, input, 0, input.length, key);
    }

    public static byte[] decrypt(long iv, byte[] input, int offset, int length, byte[] key) {
        return AesGcm.decrypt(iv, input, offset, length, key, null);
    }

    public static byte[] decrypt(long iv, byte[] input, byte[] key, byte[] additionalData) {
        return AesGcm.decrypt(iv, input, 0, input.length, key, additionalData);
    }

    public static byte[] decrypt(long iv, byte[] input, int offset, int length, byte[] key, byte[] additionalData) {
        return AesGcm.cipher(AesGcm.toIv(iv), input, offset, length, key, additionalData, false);
    }

    public static byte[] decrypt(byte[] iv, byte[] input, byte[] key, byte[] additionalData) {
        return AesGcm.decrypt(iv, input, 0, input.length, key, additionalData);
    }

    public static byte[] decrypt(byte[] iv, byte[] input, int offset, int length, byte[] key, byte[] additionalData) {
        return AesGcm.cipher(iv, input, offset, length, key, additionalData, false);
    }
}

