/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.model.signal.keypair.ISignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair;
import it.auties.whatsapp.model.signal.message.SignalPreKeyMessage;
import it.auties.whatsapp.model.signal.session.Session;
import it.auties.whatsapp.model.signal.session.SessionAddress;
import it.auties.whatsapp.model.signal.session.SessionChain;
import it.auties.whatsapp.model.signal.session.SessionPreKey;
import it.auties.whatsapp.model.signal.session.SessionState;
import it.auties.whatsapp.util.Bytes;
import it.auties.whatsapp.util.Validate;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public record SessionBuilder(SessionAddress address, Keys keys) {
    public void createOutgoing(int id, byte[] identityKey, SignalSignedKeyPair signedPreKey, SignalSignedKeyPair preKey) {
        Validate.isTrue(this.keys.hasTrust(this.address, identityKey), "Untrusted key", SecurityException.class, new Object[0]);
        Validate.isTrue(Curve25519.verifySignature((byte[])ISignalKeyPair.toCurveKey(identityKey), (byte[])signedPreKey.keyPair().signalPublicKey(), (byte[])signedPreKey.signature()), "Signature mismatch", SecurityException.class, new Object[0]);
        SignalKeyPair baseKey = SignalKeyPair.random();
        SessionState state = this.createState(true, baseKey, null, identityKey, preKey == null ? null : preKey.keyPair().signalPublicKey(), signedPreKey.keyPair().signalPublicKey(), id, 3);
        SessionPreKey pendingPreKey = new SessionPreKey(preKey == null ? null : Integer.valueOf(preKey.id()), baseKey.signalPublicKey(), signedPreKey.id());
        state.pendingPreKey(pendingPreKey);
        this.keys.findSessionByAddress(this.address).map(Session::closeCurrentState).orElseGet(this::createSession).addState(state);
    }

    public SessionState createState(boolean isInitiator, SignalKeyPair ourEphemeralKey, SignalKeyPair ourSignedKey, byte[] theirIdentityPubKey, byte[] theirEphemeralPubKey, byte[] theirSignedPubKey, int registrationId, int version) {
        if (isInitiator) {
            Validate.isTrue(ourSignedKey == null, "Our signed key should be null", new Object[0]);
            ourSignedKey = ourEphemeralKey;
        } else {
            Validate.isTrue(theirSignedPubKey == null, "Their signed public key should be null", new Object[0]);
            theirSignedPubKey = theirEphemeralPubKey;
        }
        byte[] signedSecret = Curve25519.sharedKey((byte[])ISignalKeyPair.toCurveKey(theirSignedPubKey), (byte[])this.keys.identityKeyPair().privateKey());
        byte[] identitySecret = Curve25519.sharedKey((byte[])ISignalKeyPair.toCurveKey(theirIdentityPubKey), (byte[])ourSignedKey.privateKey());
        byte[] signedIdentitySecret = Curve25519.sharedKey((byte[])ISignalKeyPair.toCurveKey(theirSignedPubKey), (byte[])ourSignedKey.privateKey());
        byte[] ephemeralSecret = theirEphemeralPubKey == null || ourEphemeralKey == null ? null : Curve25519.sharedKey((byte[])ISignalKeyPair.toCurveKey(theirEphemeralPubKey), (byte[])ourEphemeralKey.privateKey());
        byte[] sharedSecret = this.createStateSecret(isInitiator, signedSecret, identitySecret, signedIdentitySecret, ephemeralSecret);
        byte[][] masterKey = Hkdf.deriveSecrets(sharedSecret, "WhisperText".getBytes(StandardCharsets.UTF_8));
        SessionState state = this.createState(isInitiator, ourEphemeralKey, ourSignedKey, theirIdentityPubKey, theirEphemeralPubKey, theirSignedPubKey, registrationId, version, masterKey);
        return isInitiator ? this.calculateSendingRatchet(state, theirSignedPubKey) : state;
    }

    private Session createSession() {
        Session session = new Session();
        this.keys.putSession(this.address, session);
        return session;
    }

    private byte[] createStateSecret(boolean isInitiator, byte[] signedSecret, byte[] identitySecret, byte[] signedIdentitySecret, byte[] ephemeralSecret) {
        byte[] header = new byte[32];
        Arrays.fill(header, (byte)-1);
        return Bytes.concat(header, isInitiator ? signedSecret : identitySecret, isInitiator ? identitySecret : signedSecret, signedIdentitySecret, ephemeralSecret);
    }

    private SessionState createState(boolean isInitiator, SignalKeyPair ourEphemeralKey, SignalKeyPair ourSignedKey, byte[] theirIdentityPubKey, byte[] theirEphemeralPubKey, byte[] theirSignedPubKey, int registrationId, int version, byte[][] masterKey) {
        return new SessionState(version, registrationId, isInitiator ? ourEphemeralKey.signalPublicKey() : theirEphemeralPubKey, theirIdentityPubKey, new ConcurrentHashMap<String, SessionChain>(), masterKey[0], null, isInitiator ? SignalKeyPair.random() : ourSignedKey, Objects.requireNonNull(theirSignedPubKey), 0, false);
    }

    private SessionState calculateSendingRatchet(SessionState state, byte[] theirSignedPubKey) {
        byte[] initSecret = Curve25519.sharedKey((byte[])ISignalKeyPair.toCurveKey(theirSignedPubKey), (byte[])state.ephemeralKeyPair().privateKey());
        byte[][] initKey = Hkdf.deriveSecrets(initSecret, state.rootKey(), "WhisperRatchet".getBytes(StandardCharsets.UTF_8));
        byte[] key = state.ephemeralKeyPair().signalPublicKey();
        SessionChain chain = new SessionChain(-1, initKey[1]);
        return state.addChain(key, chain).rootKey(initKey[0]);
    }

    public void createIncoming(Session session, SignalPreKeyMessage message) {
        Validate.isTrue(this.keys.hasTrust(this.address, message.identityKey()), "Untrusted key", SecurityException.class, new Object[0]);
        if (session.hasState(message.version(), message.baseKey())) {
            return;
        }
        SignalPreKeyPair preKeyPair = this.keys.findPreKeyById(message.preKeyId()).orElse(null);
        SignalSignedKeyPair signedKeyPair = this.keys.findSignedKeyPairById(message.signedPreKeyId()).orElseThrow(() -> new NoSuchElementException("Cannot find signed key with id %s".formatted(message.signedPreKeyId())));
        session.closeCurrentState();
        SessionState nextState = this.createState(false, preKeyPair != null ? preKeyPair.toGenericKeyPair() : null, signedKeyPair.toGenericKeyPair(), message.identityKey(), message.baseKey(), null, message.registrationId(), message.version());
        session.addState(nextState);
    }
}

