/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.implementation;

import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.WebHistorySetting;
import it.auties.whatsapp.implementation.SocketHandler;
import it.auties.whatsapp.implementation.SocketHandshake;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.mobile.CountryLocale;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.signal.auth.ClientFinish;
import it.auties.whatsapp.model.signal.auth.ClientPayload;
import it.auties.whatsapp.model.signal.auth.ClientPayloadBuilder;
import it.auties.whatsapp.model.signal.auth.ClientPayloadSpec;
import it.auties.whatsapp.model.signal.auth.CompanionProperties;
import it.auties.whatsapp.model.signal.auth.CompanionPropertiesBuilder;
import it.auties.whatsapp.model.signal.auth.CompanionPropertiesSpec;
import it.auties.whatsapp.model.signal.auth.CompanionRegistrationData;
import it.auties.whatsapp.model.signal.auth.CompanionRegistrationDataBuilder;
import it.auties.whatsapp.model.signal.auth.DNSSource;
import it.auties.whatsapp.model.signal.auth.DNSSourceBuilder;
import it.auties.whatsapp.model.signal.auth.HandshakeMessage;
import it.auties.whatsapp.model.signal.auth.HandshakeMessageBuilder;
import it.auties.whatsapp.model.signal.auth.HandshakeMessageSpec;
import it.auties.whatsapp.model.signal.auth.ServerHello;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.UserAgentBuilder;
import it.auties.whatsapp.model.signal.auth.WebInfo;
import it.auties.whatsapp.model.signal.auth.WebInfoBuilder;
import it.auties.whatsapp.model.sync.HistorySyncConfig;
import it.auties.whatsapp.model.sync.HistorySyncConfigBuilder;
import it.auties.whatsapp.util.Bytes;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

class AuthHandler {
    private final SocketHandler socketHandler;

    AuthHandler(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
    }

    protected CompletableFuture<Void> login(byte[] message) {
        try {
            HandshakeMessage serverHandshake = HandshakeMessageSpec.decode(message);
            ServerHello serverHello = serverHandshake.serverHello();
            SocketHandshake handshake = new SocketHandshake(this.socketHandler.keys(), SocketHandshake.getPrologue(this.socketHandler.store().clientType()));
            handshake.updateHash(this.socketHandler.keys().ephemeralKeyPair().publicKey());
            handshake.updateHash(serverHello.ephemeral());
            byte[] sharedEphemeral = Curve25519.sharedKey((byte[])serverHello.ephemeral(), (byte[])this.socketHandler.keys().ephemeralKeyPair().privateKey());
            handshake.mixIntoKey(sharedEphemeral);
            byte[] decodedStaticText = handshake.cipher(serverHello.staticText(), false);
            byte[] sharedStatic = Curve25519.sharedKey((byte[])decodedStaticText, (byte[])this.socketHandler.keys().ephemeralKeyPair().privateKey());
            handshake.mixIntoKey(sharedStatic);
            handshake.cipher(serverHello.payload(), false);
            byte[] encodedKey = handshake.cipher(this.socketHandler.keys().noiseKeyPair().publicKey(), true);
            byte[] sharedPrivate = Curve25519.sharedKey((byte[])serverHello.ephemeral(), (byte[])this.socketHandler.keys().noiseKeyPair().privateKey());
            handshake.mixIntoKey(sharedPrivate);
            ClientPayload payload = this.createUserClientPayload();
            byte[] encodedPayload = handshake.cipher(ClientPayloadSpec.encode(payload), true);
            ClientFinish clientFinish = new ClientFinish(encodedKey, encodedPayload);
            HandshakeMessage clientHandshake = new HandshakeMessageBuilder().clientFinish(clientFinish).build();
            return this.socketHandler.sendBinaryWithNoResponse(HandshakeMessageSpec.encode(clientHandshake), false).thenRunAsync(() -> {
                this.socketHandler.keys().clearReadWriteKey();
                handshake.finish();
            });
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    private WebInfo createWebInfo() {
        return new WebInfoBuilder().webSubPlatform(WebInfo.Platform.WEB_BROWSER).build();
    }

    private UserAgent createUserAgent() {
        boolean mobile = this.socketHandler.store().clientType() == ClientType.MOBILE;
        return new UserAgentBuilder().platform(this.socketHandler.store().device().platform()).appVersion(this.socketHandler.store().version()).mcc("000").mnc("000").osVersion(mobile ? this.socketHandler.store().device().osVersion().toString() : null).manufacturer(mobile ? this.socketHandler.store().device().manufacturer() : null).device(mobile ? this.socketHandler.store().device().model().replaceAll("_", " ") : null).osBuildNumber(mobile ? this.socketHandler.store().device().osBuildNumber() : null).phoneId(mobile ? this.socketHandler.keys().fdid().toUpperCase() : null).releaseChannel(this.socketHandler.store().releaseChannel()).localeLanguageIso6391(this.socketHandler.store().locale().map(CountryLocale::languageValue).orElse("en")).localeCountryIso31661Alpha2(this.socketHandler.store().locale().map(CountryLocale::languageCode).orElse("US")).deviceType(UserAgent.DeviceType.PHONE).deviceModelType(this.socketHandler.store().device().modelId()).build();
    }

    private ClientPayload createUserClientPayload() {
        UserAgent agent = this.createUserAgent();
        return switch (this.socketHandler.store().clientType()) {
            default -> throw new MatchException(null, null);
            case ClientType.MOBILE -> {
                Long phoneNumber = this.socketHandler.store().phoneNumber().map(PhoneNumber::number).orElseThrow(() -> new NoSuchElementException("Missing phone number for mobile registration"));
                yield new ClientPayloadBuilder().username(phoneNumber).passive(false).pushName(this.socketHandler.keys().initialAppSync() ? this.socketHandler.store().name() : null).userAgent(agent).shortConnect(true).connectType(ClientPayload.ClientPayloadConnectType.WIFI_UNKNOWN).connectReason(ClientPayload.ClientPayloadConnectReason.USER_ACTIVATED).connectAttemptCount(0).device(0).oc(false).build();
            }
            case ClientType.WEB -> {
                Optional<Jid> jid = this.socketHandler.store().jid();
                if (jid.isPresent()) {
                    yield new ClientPayloadBuilder().connectReason(ClientPayload.ClientPayloadConnectReason.USER_ACTIVATED).connectType(ClientPayload.ClientPayloadConnectType.WIFI_UNKNOWN).userAgent(agent).webInfo(this.createWebInfo()).username(Long.parseLong(jid.get().user())).passive(true).pull(true).device(jid.get().device()).build();
                }
                yield new ClientPayloadBuilder().connectReason(ClientPayload.ClientPayloadConnectReason.USER_ACTIVATED).connectType(ClientPayload.ClientPayloadConnectType.WIFI_UNKNOWN).userAgent(agent).webInfo(this.createWebInfo()).regData(this.createRegisterData()).passive(false).pull(false).build();
            }
        };
    }

    private DNSSource getDnsSource() {
        return new DNSSourceBuilder().dnsMethod(DNSSource.ResolutionMethod.SYSTEM).appCached(false).build();
    }

    private CompanionRegistrationData createRegisterData() {
        CompanionRegistrationDataBuilder companion = new CompanionRegistrationDataBuilder().buildHash(this.socketHandler.store().version().toHash()).eRegid(this.socketHandler.keys().encodedRegistrationId()).eKeytype(Bytes.intToBytes(5, 1)).eIdent(this.socketHandler.keys().identityKeyPair().publicKey()).eSkeyId(this.socketHandler.keys().signedKeyPair().encodedId()).eSkeyVal(this.socketHandler.keys().signedKeyPair().keyPair().publicKey()).eSkeySig(this.socketHandler.keys().signedKeyPair().signature());
        if (this.socketHandler.store().clientType() == ClientType.WEB) {
            CompanionProperties props = this.createCompanionProps();
            byte[] encodedProps = props == null ? null : CompanionPropertiesSpec.encode(props);
            companion.companionProps(encodedProps);
        }
        return companion.build();
    }

    private CompanionProperties createCompanionProps() {
        return switch (this.socketHandler.store().clientType()) {
            default -> throw new MatchException(null, null);
            case ClientType.WEB -> {
                WebHistorySetting historyLength = this.socketHandler.store().webHistorySetting();
                HistorySyncConfig config = new HistorySyncConfigBuilder().inlineInitialPayloadInE2EeMsg(true).supportBotUserAgentChatHistory(true).supportCallLogHistory(true).storageQuotaMb(historyLength.size()).fullSyncSizeMbLimit(historyLength.size()).build();
                if (this.socketHandler.store().webHistorySetting().isExtended() && !this.socketHandler.store().device().platform().isDesktop()) {
                    this.socketHandler.store().setDevice(this.socketHandler.store().device().withPlatform(UserAgent.PlatformType.WINDOWS));
                }
                CompanionProperties.PlatformType v0 = switch (this.socketHandler.store().device().platform()) {
                    default -> throw new MatchException(null, null);
                    case UserAgent.PlatformType.UNKNOWN, UserAgent.PlatformType.KAIOS -> CompanionProperties.PlatformType.UNKNOWN;
                    case UserAgent.PlatformType.IOS, UserAgent.PlatformType.IOS_BUSINESS -> CompanionProperties.PlatformType.IOS_PHONE;
                    case UserAgent.PlatformType.ANDROID, UserAgent.PlatformType.ANDROID_BUSINESS -> CompanionProperties.PlatformType.ANDROID_PHONE;
                    case UserAgent.PlatformType.WINDOWS -> CompanionProperties.PlatformType.UWP;
                    case UserAgent.PlatformType.MACOS -> CompanionProperties.PlatformType.CATALINA;
                    case UserAgent.PlatformType.WEB -> CompanionProperties.PlatformType.CHROME;
                };
                CompanionProperties.PlatformType platformType = v0;
                yield new CompanionPropertiesBuilder().os(this.socketHandler.store().name()).platformType(platformType).requireFullSync(historyLength.isExtended()).historySyncConfig(config).build();
            }
            case ClientType.MOBILE -> null;
        };
    }
}

