/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.implementation;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.DisconnectReason;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.SocketEvent;
import it.auties.whatsapp.api.WebVerificationHandler;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.controller.StoreKeysPair;
import it.auties.whatsapp.crypto.AesGcm;
import it.auties.whatsapp.implementation.AppStateHandler;
import it.auties.whatsapp.implementation.AuthHandler;
import it.auties.whatsapp.implementation.MessageHandler;
import it.auties.whatsapp.implementation.SocketHandshake;
import it.auties.whatsapp.implementation.SocketListener;
import it.auties.whatsapp.implementation.SocketRequest;
import it.auties.whatsapp.implementation.SocketSession;
import it.auties.whatsapp.implementation.SocketState;
import it.auties.whatsapp.implementation.StreamHandler;
import it.auties.whatsapp.io.BinaryDecoder;
import it.auties.whatsapp.io.BinaryEncoder;
import it.auties.whatsapp.listener.Listener;
import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.call.Call;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatMetadata;
import it.auties.whatsapp.model.chat.ChatParticipant;
import it.auties.whatsapp.model.chat.ChatPastParticipant;
import it.auties.whatsapp.model.chat.ChatSettingPolicy;
import it.auties.whatsapp.model.chat.CommunityLinkedGroup;
import it.auties.whatsapp.model.chat.CommunityParticipant;
import it.auties.whatsapp.model.chat.CommunitySetting;
import it.auties.whatsapp.model.chat.GroupParticipant;
import it.auties.whatsapp.model.chat.GroupRole;
import it.auties.whatsapp.model.chat.GroupSetting;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ChatMessageInfoBuilder;
import it.auties.whatsapp.model.info.MessageIndexInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.info.QuotedMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeyBuilder;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.message.server.ProtocolMessage;
import it.auties.whatsapp.model.mobile.CountryLocale;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.node.Attributes;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.request.CommunityLinkedGroupsRequest;
import it.auties.whatsapp.model.request.MessageSendRequest;
import it.auties.whatsapp.model.response.CommunityLinkedGroupsResponse;
import it.auties.whatsapp.model.response.ContactAboutResponse;
import it.auties.whatsapp.model.setting.Setting;
import it.auties.whatsapp.model.signal.auth.ClientHello;
import it.auties.whatsapp.model.signal.auth.ClientHelloBuilder;
import it.auties.whatsapp.model.signal.auth.HandshakeMessage;
import it.auties.whatsapp.model.signal.auth.HandshakeMessageBuilder;
import it.auties.whatsapp.model.signal.auth.HandshakeMessageSpec;
import it.auties.whatsapp.model.sync.PatchRequest;
import it.auties.whatsapp.model.sync.PatchType;
import it.auties.whatsapp.model.sync.PrimaryFeature;
import it.auties.whatsapp.util.Bytes;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Json;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.SocketException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;

public class SocketHandler
implements SocketListener {
    private static final Set<UUID> connectedUuids = ConcurrentHashMap.newKeySet();
    private static final Set<Long> connectedPhoneNumbers = ConcurrentHashMap.newKeySet();
    private static final Set<String> connectedAlias = ConcurrentHashMap.newKeySet();
    private static final int PING_TIMEOUT = 20;
    private SocketSession session;
    private final Whatsapp whatsapp;
    private final AuthHandler authHandler;
    private final StreamHandler streamHandler;
    private final MessageHandler messageHandler;
    private final AppStateHandler appStateHandler;
    private final ErrorHandler errorHandler;
    private final AtomicLong requestsCounter;
    private final ScheduledExecutorService scheduler;
    private final List<ScheduledFuture<?>> scheduledTasks;
    private final ConcurrentMap<Jid, List<ChatPastParticipant>> pastParticipants;
    private final Semaphore writeSemaphore;
    private volatile SocketState state;
    private volatile CompletableFuture<Void> loginFuture;
    private volatile boolean pinging;
    private Keys keys;
    private Store store;
    private Thread shutdownHook;

    public static boolean isConnected(UUID uuid) {
        return connectedUuids.contains(uuid);
    }

    public static boolean isConnected(long phoneNumber) {
        return connectedPhoneNumbers.contains(phoneNumber);
    }

    public static boolean isConnected(String id) {
        return connectedAlias.contains(id);
    }

    public SocketHandler(Whatsapp whatsapp, Store store, Keys keys, ErrorHandler errorHandler, WebVerificationHandler webVerificationHandler) {
        this.whatsapp = whatsapp;
        this.store = store;
        this.keys = keys;
        this.state = SocketState.WAITING;
        this.authHandler = new AuthHandler(this);
        this.streamHandler = new StreamHandler(this, webVerificationHandler);
        this.messageHandler = new MessageHandler(this);
        this.appStateHandler = new AppStateHandler(this);
        this.errorHandler = Objects.requireNonNullElse(errorHandler, ErrorHandler.toTerminal());
        this.requestsCounter = new AtomicLong();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(Thread.ofVirtual().factory());
        this.scheduledTasks = new CopyOnWriteArrayList();
        this.writeSemaphore = new Semaphore(1, true);
        this.pastParticipants = new ConcurrentHashMap<Jid, List<ChatPastParticipant>>();
    }

    private void onShutdown(boolean reconnect) {
        if (this.state != SocketState.LOGGED_OUT && this.state != SocketState.RESTORE && this.state != SocketState.BANNED) {
            this.keys.dispose();
            this.store.dispose();
        }
        this.killScheduledTasks();
        if (!reconnect) {
            this.dispose();
        }
    }

    private void killScheduledTasks() {
        for (ScheduledFuture<?> scheduledTask : this.scheduledTasks) {
            scheduledTask.cancel(true);
        }
        this.scheduledTasks.clear();
    }

    protected void onSocketEvent(SocketEvent event) {
        this.callListenersAsync(listener -> {
            listener.onSocketEvent(this.whatsapp, event);
            listener.onSocketEvent(event);
        });
    }

    private void callListenersAsync(Consumer<Listener> consumer) {
        this.store.listeners().forEach(listener -> Thread.startVirtualThread(() -> this.invokeListenerSafe(consumer, (Listener)listener)));
    }

    @Override
    public void onOpen(SocketSession session) {
        this.session = session;
        if (this.state == SocketState.CONNECTED) {
            return;
        }
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(() -> this.onShutdown(false));
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        this.addToKnownConnections();
        this.state = SocketState.WAITING;
        this.onSocketEvent(SocketEvent.OPEN);
        ClientHello clientHello = new ClientHelloBuilder().ephemeral(this.keys.ephemeralKeyPair().publicKey()).build();
        HandshakeMessage handshakeMessage = new HandshakeMessageBuilder().clientHello(clientHello).build();
        this.sendBinaryWithNoResponse(HandshakeMessageSpec.encode(handshakeMessage), true).exceptionallyAsync(throwable -> (Void)this.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)throwable));
    }

    protected void addToKnownConnections() {
        connectedUuids.add(this.store.uuid());
        this.store.phoneNumber().map(PhoneNumber::number).ifPresent(connectedPhoneNumbers::add);
        connectedAlias.addAll(this.store.alias());
    }

    @Override
    public void onMessage(byte[] message) {
        Optional<byte[]> readKey;
        if (this.state == SocketState.WAITING || this.state == SocketState.RECONNECTING || this.state == SocketState.PAUSED) {
            this.handshake(message);
            return;
        }
        if (this.state == SocketState.HANDSHAKE) {
            this.setState(SocketState.CONNECTED);
        }
        if ((readKey = this.keys.readKey()).isEmpty()) {
            return;
        }
        long iv = this.keys.nextReadCounter(true);
        byte[] decipheredMessage = AesGcm.decrypt(iv, message, 0, message.length, readKey.get());
        try (BinaryDecoder decoder = new BinaryDecoder(decipheredMessage);){
            Node node = decoder.decode();
            this.onNodeReceived(node);
            this.store.resolvePendingRequest(node, false);
            this.streamHandler.digest(node);
        }
        catch (Throwable throwable) {
            this.handleFailure(ErrorHandler.Location.STREAM, throwable);
        }
    }

    private void handshake(byte[] message) {
        this.authHandler.login(message).whenCompleteAsync((result, throwable) -> {
            if (throwable == null) {
                this.setState(SocketState.HANDSHAKE);
            } else if (this.state != SocketState.RECONNECTING) {
                this.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)throwable);
            }
        });
    }

    private void onNodeReceived(Node node) {
        this.callListenersAsync(listener -> {
            listener.onNodeReceived(this.whatsapp, node);
            listener.onNodeReceived(node);
        });
    }

    @Override
    public void onClose() {
        if (this.state == SocketState.CONNECTED) {
            this.disconnect(DisconnectReason.RECONNECTING);
            return;
        }
        this.onDisconnected(this.state.toReason());
        this.onShutdown(this.state == SocketState.RECONNECTING);
    }

    @Override
    public void onError(Throwable throwable) {
        if (!(throwable instanceof SocketException)) {
            this.onSocketEvent(SocketEvent.ERROR);
            this.handleFailure(ErrorHandler.Location.UNKNOWN, throwable);
            return;
        }
        SocketException socketException = (SocketException)throwable;
        if (this.store.clientType() == ClientType.WEB || this.state() == SocketState.RECONNECTING || this.state() == SocketState.DISCONNECTED) {
            return;
        }
        this.handleFailure(ErrorHandler.Location.STREAM, socketException);
    }

    public CompletableFuture<Node> sendNode(Node node) {
        return this.sendNode(node, null);
    }

    public CompletableFuture<Node> sendNode(Node node, Function<Node, Boolean> filter) {
        if (node.id() == null) {
            node.attributes().put("id", HexFormat.of().formatHex(Bytes.random(6)));
        }
        return this.sendRequest(SocketRequest.of(node, filter), false, true);
    }

    public CompletableFuture<Void> sendNodeWithNoResponse(Node node) {
        return this.sendRequest(SocketRequest.of(node, null), false, false).thenRun(() -> {});
    }

    public CompletableFuture<Void> sendBinaryWithNoResponse(byte[] binary, boolean prologue) {
        return this.sendRequest(SocketRequest.of(binary), prologue, false).thenRun(() -> {});
    }

    private CompletableFuture<Node> sendRequest(SocketRequest request, boolean prologue, boolean response) {
        if (this.state() == SocketState.RESTORE) {
            return CompletableFuture.completedFuture(Node.of("error", Map.of("closed", true)));
        }
        boolean scheduledRelease = false;
        try {
            this.writeSemaphore.acquire();
            byte[] ciphered = this.encryptRequest(request);
            byte[] message = Bytes.concat(prologue ? SocketHandshake.getPrologue(this.store.clientType()) : null, Bytes.intToBytes(ciphered.length >> 16, 4), Bytes.intToBytes(0xFFFF & ciphered.length, 2), ciphered);
            CompletableFuture<?> future = this.session.sendBinary(message);
            scheduledRelease = true;
            future.whenCompleteAsync((result, error) -> {
                this.writeSemaphore.release();
                Object patt0$temp = request.body();
                if (patt0$temp instanceof Node) {
                    Node body = (Node)patt0$temp;
                    this.onNodeSent(body);
                }
                if (error != null) {
                    request.future().completeExceptionally((Throwable)error);
                    return;
                }
                if (!response) {
                    request.future().complete(null);
                    return;
                }
                this.store.addRequest(request);
            });
            return request.future();
        }
        catch (Throwable throwable) {
            if (!scheduledRelease) {
                this.writeSemaphore.release();
            }
            return CompletableFuture.failedFuture(throwable);
        }
    }

    private byte[] encryptRequest(SocketRequest request) {
        byte[] body = request.toBytes();
        Optional<byte[]> writeKey = this.keys.writeKey();
        if (writeKey.isEmpty()) {
            return body;
        }
        long iv = this.keys.nextWriteCounter(true);
        return AesGcm.encrypt(iv, body, writeKey.get());
    }

    private byte[] getBody(Object encodedBody) {
        Object object = encodedBody;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, Node.class}, (Object)object, n)) {
            case 0 -> {
                byte[] bytes;
                byte[] var4_5;
                yield var4_5 = (bytes = (byte[])object);
            }
            case 1 -> {
                byte[] var4_6;
                Node node = (Node)object;
                BinaryEncoder encoder = new BinaryEncoder();
                try {
                    var4_6 = encoder.encode(node);
                }
                catch (Throwable var8_10) {
                    try {
                        try {
                            encoder.close();
                        }
                        catch (Throwable var9_11) {
                            var8_10.addSuppressed(var9_11);
                        }
                        throw var8_10;
                    }
                    catch (IOException exception) {
                        throw new UncheckedIOException(exception);
                    }
                }
                encoder.close();
                yield var4_6;
            }
            default -> throw new IllegalArgumentException("Cannot create request, illegal body: %s".formatted(encodedBody));
        };
    }

    public CompletableFuture<Void> connect() {
        if (this.state == SocketState.CONNECTED) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.loginFuture == null || this.loginFuture.isDone()) {
            this.loginFuture = new CompletableFuture();
        }
        this.session = SocketSession.of(this.store.proxy().orElse(null), this.store.clientType() == ClientType.WEB);
        return this.session.connect(this).exceptionallyCompose(throwable -> {
            if (this.state == SocketState.CONNECTED || this.state == SocketState.RECONNECTING || this.state == SocketState.PAUSED) {
                this.setState(SocketState.PAUSED);
                this.onSocketEvent(SocketEvent.PAUSED);
                this.handleFailure(ErrorHandler.Location.RECONNECT, (Throwable)throwable);
                return CompletableFuture.failedFuture(throwable);
            }
            if (this.loginFuture != null && !this.loginFuture.isDone()) {
                this.loginFuture.completeExceptionally((Throwable)throwable);
            }
            return CompletableFuture.failedFuture(throwable);
        });
    }

    public CompletableFuture<Void> disconnect(DisconnectReason reason) {
        SocketState newState = SocketState.of(reason);
        if (this.state == newState) {
            return CompletableFuture.completedFuture(null);
        }
        this.setState(newState);
        this.keys.clearReadWriteKey();
        return switch (reason) {
            default -> throw new MatchException(null, null);
            case DisconnectReason.DISCONNECTED -> this.handleDisconnection();
            case DisconnectReason.RECONNECTING -> this.handleReconnection();
            case DisconnectReason.LOGGED_OUT, DisconnectReason.BANNED -> this.handleLoggedOut();
            case DisconnectReason.RESTORE -> this.handleRestore();
        };
    }

    private CompletableFuture<Void> handleRestore() {
        this.store.deleteSession();
        this.store.resolveAllPendingRequests();
        ArrayList<Listener> oldListeners = new ArrayList<Listener>(this.store.listeners());
        if (this.session != null) {
            this.session.disconnect();
        }
        UUID uuid = UUID.randomUUID();
        Long number = this.store.phoneNumber().map(PhoneNumber::number).orElse(null);
        StoreKeysPair result = this.store.serializer().newStoreKeysPair(uuid, number, this.store.alias(), this.store.clientType());
        this.keys = result.keys();
        this.store = result.store();
        this.store.addListeners(oldListeners);
        return this.connect();
    }

    private CompletableFuture<Void> handleLoggedOut() {
        this.store.deleteSession();
        this.store.resolveAllPendingRequests();
        return this.handleDisconnection();
    }

    private CompletableFuture<Void> handleReconnection() {
        this.store.resolveAllPendingRequests();
        if (this.session != null) {
            this.session.disconnect();
        }
        return this.connect();
    }

    private CompletableFuture<Void> handleDisconnection() {
        this.store.resolveAllPendingRequests();
        if (this.session != null) {
            this.session.disconnect();
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> pushPatch(PatchRequest request) {
        Jid jid = this.store.jid().orElseThrow(() -> new IllegalStateException("The session isn't connected"));
        return this.appStateHandler.push(jid, List.of(request));
    }

    public CompletableFuture<Void> pushPatches(Jid jid, List<PatchRequest> requests) {
        return this.appStateHandler.push(jid, requests);
    }

    public void pullPatch(PatchType ... patchTypes) {
        this.appStateHandler.pull(patchTypes);
    }

    protected CompletableFuture<Void> pullInitialPatches() {
        return this.appStateHandler.pullInitial();
    }

    public void decodeMessage(Node node, JidProvider chatOverride, boolean notify) {
        this.messageHandler.decode(node, chatOverride, notify);
    }

    public CompletableFuture<Void> sendPeerMessage(Jid companion, ProtocolMessage message) {
        if (message == null) {
            return CompletableFuture.completedFuture(null);
        }
        Jid jid = this.store.jid().orElseThrow(() -> new IllegalStateException("The session isn't connected"));
        ChatMessageKey key = new ChatMessageKeyBuilder().id(ChatMessageKey.randomIdV2(jid, this.store.clientType())).chatJid(companion).fromMe(true).senderJid(jid).build();
        ChatMessageInfo info = new ChatMessageInfoBuilder().status(MessageStatus.PENDING).senderJid(jid).key(key).message(MessageContainer.of(message)).timestampSeconds(Clock.nowSeconds()).build();
        MessageSendRequest.Chat request = new MessageSendRequest.Chat(info, null, false, true, null);
        return this.sendMessage(request);
    }

    public CompletableFuture<Void> sendMessage(MessageSendRequest request) {
        return this.messageHandler.encode(request);
    }

    public CompletableFuture<Void> sendQueryWithNoResponse(String method, String category, Node ... body) {
        return this.sendQueryWithNoResponse(null, JidServer.whatsapp().toJid(), method, category, null, body);
    }

    public CompletableFuture<Void> sendQueryWithNoResponse(String id, Jid to, String method, String category, Map<String, Object> metadata, Node ... body) {
        LinkedHashMap<String, Object> attributes = Attributes.ofNullable(metadata).put("id", id, Objects::nonNull).put("type", method).put("to", to).put("xmlns", category, Objects::nonNull).toMap();
        return this.sendNodeWithNoResponse(Node.of("iq", attributes, body));
    }

    private SocketRequest createRequest(Node node, Function<Node, Boolean> filter, boolean response) {
        if (response && node.id() == null) {
            node.attributes().put("id", this.store.initializationTimeStamp() + "-" + this.requestsCounter.incrementAndGet());
        }
        return SocketRequest.of(node, filter);
    }

    private void onNodeSent(Node node) {
        this.callListenersAsync(listener -> {
            listener.onNodeSent(this.whatsapp, node);
            listener.onNodeSent(node);
        });
    }

    public CompletableFuture<Optional<ContactAboutResponse>> queryAbout(JidProvider chat) {
        Node query = Node.of("status");
        Node body = Node.of("user", Map.of("jid", chat.toJid()));
        return this.sendInteractiveQuery(List.of(query), List.of(body), List.of()).thenApplyAsync(this::parseAbout);
    }

    public CompletableFuture<List<Node>> sendInteractiveQuery(Collection<Node> queries, Collection<Node> listData, Collection<Node> sideListData) {
        Node query = Node.of("query", queries);
        Node list = Node.of("list", listData);
        Node sideList = Node.of("side_list", sideListData);
        Node sync = Node.of("usync", Map.of("sid", SocketHandler.randomSid(), "mode", "query", "last", "true", "index", "0", "context", "interactive"), query, list, sideList);
        return this.sendQuery("get", "usync", sync).thenApplyAsync(this::parseQueryResult);
    }

    public static String randomSid() {
        return Clock.nowSeconds() + "-" + ThreadLocalRandom.current().nextLong(1000000000L, 9999999999L) + "-" + ThreadLocalRandom.current().nextInt(0, 1000);
    }

    private Optional<ContactAboutResponse> parseAbout(List<Node> responses) {
        return responses.stream().map(entry -> entry.findChild("status")).flatMap(Optional::stream).findFirst().map(ContactAboutResponse::ofNode);
    }

    public CompletableFuture<Node> sendQuery(String method, String category, Node ... body) {
        return this.sendQuery(null, JidServer.whatsapp().toJid(), method, category, null, body);
    }

    private List<Node> parseQueryResult(Node result) {
        return result == null ? List.of() : result.listChildren("usync").stream().map(node -> node.findChild("list")).flatMap(Optional::stream).map(node -> node.listChildren("user")).flatMap(Collection::stream).toList();
    }

    public CompletableFuture<Node> sendQuery(String id, Jid to, String method, String category, Map<String, Object> metadata, Node ... body) {
        LinkedHashMap<String, Object> attributes = Attributes.ofNullable(metadata).put("xmlns", category, Objects::nonNull).put("id", id, Objects::nonNull).put("to", to).put("type", method).toMap();
        return this.sendNode(Node.of("iq", attributes, body));
    }

    public CompletableFuture<Optional<URI>> queryPicture(JidProvider chat) {
        Node body = Node.of("picture", Map.of("query", "url", "type", "image"));
        if (chat.toJid().hasServer(JidServer.groupOrCommunity())) {
            return ((CompletableFuture)this.queryGroupMetadata(chat.toJid()).thenComposeAsync(result -> this.sendQuery("get", "w:profile:picture", Map.of(result.isCommunity() ? "parent_group_jid" : "target", chat.toJid()), body))).thenApplyAsync(this::parseChatPicture);
        }
        return this.sendQuery("get", "w:profile:picture", Map.of("target", chat.toJid()), body).thenApplyAsync(this::parseChatPicture);
    }

    public CompletableFuture<Node> sendQuery(String method, String category, Map<String, Object> metadata, Node ... body) {
        return this.sendQuery(null, JidServer.whatsapp().toJid(), method, category, metadata, body);
    }

    private Optional<URI> parseChatPicture(Node result) {
        return result.findChild("picture").flatMap(picture -> picture.attributes().getOptionalString("url")).map(URI::create);
    }

    public CompletableFuture<List<Jid>> queryBlockList() {
        return this.sendQuery("get", "blocklist", new Node[]{null}).thenApplyAsync(this::parseBlockList);
    }

    private List<Jid> parseBlockList(Node result) {
        return result.findChild("list").stream().flatMap(node -> node.listChildren("item").stream()).map(item -> item.attributes().getOptionalJid("jid")).flatMap(Optional::stream).toList();
    }

    public CompletableFuture<Void> subscribeToPresence(JidProvider jid) {
        Node node = Node.of("presence", Map.of("to", jid.toJid(), "type", "subscribe"));
        return this.sendNodeWithNoResponse(node);
    }

    public CompletableFuture<OptionalLong> subscribeToNewsletterReactions(JidProvider channel) {
        return this.sendQuery(channel.toJid(), "set", "newsletter", Node.of("live_updates")).thenApplyAsync(this::parseNewsletterSubscription);
    }

    private OptionalLong parseNewsletterSubscription(Node result) {
        return result.findChild("live_updates").stream().map(node -> node.attributes().getOptionalLong("duration")).flatMapToLong(OptionalLong::stream).findFirst();
    }

    public CompletableFuture<Void> queryNewsletterMessages(JidProvider newsletterJid, int count) {
        Newsletter newsletter = this.store.findNewsletterByJid(newsletterJid).orElseThrow(() -> new NoSuchElementException("Missing newsletter"));
        String newsletterInvite = newsletter.metadata().invite().orElseThrow(() -> new NoSuchElementException("Missing newsletter key"));
        return this.sendQuery("get", "newsletter", Node.of("messages", Map.of("count", count, "type", "invite", "key", newsletterInvite))).thenAcceptAsync(result -> this.onNewsletterMessages(newsletter, (Node)result));
    }

    private void onNewsletterMessages(Newsletter newsletter, Node result) {
        result.findChild("messages").stream().map(messages -> messages.listChildren("message")).flatMap(Collection::stream).forEach(messages -> this.decodeMessage((Node)messages, newsletter, false));
    }

    public CompletableFuture<ChatMetadata> queryGroupMetadata(JidProvider group) {
        Node body = Node.of("query", Map.of("request", "interactive"));
        return this.sendQuery(group.toJid(), "get", "w:g2", body).thenComposeAsync(this::handleGroupMetadata);
    }

    public CompletableFuture<ChatMetadata> handleGroupMetadata(Node response) {
        Node metadataNode = Optional.of(response).filter(entry -> entry.hasDescription("group")).or(() -> response.findChild("group")).orElseThrow(() -> new NoSuchElementException("Erroneous response: %s".formatted(response)));
        return this.parseGroupMetadata(metadataNode).thenApplyAsync(metadata -> {
            Chat chat = this.store.findChatByJid(metadata.jid()).orElseGet(() -> this.store().addNewChat(metadata.jid()));
            chat.setName(metadata.subject());
            return metadata;
        });
    }

    private CompletableFuture<ChatMetadata> parseGroupMetadata(Node node) {
        Jid groupId = node.attributes().getOptionalString("id").map(id -> Jid.of(id, JidServer.groupOrCommunity())).orElseThrow(() -> new NoSuchElementException("Missing group jid"));
        String subject = node.attributes().getString("subject");
        Optional<Jid> subjectAuthor = node.attributes().getOptionalJid("s_o");
        long subjectTimestampSeconds = node.attributes().getOptionalLong("s_t").orElse(0L);
        long foundationTimestampSeconds = node.attributes().getOptionalLong("creation").orElse(0L);
        Optional<Jid> founder = node.attributes().getOptionalJid("creator");
        Optional<String> description = node.findChild("description").flatMap(parent -> parent.findChild("body")).flatMap(Node::contentAsString);
        Optional<String> descriptionId = node.findChild("description").map(Node::attributes).flatMap(attributes -> attributes.getOptionalString("id"));
        Optional<Jid> parentCommunityJid = node.findChild("linked_parent").flatMap(entry -> entry.attributes().getOptionalJid("jid"));
        Optional<ZonedDateTime> ephemeral = node.findChild("ephemeral").map(Node::attributes).map(attributes -> attributes.getLong("expiration")).flatMap(Clock::parseSeconds);
        Node communityNode = node.findChild("parent").orElse(null);
        HashMap<Enum, ChatSettingPolicy> policies = new HashMap<Enum, ChatSettingPolicy>();
        List pastParticipants = Objects.requireNonNullElseGet((List)this.pastParticipants.get(groupId), List::of);
        if (communityNode == null) {
            policies.put(GroupSetting.EDIT_GROUP_INFO, ChatSettingPolicy.of(node.hasNode("announce")));
            policies.put(GroupSetting.SEND_MESSAGES, ChatSettingPolicy.of(node.hasNode("restrict")));
            String addParticipantsMode = node.findChild("member_add_mode").flatMap(Node::contentAsString).orElse(null);
            policies.put(GroupSetting.ADD_PARTICIPANTS, ChatSettingPolicy.of(Objects.equals(addParticipantsMode, "admin_add")));
            Boolean groupJoin = node.findChild("membership_approval_mode").flatMap(entry -> entry.findChild("group_join")).map(entry -> entry.attributes().hasValue("state", "on")).orElse(false);
            policies.put(GroupSetting.APPROVE_PARTICIPANTS, ChatSettingPolicy.of(groupJoin));
            List<ChatParticipant> participants = node.listChildren("participant").stream().map(this::parseGroupParticipant).flatMap(Optional::stream).toList();
            return CompletableFuture.completedFuture(new ChatMetadata(groupId, subject, subjectAuthor, Clock.parseSeconds(subjectTimestampSeconds), Clock.parseSeconds(foundationTimestampSeconds), founder, description, descriptionId, Collections.unmodifiableMap(policies), participants, pastParticipants, ephemeral, parentCommunityJid, false, List.of()));
        }
        policies.put(CommunitySetting.MODIFY_GROUPS, ChatSettingPolicy.of(communityNode.hasNode("allow_non_admin_sub_group_creation")));
        String addParticipantsMode = node.findChild("member_add_mode").flatMap(Node::contentAsString).orElse(null);
        policies.put(CommunitySetting.ADD_PARTICIPANTS, ChatSettingPolicy.of(Objects.equals(addParticipantsMode, "admin_add")));
        byte[] mexBody = Json.writeValueAsBytes(new CommunityLinkedGroupsRequest(new CommunityLinkedGroupsRequest.Variable(new CommunityLinkedGroupsRequest.Input(groupId, "INTERACTIVE"))));
        return this.sendQuery(groupId, "get", "w:g2", Node.of("linked_groups_participants")).thenComposeAsync(participantsNode -> {
            List<ChatParticipant> participants = participantsNode.findChild("linked_groups_participants").stream().flatMap(participantsNodeBody -> participantsNodeBody.streamChildren("participant")).flatMap(participantNode -> participantNode.attributes().getOptionalJid("jid").stream()).map(participantJid -> new CommunityParticipant((Jid)participantJid)).toList();
            return this.sendQuery("get", "w:mex", Node.of("query", Map.of("query_id", "7353258338095347"), (Object)mexBody)).thenApplyAsync(communityResponse -> {
                List<CommunityLinkedGroup> linkedGroups = communityResponse.findChild("result").flatMap(Node::contentAsBytes).flatMap(CommunityLinkedGroupsResponse::ofJson).map(CommunityLinkedGroupsResponse::linkedGroups).orElse(List.of());
                return new ChatMetadata(groupId, subject, subjectAuthor, Clock.parseSeconds(subjectTimestampSeconds), Clock.parseSeconds(foundationTimestampSeconds), founder, description, descriptionId, Collections.unmodifiableMap(policies), participants, pastParticipants, ephemeral, parentCommunityJid, true, linkedGroups);
            });
        });
    }

    private Optional<ChatParticipant> parseGroupParticipant(Node node) {
        if (node.attributes().hasKey("error")) {
            return Optional.empty();
        }
        Jid id = node.attributes().getRequiredJid("jid");
        GroupRole role = GroupRole.of(node.attributes().getString("type", null));
        return Optional.of(new GroupParticipant(id, role));
    }

    public CompletableFuture<Node> sendQuery(Jid to, String method, String category, Node ... body) {
        return this.sendQuery(null, to, method, category, null, body);
    }

    public CompletableFuture<Void> sendRetryReceipt(long nodeTimestamp, Jid chatJid, Jid participantJid, String messageId, int retryCount) {
        LinkedHashMap<String, Object> retryAttributes = Attributes.of(new Map.Entry[0]).put("count", 1).put("id", messageId).put("t", nodeTimestamp).put("v", 1).toMap();
        Node retryNode = Node.of("retry", retryAttributes);
        Node registrationNode = Node.of("registration", this.keys.encodedRegistrationId());
        LinkedHashMap<String, Object> receiptAttributes = Attributes.of(new Map.Entry[0]).put("id", messageId).put("type", "retry").put("to", chatJid.withoutAgent()).put("participant", (Object)(participantJid == null ? null : participantJid.withoutAgent()), participantJid != null).toMap();
        Node receipt = Node.of("receipt", receiptAttributes, retryNode, registrationNode);
        return this.sendNodeWithNoResponse(receipt);
    }

    public CompletableFuture<Void> sendReceipt(Jid jid, Jid participant, List<String> messages, String type) {
        if (messages.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Attributes attributes = Attributes.of(new Map.Entry[0]).put("id", messages.getFirst()).put("t", (Object)Clock.nowMilliseconds(), () -> Objects.equals(type, "read") || Objects.equals(type, "read-self")).put("to", jid.withoutAgent()).put("type", type, Objects::nonNull);
        if (Objects.equals(type, "sender") && jid.hasServer(JidServer.whatsapp())) {
            attributes.put("recipient", jid.withoutAgent());
            attributes.put("to", participant.withoutAgent());
        }
        Node receipt = Node.of("receipt", attributes.toMap(), this.toMessagesNode(messages));
        return this.sendNodeWithNoResponse(receipt);
    }

    private List<Node> toMessagesNode(List<String> messages) {
        if (messages.size() <= 1) {
            return null;
        }
        return messages.subList(1, messages.size()).stream().map(id -> Node.of("item", Map.of("id", id))).toList();
    }

    protected CompletableFuture<Void> sendMessageAck(Jid from, Node node) {
        Attributes attrs = node.attributes();
        String type = attrs.getOptionalString("type").filter(entry -> !Objects.equals(entry, "message")).orElse(null);
        String participant = attrs.getNullableString("participant");
        String recipient = attrs.getNullableString("recipient");
        LinkedHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("id", node.id()).put("to", from).put("class", node.description()).put("participant", participant != null ? Jid.of(participant).withoutAgent() : null).put("recipient", recipient != null ? Jid.of(recipient).withoutAgent() : null).put("type", type, Objects::nonNull).toMap();
        return this.sendNodeWithNoResponse(Node.of("ack", attributes));
    }

    protected void onRegistrationCode(long code) {
        this.callListenersAsync(listener -> {
            listener.onRegistrationCode(this.whatsapp, code);
            listener.onRegistrationCode(code);
        });
    }

    protected void onMetadata(Map<String, String> properties) {
        this.callListenersAsync(listener -> {
            listener.onMetadata(this.whatsapp, properties);
            listener.onMetadata(properties);
        });
    }

    protected void onMessageStatus(MessageInfo<?> message) {
        this.callListenersAsync(listener -> {
            listener.onMessageStatus(this.whatsapp, message);
            listener.onMessageStatus(message);
        });
    }

    protected void onUpdateChatPresence(ContactStatus status, Jid jid, Chat chat) {
        Optional<Contact> contact = this.store.findContactByJid(jid);
        if (contact.isPresent()) {
            contact.get().setLastKnownPresence(status);
            contact.get().setLastSeen(ZonedDateTime.now());
        }
        Jid provider = contact.isPresent() ? (JidProvider)contact.get() : jid;
        chat.presences().put(jid, status);
        this.callListenersAsync(listener -> {
            listener.onContactPresence(this.whatsapp, chat, provider);
            listener.onContactPresence(chat, provider);
        });
    }

    protected void onNewMessage(MessageInfo<?> info) {
        this.callListenersAsync(listener -> {
            listener.onNewMessage(this.whatsapp, info);
            listener.onNewMessage(info);
        });
    }

    protected void onNewStatus(ChatMessageInfo info) {
        this.callListenersAsync(listener -> {
            listener.onNewStatus(this.whatsapp, info);
            listener.onNewStatus(info);
        });
    }

    protected void onChatRecentMessages(Chat chat, boolean last) {
        this.callListenersAsync(listener -> {
            listener.onChatMessagesSync(this.whatsapp, chat, last);
            listener.onChatMessagesSync(chat, last);
        });
    }

    protected void onFeatures(PrimaryFeature features) {
        this.callListenersAsync(listener -> {
            listener.onFeatures(this.whatsapp, features.flags());
            listener.onFeatures(features.flags());
        });
    }

    protected void onSetting(Setting setting) {
        this.callListenersAsync(listener -> {
            listener.onSetting(this.whatsapp, setting);
            listener.onSetting(setting);
        });
    }

    protected void onMessageDeleted(MessageInfo<?> message, boolean everyone) {
        this.callListenersAsync(listener -> {
            listener.onMessageDeleted(this.whatsapp, message, everyone);
            listener.onMessageDeleted(message, everyone);
        });
    }

    protected void onAction(Action action, MessageIndexInfo indexInfo) {
        this.callListenersAsync(listener -> {
            listener.onAction(this.whatsapp, action, indexInfo);
            listener.onAction(action, indexInfo);
        });
    }

    protected void onDisconnected(DisconnectReason reason) {
        if (this.state == SocketState.WAITING || this.state == SocketState.HANDSHAKE) {
            this.handleFailure(ErrorHandler.Location.LOGIN, new RuntimeException("Cannot login: no response from Whatsapp"));
            return;
        }
        if (reason != DisconnectReason.RECONNECTING) {
            connectedUuids.remove(this.store.uuid());
            this.store.phoneNumber().map(PhoneNumber::number).ifPresent(connectedPhoneNumbers::remove);
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.confirmConnection();
        }
        this.callListenersSync(listener -> {
            listener.onDisconnected(this.whatsapp, reason);
            listener.onDisconnected(reason);
        });
    }

    protected void onLoggedIn() {
        this.callListenersAsync(listener -> {
            listener.onLoggedIn(this.whatsapp);
            listener.onLoggedIn();
        });
    }

    public void callListenersSync(Consumer<Listener> consumer) {
        for (Listener listener : this.store.listeners()) {
            this.invokeListenerSafe(consumer, listener);
        }
    }

    private void invokeListenerSafe(Consumer<Listener> consumer, Listener listener) {
        try {
            consumer.accept(listener);
        }
        catch (Throwable throwable) {
            this.handleFailure(ErrorHandler.Location.UNKNOWN, throwable);
        }
    }

    protected void onChats() {
        this.callListenersAsync(listener -> {
            listener.onChats(this.whatsapp, this.store().chats());
            listener.onChats(this.store().chats());
        });
    }

    protected void onNewsletters() {
        this.callListenersAsync(listener -> {
            listener.onNewsletters(this.whatsapp, this.store().newsletters());
            listener.onNewsletters(this.store().newsletters());
        });
    }

    protected void onStatus() {
        this.callListenersAsync(listener -> {
            listener.onStatus(this.whatsapp, this.store().status());
            listener.onStatus(this.store().status());
        });
    }

    protected void onContacts() {
        this.callListenersAsync(listener -> {
            listener.onContacts(this.whatsapp, this.store().contacts());
            listener.onContacts(this.store().contacts());
        });
    }

    protected void onHistorySyncProgress(Integer progress, boolean recent) {
        this.callListenersAsync(listener -> {
            listener.onHistorySyncProgress(this.whatsapp, progress, recent);
            listener.onHistorySyncProgress(progress, recent);
        });
    }

    protected void onReply(ChatMessageInfo info) {
        QuotedMessageInfo quoted = info.quotedMessage().orElse(null);
        if (quoted == null) {
            return;
        }
        this.store.resolvePendingReply(info);
        this.callListenersAsync(listener -> {
            listener.onMessageReply(this.whatsapp, info, quoted);
            listener.onMessageReply(info, quoted);
        });
    }

    protected void onGroupPictureChanged(Chat fromChat) {
        this.callListenersAsync(listener -> {
            listener.onGroupPictureChanged(this.whatsapp, fromChat);
            listener.onGroupPictureChanged(fromChat);
        });
    }

    protected void onContactPictureChanged(Contact fromContact) {
        this.callListenersAsync(listener -> {
            listener.onProfilePictureChanged(this.whatsapp, fromContact);
            listener.onProfilePictureChanged(fromContact);
        });
    }

    protected void onUserAboutChanged(String newAbout, String oldAbout) {
        this.callListenersAsync(listener -> {
            listener.onAboutChanged(this.whatsapp, oldAbout, newAbout);
            listener.onAboutChanged(oldAbout, newAbout);
        });
    }

    public void onUserPictureChanged(URI newPicture, URI oldPicture) {
        this.callListenersAsync(listener -> this.store().jid().flatMap(this.store()::findContactByJid).ifPresent(selfJid -> {
            listener.onProfilePictureChanged(this.whatsapp, (Contact)selfJid);
            listener.onProfilePictureChanged((Contact)selfJid);
        }));
    }

    public void onUserChanged(String newName, String oldName) {
        if (oldName != null && !Objects.equals(newName, oldName)) {
            this.onUserNameChanged(newName, oldName);
        }
        Jid self = this.store.jid().orElseThrow(() -> new IllegalStateException("The session isn't connected")).toSimpleJid();
        this.store().findContactByJid(self).orElseGet(() -> this.store().addContact(self)).setChosenName(newName);
        this.store().setName(newName);
    }

    private void onUserNameChanged(String newName, String oldName) {
        this.callListenersAsync(listener -> {
            listener.onNameChanged(this.whatsapp, oldName, newName);
            listener.onNameChanged(oldName, newName);
        });
    }

    public void updateLocale(CountryLocale newLocale, CountryLocale oldLocale) {
        if (!Objects.equals(newLocale, oldLocale)) {
            return;
        }
        if (oldLocale != null) {
            this.onUserLocaleChanged(newLocale, oldLocale);
        }
        this.store().setLocale(newLocale);
    }

    private void onUserLocaleChanged(CountryLocale newLocale, CountryLocale oldLocale) {
        this.callListenersAsync(listener -> {
            listener.onLocaleChanged(this.whatsapp, oldLocale, newLocale);
            listener.onLocaleChanged(oldLocale, newLocale);
        });
    }

    protected void onContactBlocked(Contact contact) {
        this.callListenersAsync(listener -> {
            listener.onContactBlocked(this.whatsapp, contact);
            listener.onContactBlocked(contact);
        });
    }

    protected void onNewContact(Contact contact) {
        this.callListenersAsync(listener -> {
            listener.onNewContact(this.whatsapp, contact);
            listener.onNewContact(contact);
        });
    }

    protected void onDevices(LinkedHashMap<Jid, Integer> devices) {
        this.callListenersAsync(listener -> {
            listener.onLinkedDevices(this.whatsapp, devices.keySet());
            listener.onLinkedDevices(devices.keySet());
        });
    }

    public void onCall(Call call) {
        this.callListenersAsync(listener -> {
            listener.onCall(this.whatsapp, call);
            listener.onCall(call);
        });
    }

    public void onPrivacySettingChanged(PrivacySettingEntry oldEntry, PrivacySettingEntry newEntry) {
        this.callListenersAsync(listener -> {
            listener.onPrivacySettingChanged(this.whatsapp, oldEntry, newEntry);
            listener.onPrivacySettingChanged(oldEntry, newEntry);
        });
    }

    protected CompletableFuture<Void> querySessionsForcefully(Jid jid) {
        return this.messageHandler.querySessions(List.of(jid), true);
    }

    private void dispose() {
        this.onSocketEvent(SocketEvent.CLOSE);
        this.streamHandler.dispose();
        this.messageHandler.dispose();
        this.appStateHandler.dispose();
        this.scheduler.shutdownNow();
        this.confirmConnection();
    }

    protected <T> T handleFailure(ErrorHandler.Location location, Throwable throwable) {
        if (this.state() == SocketState.RESTORE || this.state() == SocketState.LOGGED_OUT || this.state() == SocketState.BANNED) {
            return null;
        }
        ErrorHandler.Result result = this.errorHandler.handleError(this.whatsapp, location, throwable);
        switch (result) {
            case RESTORE: {
                this.disconnect(DisconnectReason.RESTORE);
                break;
            }
            case LOG_OUT: {
                this.disconnect(DisconnectReason.LOGGED_OUT);
                break;
            }
            case DISCONNECT: {
                this.disconnect(DisconnectReason.DISCONNECTED);
                break;
            }
            case RECONNECT: {
                this.disconnect(DisconnectReason.RECONNECTING);
            }
        }
        return null;
    }

    public CompletableFuture<List<Jid>> querySessions(List<Jid> jid) {
        return this.messageHandler.querySessions(jid, true).thenComposeAsync(values -> this.messageHandler.queryDevices(jid, false));
    }

    public void parseSessions(Node result) {
        this.messageHandler.parseSessions(result);
    }

    public CompletableFuture<List<BusinessCategory>> queryBusinessCategories() {
        return this.sendQuery("get", "fb:thrift_iq", Node.of("request", Map.of("op", "profile_typeahead", "type", "catkit", "v", "1"), (Object)Node.of("query", List.of()))).thenApplyAsync(this::parseBusinessCategories);
    }

    private List<BusinessCategory> parseBusinessCategories(Node result) {
        return result.findChild("response").flatMap(entry -> entry.findChild("categories")).stream().map(entry -> entry.listChildren("category")).flatMap(Collection::stream).map(BusinessCategory::of).toList();
    }

    public SocketState state() {
        return this.state;
    }

    public Keys keys() {
        return this.keys;
    }

    public Store store() {
        return this.store;
    }

    protected void setState(SocketState state) {
        this.state = state;
    }

    public CompletableFuture<Void> changeAbout(String newAbout) {
        return this.sendQuery("set", "status", Node.of("status", newAbout.getBytes(StandardCharsets.UTF_8))).thenRun(() -> this.store().setAbout(newAbout));
    }

    void confirmConnection() {
        if (this.loginFuture == null || this.loginFuture.isDone()) {
            return;
        }
        this.loginFuture.complete(null);
    }

    protected void scheduleAtFixedInterval(Runnable command, long initialDelay, long period) {
        ScheduledFuture<?> result = this.scheduler.scheduleAtFixedRate(command, initialDelay, period, TimeUnit.SECONDS);
        this.scheduledTasks.add(result);
    }

    protected ScheduledFuture<?> scheduleDelayed(Runnable command, long delay) {
        ScheduledFuture<?> result = this.scheduler.schedule(command, delay, TimeUnit.SECONDS);
        this.scheduledTasks.add(result);
        return result;
    }

    protected void sendPing() {
        if (this.pinging) {
            return;
        }
        this.pinging = true;
        LinkedHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("xmlns", "w:p").put("to", JidServer.whatsapp().toJid()).put("type", "get").put("id", HexFormat.of().formatHex(Bytes.random(6))).toMap();
        Node node = Node.of("iq", attributes, (Object)Node.of("ping"));
        CompletableFuture<Node> future = new CompletableFuture().orTimeout(20L, TimeUnit.SECONDS);
        SocketRequest request = new SocketRequest(node.id(), node, future, null);
        ((CompletableFuture)this.sendRequest(request, false, true).thenApply(result -> {
            this.pinging = false;
            return result;
        })).exceptionally(throwable -> {
            this.pinging = false;
            this.disconnect(DisconnectReason.RECONNECTING);
            return null;
        });
    }

    public CompletableFuture<Void> updateBusinessCertificate(String newName) {
        return this.streamHandler.updateBusinessCertificate(newName);
    }

    public ConcurrentMap<Jid, List<ChatPastParticipant>> pastParticipants() {
        return this.pastParticipants;
    }

    public void addPastParticipant(Jid jid, final ChatPastParticipant pastParticipant) {
        List pastParticipants = (List)this.pastParticipants().get(jid);
        if (pastParticipants != null) {
            pastParticipants.add(pastParticipant);
            this.pastParticipants().put(jid, pastParticipants);
        } else {
            this.pastParticipants().put(jid, (List<ChatPastParticipant>)new ArrayList<ChatPastParticipant>(this){
                final /* synthetic */ SocketHandler this$0;
                {
                    this.this$0 = this$0;
                    this.add(pastParticipant);
                }
            });
        }
    }

    protected void queryNewsletters() {
        this.streamHandler.queryNewsletters().exceptionallyAsync(throwable -> (Void)this.handleFailure(ErrorHandler.Location.HISTORY_SYNC, (Throwable)throwable));
    }
}

