/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.implementation;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.crypto.AesGcm;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.util.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class SocketHandshake {
    private static final byte[] NOISE_PROTOCOL = "Noise_XX_25519_AESGCM_SHA256\u0000\u0000\u0000\u0000".getBytes(StandardCharsets.UTF_8);
    private static final byte[] WHATSAPP_VERSION_HEADER = "WA".getBytes(StandardCharsets.UTF_8);
    private static final byte[] WEB_VERSION = new byte[]{6, 3};
    private static final byte[] WEB_PROLOGUE = Bytes.concat(WHATSAPP_VERSION_HEADER, WEB_VERSION);
    private static final byte[] MOBILE_VERSION = new byte[]{5, 3};
    private static final byte[] MOBILE_PROLOGUE = Bytes.concat(WHATSAPP_VERSION_HEADER, MOBILE_VERSION);
    private final Keys keys;
    private byte[] hash;
    private byte[] salt;
    private byte[] cryptoKey;
    private long counter;

    public static byte[] getPrologue(ClientType clientType) {
        return switch (clientType) {
            default -> throw new MatchException(null, null);
            case ClientType.WEB -> WEB_PROLOGUE;
            case ClientType.MOBILE -> MOBILE_PROLOGUE;
        };
    }

    SocketHandshake(Keys keys, byte[] prologue) {
        this.keys = keys;
        this.hash = NOISE_PROTOCOL;
        this.salt = NOISE_PROTOCOL;
        this.cryptoKey = NOISE_PROTOCOL;
        this.counter = 0L;
        this.updateHash(prologue);
    }

    void updateHash(byte[] data) {
        byte[] input = Bytes.concat(this.hash, data);
        this.hash = Sha256.calculate(input);
    }

    byte[] cipher(byte[] bytes, boolean encrypt) {
        byte[] cyphered;
        byte[] byArray = cyphered = encrypt ? AesGcm.encrypt(this.counter++, bytes, this.cryptoKey, this.hash) : AesGcm.decrypt(this.counter++, bytes, this.cryptoKey, this.hash);
        if (!encrypt) {
            this.updateHash(bytes);
            return cyphered;
        }
        this.updateHash(cyphered);
        return cyphered;
    }

    void finish() {
        byte[] expanded = Hkdf.extractAndExpand(new byte[0], this.salt, null, 64);
        this.keys.setWriteKey(Arrays.copyOfRange(expanded, 0, 32));
        this.keys.setReadKey(Arrays.copyOfRange(expanded, 32, 64));
        this.dispose();
    }

    void mixIntoKey(byte[] bytes) {
        byte[] expanded = Hkdf.extractAndExpand(bytes, this.salt, null, 64);
        this.salt = Arrays.copyOfRange(expanded, 0, 32);
        this.cryptoKey = Arrays.copyOfRange(expanded, 32, 64);
        this.counter = 0L;
    }

    void dispose() {
        this.hash = null;
        this.salt = null;
        this.cryptoKey = null;
        this.counter = 0L;
    }
}

