/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.implementation;

import it.auties.whatsapp.exception.RequestException;
import it.auties.whatsapp.io.BinaryEncoder;
import it.auties.whatsapp.model.node.Node;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public record SocketRequest(String id, Object body, CompletableFuture<Node> future, Function<Node, Boolean> filter) {
    private static final int TIMEOUT = 60;

    private SocketRequest(String id, Function<Node, Boolean> filter, Object body) {
        this(id, body, SocketRequest.futureOrTimeout(body), filter);
    }

    private static CompletableFuture<Node> futureOrTimeout(Object body) {
        return new CompletableFuture().orTimeout(60L, TimeUnit.SECONDS).exceptionally(throwable -> {
            throw new RequestException("Node timed out: " + String.valueOf(body));
        });
    }

    static SocketRequest of(Node body, Function<Node, Boolean> filter) {
        return new SocketRequest(body.id(), filter, body);
    }

    static SocketRequest of(byte[] body) {
        return new SocketRequest(null, null, body);
    }

    byte[] toBytes() {
        Object object = this.body;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, Node.class}, (Object)object, n)) {
            case 0 -> {
                byte[] bytes;
                byte[] var3_4;
                yield var3_4 = (bytes = (byte[])object);
            }
            case 1 -> {
                byte[] var3_5;
                Node node = (Node)object;
                BinaryEncoder encoder = new BinaryEncoder();
                try {
                    var3_5 = encoder.encode(node);
                }
                catch (Throwable var7_9) {
                    try {
                        try {
                            encoder.close();
                        }
                        catch (Throwable var8_10) {
                            var7_9.addSuppressed(var8_10);
                        }
                        throw var7_9;
                    }
                    catch (IOException exception) {
                        throw new UncheckedIOException(exception);
                    }
                }
                encoder.close();
                yield var3_5;
            }
            default -> throw new IllegalArgumentException("Cannot create request, illegal body: %s".formatted(this.body));
        };
    }

    public boolean complete(Node response, boolean exceptionally) {
        if (response == null) {
            this.future.complete(Node.of("error", Map.of("closed", true)));
            return true;
        }
        if (exceptionally) {
            this.future.completeExceptionally(new RuntimeException("Cannot process request %s with %s".formatted(this, response)));
            return true;
        }
        if (this.filter != null && !this.filter.apply(response).booleanValue()) {
            return false;
        }
        this.future.complete(response);
        return true;
    }
}

