/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.implementation;

import it.auties.whatsapp.implementation.SocketListener;
import it.auties.whatsapp.util.Proxies;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;

abstract sealed class SocketSession {
    private static final URI WEB_SOCKET = URI.create("wss://web.whatsapp.com/ws/chat");
    private static final InetSocketAddress MOBILE_SOCKET_ENDPOINT = new InetSocketAddress("g.whatsapp.net", 443);
    private static final int MESSAGE_LENGTH = 3;
    final URI proxy;
    SocketListener listener;

    private SocketSession(URI proxy) {
        this.proxy = proxy;
    }

    public CompletableFuture<Void> connect(SocketListener listener) {
        this.listener = listener;
        return CompletableFuture.completedFuture(null);
    }

    abstract void disconnect();

    public abstract CompletableFuture<?> sendBinary(byte[] var1);

    static SocketSession of(URI proxy, boolean webSocket) {
        if (webSocket) {
            return new WebSocketSession(proxy);
        }
        return new RawSocketSession(proxy);
    }

    private static final class WebSocketSession
    extends SocketSession
    implements WebSocket.Listener {
        private WebSocket session;
        private byte[] message;
        private int messageOffset;

        WebSocketSession(URI proxy) {
            super(proxy);
        }

        @Override
        public CompletableFuture<Void> connect(SocketListener listener) {
            if (this.session != null) {
                return CompletableFuture.completedFuture(null);
            }
            super.connect(listener);
            HttpClient.Builder builder = HttpClient.newBuilder();
            if (this.proxy != null) {
                builder.proxy(Proxies.toProxySelector(this.proxy));
                builder.authenticator(Proxies.toAuthenticator(this.proxy));
            }
            return builder.build().newWebSocketBuilder().buildAsync(WEB_SOCKET, this).thenAcceptAsync(webSocket -> {
                this.session = webSocket;
                listener.onOpen(this);
            });
        }

        @Override
        void disconnect() {
            if (this.session == null) {
                return;
            }
            this.session.sendClose(1000, "");
        }

        @Override
        public CompletableFuture<?> sendBinary(byte[] bytes) {
            if (this.session == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.session.sendBinary(ByteBuffer.wrap(bytes), true);
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            if (this.session != null) {
                this.message = null;
                this.listener.onClose();
                this.session = null;
            }
            return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            this.listener.onError(error);
        }

        @Override
        public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
            try {
                while (data.hasRemaining()) {
                    if (this.messageOffset == 0) {
                        if (data.remaining() < 3) break;
                        int messageLength = data.get() << 16 | Short.toUnsignedInt(data.getShort());
                        if (messageLength < 0) {
                            this.disconnect();
                            break;
                        }
                        this.message = new byte[messageLength];
                    }
                    int remaining = Math.min(this.message.length - this.messageOffset, data.remaining());
                    data.get(this.message, this.messageOffset, remaining);
                    this.messageOffset += remaining;
                    if (this.messageOffset != this.message.length) continue;
                    this.messageOffset = 0;
                    this.listener.onMessage(this.message);
                }
            }
            catch (Throwable throwable) {
                this.listener.onError(throwable);
            }
            return WebSocket.Listener.super.onBinary(webSocket, data, last);
        }
    }

    private static final class RawSocketSession
    extends SocketSession {
        private SocketChannel channel;

        RawSocketSession(URI proxy) {
            super(proxy);
        }

        @Override
        public CompletableFuture<Void> connect(SocketListener listener) {
            super.connect(listener);
            if (this.isOpen()) {
                return CompletableFuture.completedFuture(null);
            }
            try {
                this.channel = SocketChannel.open();
                this.channel.configureBlocking(false);
                ConnectionContext context = new ConnectionContext(this, listener, new CompletableFuture<Void>());
                if (this.channel.connect(MOBILE_SOCKET_ENDPOINT)) {
                    context.connectFuture.complete(null);
                    listener.onOpen(this);
                    CentralSelector.INSTANCE.register(this.channel, 1, context);
                } else {
                    CentralSelector.INSTANCE.register(this.channel, 8, context);
                }
                return context.connectFuture;
            }
            catch (IOException exception) {
                return CompletableFuture.failedFuture(exception);
            }
        }

        @Override
        void disconnect() {
            try {
                if (this.channel == null) {
                    return;
                }
                this.channel.close();
                this.listener.onClose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private boolean isOpen() {
            return this.channel != null && this.channel.isOpen();
        }

        public CompletableFuture<Void> sendBinary(byte[] bytes) {
            if (this.channel == null) {
                return CompletableFuture.completedFuture(null);
            }
            CentralSelector.INSTANCE.addWrite(this.channel, ByteBuffer.wrap(bytes));
            return CompletableFuture.completedFuture(null);
        }

        private static final class ConnectionContext {
            private final RawSocketSession session;
            private final SocketListener listener;
            private final CompletableFuture<Void> connectFuture;
            private final Queue<ByteBuffer> pendingWrites = new ConcurrentLinkedQueue<ByteBuffer>();
            private final ByteBuffer lengthBuffer = ByteBuffer.allocate(3);
            private ByteBuffer payloadBuffer = null;

            private ConnectionContext(RawSocketSession session, SocketListener listener, CompletableFuture<Void> connectFuture) {
                this.session = session;
                this.listener = listener;
                this.connectFuture = connectFuture;
            }
        }

        private static final class CentralSelector
        implements Runnable {
            private static final CentralSelector INSTANCE = new CentralSelector();
            private final Selector selector;
            private final Object lock = new Object();
            private volatile Thread selectorThread;

            private CentralSelector() {
                try {
                    this.selector = Selector.open();
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot open selector", e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void register(SocketChannel channel, int ops, ConnectionContext context) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        channel.register(this.selector, ops, context);
                    }
                    catch (ClosedChannelException e) {
                        context.listener.onError(e);
                    }
                    if (this.selectorThread == null || !this.selectorThread.isAlive()) {
                        this.selectorThread = Thread.startVirtualThread(this);
                    }
                    this.selector.wakeup();
                }
            }

            public void addWrite(SocketChannel channel, ByteBuffer buffer) {
                SelectionKey key = channel.keyFor(this.selector);
                if (key == null) {
                    return;
                }
                ConnectionContext ctx = (ConnectionContext)key.attachment();
                ctx.pendingWrites.add(buffer);
                key.interestOps(key.interestOps() | 4);
                this.selector.wakeup();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        do {
                            int readyChannels;
                            if ((readyChannels = this.selector.select()) <= 0) continue;
                            Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                            while (iter.hasNext()) {
                                SelectionKey key = iter.next();
                                iter.remove();
                                this.handleKey(key);
                            }
                        } while (!this.selector.keys().isEmpty());
                        Object object = this.lock;
                        synchronized (object) {
                            if (this.selector.keys().isEmpty()) {
                                this.selectorThread = null;
                                break;
                            }
                        }
                    }
                    catch (IOException error) {
                        System.getLogger("Socket").log(System.Logger.Level.ERROR, error);
                        break;
                    }
                }
            }

            private void handleKey(SelectionKey key) {
                Object attachment = key.attachment();
                if (!(attachment instanceof ConnectionContext)) {
                    return;
                }
                ConnectionContext ctx = (ConnectionContext)attachment;
                SocketChannel channel = (SocketChannel)key.channel();
                try {
                    boolean ok;
                    if (key.isConnectable() && channel.finishConnect()) {
                        key.interestOps(1);
                        ctx.connectFuture.complete(null);
                        ctx.listener.onOpen(ctx.session);
                    }
                    if (key.isReadable() && !(ok = this.processRead(channel, ctx))) {
                        key.cancel();
                        channel.close();
                        ctx.listener.onClose();
                    }
                    if (key.isWritable()) {
                        this.processWrite(channel, key, ctx);
                    }
                }
                catch (IOException e) {
                    key.cancel();
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ctx.listener.onError(e);
                }
            }

            private boolean processRead(SocketChannel channel, ConnectionContext ctx) throws IOException {
                int bytesRead;
                if (ctx.lengthBuffer.hasRemaining()) {
                    bytesRead = channel.read(ctx.lengthBuffer);
                    if (bytesRead == -1) {
                        return false;
                    }
                    if (ctx.lengthBuffer.hasRemaining()) {
                        return true;
                    }
                    ctx.lengthBuffer.flip();
                    int length = (ctx.lengthBuffer.get() & 0xFF) << 16 | (ctx.lengthBuffer.get() & 0xFF) << 8 | ctx.lengthBuffer.get() & 0xFF;
                    ctx.payloadBuffer = ByteBuffer.allocate(length);
                }
                if (ctx.payloadBuffer != null && ctx.payloadBuffer.hasRemaining()) {
                    bytesRead = channel.read(ctx.payloadBuffer);
                    if (bytesRead == -1) {
                        return false;
                    }
                    if (ctx.payloadBuffer.hasRemaining()) {
                        return true;
                    }
                    ctx.payloadBuffer.flip();
                    byte[] message = new byte[ctx.payloadBuffer.remaining()];
                    ctx.payloadBuffer.get(message);
                    ctx.lengthBuffer.clear();
                    ctx.payloadBuffer = null;
                    ctx.listener.onMessage(message);
                }
                return true;
            }

            private void processWrite(SocketChannel channel, SelectionKey key, ConnectionContext ctx) throws IOException {
                Queue<ByteBuffer> queue = ctx.pendingWrites;
                while (!queue.isEmpty()) {
                    ByteBuffer buf = queue.peek();
                    channel.write(buf);
                    if (buf.hasRemaining()) break;
                    queue.poll();
                }
                if (queue.isEmpty()) {
                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                }
            }
        }
    }
}

