/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.implementation;

import it.auties.whatsapp.api.DisconnectReason;

public enum SocketState {
    WAITING,
    HANDSHAKE,
    CONNECTED,
    DISCONNECTED,
    RECONNECTING,
    LOGGED_OUT,
    RESTORE,
    BANNED,
    PAUSED;


    static SocketState of(DisconnectReason reason) {
        return switch (reason) {
            default -> throw new MatchException(null, null);
            case DisconnectReason.DISCONNECTED -> DISCONNECTED;
            case DisconnectReason.RECONNECTING -> RECONNECTING;
            case DisconnectReason.LOGGED_OUT -> LOGGED_OUT;
            case DisconnectReason.BANNED -> BANNED;
            case DisconnectReason.RESTORE -> RESTORE;
        };
    }

    DisconnectReason toReason() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2, 4 -> DisconnectReason.RECONNECTING;
            case 0, 1, 3, 8 -> DisconnectReason.DISCONNECTED;
            case 5 -> DisconnectReason.LOGGED_OUT;
            case 6 -> DisconnectReason.RESTORE;
            case 7 -> DisconnectReason.BANNED;
        };
    }
}

