/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.listener;

import it.auties.whatsapp.api.DisconnectReason;
import it.auties.whatsapp.api.SocketEvent;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.model.call.Call;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.MessageIndexInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.info.QuotedMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.mobile.CountryLocale;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.setting.Setting;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface Listener {
    default public void onNodeSent(Whatsapp whatsapp, Node outgoing) {
    }

    default public void onNodeSent(Node outgoing) {
    }

    default public void onNodeReceived(Whatsapp whatsapp, Node incoming) {
    }

    default public void onNodeReceived(Node incoming) {
    }

    default public void onLoggedIn(Whatsapp whatsapp) {
    }

    default public void onLoggedIn() {
    }

    default public void onMetadata(Whatsapp whatsapp, Map<String, String> metadata) {
    }

    default public void onMetadata(Map<String, String> metadata) {
    }

    default public void onDisconnected(Whatsapp whatsapp, DisconnectReason reason) {
    }

    default public void onDisconnected(DisconnectReason reason) {
    }

    default public void onAction(Whatsapp whatsapp, Action action, MessageIndexInfo messageIndexInfo) {
    }

    default public void onAction(Action action, MessageIndexInfo messageIndexInfo) {
    }

    default public void onSetting(Whatsapp whatsapp, Setting setting) {
    }

    default public void onSetting(Setting setting) {
    }

    default public void onFeatures(Whatsapp whatsapp, List<String> features) {
    }

    default public void onFeatures(List<String> features) {
    }

    default public void onContacts(Whatsapp whatsapp, Collection<Contact> contacts) {
    }

    default public void onContacts(Collection<Contact> contacts) {
    }

    default public void onContactPresence(Whatsapp whatsapp, Chat chat, JidProvider jid) {
    }

    default public void onContactPresence(Chat chat, JidProvider jid) {
    }

    default public void onChats(Whatsapp whatsapp, Collection<Chat> chats) {
    }

    default public void onChats(Collection<Chat> chats) {
    }

    default public void onNewsletters(Whatsapp whatsapp, Collection<Newsletter> newsletters) {
    }

    default public void onNewsletters(Collection<Newsletter> newsletters) {
    }

    default public void onChatMessagesSync(Whatsapp whatsapp, Chat chat, boolean last) {
    }

    default public void onChatMessagesSync(Chat chat, boolean last) {
    }

    default public void onHistorySyncProgress(int percentage, boolean recent) {
    }

    default public void onHistorySyncProgress(Whatsapp whatsapp, int percentage, boolean recent) {
    }

    default public void onNewMessage(Whatsapp whatsapp, MessageInfo<?> info) {
    }

    default public void onNewMessage(MessageInfo<?> info) {
    }

    default public void onMessageDeleted(Whatsapp whatsapp, MessageInfo<?> info, boolean everyone) {
    }

    default public void onMessageDeleted(MessageInfo<?> info, boolean everyone) {
    }

    default public void onMessageStatus(Whatsapp whatsapp, MessageInfo<?> info) {
    }

    default public void onMessageStatus(MessageInfo<?> info) {
    }

    default public void onStatus(Whatsapp whatsapp, Collection<ChatMessageInfo> status) {
    }

    default public void onStatus(Collection<ChatMessageInfo> status) {
    }

    default public void onNewStatus(Whatsapp whatsapp, ChatMessageInfo status) {
    }

    default public void onNewStatus(ChatMessageInfo status) {
    }

    default public void onSocketEvent(Whatsapp whatsapp, SocketEvent event) {
    }

    default public void onSocketEvent(SocketEvent event) {
    }

    default public void onMessageReply(ChatMessageInfo response, QuotedMessageInfo quoted) {
    }

    default public void onMessageReply(Whatsapp whatsapp, ChatMessageInfo response, QuotedMessageInfo quoted) {
    }

    default public void onProfilePictureChanged(Contact contact) {
    }

    default public void onProfilePictureChanged(Whatsapp whatsapp, Contact contact) {
    }

    default public void onGroupPictureChanged(Chat group) {
    }

    default public void onGroupPictureChanged(Whatsapp whatsapp, Chat group) {
    }

    default public void onNameChanged(String oldName, String newName) {
    }

    default public void onNameChanged(Whatsapp whatsapp, String oldName, String newName) {
    }

    default public void onAboutChanged(String oldAbout, String newAbout) {
    }

    default public void onAboutChanged(Whatsapp whatsapp, String oldAbout, String newAbout) {
    }

    default public void onLocaleChanged(CountryLocale oldLocale, CountryLocale newLocale) {
    }

    default public void onLocaleChanged(Whatsapp whatsapp, CountryLocale oldLocale, CountryLocale newLocale) {
    }

    default public void onContactBlocked(Contact contact) {
    }

    default public void onContactBlocked(Whatsapp whatsapp, Contact contact) {
    }

    default public void onNewContact(Whatsapp whatsapp, Contact contact) {
    }

    default public void onNewContact(Contact contact) {
    }

    default public void onPrivacySettingChanged(Whatsapp whatsapp, PrivacySettingEntry oldPrivacyEntry, PrivacySettingEntry newPrivacyEntry) {
    }

    default public void onPrivacySettingChanged(PrivacySettingEntry oldPrivacyEntry, PrivacySettingEntry newPrivacyEntry) {
    }

    default public void onLinkedDevices(Whatsapp whatsapp, Collection<Jid> devices) {
    }

    default public void onLinkedDevices(Collection<Jid> devices) {
    }

    default public void onRegistrationCode(long code) {
    }

    default public void onRegistrationCode(Whatsapp whatsapp, long code) {
    }

    default public void onCall(Call call) {
    }

    default public void onCall(Whatsapp whatsapp, Call call) {
    }
}

