/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.action;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.action.StickerAction;
import java.nio.ByteBuffer;

public class StickerActionSpec {
    public static byte[] encode(StickerAction protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)StickerActionSpec.sizeOf(protoInputObject));
        StickerActionSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(StickerAction protoInputObject, ProtobufOutputStream protoOutputStream) {
        ProtobufString directPath0;
        ProtobufString mimetype0;
        String mimetype;
        ByteBuffer mediaKey0;
        byte[] mediaKey;
        ByteBuffer fileEncSha2560;
        byte[] fileEncSha256;
        ProtobufString url0;
        if (protoInputObject == null) {
            return;
        }
        String url = protoInputObject.url();
        if (url != null && (url0 = ProtobufLazyMixin.toValue((String)url)) != null) {
            protoOutputStream.writeString(1, url0);
        }
        if ((fileEncSha256 = protoInputObject.fileEncSha256()) != null && (fileEncSha2560 = ProtobufLazyMixin.toValue((byte[])fileEncSha256)) != null) {
            protoOutputStream.writeBytes(2, fileEncSha2560);
        }
        if ((mediaKey = protoInputObject.mediaKey()) != null && (mediaKey0 = ProtobufLazyMixin.toValue((byte[])mediaKey)) != null) {
            protoOutputStream.writeBytes(3, mediaKey0);
        }
        if ((mimetype = protoInputObject.mimetype()) != null && (mimetype0 = ProtobufLazyMixin.toValue((String)mimetype)) != null) {
            protoOutputStream.writeString(4, mimetype0);
        }
        int height = protoInputObject.height();
        protoOutputStream.writeUInt32(5, Integer.valueOf(height));
        int width = protoInputObject.width();
        protoOutputStream.writeUInt32(6, Integer.valueOf(width));
        String directPath = protoInputObject.directPath();
        if (directPath != null && (directPath0 = ProtobufLazyMixin.toValue((String)directPath)) != null) {
            protoOutputStream.writeString(7, directPath0);
        }
        long fileLength = protoInputObject.fileLength();
        protoOutputStream.writeUInt64(8, Long.valueOf(fileLength));
        boolean favorite = protoInputObject.favorite();
        protoOutputStream.writeBool(9, Boolean.valueOf(favorite));
        Integer deviceIdHint = protoInputObject.deviceIdHint();
        if (deviceIdHint != null) {
            protoOutputStream.writeUInt32(10, deviceIdHint);
        }
    }

    public static StickerAction decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return StickerActionSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static StickerAction decode(ProtobufInputStream protoInputStream) {
        String url = null;
        byte[] fileEncSha256 = null;
        byte[] mediaKey = null;
        String mimetype = null;
        int height = 0;
        int width = 0;
        String directPath = null;
        long fileLength = 0L;
        boolean favorite = false;
        Integer deviceIdHint = null;
        block12: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    url = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block12;
                }
                case 2: {
                    fileEncSha256 = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block12;
                }
                case 3: {
                    mediaKey = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block12;
                }
                case 4: {
                    mimetype = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block12;
                }
                case 5: {
                    height = protoInputStream.readInt32();
                    continue block12;
                }
                case 6: {
                    width = protoInputStream.readInt32();
                    continue block12;
                }
                case 7: {
                    directPath = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block12;
                }
                case 8: {
                    fileLength = protoInputStream.readInt64();
                    continue block12;
                }
                case 9: {
                    favorite = protoInputStream.readBool();
                    continue block12;
                }
                case 10: {
                    deviceIdHint = protoInputStream.readInt32();
                    continue block12;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new StickerAction(url, fileEncSha256, mediaKey, mimetype, height, width, directPath, fileLength, favorite, deviceIdHint);
    }

    public static int sizeOf(StickerAction protoInputObject) {
        ProtobufString directPath0;
        ProtobufString mimetype0;
        String mimetype;
        ByteBuffer mediaKey0;
        byte[] mediaKey;
        ByteBuffer fileEncSha2560;
        byte[] fileEncSha256;
        ProtobufString url0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        String url = protoInputObject.url();
        if (url != null && (url0 = ProtobufLazyMixin.toValue((String)url)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)url0);
        }
        if ((fileEncSha256 = protoInputObject.fileEncSha256()) != null && (fileEncSha2560 = ProtobufLazyMixin.toValue((byte[])fileEncSha256)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)fileEncSha2560);
        }
        if ((mediaKey = protoInputObject.mediaKey()) != null && (mediaKey0 = ProtobufLazyMixin.toValue((byte[])mediaKey)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)mediaKey0);
        }
        if ((mimetype = protoInputObject.mimetype()) != null && (mimetype0 = ProtobufLazyMixin.toValue((String)mimetype)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)mimetype0);
        }
        int height = protoInputObject.height();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)height);
        int width = protoInputObject.width();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)width);
        String directPath = protoInputObject.directPath();
        if (directPath != null && (directPath0 = ProtobufLazyMixin.toValue((String)directPath)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)directPath0);
        }
        long fileLength = protoInputObject.fileLength();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)fileLength);
        boolean favorite = protoInputObject.favorite();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)9, (int)0);
        ++protoOutputSize;
        Integer deviceIdHint = protoInputObject.deviceIdHint();
        if (deviceIdHint != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)10, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)deviceIdHint.intValue());
        }
        return protoOutputSize;
    }
}

