/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.business.BusinessItemAvailability;
import it.auties.whatsapp.model.business.BusinessReviewStatus;
import it.auties.whatsapp.model.node.Node;
import java.net.URI;
import java.util.NoSuchElementException;

public record BusinessCatalogEntry(String id, URI encryptedImage, BusinessReviewStatus reviewStatus, BusinessItemAvailability availability, String name, String sellerId, URI uri, String description, long price, String currency, boolean hidden) {
    public static BusinessCatalogEntry of(Node node) {
        String id = node.attributes().getRequiredString("id");
        boolean hidden = node.attributes().getBoolean("is_hidden");
        String name = (String)node.findChild("name").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing name for catalog entry"));
        URI encryptedImage = node.findChild("media").flatMap(entry -> entry.findChild("original_image_url")).flatMap(Node::contentAsString).map(URI::create).orElseThrow(() -> new NoSuchElementException("Missing image for catalog entry"));
        BusinessReviewStatus statusInfo = node.findChild("status_info").flatMap(entry -> entry.findChild("status")).flatMap(Node::contentAsString).map(BusinessReviewStatus::of).orElse(BusinessReviewStatus.NO_REVIEW);
        BusinessItemAvailability availability = node.findChild("availability").flatMap(Node::contentAsString).map(BusinessItemAvailability::of).orElse(BusinessItemAvailability.UNKNOWN);
        String sellerId = (String)node.findChild("retailer_id").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing seller id for catalog entry"));
        URI uri = node.findChild("url").flatMap(Node::contentAsString).map(URI::create).orElseThrow(() -> new NoSuchElementException("Missing uri for catalog entry"));
        String description = node.findChild("description").flatMap(Node::contentAsString).orElse("");
        Long price = node.findChild("price").flatMap(Node::contentAsString).map(Long::parseUnsignedLong).orElseThrow(() -> new NoSuchElementException("Missing price for catalog entry"));
        String currency = (String)node.findChild("currency").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing currency for catalog entry"));
        return new BusinessCatalogEntry(id, encryptedImage, statusInfo, availability, name, sellerId, uri, description, price, currency, hidden);
    }
}

